/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.project;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelFactory;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IAutoLoad;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.project.ModelNatureExtension;
import org.jboss.tools.common.model.project.ProjectHome;
import org.jboss.tools.common.model.util.ClassLoaderUtil;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public abstract class ModelNature
extends PlatformObject
implements IProjectNature,
IModelNature {
    public static final String NATURE_ID = "org.jboss.tools.common.model.modelnature";
    static Map<IProject, XModel> models = new HashMap<IProject, XModel>();
    static IResourceChangeListener listener = null;
    protected String workspaceHome = null;
    protected IProject project = null;
    protected XModel model = null;
    static String EXTERNAL_TOOL_BUILDER = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    static final String LAUNCH_CONFIG_HANDLE = "LaunchConfigHandle";
    static Map<IProject, Set<String>> checked = new HashMap<IProject, Set<String>>();

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
        ModelPlugin p = ModelPlugin.getDefault();
        if (this.model != null) {
            p.getSaveParticipant().removeModel(this.model);
            this.model = null;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        if (this.project == project) {
            return;
        }
        this.project = project;
        this.createProject();
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    public XModel getModel() {
        return this.model;
    }

    private void updateListener() {
        if (listener != null) {
            return;
        }
        listener = new Listener();
        ModelPlugin.getWorkspace().addResourceChangeListener(listener, 6);
    }

    private void createProject() {
        ClassLoaderUtil.init();
        Properties p = new Properties();
        p.putAll((Map<?, ?>)System.getProperties());
        String home = this.getWorkspaceHome();
        if (home != null && home.length() > 0) {
            p.setProperty(XModelConstants.WORKSPACE, home);
            p.setProperty(XModelConstants.WORKSPACE_OLD, home);
        } else {
            boolean result;
            IAutoLoad auto = this.createAutoLoad();
            boolean bl = result = auto != null && ProjectHome.getLocation(this.project, p);
            if (result) {
                p.put(XModelConstants.AUTOLOAD, auto);
            } else {
                p.setProperty(XModelConstants.WORKSPACE, "");
                p.setProperty(XModelConstants.WORKSPACE_OLD, "");
            }
        }
        p.setProperty("eclipse.project", this.project.getLocation().toString());
        p.setProperty("exadel.eclipse.project", this.project.getLocation().toString());
        p.put("project", this.project);
        p.setProperty("nature", this.getID());
        this.model = models.get(this.project);
        if (this.model != null) {
            home = p.getProperty(XModelConstants.WORKSPACE);
            String h = XModelConstants.getWorkspace(this.model);
            if (home == null || !home.equals(h)) {
                ModelPlugin.getPluginLog().logInfo("WARNING: workspace home changed from " + h + " to " + home);
                this.model.getProperties().setProperty(XModelConstants.WORKSPACE, home);
                this.model.getProperties().setProperty(XModelConstants.WORKSPACE_OLD, home);
                this.model.getProperties().setProperty("nature", this.getID());
                this.model.load();
            }
            return;
        }
        this.model = XModelFactory.getModel(p);
        if (this.model.getService() == null) {
            this.model.setService(this.createServiceDialog());
        }
        models.put(this.project, this.model);
        ModelPlugin.getDefault().getSaveParticipant().addModel(this.model);
        this.updateProjectVersion();
        this.updateListener();
    }

    protected IAutoLoad createAutoLoad() {
        return null;
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand command = null;
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length && command == null) {
            if (commands[i].getBuilderName().equals(builderID)) {
                command = commands[i];
            }
            ++i;
        }
        if (command == null) {
            command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] oldCommands = description.getBuildSpec();
            ICommand[] newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = command;
            description.setBuildSpec(newCommands);
            this.getProject().setDescription(description, null);
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            Object handle;
            String builderName = commands[i].getBuilderName();
            if (builderName.equals(builderID) || builderName.equals(EXTERNAL_TOOL_BUILDER) && (handle = commands[i].getArguments().get(LAUNCH_CONFIG_HANDLE)) != null && handle.toString().indexOf(builderID) >= 0) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    protected void updateProjectVersion() {
    }

    private String getWorkspaceHome() {
        return new ProjectHome().getLocation(this.project);
    }

    private ServiceDialog createServiceDialog() {
        try {
            return (ServiceDialog)ModelFeatureFactory.getInstance().createFeatureInstance("org.jboss.tools.common.model.ui.wizards.one.ServiceDialogImpl");
        }
        catch (ClassCastException classCastException) {
            ModelPlugin.getPluginLog().logError("Cannot create service dialog.");
            return null;
        }
    }

    public static boolean checkModelNature(IProject project) {
        if (project == null || !project.isOpen()) {
            return false;
        }
        String nature = null;
        ModelNatureExtension[] es = ModelNatureExtension.getInstances();
        try {
            ModelNatureExtension[] modelNatureExtensionArray = es;
            int n = es.length;
            int n2 = 0;
            while (n2 < n) {
                ModelNatureExtension ext = modelNatureExtensionArray[n2];
                if (project.hasNature(ext.getName())) {
                    nature = ext.getName();
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
            return false;
        }
        return ModelNature.checkModelNature(project, nature);
    }

    public static boolean checkModelNature(IProject project, String nature) {
        if (project == null || !project.isOpen()) {
            if (project != null && checked.containsKey(project)) {
                checked.remove(project);
            }
            return false;
        }
        if (nature == null) {
            return false;
        }
        Set<String> ns = checked.get(project);
        if (ns == null) {
            ns = new HashSet<String>();
            checked.put(project, ns);
        } else if (ns.contains(nature)) {
            return true;
        }
        String home = new ProjectHome().getLocation(project);
        if (home != null && home.length() > 0) {
            ns.add(nature);
            return true;
        }
        if (!project.isSynchronized(1)) {
            return false;
        }
        ns.add(nature);
        return true;
    }

    static class Listener
    implements IResourceChangeListener {
        Listener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IProject p;
            if (event.getType() == 4 && (p = event.getResource().getProject()) != null && models.containsKey(p)) {
                models.remove(p);
            }
        }
    }
}

