/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathUpdate {
    IProject project = null;
    IJavaProject javaProject;
    XModel model;
    List<IClasspathEntry> newClassPath;
    IPath classes;
    Map<String, String> replacedSrc = new HashMap<String, String>();
    static SpecialWizard addServletSupportWizard = SpecialWizardFactory.createSpecialWizard("org.jboss.tools.jst.web.project.AddServletSupportWizard");

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setModel(XModel model) {
        String entity = model.getRoot().getModelEntity().getName();
        if ("RootDummy".equals(entity)) {
            String pn = this.project == null ? "?" : this.project.getName();
            throw new IllegalArgumentException("Project " + pn + " is corrupted.");
        }
        this.model = model;
    }

    public XModel getModel() {
        return this.model;
    }

    public void setReplacedSrc(Map<String, String> replacedSrc) {
        this.replacedSrc = replacedSrc;
    }

    public void setClasses(IPath classes) {
        this.classes = classes;
    }

    public void execute() throws CoreException {
        if (this.model == null) {
            IModelNature nature = EclipseResourceUtil.getModelNature(this.project);
            this.setModel(nature.getModel());
        }
        this.javaProject = JavaCore.create((IProject)this.project);
        EclipseResourceUtil.addNatureToProject((IProject)this.project, (String)"org.eclipse.jdt.core.javanature");
        this.init();
        this.createOutputFolder();
        this.removeReplacedSrc();
        this.createSrcFolders();
        this.createClassPath();
        this.commit();
    }

    private void init() throws CoreException {
        this.newClassPath = new ArrayList<IClasspathEntry>(Arrays.asList(this.javaProject.getRawClasspath()));
        Iterator<IClasspathEntry> iterator = this.newClassPath.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = iterator.next();
            if (!this.project.getFullPath().equals((Object)entry.getPath())) continue;
            iterator.remove();
        }
    }

    private void commit() throws CoreException {
        this.removeDuplicateEntries();
        IClasspathEntry[] entries = this.newClassPath.toArray(new IClasspathEntry[this.newClassPath.size()]);
        if (entries.length != 0) {
            this.javaProject.setRawClasspath(entries, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void revalidateLibs(XModel model) throws XModelException, CoreException {
        this.setProject(EclipseResourceUtil.getProject(model.getRoot()));
        this.setModel(model);
        this.javaProject = JavaCore.create((IProject)this.project);
        this.init();
        this.addLibJars();
        this.commit();
    }

    private void removeReplacedSrc() {
        if (this.replacedSrc == null || this.replacedSrc.isEmpty()) {
            return;
        }
        String[] s = this.replacedSrc.keySet().toArray(new String[0]);
        int i = 0;
        while (i < s.length) {
            IClasspathEntry entry = this.createNewClasspathEntry(s[i], 3);
            int i1 = this.newClassPath.indexOf(entry);
            if (i1 >= 0) {
                String sn = this.replacedSrc.get(s[i]);
                if (sn == null || sn.length() == 0) {
                    this.newClassPath.remove(i1);
                } else {
                    entry = this.createNewClasspathEntry(sn, 3);
                    int i2 = this.newClassPath.indexOf(entry);
                    if (i2 < 0) {
                        this.newClassPath.set(i1, entry);
                    } else {
                        this.newClassPath.remove(i1);
                    }
                }
            }
            ++i;
        }
    }

    private void createSrcFolders() {
        XModelObject web = this.model.getByPath("Web");
        if (web == null) {
            return;
        }
        XModelObject[] children = this.model.getByPath("Web").getChildren();
        ArrayList<String> srcPaths = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < children.length) {
            String objectPaths = children[i].getAttributeValue("src file system");
            if (objectPaths != null && objectPaths.length() != 0) {
                StringTokenizer st = new StringTokenizer(objectPaths, ",;");
                while (st.hasMoreTokens()) {
                    String osPath;
                    XModelObject srcObject;
                    String objectPath = st.nextToken().trim();
                    if (objectPath.length() == 0 || (srcObject = this.model.getByPath("FileSystems/" + objectPath)) == null || (osPath = XModelObjectUtil.getExpandedValue(srcObject, "location", null)) == null || "".equals(osPath) || set.contains(osPath)) continue;
                    srcPaths.add(osPath);
                    set.add(osPath);
                }
            }
            ++i;
        }
        Iterator iterator = srcPaths.iterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = this.createNewClasspathEntry(iterator.next().toString(), 3);
            this.insertSrc(entry);
        }
    }

    private void insertSrc(IClasspathEntry entry) {
        if (!this.entryAlreadyExists(entry, this.newClassPath)) {
            this.newClassPath.add(0, entry);
        }
    }

    private void createOutputFolder() {
        XModelObject classesObject = this.model.getByPath("FileSystems/classes");
        String classesPath = "";
        if (classesObject != null) {
            classesPath = XModelObjectUtil.getExpandedValue(classesObject, "location", null);
        } else if (this.classes != null) {
            classesPath = this.classes.toString();
        }
        try {
            this.javaProject.setOutputLocation(EclipseResourceUtil.getRelativePath(this.project, classesPath), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException ex) {
            ModelPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    private void removeDuplicateEntries() {
        ArrayList<IClasspathEntry> removeList = new ArrayList<IClasspathEntry>();
        ArrayList<IClasspathEntry> tmpList = new ArrayList<IClasspathEntry>();
        for (IClasspathEntry entry : this.newClassPath) {
            tmpList.clear();
            tmpList.addAll(this.newClassPath);
            tmpList.remove(entry);
            if (!this.entryAlreadyExists(entry, tmpList)) continue;
            removeList.add(entry);
        }
        Iterator<Object> iterator = removeList.iterator();
        while (iterator.hasNext()) {
            this.newClassPath.remove(iterator.next());
        }
    }

    private void addJRE() {
        IClasspathEntry[] jre = EclipseResourceUtil.getDefaultJRELibrary();
        int i = 0;
        while (i < jre.length) {
            if (!this.entryAlreadyExists(jre[i], this.newClassPath)) {
                this.newClassPath.add(jre[i]);
            }
            ++i;
        }
    }

    private void addLibJars() {
        XModelObject fss = FileSystemsHelper.getFileSystems(this.model);
        XModelObject[] children = fss == null ? new XModelObject[]{} : fss.getChildren("FileSystemJar");
        ArrayList<String> srcPaths = new ArrayList<String>();
        int i = 0;
        while (i < children.length) {
            if (!"true".equals(children[i].get(FileSystemsLoader.IS_ADDED_TO_CLASSPATH))) {
                String osPath = XModelObjectUtil.getExpandedValue(children[i], "location", null);
                if (osPath != null && !"".equals(osPath) && new File(osPath).isFile()) {
                    srcPaths.add(osPath);
                }
                children[i].set(FileSystemsLoader.IS_ADDED_TO_CLASSPATH, "true");
            }
            ++i;
        }
    }

    private void createClassPath() {
        this.addJRE();
        this.addLibJars();
        this.addServletSupport();
    }

    private void addServletSupport() {
    }

    private boolean entryAlreadyExists(IClasspathEntry entry, List entryList) {
        IPath resolvedEntryPath;
        boolean result;
        boolean bl = result = entry != null && entryList.contains(entry);
        if (result) {
            return true;
        }
        IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        IPath iPath = resolvedEntryPath = resolvedEntry != null ? resolvedEntry.getPath() : null;
        if (resolvedEntryPath == null) {
            return false;
        }
        Iterator iterator = entryList.iterator();
        while (iterator.hasNext() && !result) {
            IClasspathEntry tmpResolvedEntry;
            IClasspathEntry tmpEntry = (IClasspathEntry)iterator.next();
            if (tmpEntry.getEntryKind() == 5) {
                IClasspathContainer container;
                try {
                    container = JavaCore.getClasspathContainer((IPath)tmpEntry.getPath(), (IJavaProject)this.javaProject);
                }
                catch (JavaModelException javaModelException) {
                    container = null;
                }
                if (container == null) continue;
                IClasspathEntry[] containerEntries = container.getClasspathEntries();
                int i = 0;
                while (i < containerEntries.length && !result) {
                    tmpResolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)containerEntries[i]);
                    result = tmpResolvedEntry != null && resolvedEntryPath.equals((Object)tmpResolvedEntry.getPath());
                    ++i;
                }
                continue;
            }
            tmpResolvedEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)tmpEntry);
            boolean bl2 = result = tmpResolvedEntry != null && resolvedEntryPath.equals((Object)tmpResolvedEntry.getPath());
        }
        if (entry.getEntryKind() == 5) {
            IClasspathContainer container;
            try {
                container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)this.javaProject);
            }
            catch (JavaModelException javaModelException) {
                container = null;
            }
            if (container != null) {
                IClasspathEntry[] containerEntries = container.getClasspathEntries();
                int i = 0;
                while (i < containerEntries.length) {
                    if (this.entryAlreadyExists(containerEntries[i], entryList)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private IClasspathEntry createNewClasspathEntry(String location, int entryKind) {
        IPath entryPath = EclipseResourceUtil.getRelativePath(this.project, location);
        return this.createNewClasspathEntry(entryPath, entryKind);
    }

    public IClasspathEntry createNewClasspathEntry(IPath path, int entryKind) {
        switch (entryKind) {
            case 3: {
                return JavaCore.newSourceEntry((IPath)path);
            }
            case 1: {
                return JavaCore.newLibraryEntry((IPath)path, null, null);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)path, null, null);
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)path);
            }
        }
        return null;
    }

    public void registerEntry(IClasspathEntry entry) {
        if (!this.entryAlreadyExists(entry, this.newClassPath)) {
            this.newClassPath.add(entry);
        }
    }
}

