/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.options.impl.XStudioContribution;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class XStudioContributions {
    public static String EXTENSION_POINT = "org.jboss.tools.common.model.preferences";
    public static String ATTR_RESOURCE = "resource";
    public static String ATTR_TARGET = "target";
    public static String ATTR_PRIORITY = "priority";

    public static XStudioContribution[] getContributions() {
        ArrayList<XStudioContribution> result = new ArrayList<XStudioContribution>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT);
        IConfigurationElement[] cs = point.getConfigurationElements();
        int i = 0;
        while (i < cs.length) {
            XStudioContribution c = new XStudioContribution();
            c.resource = cs[i].getAttribute(ATTR_RESOURCE);
            c.loader = cs[i].getNamespaceIdentifier();
            if (c.loader != null) {
                String pr;
                String targets = cs[i].getAttribute(ATTR_TARGET);
                if (targets != null && targets.length() > 0) {
                    c.targets = XModelObjectUtil.asStringArray(targets);
                }
                if ((pr = cs[i].getAttribute(ATTR_PRIORITY)) != null && pr.length() > 0) {
                    try {
                        c.priority = Integer.parseInt(pr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        c.priority = 100;
                    }
                } else {
                    c.priority = 10;
                }
                result.add(c);
            }
            ++i;
        }
        XStudioContribution[] rs = result.toArray(new XStudioContribution[0]);
        Arrays.sort(rs, new C());
        return rs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class C
    implements Comparator<XStudioContribution> {
        C() {
        }

        @Override
        public int compare(XStudioContribution o1, XStudioContribution o2) {
            return o1.priority - o2.priority;
        }
    }
}

