/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.MountFileSystemUndo;
import org.jboss.tools.common.model.filesystems.impl.MoveFileSystemHandler;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class MountFileSystemHandler
extends DefaultCreateHandler {
    static SpecialWizard w = SpecialWizardFactory.createSpecialWizard("org.jboss.tools.common.model.project.ClassPathUpdateWizard");

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object) || this.data == null || this.data.length == 0) {
            return;
        }
        String entity = this.data[0].getModelEntity().getName();
        if (!this.checkOverlap(object, entity, p = MountFileSystemHandler.extractProperties(this.data[0]))) {
            return;
        }
        this.setRelativeToProject(object, p);
        this.mount(object, p, entity);
    }

    public XModelObject mount(XModelObject fs, Properties p, String entity) throws XModelException {
        this.validateName(fs, p);
        XModelObject c = XModelObjectLoaderUtil.createValidObject(fs.getModel(), entity, p);
        MountFileSystemHandler.addCreatedObject(fs, c, false, p);
        fs.getModel().getUndoManager().addUndoable(new MountFileSystemUndo(c));
        MountFileSystemHandler.updateClassPath(c);
        MoveFileSystemHandler.sortFileSystems(fs.getModel());
        return c;
    }

    private boolean checkOverlap(XModelObject object, String entity, Properties p) {
        String location = p.getProperty("location");
        if (location == null) {
            return true;
        }
        boolean b = location.indexOf(37) >= 0;
        if ((location = this.canonize(location, object.getModel())) != null && !b) {
            p.setProperty("location", location);
        }
        if (!"FileSystemFolder".equals(entity)) {
            return true;
        }
        location = String.valueOf(location) + "/";
        XModelObject[] cs = object.getChildren(entity);
        int i = 0;
        while (i < cs.length) {
            String loc = String.valueOf(this.canonize(cs[i].get("location"), cs[i].getModel())) + "/";
            if (loc.startsWith(location) || location.startsWith(loc)) {
                String mes = MessageFormat.format("File system {0} will share files with file system {1}", p.get("name"), cs[i].getAttributeValue("name"));
                ServiceDialog d = object.getModel().getService();
                int q = d.showDialog(ModelMessages.WARNING, mes, new String[]{ModelMessages.OK, ModelMessages.Cancel}, null, 2);
                return q == 0;
            }
            ++i;
        }
        return true;
    }

    private String canonize(String location, XModel model) {
        try {
            location = XModelObjectUtil.expand(location, model, null);
            return location == null ? null : new File(location).getCanonicalPath().replace('\\', '/');
        }
        catch (IOException iOException) {
            return location;
        }
    }

    private void validateName(XModelObject object, Properties p) {
        String name = p.getProperty("name");
        if (name != null && name.length() > 0) {
            return;
        }
        String location = p.getProperty("location");
        name = location.substring(location.lastIndexOf(47) + 1);
        if (name.length() == 0) {
            name = "filesystem";
        }
        name = XModelObjectUtil.createNewChildName(name, object);
        p.setProperty("name", name);
    }

    private void setRelativeToProject(XModelObject object, Properties p) {
        String project;
        boolean isRelative = "true".equals(p.getProperty("set location relative to project"));
        if (!isRelative) {
            return;
        }
        String location = this.canonize(p.getProperty("location"), object.getModel());
        if (location.equals(project = this.canonize(XModelConstants.WORKSPACE_REF, object.getModel()))) {
            p.setProperty("location", XModelConstants.WORKSPACE_REF);
            return;
        }
        boolean common = false;
        while (location.length() > 0 && project.length() > 0) {
            String p2;
            String p1;
            int i2;
            int i1 = location.indexOf(47);
            if (i1 < 0) {
                i1 = location.length();
            }
            if ((i2 = project.indexOf(47)) < 0) {
                i2 = project.length();
            }
            if (i1 != i2 || !(p1 = location.substring(0, i1)).equals(p2 = project.substring(0, i2))) break;
            location = location.substring(i1);
            project = project.substring(i2);
            if (location.startsWith("/")) {
                location = location.substring(1);
            }
            if (project.startsWith("/")) {
                project = project.substring(1);
            }
            common = true;
        }
        if (!common) {
            return;
        }
        String s = XModelConstants.WORKSPACE_REF;
        if (project.length() > 0) {
            int q = new StringTokenizer(project, "/").countTokens();
            int i = 0;
            while (i < q) {
                s = String.valueOf(s) + "/..";
                ++i;
            }
        }
        if (location.length() > 0) {
            s = String.valueOf(s) + "/" + location;
        }
        p.setProperty("location", s);
    }

    public static void updateClassPath(XModelObject fs) {
        if (fs.getModelEntity().getName().indexOf("ar") >= 0 && w != null) {
            Properties p = new Properties();
            p.put("model", fs.getModel());
            w.setObject(p);
            w.execute();
        }
    }
}

