/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.text.MessageFormat;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.constraint.XAttributeConstraint;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.ActionDeclinedException;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.undo.XCreateUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class DefaultCreateHandler
extends AbstractHandler {
    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        if (!this.isEnabled(object) || this.data == null || this.data.length == 0) {
            return;
        }
        String entity = this.getEntityName();
        Properties p = DefaultCreateHandler.extractProperties(this.data[0]);
        this.setOtherProperties(object, p);
        XModelObject c = XModelObjectLoaderUtil.createValidObject(object.getModel(), entity, p);
        c = this.modifyCreatedObject(c);
        DefaultCreateHandler.addCreatedObject(object, c, prop);
        this.checkPosition(object, c, prop);
        if (prop != null) {
            prop.put("created", c);
        }
    }

    private void checkPosition(XModelObject o, XModelObject c, Properties prop) {
        if (prop == null || !(prop.get("insertAfter") instanceof Integer)) {
            return;
        }
        int i = (Integer)prop.get("insertAfter");
        if (i < 0) {
            return;
        }
        RegularObjectImpl impl = (RegularObjectImpl)o;
        impl.move(impl.getIndexOfChild(c), ++i, true);
    }

    protected String getEntityName() {
        String n = this.action.getProperty("entity");
        return n == null ? this.data[0].getModelEntity().getName() : n;
    }

    protected XModelObject modifyCreatedObject(XModelObject o) {
        return o;
    }

    public static Properties extractProperties(XEntityData es) {
        Properties p = new Properties();
        XAttributeData[] ads = es.getAttributeData();
        int i = 0;
        while (i < ads.length) {
            XAttribute a = ads[i].getAttribute();
            String pn = a.getName();
            String pv = DefaultCreateHandler.extractProperty(ads[i]);
            p.setProperty(pn, pv);
            ++i;
        }
        return p;
    }

    public static String extractProperty(XAttributeData ad) {
        XAttribute a = ad.getAttribute();
        String pn = a.getName();
        String pv = ad.getValue();
        if (a.isTrimmable()) {
            String string = pv = pv == null ? "" : pv.trim();
        }
        if ((pv == null || pv.length() == 0) && ad.getMandatoryFlag()) {
            throw new RuntimeException(DefaultCreateHandler.getReguiredMessage(pn));
        }
        XAttributeConstraint c = ad.getAttribute().getConstraint();
        DefaultCreateHandler.validateValue(pn, pv, c);
        return pv;
    }

    public static String getReguiredMessage(String attributeName) {
        return NLS.bind((String)ModelMessages.ATTRIBUTE_REQUIRED, (Object[])new Object[]{attributeName});
    }

    public static Properties getProperties(XEntityData es) {
        Properties p = new Properties();
        XAttributeData[] ads = es.getAttributeData();
        int i = 0;
        while (i < ads.length) {
            XAttribute a = ads[i].getAttribute();
            String pn = a.getName();
            String pv = ads[i].getValue();
            if (a.isTrimmable()) {
                String string = pv = pv == null ? "" : pv.trim();
            }
            if (pv == null) {
                pv = "";
            }
            p.setProperty(pn, pv);
            ++i;
        }
        return p;
    }

    public static String validateAttribute(XAttributeData ad, String pv) {
        XAttribute a = ad.getAttribute();
        String vis = WizardKeys.getAttributeDisplayName(ad, true);
        if (a.isTrimmable()) {
            String string = pv = pv == null ? "" : pv.trim();
        }
        if ((pv == null || pv.length() == 0) && ad.getMandatoryFlag()) {
            return NLS.bind((String)ModelMessages.ATTRIBUTE_REQUIRED, (Object[])new Object[]{vis});
        }
        XAttributeConstraint c = ad.getAttribute().getConstraint();
        return DefaultCreateHandler.getConstraintMessage(vis, pv, c);
    }

    public static String getConstraintMessage(String name, String value, XAttributeConstraint c) {
        if (c == null || c.getError(value) == null) {
            return null;
        }
        return NLS.bind((String)ModelMessages.SET_ATTRIBUTE_FAILURE, (Object[])new Object[]{name, value, c.getError(value)});
    }

    public static void validateValue(String name, String value, XAttributeConstraint c) {
        String mes = DefaultCreateHandler.getConstraintMessage(name, value, c);
        if (mes != null) {
            throw new RuntimeException(mes);
        }
    }

    protected void setOtherProperties(XModelObject object, Properties p) {
    }

    public boolean isEnabled(XModelObject object) {
        return object != null && object.isObjectEditable();
    }

    public static void addCreatedObject(XModelObject parent, XModelObject child, Properties whereSelect) throws XModelException {
        DefaultCreateHandler.addCreatedObject(parent, child, true, whereSelect);
    }

    public static String getContainsMessage(XModelObject parent, XModelObject child) {
        return DefaultCreateHandler.getContainsMessage(parent, child, true);
    }

    private static String getContainsMessage(XModelObject parent, XModelObject child, boolean forceUnique) {
        String pathpart = child.getPathPart();
        XModelObject e = parent.getChildByPath(pathpart);
        if (e != null && e != parent && e != parent.getParent()) {
            String te;
            if (!(child.getModelEntity().getAttribute(XModelObjectLoaderUtil.ATTR_ID_NAME) == null || forceUnique && "true".equals(child.getModelEntity().getProperty("unique")))) {
                return null;
            }
            String tp = DefaultCreateHandler.title(parent, true);
            String tc = DefaultCreateHandler.title(child, false);
            String mes = tc.equals(te = DefaultCreateHandler.title(e, false)) ? NLS.bind((String)ModelMessages.CONTAINS_OBJECT_1, (Object[])new Object[]{tp, tc}) : NLS.bind((String)ModelMessages.CONTAINS_OBJECT_2, (Object[])new Object[]{tp, te, "\n", tc});
            return mes;
        }
        return null;
    }

    public static void addCreatedObject(XModelObject parent, XModelObject child, boolean registerundo, Properties whereSelect) throws XModelException {
        DefaultCreateHandler.addCreatedObject(parent, child, registerundo, DefaultCreateHandler.extractWhereSelect(whereSelect));
    }

    public static void addCreatedObject(XModelObject parent, XModelObject child, int whereSelect) throws XModelException {
        DefaultCreateHandler.addCreatedObject(parent, child, true, whereSelect);
    }

    public static void addCreatedObject(XModelObject parent, final XModelObject child, boolean registerundo, final int whereSelect) throws XModelException {
        if (child == null) {
            throw new XModelException(ModelMessages.OBJECT_CREATION_FAILURE);
        }
        String mes = DefaultCreateHandler.getContainsMessage(parent, child, false);
        if (mes != null) {
            throw new XModelException(mes);
        }
        String ce = child.getModelEntity().getName();
        XChild c = parent.getModelEntity().getChild(ce);
        if (c == null) {
            throw new XModelException(ModelMessages.OBJECT_ADDING_FAILURE);
        }
        int max = c.getMaxCount();
        int cur = parent.getChildren(ce).length;
        if (cur >= max) {
            ServiceDialog d = parent.getModel().getService();
            d.showDialog(ModelMessages.WARNING, MessageFormat.format("The limit of {0} children is achieved.", max), new String[]{"OK"}, null, 3);
            mes = MessageFormat.format("{0} can contain only {1}{2}with entity {3}.", DefaultCreateHandler.title(parent, true), max, max == 1 ? " child " : " children ", ce);
            throw new ActionDeclinedException(mes);
        }
        boolean b = parent.addChild(child);
        if (!b && child.getModelEntity().getAttribute(XModelObjectLoaderUtil.ATTR_ID_NAME) != null) {
            int k = 1;
            String pp = child.getPathPart();
            while (parent.getChildByPath(pp) != null) {
                child.setAttributeValue(XModelObjectLoaderUtil.ATTR_ID_NAME, "" + k);
                String ppn = child.getPathPart();
                if (ppn.equals(pp)) {
                    throw new RuntimeException(ModelMessages.OBJECT_ADDING_FAILURE);
                }
                pp = ppn;
                ++k;
            }
            b = parent.addChild(child);
        }
        if (!b) {
            throw new XModelException(ModelMessages.OBJECT_ADDING_FAILURE);
        }
        XUndoManager undo = DefaultCreateHandler.getUndoManager(parent);
        if (registerundo && undo != null) {
            undo.addUndoable(new XCreateUndo(parent, child));
        }
        child.setModified(true);
        if (whereSelect >= 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    FindObjectHelper.findModelObject(child, whereSelect);
                }
            });
        }
    }

    static XUndoManager getUndoManager(XModelObject o) {
        XModelObject root = o.getModel().getRoot();
        while (o != null && o != root) {
            o = o.getParent();
        }
        return o == null ? null : o.getModel().getUndoManager();
    }

    public static String title(XModelObject o, boolean capitalize) {
        String elementType = o.getAttributeValue("element type");
        String objectTitle = o.getModelEntity().getRenderer().getTitle(o);
        String s = String.valueOf(elementType) + " " + objectTitle;
        if (objectTitle != null && objectTitle.equalsIgnoreCase(elementType)) {
            s = objectTitle;
        }
        return !capitalize || s.length() < 1 || Character.isUpperCase(s.charAt(0)) ? s : String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static int extractWhereSelect(Properties p) {
        if (p == null) {
            return FindObjectHelper.EVERY_WHERE;
        }
        String component = p.getProperty("actionSourceGUIComponentID");
        if ("navigator".equals(component)) {
            return FindObjectHelper.IN_NAVIGATOR_AND_IN_EDITOR_IF_OPEN;
        }
        if ("editor".equals(component)) {
            return FindObjectHelper.IN_EDITOR_ONLY;
        }
        if ("dialog".equals(component)) {
            return FindObjectHelper.IN_NAVIGATOR_ONLY;
        }
        return FindObjectHelper.EVERY_WHERE;
    }
}

