/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.autolayout.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.IItemInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.ILinkInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.autolayout.data.LinkInfo;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Connection;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;

public class DiagramElementInfo
implements IItemInfo {
    protected OrmShape element;
    protected List<ILinkInfo> links = new ArrayList<ILinkInfo>();
    protected int cxFigure;
    protected int cyFigure;

    public DiagramElementInfo(OrmShape element, int cxFigure, int cyFigure) {
        LinkInfo link;
        this.element = element;
        this.cxFigure = cxFigure;
        this.cyFigure = cyFigure;
        for (Connection connection : element.getSourceConnections()) {
            if (!connection.isVisible()) continue;
            link = new LinkInfo(connection);
            this.addLink(link);
        }
        Iterator<Shape> it = element.getChildrenIterator();
        while (it.hasNext()) {
            Shape child = it.next();
            if (!child.isVisible()) continue;
            List<Connection> sourceConnections = child.getSourceConnections();
            if (sourceConnections.size() == 0) {
                link = new LinkInfo(this.getID());
                this.addLink(link);
            }
            for (Connection connection : sourceConnections) {
                if (!connection.isVisible()) continue;
                link = new LinkInfo(connection);
                this.addLink(link);
            }
        }
    }

    public String getID() {
        return this.element.toString();
    }

    public boolean isComment() {
        return false;
    }

    public boolean isVisible() {
        return this.element.isVisible();
    }

    public int[] getShape() {
        int[] shape = new int[]{this.element.getLocation().x, this.element.getLocation().y, this.cxFigure, this.cyFigure};
        return shape;
    }

    public void setShape(int[] s) {
        this.element.setLocation(new Point(s[0], s[1]));
    }

    public ILinkInfo[] getLinks() {
        return this.links.toArray(new ILinkInfo[0]);
    }

    public void addLink(ILinkInfo link) {
        this.links.add(link);
    }
}

