/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.hibernate.Hibernate;
import org.hibernate.mapping.Table;
import org.hibernate.type.NullableType;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleQueryParameter {
    private static final Object NULL_MARKER = null;
    static final Map<Type, String> typeFormats = new HashMap<Type, String>();
    String name;
    NullableType type;
    Object value;

    static {
        ConsoleQueryParameter.addTypeFormat(Hibernate.BOOLEAN, Boolean.TRUE);
        ConsoleQueryParameter.addTypeFormat(Hibernate.BYTE, (byte)42);
        ConsoleQueryParameter.addTypeFormat(Hibernate.BIG_INTEGER, BigInteger.valueOf(42L));
        ConsoleQueryParameter.addTypeFormat(Hibernate.SHORT, (short)42);
        ConsoleQueryParameter.addTypeFormat(Hibernate.CALENDAR, new GregorianCalendar());
        ConsoleQueryParameter.addTypeFormat(Hibernate.CALENDAR_DATE, new GregorianCalendar());
        ConsoleQueryParameter.addTypeFormat(Hibernate.INTEGER, 42);
        ConsoleQueryParameter.addTypeFormat(Hibernate.INTEGER, 42);
        ConsoleQueryParameter.addTypeFormat(Hibernate.BIG_DECIMAL, new BigDecimal(42.0));
        ConsoleQueryParameter.addTypeFormat(Hibernate.CHARACTER, Character.valueOf('h'));
        ConsoleQueryParameter.addTypeFormat(Hibernate.CLASS, Table.class);
        ConsoleQueryParameter.addTypeFormat(Hibernate.CURRENCY, Currency.getInstance(Locale.getDefault()));
        ConsoleQueryParameter.addTypeFormat(Hibernate.DATE, new Date());
        ConsoleQueryParameter.addTypeFormat(Hibernate.DOUBLE, 42.42);
        ConsoleQueryParameter.addTypeFormat(Hibernate.FLOAT, Float.valueOf(42.42f));
        ConsoleQueryParameter.addTypeFormat(Hibernate.LOCALE, Locale.getDefault());
        ConsoleQueryParameter.addTypeFormat(Hibernate.LONG, 42L);
        ConsoleQueryParameter.addTypeFormat(Hibernate.STRING, "a string");
        ConsoleQueryParameter.addTypeFormat(Hibernate.TEXT, "a text");
        ConsoleQueryParameter.addTypeFormat(Hibernate.TIME, new Date());
        ConsoleQueryParameter.addTypeFormat(Hibernate.TIMESTAMP, new Date());
        ConsoleQueryParameter.addTypeFormat(Hibernate.TIMEZONE, TimeZone.getDefault());
        ConsoleQueryParameter.addTypeFormat(Hibernate.TRUE_FALSE, Boolean.TRUE);
        ConsoleQueryParameter.addTypeFormat(Hibernate.YES_NO, Boolean.TRUE);
    }

    private static void addTypeFormat(NullableType nullableType, Object value) {
        typeFormats.put((Type)nullableType, nullableType.toString(value));
    }

    public ConsoleQueryParameter(ConsoleQueryParameter cqp) {
        this.name = cqp.name;
        this.type = cqp.type;
        this.value = cqp.value;
    }

    public ConsoleQueryParameter() {
    }

    public ConsoleQueryParameter(String name, NullableType type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NullableType getType() {
        return this.type;
    }

    public void setType(NullableType type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String[] getStringValues() {
        if (this.value == null) {
            return new String[]{""};
        }
        if (this.value.getClass().isArray()) {
            Object[] arr = (Object[])this.value;
            String[] values = new String[arr.length];
            int i = 0;
            while (i < arr.length) {
                values[i] = this.type.toString(arr[i]);
                ++i;
            }
            return values;
        }
        return new String[]{this.type.toString(this.value)};
    }

    public Object convertStringToValue(String value) {
        try {
            return this.type.fromStringValue(value);
        }
        catch (Exception exception) {
            return NULL_MARKER;
        }
    }

    public String getDefaultFormat() {
        String object;
        if (this.type != null && (object = typeFormats.get(this.type)) != null) {
            return object.toString();
        }
        return "<unknown>";
    }

    public static Set<Type> getPossibleTypes() {
        return typeFormats.keySet();
    }

    public void setNull() {
        this.setValue(NULL_MARKER);
    }

    public boolean isNull() {
        return this.getValue() == NULL_MARKER;
    }

    public Object getValueForQuery() {
        if (this.isNull()) {
            return null;
        }
        return this.getValue();
    }
}

