/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.util.ElService;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMElementCSSInlineStyle;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeStyleUtil {
    public static final String UNRESOLVED_IMAGE_PATH = "unresolved_image.gif";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String PARAMETER_POSITION = "position";
    public static final String PARAMETER_TOP = "top";
    public static final String PARAMETER_LEFT = "left";
    public static final String PARAMETER_WIDTH = "width";
    public static final String PARAMETER_HEIGHT = "height";
    public static final String PARAMETR_BACKGROND = "background";
    public static final String PARAMETR_VERTICAL_ALIGN = "vertical-align";
    public static final String VALUE_ABSOLUTE = "absolute";
    public static final String DOT_STRING = ".";
    public static final String COLON_STRING = ":";
    public static final String SEMICOLON_STRING = ";";
    public static final String PX_STRING = "px";
    public static final String SPACE_STRING = " ";
    public static final String EMPTY_STRING = "";
    public static final String SINGLE_QUOTE_STRING = "'";
    public static final String QUOTE_STRING = "\"";
    public static String ATTR_URL = "url";
    public static String OPEN_BRACKET = "(";
    public static String CLOSE_BRACKET = ")";
    public static String FILE_PROTOCOL = "file:";
    public static String HTTP_PROTOCOL = "http:";
    public static String SLASH = "/";

    public static nsIDOMCSSStyleDeclaration getStyle(nsIDOMElement element) {
        nsIDOMElementCSSInlineStyle inlineStyle = (nsIDOMElementCSSInlineStyle)XPCOM.queryInterface((nsISupports)element, nsIDOMElementCSSInlineStyle.class);
        return inlineStyle.getStyle();
    }

    public static void setAbsolute(Element sourceElement) {
        String style = sourceElement.getAttribute(ATTRIBUTE_STYLE);
        style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, PARAMETER_POSITION, SEMICOLON_STRING);
        if (style.length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + " position : absolute;";
        sourceElement.setAttribute(ATTRIBUTE_STYLE, style);
    }

    public static String setAbsolute(String styleString) {
        String style = styleString;
        style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, PARAMETER_POSITION, SEMICOLON_STRING);
        if (style.length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + " position : absolute;";
        return style;
    }

    public static boolean getAbsolute(Element sourceElement) {
        String style = sourceElement.getAttribute(ATTRIBUTE_STYLE);
        if (style == null) {
            return false;
        }
        return style.indexOf(VALUE_ABSOLUTE) >= 0;
    }

    public static boolean getAbsolute(String style) {
        if (style == null) {
            return false;
        }
        return style.indexOf(VALUE_ABSOLUTE) >= 0;
    }

    public static int getSizeFromStyle(Element sourceElement, String sizeAttribute) {
        int endPosition;
        int valuePosition;
        int dotPosition = sizeAttribute.indexOf(DOT_STRING);
        String attribute = sizeAttribute.substring(0, dotPosition);
        String parameter = sizeAttribute.substring(dotPosition + 1, sizeAttribute.length());
        String style = sourceElement.getAttribute(attribute);
        if (style == null || EMPTY_STRING.equals(style)) {
            return -1;
        }
        int parameterPosition = style.indexOf(parameter);
        if (parameterPosition >= 0 && (valuePosition = style.indexOf(COLON_STRING, parameterPosition)) >= 0 && (endPosition = style.indexOf(PX_STRING, valuePosition)) >= 0) {
            return Integer.parseInt(style.substring(valuePosition + 1, endPosition).trim());
        }
        return -1;
    }

    public static String getParameterFromStyle(Element sourceElement, String sizeAttribute) {
        int endPosition;
        int valuePosition;
        int dotPosition = sizeAttribute.indexOf(DOT_STRING);
        String attribute = sizeAttribute.substring(0, dotPosition);
        String parameter = sizeAttribute.substring(dotPosition + 1, sizeAttribute.length());
        String style = sourceElement.getAttribute(attribute);
        if (style == null || EMPTY_STRING.equals(style)) {
            return null;
        }
        int parameterPosition = style.indexOf(parameter);
        if (parameterPosition >= 0 && (valuePosition = style.indexOf(COLON_STRING, parameterPosition)) >= 0 && (endPosition = style.indexOf(PX_STRING, valuePosition)) >= 0) {
            return style.substring(valuePosition + 1, endPosition).trim();
        }
        return null;
    }

    public static String getParameterFromStyleAttribute(String style, String parameter) {
        int valuePosition;
        if (style == null || EMPTY_STRING.equals(style)) {
            return null;
        }
        int parameterPosition = style.indexOf(parameter);
        if (parameterPosition >= 0 && (valuePosition = style.indexOf(COLON_STRING, parameterPosition)) >= 0) {
            int endPosition = style.indexOf(SEMICOLON_STRING, valuePosition);
            if (endPosition >= 0) {
                if ((endPosition = (style = style.substring(valuePosition + 1, endPosition).trim()).indexOf(PX_STRING, valuePosition)) >= 0) {
                    return style.substring(valuePosition + 1, endPosition).trim();
                }
                return style;
            }
            return style.substring(valuePosition + 1).trim();
        }
        return null;
    }

    public static void setParameterInStyle(Element sourceElement, String sizeAttribute, String value) {
        int dotPosition = sizeAttribute.indexOf(DOT_STRING);
        String attribute = sizeAttribute.substring(0, dotPosition);
        String parameter = sizeAttribute.substring(dotPosition + 1, sizeAttribute.length());
        String style = sourceElement.getAttribute(attribute);
        style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, parameter, SEMICOLON_STRING);
        if (style.length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + SPACE_STRING + parameter + SPACE_STRING + COLON_STRING + SPACE_STRING + value + SEMICOLON_STRING;
        sourceElement.setAttribute(attribute, style);
    }

    public static String setSizeInStyle(String style, String parameter, int size) {
        if ((style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, parameter, SEMICOLON_STRING)).length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + SPACE_STRING + parameter + SPACE_STRING + COLON_STRING + SPACE_STRING + size + PX_STRING + SEMICOLON_STRING;
        return style;
    }

    public static String setParameterInStyle(String style, String parameter, String value) {
        if ((style = style == null ? EMPTY_STRING : VpeStyleUtil.deleteFromString(style, parameter, SEMICOLON_STRING)).length() > 0 && !style.endsWith(SEMICOLON_STRING)) {
            style = String.valueOf(style) + SEMICOLON_STRING;
        }
        style = String.valueOf(style) + SPACE_STRING + parameter + SPACE_STRING + COLON_STRING + SPACE_STRING + value + SEMICOLON_STRING;
        return style;
    }

    public static void deleteFromStyle(Element sourceElement, String begin, String end) {
        String style = sourceElement.getAttribute(ATTRIBUTE_STYLE);
        style = VpeStyleUtil.deleteFromString(style, begin, end);
        sourceElement.setAttribute(ATTRIBUTE_STYLE, style);
    }

    public static String deleteFromString(String data, String begin, String end) {
        int startPosition = data.indexOf(begin);
        if (startPosition < 0) {
            return data;
        }
        int endPosition = data.indexOf(end, startPosition);
        String result = data.substring(0, startPosition).trim();
        if (endPosition > 0) {
            result = String.valueOf(result) + data.substring(endPosition + 1, data.length()).trim();
        }
        return result;
    }

    public static String addFullPathIntoBackgroundValue(String value, IEditorInput input) {
        if (value.indexOf(FILE_PROTOCOL) != -1) {
            return value;
        }
        if (!new File(value).isAbsolute()) {
            value = VpeStyleUtil.getFilePath(input, value);
        }
        value = String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + value.replace('\\', '/');
        URL url = null;
        try {
            url = new URL(value);
        }
        catch (MalformedURLException malformedURLException) {
            return value;
        }
        return url.toString();
    }

    public static String addFullPathIntoURLValue(String value, VpePageContext pageContext) {
        String[] urls = value.split(ATTR_URL);
        if (urls.length == 1) {
            return value;
        }
        String finalStr = EMPTY_STRING;
        int i = 1;
        while (i < urls.length) {
            urls[i] = urls[i].replace(SINGLE_QUOTE_STRING, EMPTY_STRING);
            urls[i] = urls[i].replace(QUOTE_STRING, EMPTY_STRING);
            urls[i] = String.valueOf(ATTR_URL) + urls[i];
            int startAttr = urls[i].indexOf(ATTR_URL);
            int startPathIndex = urls[i].indexOf(OPEN_BRACKET, startAttr);
            int endPathIndex = urls[i].indexOf(CLOSE_BRACKET, startPathIndex + 1);
            if (startPathIndex >= 0 && endPathIndex >= 0) {
                String filePath = urls[i].substring(startPathIndex + 1, endPathIndex);
                IFile file = null;
                if (pageContext.getVisualBuilder().getCurrentIncludeInfo() != null && pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage() instanceof IFile) {
                    file = (IFile)pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage();
                }
                if (file != null) {
                    filePath = VpeStyleUtil.processUrl(filePath, file);
                }
                String firstPartValue = urls[i].substring(0, startPathIndex + 1);
                String secondPartValue = urls[i].substring(endPathIndex, urls[i].length());
                urls[i] = String.valueOf(firstPartValue) + filePath + secondPartValue;
            }
            ++i;
        }
        i = 0;
        while (i < urls.length) {
            finalStr = String.valueOf(finalStr) + urls[i];
            ++i;
        }
        return finalStr;
    }

    public static String getFilePath(IEditorInput input, String fileName) {
        IPath inputPath = VpeStyleUtil.getInputParentPath(input);
        return String.valueOf(inputPath.toOSString()) + File.separator + fileName;
    }

    public static String getFilePath(String href_val, String fileName) {
        IPath inputPath = VpeStyleUtil.getInputParentPath(href_val);
        return String.valueOf(inputPath.toOSString()) + File.separator + fileName;
    }

    public static IPath getInputParentPath(IEditorInput input) {
        IFile inputFile;
        IPath inputPath = null;
        if (input instanceof ILocationProvider) {
            inputPath = ((ILocationProvider)input).getPath((Object)input);
        } else if (input instanceof IFileEditorInput && (inputFile = ((IFileEditorInput)input).getFile()) != null) {
            inputPath = inputFile.getLocation();
        }
        if (inputPath != null && !inputPath.isEmpty()) {
            inputPath = inputPath.removeLastSegments(1);
        }
        return inputPath;
    }

    public static IPath getInputParentPath(String href_val) {
        Path inputPath = null;
        inputPath = new Path(href_val);
        if (inputPath != null && !inputPath.isEmpty()) {
            inputPath = inputPath.removeLastSegments(1);
        }
        return inputPath;
    }

    public static String addFullPathIntoURLValue(String value, String href_val) {
        String[] urls = value.split(ATTR_URL);
        if (urls.length == 1) {
            return value;
        }
        String finalStr = EMPTY_STRING;
        int i = 1;
        while (i < urls.length) {
            block12: {
                urls[i] = urls[i].replace(SINGLE_QUOTE_STRING, EMPTY_STRING);
                urls[i] = urls[i].replace(QUOTE_STRING, EMPTY_STRING);
                urls[i] = String.valueOf(ATTR_URL) + urls[i];
                int startAttr = urls[i].indexOf(ATTR_URL);
                int startPathIndex = urls[i].indexOf(OPEN_BRACKET, startAttr);
                int endPathIndex = urls[i].indexOf(CLOSE_BRACKET, startPathIndex + 1);
                if (startPathIndex >= 0 && endPathIndex >= 0) {
                    String filePath = urls[i].substring(startPathIndex + 1, endPathIndex);
                    IFile sourceFile = null;
                    try {
                        URL url1 = new URL(href_val);
                        sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(url1.getPath()));
                    }
                    catch (MalformedURLException malformedURLException) {}
                    if (sourceFile != null) {
                        filePath = VpeStyleUtil.processUrl(filePath, sourceFile);
                    } else {
                        try {
                            new URL(filePath);
                            break block12;
                        }
                        catch (MalformedURLException malformedURLException) {
                            if (filePath.indexOf(FILE_PROTOCOL) != -1) break block12;
                            filePath = !new File(filePath).isAbsolute() ? VpeStyleUtil.getFilePath(href_val, filePath) : String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + filePath.replace('\\', '/');
                            URL url = null;
                            try {
                                url = new URL(filePath);
                            }
                            catch (MalformedURLException malformedURLException2) {
                                break block12;
                            }
                            filePath = url.toString();
                        }
                    }
                    String firstPartValue = urls[i].substring(0, startPathIndex + 1);
                    String secondPartValue = urls[i].substring(endPathIndex, urls[i].length());
                    urls[i] = String.valueOf(firstPartValue) + filePath + secondPartValue;
                }
            }
            ++i;
        }
        i = 0;
        while (i < urls.length) {
            finalStr = String.valueOf(finalStr) + urls[i];
            ++i;
        }
        return finalStr;
    }

    public static String getAbsoluteResourcePathUrl(String resourcePathInPlugin) {
        return String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + SLASH + VpeStyleUtil.getAbsoluteResourcePath(resourcePathInPlugin).replace('\\', '/');
    }

    public static String addFullPathToImgSrc(String path, VpePageContext pageContext, boolean showUnresolvedImage) {
        String device;
        if (path == null) {
            if (showUnresolvedImage) {
                return String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + VpeStyleUtil.getAbsoluteResourcePath(UNRESOLVED_IMAGE_PATH).replace('\\', '/');
            }
            return EMPTY_STRING;
        }
        Path tagPath = new Path(path);
        if (tagPath.isEmpty()) {
            if (showUnresolvedImage) {
                return String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + VpeStyleUtil.getAbsoluteResourcePath(UNRESOLVED_IMAGE_PATH).replace('\\', '/');
            }
            return path.replace('\\', '/');
        }
        String string = device = tagPath.getDevice() == null ? tagPath.segment(0) : tagPath.getDevice();
        if (device != null && (HTTP_PROTOCOL.equalsIgnoreCase(device) || FILE_PROTOCOL.equalsIgnoreCase(device))) {
            if (showUnresolvedImage) {
                return String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + VpeStyleUtil.getAbsoluteResourcePath(UNRESOLVED_IMAGE_PATH).replace('\\', '/');
            }
            return path.replace('\\', '/');
        }
        File locFile = tagPath.toFile();
        if (locFile.exists()) {
            return String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + SLASH + locFile.getAbsolutePath().replace('\\', '/');
        }
        IEditorInput input = pageContext.getEditPart().getEditorInput();
        IPath inputPath = VpeStyleUtil.getInputParentPath(input);
        IPath imgPath = null;
        if (input instanceof ILocationProvider) {
            imgPath = inputPath.append(path);
        } else {
            IPath basePath;
            IPath iPath = basePath = tagPath.isAbsolute() ? VpeStyleUtil.getRootPath(input) : inputPath;
            if (basePath != null) {
                imgPath = basePath.append((IPath)tagPath);
            }
        }
        if (imgPath != null && imgPath.toFile().exists()) {
            return String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + SLASH + imgPath.toString();
        }
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        if (file != null) {
            File f;
            ResourceReference resourceReference = null;
            String pathCopy = path;
            if (SLASH.equals(path.substring(0, 1))) {
                resourceReference = pageContext.getRuntimeAbsoluteFolder(file);
                pathCopy = pathCopy.substring(1);
            } else {
                resourceReference = pageContext.getRuntimeRelativeFolder(file);
            }
            String location = null;
            if (resourceReference != null) {
                location = resourceReference.getLocation();
            }
            if (location == null && file.getLocation() != null) {
                location = file.getLocation().toFile().getParent();
            }
            if (location != null && (f = new File(String.valueOf(location) + File.separator + pathCopy)).exists()) {
                return String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + SLASH + f.getPath().replace('\\', '/');
            }
        }
        if (showUnresolvedImage) {
            return String.valueOf(FILE_PROTOCOL) + SLASH + SLASH + VpeStyleUtil.getAbsoluteResourcePath(UNRESOLVED_IMAGE_PATH).replace('\\', '/');
        }
        return path.replace('\\', '/');
    }

    public static IPath getRootPath(IEditorInput input) {
        IProject project;
        Object rootPath = null;
        if (input instanceof IFileEditorInput && (project = ((IFileEditorInput)input).getFile().getProject()) != null && project.isOpen()) {
            XModel model;
            String rootPathStr;
            IModelNature modelNature = EclipseResourceUtil.getModelNature((IProject)project);
            rootPath = modelNature != null ? ((rootPathStr = WebProject.getInstance((XModel)(model = modelNature.getModel())).getWebRootLocation()) != null ? new Path(rootPathStr) : project.getLocation()) : project.getLocation();
        }
        return rootPath;
    }

    public static void refreshStyleElement(VpeVisualDomBuilder visualDomBuilder, VpeElementMapping elementMapping) {
        nsIDOMNode value = null;
        Map map = (Map)elementMapping.getData();
        if (map != null && map.size() > 0) {
            value = (nsIDOMNode)map.values().iterator().next();
        }
        if (value == null) {
            return;
        }
        Node textNode = elementMapping.getSourceNode().getFirstChild();
        String text = null;
        if (textNode != null) {
            text = textNode.getNodeValue();
        }
        nsIDOMNodeList list = value.getChildNodes();
        int i = 0;
        while ((long)i < list.getLength()) {
            value.removeChild(list.item((long)i));
            ++i;
        }
        value.appendChild((nsIDOMNode)visualDomBuilder.getXulRunnerEditor().getDOMDocument().createTextNode(text));
    }

    public static String getAbsoluteResourcePath(String resourcePathInPlugin) {
        String pluginPath = VpePlugin.getPluginResourcePath();
        Path pluginFile = new Path(pluginPath);
        File file = pluginFile.append(resourcePathInPlugin).toFile();
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        throw new RuntimeException("Can't get path for " + resourcePathInPlugin);
    }

    public static String addPxIfNecessary(String size) {
        char lastChar;
        String trimmed = size.trim();
        int length = trimmed.length();
        if (length > 0 && Character.isDigit(lastChar = trimmed.charAt(length - 1))) {
            return String.valueOf(trimmed) + PX_STRING;
        }
        return size;
    }

    public static String toPxPosition(int position) {
        return String.valueOf(Integer.toString(position)) + PX_STRING;
    }

    public static String processUrl(String url, IFile file) {
        String resolvedValue = url.replaceFirst("^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}", EMPTY_STRING);
        resolvedValue = ElService.getInstance().replaceEl(file, resolvedValue);
        URI uri = null;
        try {
            uri = new URI(resolvedValue);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (uri != null && uri.isAbsolute()) {
            return resolvedValue;
        }
        Path path = new Path(resolvedValue);
        if (resolvedValue.startsWith("/") && path.segment(0).equals(file.getProject().getName())) {
            resolvedValue = "/" + path.removeFirstSegments(1).toPortableString();
        }
        return "file://" + FileUtil.getFile(resolvedValue, file).getLocation().toPortableString();
    }

    public static String getAbsoluteWorkspacePath(String resourcePathInWorkspace, VpePageContext pageContext) {
        String resolvedValue = resourcePathInWorkspace.replaceFirst("^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}", EMPTY_STRING);
        IFile file = null;
        if (pageContext.getVisualBuilder().getCurrentIncludeInfo() != null && pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage() instanceof IFile) {
            file = (IFile)pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage();
        }
        if (file == null) {
            return resolvedValue;
        }
        resolvedValue = ElService.getInstance().replaceEl(file, resolvedValue);
        URI uri = null;
        try {
            uri = new URI(resolvedValue);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (uri != null && (uri.isAbsolute() || new File(resolvedValue).exists())) {
            return resolvedValue;
        }
        return "file://" + FileUtil.getFile(resolvedValue, file).getLocation().toPortableString();
    }

    public static void moveElementTo(nsIDOMElement element, int x, int y) {
        nsIDOMCSSStyleDeclaration style = VpeStyleUtil.getStyle(element);
        style.setProperty(PARAMETER_LEFT, VpeStyleUtil.toPxPosition(x), "important");
        style.setProperty(PARAMETER_TOP, VpeStyleUtil.toPxPosition(y), "important");
    }

    public static void setElementVisible(nsIDOMElement element, boolean visible) {
        nsIDOMCSSStyleDeclaration style = VpeStyleUtil.getStyle(element);
        style.setProperty("display", visible ? EMPTY_STRING : "none", "important");
    }
}

