/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;

public class VpeDropDownMenu {
    private Menu dropDownMenu;

    public VpeDropDownMenu(ToolBar bar, String toolTipText) {
        ToolItem item = new ToolItem(bar, 64);
        item.setToolTipText(toolTipText);
        item.setImage(ImageDescriptor.createFromFile(MozillaEditor.class, (String)"icons/arrow.gif").createImage());
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                VpeDropDownMenu.this.dropDownMenu.setLocation(pt.x, pt.y + rect.height);
                VpeDropDownMenu.this.dropDownMenu.setVisible(true);
            }
        });
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ((ToolItem)e.widget).getImage().dispose();
            }
        });
        this.dropDownMenu = new Menu((Control)item.getParent().getShell());
    }

    public Menu getDropDownMenu() {
        return this.dropDownMenu;
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }
}

