package com.jboss.jbds.installer;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import com.jboss.jbds.installer.ServerListPanel.FindActionHandler;
import com.jboss.jbds.installer.ServerListPanel.FindActionNotifier;
import com.jboss.jbds.installer.bean.ServerBean;
import com.jboss.jbds.installer.bean.ServerBeanLoader;
import com.jboss.jbds.installer.bean.ServerType;

public class FindActionHandlerTest extends TestCase {
	
	private final FindActionNotifier DO_NOTHING_NOTIFIER = new FindActionNotifier() {
		public void serverAdded(ServerBean bean) {
		}};
	
	public void testFindServeres() throws InterruptedException {
		
		List<ServerBean> servers = new ArrayList<ServerBean>();
		servers.add(new ServerBean(
				CommonTestData.AS_3_2_8_SP1.getPath(),
				CommonTestData.AS_3_2_8_SP1.getName(),
				ServerType.AS,
				"3.2"));
		servers.add(new ServerBean(
				CommonTestData.AS_4_0_5_GA.getPath(),
				CommonTestData.AS_4_0_5_GA.getName(),
				ServerType.AS,
				"4.0"));
		servers.add(new ServerBean(
				CommonTestData.AS_4_2_2_GA.getPath(),
				CommonTestData.AS_4_2_2_GA.getName(),
				ServerType.AS,
				"4.2"));
		servers.add(new ServerBean(
				CommonTestData.AS_4_2_3_GA.getPath(),
				CommonTestData.AS_4_2_3_GA.getName(),
				ServerType.AS,
				"4.2"));
		servers.add(new ServerBean(
				CommonTestData.EAP_4_3_0_GA_CP1.getPath(),
				CommonTestData.EAP_4_3_0_GA_CP1.getName(),
				ServerType.EAP,
				"4.3"));
		servers.add(new ServerBean(
				CommonTestData.SOAP_4_3_0_GA.getPath(),
				CommonTestData.SOAP_4_3_0_GA.getName(),
				ServerType.SOAP,
				"4.3"));

		servers.add(new ServerBean(
				CommonTestData.AS_3_2_8_SP1_1.getPath(),
				CommonTestData.AS_3_2_8_SP1_1.getName() + "(1)",
				ServerType.AS,
				"3.2"));
		servers.add(new ServerBean(
				CommonTestData.AS_4_0_5_GA_2.getPath(),
				CommonTestData.AS_4_0_5_GA_2.getName() + "(2)",
				ServerType.AS,
				"4.0"));
		servers.add(new ServerBean(
				CommonTestData.AS_4_2_2_GA_3.getPath(),
				CommonTestData.AS_4_2_2_GA_3.getName() + "(3)",
				ServerType.AS,
				"4.2"));
		servers.add(new ServerBean(
				CommonTestData.AS_4_2_3_GA_4.getPath(),
				CommonTestData.AS_4_2_3_GA_4.getName() + "(4)",
				ServerType.AS,
				"4.2"));
		servers.add(new ServerBean(
				CommonTestData.EAP_4_3_0_GA_CP1_5.getPath(),
				CommonTestData.EAP_4_3_0_GA_CP1_5.getName() + "(5)",
				ServerType.EAP,
				"4.3"));
		servers.add(new ServerBean(
				CommonTestData.SOAP_4_3_0_GA_6.getPath(),
				CommonTestData.SOAP_4_3_0_GA_6.getName() + "(6)",
				ServerType.SOAP,
				"4.3"));
		
		FindActionHandler handler = new ServerListPanel.FindActionHandler();
		List<ServerBean> real = handler.findServeres(CommonTestData.serverRoots, new ArrayList<ServerBean>(),DO_NOTHING_NOTIFIER);
		for (ServerBean serverBean : servers) {
			if(!real.contains(serverBean)) {
				fail("Cannot find server " + serverBean + " in find results");
			}
		}
		
		real = new ArrayList<ServerBean>();
		real.add(new ServerBean(
				CommonTestData.SOAP_4_3_0_GA_6.getPath(),
				CommonTestData.SOAP_4_3_0_GA_6.getName(),
				ServerType.SOAP,
				"4.3"));
		real.add(new ServerBean(
				CommonTestData.SOAP_4_3_0_GA_6.getPath(),
				CommonTestData.SOAP_4_3_0_GA_6.getName() + "(1)",
				ServerType.SOAP,
				"4.3"));
		real = handler.findServeres(CommonTestData.serverRoots, real,DO_NOTHING_NOTIFIER);
		
		assertTrue(real.contains(new ServerBean(
				CommonTestData.SOAP_4_3_0_GA.getPath(),
				CommonTestData.SOAP_4_3_0_GA.getName() + "(2)",
				ServerType.SOAP,
				"4.3")));
	}
	
	public void testJBDS509FindInAsRootFolder() {
		FindActionHandler handler = new ServerListPanel.FindActionHandler();
		try {
			List<ServerBean> result = handler.findServeres(CommonTestData.AS_3_2_8_SP1, new ArrayList<ServerBean>(), DO_NOTHING_NOTIFIER);
			assertEquals("One server should be found if AS root folder is seletced", 1, result.size());
			result = handler.findServeres(CommonTestData.EAP_4_3_0_GA_CP1, new ArrayList<ServerBean>(), DO_NOTHING_NOTIFIER);
			assertEquals("One server should be found if EAP root folder is seletced", 1, result.size());
			result = handler.findServeres(CommonTestData.SOAP_4_3_0_GA, new ArrayList<ServerBean>(), DO_NOTHING_NOTIFIER);
			assertEquals("One server should be found if SOA-P root folder is seletced", 1, result.size());

		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
