/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_layers_ShadowLayerChild_h
#define mozilla_layers_ShadowLayerChild_h

#include "mozilla/Attributes.h"         // for override
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/layers/PLayerChild.h"  // for PLayerChild

namespace mozilla {
namespace layers {

class ShadowableLayer;

class ShadowLayerChild : public PLayerChild
{
public:
  ShadowLayerChild();
  virtual ~ShadowLayerChild();

  void SetShadowableLayer(ShadowableLayer* aLayer);
  ShadowableLayer* layer() const { return mLayer; }

protected:
  virtual void ActorDestroy(ActorDestroyReason why) override;

private:
  ShadowableLayer* mLayer;
};

} // namespace layers
} // namespace mozilla

#endif // ifndef mozilla_layers_ShadowLayerChild_h
