/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_ProcessHangMonitorIPC_h
#define mozilla_ProcessHangMonitorIPC_h

#include "base/task.h"
#include "base/thread.h"

#include "mozilla/PProcessHangMonitor.h"
#include "mozilla/PProcessHangMonitorParent.h"
#include "mozilla/PProcessHangMonitorChild.h"

namespace mozilla {

namespace dom {
class ContentParent;
} // namespace dom

PProcessHangMonitorParent*
CreateHangMonitorParent(mozilla::dom::ContentParent* aContentParent,
                        mozilla::ipc::Transport* aTransport,
                        base::ProcessId aOtherProcess);

PProcessHangMonitorChild*
CreateHangMonitorChild(mozilla::ipc::Transport* aTransport,
                       base::ProcessId aOtherProcess);

} // namespace mozilla

#endif // mozilla_ProcessHangMonitorIPC_h
