/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.core.actions.MenuScroller;
import ancestris.modules.editors.standard.tools.SourceWrapper;
import ancestris.modules.viewers.media.MediaChooser;
import ancestris.swing.UndoTextArea;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceMedium;
import genj.gedcom.PropertyRepository;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.values.EnumOperations;
import genj.gedcom.values.MediEnum;
import genj.io.FileAssociation;
import genj.renderer.MediaUtils;
import genj.util.ReferenceSet;
import genj.util.Registry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class RepoChooser
extends JPanel
implements DocumentListener {
    private static int THUMB_WIDTH = 120;
    private static int THUMB_HEIGHT = 140;
    private Registry registry = null;
    private ThumbComparator thumbComparator = new ThumbComparator();
    private TreeSet<RepoThumb> allRepo = new TreeSet<RepoThumb>(this.thumbComparator);
    private DefaultListModel<RepoThumb> filteredModel = new DefaultListModel();
    private DefaultListModel<Object> sourceListModel = new DefaultListModel();
    private DefaultComboBoxModel<String> mediaListModel = new DefaultComboBoxModel();
    private Gedcom gedcom = null;
    private SourceWrapper source = null;
    private Repository mainSourceRepo = null;
    private JButton attachButton = null;
    private JButton detachButton = null;
    private JButton cancelButton = null;
    private boolean repoBeingEdited = false;
    private boolean isBusy = false;
    private JLabel filterLabel;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonSave;
    private JComboBox<String> jComboBoxMedia;
    private JLabel jLabelAddress;
    private JLabel jLabelCaln;
    private JLabel jLabelMail;
    private JLabel jLabelMedia;
    private JLabel jLabelName;
    private JLabel jLabelNote;
    private JLabel jLabelRepoIDLabel;
    private JLabel jLabelRepoIDValue;
    private JLabel jLabelRepoSelectLabel;
    private JLabel jLabelWeb;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneRepo;
    private JSplitPane jSplitPane;
    private JTextField jTextAddress;
    private JTextField jTextCaln;
    private JTextField jTextCity;
    private JTextField jTextCountry;
    private JTextField jTextEmail;
    private JTextField jTextName;
    private JTextField jTextWeb;
    private JTextField jTextZip;
    private JLabel legendLabel;
    private JLabel mainSourceLabel;
    private JLabel mainSourceName;
    private JLabel mainSourceRepositoryLabel;
    private JLabel mainSourceRepositoryName;
    private JButton noteLinkButton;
    private JScrollPane noteScrollPane;
    private JTextArea noteText;
    private JButton repoEmailLinkButton;
    private JList<RepoThumb> repoList;
    private JButton repoWebLinkButton;
    private JScrollPane reponoteScrollPane;
    private JTextArea reponoteText;
    private JList<Object> sourceList;
    private JLabel sourceListLabel;
    private JTextField textFilter;

    public RepoChooser(Gedcom gedcom, SourceWrapper source, JButton attachButton, JButton detachButton, JButton cancelButton) {
        this.gedcom = gedcom;
        this.source = source;
        this.mainSourceRepo = source != null ? source.getRepo() : null;
        this.attachButton = attachButton;
        this.detachButton = detachButton;
        this.cancelButton = cancelButton;
        this.createRepoThumbs();
        this.registry = Registry.get(this.getClass());
        this.initComponents();
        this.mainSourceName.setText(source != null && source.getTargetSource() != null ? source.getTargetSource().getDisplayTitle(true) : "");
        this.updateMainRepositoryName();
        this.setPreferredSize(new Dimension(this.registry.get("repoWindowWidth", this.getPreferredSize().width), this.registry.get("repoWindowHeight", this.getPreferredSize().height)));
        this.jSplitPane.setDividerLocation(this.registry.get("repoSplitDividerLocation", this.jSplitPane.getDividerLocation()));
        this.repoList.setCellRenderer(new RepoListCellRenderer());
        this.sourceList.setCellRenderer(new SourceListCellRenderer());
        this.textFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void filter() {
                RepoChooser.this.filterModel(RepoChooser.this.textFilter.getText());
            }
        });
        this.addListeners();
        this.setHotKeys();
        this.getMediaList();
        this.jComboBoxMedia.setModel(this.mediaListModel);
        Thread repoThread = new Thread(){

            @Override
            public void run() {
                RepoChooser.this.displayRepoThumbs();
                RepoChooser.this.selectRepository(RepoChooser.this.mainSourceRepo);
            }
        };
        repoThread.setName("Repo reading thread");
        repoThread.start();
    }

    private void addListeners() {
        this.jTextName.getDocument().addDocumentListener(this);
        this.jTextAddress.getDocument().addDocumentListener(this);
        this.jTextZip.getDocument().addDocumentListener(this);
        this.jTextCity.getDocument().addDocumentListener(this);
        this.jTextCountry.getDocument().addDocumentListener(this);
        this.jTextEmail.getDocument().addDocumentListener(this);
        this.jTextWeb.getDocument().addDocumentListener(this);
        this.reponoteText.getDocument().addDocumentListener(this);
        this.jTextCaln.getDocument().addDocumentListener(this);
        ((JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        this.noteText.getDocument().addDocumentListener(this);
    }

    private void setHotKeys() {
        KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
        AbstractAction enterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (RepoChooser.this.jButtonSave.isEnabled()) {
                    RepoChooser.this.jButtonSaveActionPerformed(evt);
                } else {
                    RepoChooser.this.attachButton.doClick();
                }
            }
        };
        this.registerKeyboardAction(enterAction, enterStroke, 1);
        KeyStroke escStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction escAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (RepoChooser.this.jButtonCancel.isEnabled()) {
                    RepoChooser.this.jButtonCancelActionPerformed(evt);
                } else {
                    RepoChooser.this.cancelButton.doClick();
                }
            }
        };
        this.registerKeyboardAction(escAction, escStroke, 1);
    }

    private void refreshAll(Repository selectedRepo) {
        this.isBusy = true;
        this.repoBeingEdited = false;
        this.updateMainRepositoryName();
        this.createRepoThumbs();
        this.displayRepoThumbs();
        this.selectRepository(selectedRepo);
        this.isBusy = false;
    }

    private void selectRepository(Repository selectedRepo) {
        RepoThumb selectedRepotb = null;
        for (RepoThumb repotb : this.allRepo) {
            if (repotb.entity == null && selectedRepo == null) {
                selectedRepotb = repotb;
                break;
            }
            if (repotb.entity == null || selectedRepo == null || !repotb.entity.getId().equals(selectedRepo.getId())) continue;
            selectedRepotb = repotb;
            break;
        }
        if (selectedRepotb != null) {
            RepoThumb repotb = selectedRepotb;
            WindowManager.getDefault().invokeWhenUIReady(() -> this.repoList.setSelectedValue(repotb, true));
        }
    }

    private Repository getSelectedRepository() {
        if (!this.repoList.isSelectionEmpty()) {
            RepoThumb repotb = this.filteredModel.get(this.repoList.getSelectedIndex());
            return repotb.entity;
        }
        return null;
    }

    private Repository getMainRepository() {
        PropertyRepository sourceRepo;
        Entity ent;
        Property pRepo;
        if (this.source != null && this.source.getTargetSource() != null && (pRepo = this.source.getTargetSource().getProperty("REPO")) instanceof PropertyRepository && (ent = (Entity)(sourceRepo = (PropertyRepository)pRepo).getTargetEntity().get()) instanceof Repository) {
            Repository mainRepo = (Repository)ent;
            return mainRepo;
        }
        return null;
    }

    private void clearForm() {
        this.jTextName.setText("");
        this.jTextAddress.setText("");
        this.jTextZip.setText("");
        this.jTextCity.setText("");
        this.jTextCountry.setText("");
        this.jTextEmail.setText("");
        this.jTextWeb.setText("");
        this.reponoteText.setText("");
        this.sourceListModel.removeAllElements();
        this.sourceListLabel.setText(NbBundle.getMessage(this.getClass(), (String)"RepoChooser.sourceListLabel.text", (Object)this.sourceListModel.getSize()));
        this.jTextCaln.setText("");
        ((JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent()).setText("");
        this.noteText.setText("");
        this.repoBeingEdited = false;
    }

    private void displayRepoDetails(Repository repo, SourceWrapper source) {
        Property prop;
        this.isBusy = true;
        this.clearForm();
        if (repo == null) {
            this.jLabelRepoIDValue.setText("-");
            this.isBusy = false;
            this.enableButtons();
            return;
        }
        this.jLabelRepoIDValue.setText(repo.getId());
        this.jTextName.setText(repo.getRepositoryName());
        this.jTextName.setCaretPosition(0);
        Property pAddr = repo.getProperty("ADDR");
        this.jTextAddress.setText(pAddr != null ? pAddr.getDisplayValue() : "");
        this.jTextAddress.setCaretPosition(0);
        if (pAddr != null) {
            prop = pAddr.getProperty("POST");
            this.jTextZip.setText(prop != null ? prop.getDisplayValue() : "");
            prop = pAddr.getProperty("CITY");
            this.jTextCity.setText(prop != null ? prop.getDisplayValue() : "");
            prop = pAddr.getProperty("CTRY");
            this.jTextCountry.setText(prop != null ? prop.getDisplayValue() : "");
            this.jTextZip.setCaretPosition(0);
            this.jTextCity.setCaretPosition(0);
            this.jTextCountry.setCaretPosition(0);
            this.jTextEmail.setCaretPosition(0);
            this.jTextWeb.setCaretPosition(0);
        } else {
            this.jTextZip.setText("");
            this.jTextCity.setText("");
            this.jTextCountry.setText("");
        }
        prop = repo.getProperty(this.getEmailTag());
        this.jTextEmail.setText(prop != null ? prop.getDisplayValue() : "");
        this.jTextEmail.setCaretPosition(0);
        prop = repo.getProperty(this.getWebTag());
        this.jTextWeb.setText(prop != null ? prop.getDisplayValue() : "");
        this.jTextWeb.setCaretPosition(0);
        Property pNote = repo.getProperty("NOTE");
        this.reponoteText.setText(pNote != null ? pNote.getDisplayValue() : "");
        this.reponoteText.setCaretPosition(0);
        this.getSourceList(repo);
        this.sourceListLabel.setText(NbBundle.getMessage(this.getClass(), (String)"RepoChooser.sourceListLabel.text", (Object)this.sourceListModel.getSize()));
        this.sourceList.setModel(this.sourceListModel);
        int selectedSource = 0;
        if (source != null && source.getRepo() == repo) {
            for (int i = 0; i < this.sourceListModel.getSize(); ++i) {
                Entity ent = (Entity)this.sourceListModel.getElementAt(i);
                if (ent != source.getTargetSource()) continue;
                selectedSource = i;
                break;
            }
        }
        this.getMediaList();
        this.jComboBoxMedia.setModel(this.mediaListModel);
        if (!this.sourceListModel.isEmpty()) {
            this.sourceList.setSelectedIndex(selectedSource);
        } else {
            ((JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent()).setText("");
        }
        this.isBusy = false;
        this.enableButtons();
    }

    private String getEmailTag() {
        return this.gedcom.getGrammar().equals(Grammar.V55) ? "_EMAIL" : "EMAIL";
    }

    private String getWebTag() {
        return this.gedcom.getGrammar().equals(Grammar.V55) ? "_WWW" : "WWW";
    }

    private DefaultListModel<Object> getSourceList(Repository repo) {
        this.sourceListModel.removeAllElements();
        ArrayList<Entity> sources = new ArrayList<Entity>();
        Entity[] ents = PropertyXRef.getReferences((Entity)repo);
        sources.addAll(Arrays.asList(ents));
        Collections.sort(sources, (e1, e2) -> e1.toString(true).compareTo(e2.toString(true)));
        if (!sources.contains(this.source.getTargetSource())) {
            this.sourceListModel.add(0, this.source.getTargetSource());
        }
        for (Entity ent : sources) {
            this.sourceListModel.addElement(ent);
        }
        return this.sourceListModel;
    }

    private DefaultComboBoxModel<String> getMediaList() {
        List keys;
        this.mediaListModel.removeAllElements();
        if (this.gedcom.isGrammar7()) {
            keys = Arrays.asList(EnumOperations.getDisplayChoices((Enum[])MediEnum.values()));
        } else {
            ReferenceSet refs = this.gedcom.getReferenceSet("MEDI");
            keys = refs.getKeys();
            Collections.sort(keys, (s1, s2) -> s1.toLowerCase().compareTo(s2.toLowerCase()));
        }
        for (String key : keys) {
            this.mediaListModel.addElement(key);
        }
        return this.mediaListModel;
    }

    private void initComponents() {
        this.jSplitPane = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabelRepoSelectLabel = new JLabel();
        this.jLabelRepoIDLabel = new JLabel();
        this.jLabelRepoIDValue = new JLabel();
        this.jLabelName = new JLabel();
        this.jTextName = new JTextField();
        this.jLabelAddress = new JLabel();
        this.jTextAddress = new JTextField();
        this.jTextZip = new JTextField();
        this.jTextCity = new JTextField();
        this.jTextCountry = new JTextField();
        this.jLabelMail = new JLabel();
        this.jTextEmail = new JTextField();
        this.repoEmailLinkButton = new JButton();
        this.jLabelWeb = new JLabel();
        this.jTextWeb = new JTextField();
        this.repoWebLinkButton = new JButton();
        this.reponoteScrollPane = new JScrollPane();
        this.reponoteText = new UndoTextArea();
        this.sourceListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.sourceList = new JList();
        this.jLabelCaln = new JLabel();
        this.jTextCaln = new JTextField();
        this.jLabelMedia = new JLabel();
        this.jComboBoxMedia = new JComboBox();
        this.jLabelNote = new JLabel();
        this.noteLinkButton = new JButton();
        this.noteScrollPane = new JScrollPane();
        this.noteText = new UndoTextArea();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.mainSourceLabel = new JLabel();
        this.mainSourceName = new JLabel();
        this.mainSourceRepositoryLabel = new JLabel();
        this.mainSourceRepositoryName = new JLabel();
        this.filterLabel = new JLabel();
        this.textFilter = new JTextField();
        this.jScrollPaneRepo = new JScrollPane();
        this.repoList = new JList<RepoThumb>(this.filteredModel);
        this.legendLabel = new JLabel();
        this.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.toolTipText"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                RepoChooser.this.formComponentResized(evt);
            }
        });
        this.jSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RepoChooser.this.jSplitPanePropertyChange(evt);
            }
        });
        this.jPanel1.setPreferredSize(new Dimension(250, 383));
        this.jLabelRepoSelectLabel.setFont(this.jLabelRepoSelectLabel.getFont().deriveFont(this.jLabelRepoSelectLabel.getFont().getStyle() | 1));
        this.jLabelRepoSelectLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabelRepoSelectLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelRepoSelectLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelRepoIDLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelRepoIDLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelRepoIDValue, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelRepoIDValue.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelName, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelName.text"));
        this.jTextName.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextName.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelAddress, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelAddress.text"));
        this.jTextAddress.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextAddress.text"));
        this.jTextAddress.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextAddress.toolTipText"));
        this.jTextZip.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextZip.text"));
        this.jTextZip.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextZip.toolTipText"));
        this.jTextZip.setPreferredSize(new Dimension(50, 27));
        this.jTextCity.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCity.text"));
        this.jTextCity.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCity.toolTipText"));
        this.jTextCity.setPreferredSize(new Dimension(126, 27));
        this.jTextCountry.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCountry.text"));
        this.jTextCountry.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCountry.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelMail, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelMail.text"));
        this.jTextEmail.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextEmail.text"));
        this.jTextEmail.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextEmail.toolTipText"));
        this.repoEmailLinkButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/standard/images/mail.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.repoEmailLinkButton, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.repoEmailLinkButton.text"));
        this.repoEmailLinkButton.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.repoEmailLinkButton.toolTipText"));
        this.repoEmailLinkButton.setPreferredSize(new Dimension(22, 22));
        this.repoEmailLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.repoEmailLinkButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelWeb, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelWeb.text"));
        this.jTextWeb.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextWeb.text"));
        this.jTextWeb.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextWeb.toolTipText"));
        this.repoWebLinkButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/standard/images/web.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.repoWebLinkButton, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.repoWebLinkButton.text"));
        this.repoWebLinkButton.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.repoWebLinkButton.toolTipText"));
        this.repoWebLinkButton.setPreferredSize(new Dimension(22, 22));
        this.repoWebLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.repoWebLinkButtonActionPerformed(evt);
            }
        });
        this.reponoteScrollPane.setPreferredSize(new Dimension(188, 93));
        this.reponoteText.setColumns(20);
        this.reponoteText.setLineWrap(true);
        this.reponoteText.setRows(3);
        this.reponoteText.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.reponoteText.text"));
        this.reponoteText.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.reponoteText.toolTipText"));
        this.reponoteText.setWrapStyleWord(true);
        this.reponoteScrollPane.setViewportView(this.reponoteText);
        this.sourceListLabel.setFont(new Font("DejaVu Sans", 1, 12));
        this.sourceListLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.sourceListLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.sourceListLabel.text"));
        this.sourceListLabel.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.sourceListLabel.toolTipText"));
        this.sourceListLabel.setVerticalAlignment(1);
        this.sourceList.setModel(this.sourceListModel);
        this.sourceList.setSelectionMode(0);
        this.sourceList.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.sourceList.toolTipText"));
        this.sourceList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                RepoChooser.this.sourceListMousePressed(evt);
            }
        });
        this.sourceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RepoChooser.this.sourceListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.sourceList);
        Mnemonics.setLocalizedText((JLabel)this.jLabelCaln, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelCaln.text"));
        this.jTextCaln.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCaln.text"));
        this.jTextCaln.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jTextCaln.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelMedia, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelMedia.text"));
        this.jComboBoxMedia.setEditable(true);
        this.jComboBoxMedia.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((JLabel)this.jLabelNote, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jLabelNote.text"));
        this.noteLinkButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/standard/images/web.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.noteLinkButton, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.noteLinkButton.text"));
        this.noteLinkButton.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.noteLinkButton.toolTipText"));
        this.noteLinkButton.setPreferredSize(new Dimension(22, 22));
        this.noteLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.noteLinkButtonActionPerformed(evt);
            }
        });
        this.noteText.setColumns(20);
        this.noteText.setFont(new Font("DejaVu Sans", 0, 10));
        this.noteText.setLineWrap(true);
        this.noteText.setRows(3);
        this.noteText.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.noteText.text"));
        this.noteText.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.noteText.toolTipText"));
        this.noteText.setWrapStyleWord(true);
        this.noteScrollPane.setViewportView(this.noteText);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSave, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonSave.text"));
        this.jButtonSave.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonSave.toolTipText"));
        this.jButtonSave.setEnabled(false);
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.jButtonSaveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonCancel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonCancel.text"));
        this.jButtonCancel.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonCancel.toolTipText"));
        this.jButtonCancel.setEnabled(false);
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.jButtonCancelActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonDelete, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonDelete.text"));
        this.jButtonDelete.setToolTipText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.jButtonDelete.toolTipText"));
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoChooser.this.jButtonDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.jButtonSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.sourceListLabel, -1, -1, Short.MAX_VALUE).addComponent(this.reponoteScrollPane, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelAddress).addComponent(this.jLabelName).addComponent(this.jLabelMail).addComponent(this.jLabelWeb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextZip, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextCity, -2, 1, Short.MAX_VALUE)).addComponent(this.jTextName).addComponent(this.jTextAddress).addComponent(this.jTextCountry).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextEmail).addComponent(this.jTextWeb)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.repoEmailLinkButton, GroupLayout.Alignment.TRAILING, -2, 22, -2).addComponent(this.repoWebLinkButton, GroupLayout.Alignment.TRAILING, -2, 22, -2))))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelCaln).addComponent(this.jLabelMedia).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelNote).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.noteLinkButton, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextCaln).addComponent(this.jComboBoxMedia, 0, -1, Short.MAX_VALUE).addComponent(this.noteScrollPane, -2, 0, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelRepoIDLabel).addGap(39, 39, 39).addComponent(this.jLabelRepoIDValue, -1, -1, Short.MAX_VALUE)))).addComponent(this.jLabelRepoSelectLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabelRepoSelectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelRepoIDLabel).addComponent(this.jLabelRepoIDValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelName).addComponent(this.jTextName, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAddress).addComponent(this.jTextAddress, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextZip, -2, -1, -2).addComponent(this.jTextCity, -2, -1, -2)).addGap(2, 2, 2).addComponent(this.jTextCountry, -2, -1, -2).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelMail).addComponent(this.jTextEmail, -2, -1, -2).addComponent(this.repoEmailLinkButton, -2, 22, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabelWeb).addComponent(this.jTextWeb, -2, -1, -2).addComponent(this.repoWebLinkButton, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reponoteScrollPane, -2, 77, -2).addGap(18, 18, 18).addComponent(this.sourceListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelCaln).addComponent(this.jTextCaln, -2, -1, -2)).addGap(2, 2, 2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelMedia).addComponent(this.jComboBoxMedia, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.noteScrollPane)).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.noteLinkButton, -2, -1, -2).addComponent(this.jLabelNote)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonSave).addComponent(this.jButtonDelete)).addContainerGap()));
        this.jSplitPane.setLeftComponent(this.jPanel1);
        this.jPanel2.setPreferredSize(new Dimension(200, 58));
        Mnemonics.setLocalizedText((JLabel)this.mainSourceLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.mainSourceLabel.text"));
        this.mainSourceName.setFont(this.mainSourceName.getFont().deriveFont(this.mainSourceName.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.mainSourceName, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.mainSourceName.text"));
        Mnemonics.setLocalizedText((JLabel)this.mainSourceRepositoryLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.mainSourceRepositoryLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.mainSourceRepositoryName, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.mainSourceRepositoryName.text"));
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.filterLabel.text"));
        this.textFilter.setText(NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.textFilter.text"));
        this.repoList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.repoList.setFont(new Font("DejaVu Sans Condensed", 0, 10));
        this.repoList.setSelectionMode(0);
        this.repoList.setLayoutOrientation(2);
        this.repoList.setVisibleRowCount(-1);
        this.repoList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RepoChooser.this.repoListMouseClicked(evt);
            }
        });
        this.repoList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                RepoChooser.this.repoListValueChanged(evt);
            }
        });
        this.jScrollPaneRepo.setViewportView(this.repoList);
        this.legendLabel.setFont(new Font("DejaVu Sans", 0, 10));
        Mnemonics.setLocalizedText((JLabel)this.legendLabel, (String)NbBundle.getMessage(RepoChooser.class, (String)"RepoChooser.legendLabel.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneRepo).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter, -1, 449, Short.MAX_VALUE)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.legendLabel)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.mainSourceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainSourceName, -1, -1, Short.MAX_VALUE))).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.mainSourceRepositoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mainSourceRepositoryName).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainSourceLabel).addComponent(this.mainSourceName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainSourceRepositoryLabel).addComponent(this.mainSourceRepositoryName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filterLabel).addComponent(this.textFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneRepo, -2, 484, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 106, Short.MAX_VALUE).addComponent(this.legendLabel, -2, -1, -2)));
        this.jSplitPane.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 797, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane, GroupLayout.Alignment.TRAILING, -1, 692, Short.MAX_VALUE));
    }

    private void repoListValueChanged(ListSelectionEvent evt) {
        this.displaySelection();
    }

    private void repoListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.attachButton.doClick();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("repoWindowWidth", evt.getComponent().getWidth());
        this.registry.put("repoWindowHeight", evt.getComponent().getHeight());
    }

    private void jSplitPanePropertyChange(PropertyChangeEvent evt) {
        this.registry.put("repoSplitDividerLocation", this.jSplitPane.getDividerLocation());
    }

    private void sourceListValueChanged(ListSelectionEvent evt) {
        if (this.sourceList.getSelectedIndex() == -1) {
            return;
        }
        this.isBusy = true;
        Source selectedSource = (Source)this.sourceListModel.getElementAt(this.sourceList.getSelectedIndex());
        if (selectedSource != null) {
            Property pRepo = selectedSource.getProperty("REPO");
            if (pRepo != null) {
                Property pNote;
                Property pCaln = pRepo.getProperty("CALN");
                String strCaln = pCaln != null ? pCaln.getDisplayValue() : "";
                String strMedi = "";
                JTextComponent jTextMedia = (JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent();
                if (pCaln != null) {
                    Property pMedi = pCaln.getProperty("MEDI");
                    if (pMedi instanceof PropertyChoiceMedium) {
                        PropertyChoiceMedium pChoiceMedium = (PropertyChoiceMedium)pMedi;
                        strMedi = pChoiceMedium.getPhraseDisplayValue();
                    } else {
                        strMedi = pMedi != null ? pMedi.getDisplayValue() : "";
                    }
                }
                String strNote = (pNote = pRepo.getProperty("NOTE")) != null ? pNote.getDisplayValue() : "";
                this.jTextCaln.setText(strCaln);
                jTextMedia.setText(strMedi);
                this.noteText.setText(strNote);
            } else {
                this.jTextCaln.setText("");
                JTextComponent jTextMedia = (JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent();
                jTextMedia.setText("");
                this.noteText.setText("");
            }
        }
        this.isBusy = false;
        this.enableButtons();
    }

    private void sourceListMousePressed(MouseEvent evt) {
        if (evt.getButton() == 3 && this.sourceList.getSelectedIndex() != -1) {
            Source selectedSource = (Source)this.sourceListModel.getElementAt(this.sourceList.getSelectedIndex());
            JPopupMenu menu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(MediaChooser.class, (String)"EditEntity", (Object)selectedSource.toString(true)));
            menu.add(menuItem);
            Source finalEntity = selectedSource;
            menuItem.addActionListener(arg_0 -> this.lambda$sourceListMousePressed$3((Entity)finalEntity, arg_0));
            MenuScroller.addSettingsAction((JPopupMenu)menu);
            MenuScroller.setScrollerFor((JPopupMenu)menu, (int)Math.min(menu.getSubElements().length + 2, MenuScroller.getMenuScrollerSize()), (int)40, (int)0, (int)0);
            menu.show(this.sourceList, evt.getX(), evt.getY());
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.gedcom.isWriteLocked()) {
            this.commit();
        } else {
            try {
                this.gedcom.doUnitOfWork(gedcom1 -> this.commit());
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.displaySelection();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.gedcom.isWriteLocked()) {
            this.delete();
        } else {
            try {
                this.gedcom.doUnitOfWork(gedcom1 -> this.delete());
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void noteLinkButtonActionPerformed(ActionEvent evt) {
        this.gotoLink(this.noteText.getText());
    }

    private void repoEmailLinkButtonActionPerformed(ActionEvent evt) {
        this.openMail(this.jTextEmail.getText());
    }

    private void repoWebLinkButtonActionPerformed(ActionEvent evt) {
        this.gotoLink(this.jTextWeb.getText());
    }

    private void createRepoThumbs() {
        this.allRepo.clear();
        this.allRepo.add(new RepoThumb());
        Collection entities = this.gedcom.getEntities("REPO");
        for (Repository entity : entities) {
            RepoThumb repotb = new RepoThumb(entity);
            Entity[] ents = PropertyXRef.getReferences((Entity)entity);
            repotb.setUnused(ents.length == 0);
            this.allRepo.add(repotb);
        }
    }

    private void displayRepoThumbs() {
        this.filteredModel.clear();
        for (RepoThumb item : this.allRepo) {
            this.filteredModel.addElement(item);
        }
    }

    private RepoThumb getSelectedThumb() {
        return this.repoList.getSelectedIndex() > -1 ? this.filteredModel.get(this.repoList.getSelectedIndex()) : null;
    }

    public boolean isSelectedEntityRepo() {
        RepoThumb repotb = this.getSelectedThumb();
        return repotb == null ? false : repotb.isRepo;
    }

    public Entity getSelectedEntity() {
        RepoThumb repotb = this.getSelectedThumb();
        return repotb == null ? null : repotb.entity;
    }

    public String getSelectedText() {
        RepoThumb repotb = this.getSelectedThumb();
        return repotb == null ? "" : repotb.text;
    }

    public void filterModel(String filter) {
        this.repoList.clearSelection();
        this.repoList.setModel(new DefaultListModel());
        this.filteredModel.clear();
        for (RepoThumb item : this.allRepo) {
            if (!item.text.toLowerCase().contains(filter.toLowerCase())) continue;
            this.filteredModel.addElement(item);
        }
        this.repoList.setModel(this.filteredModel);
    }

    public int getNbRepos() {
        return this.allRepo.size();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.isBusy) {
            this.repoBeingEdited = true;
        }
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.isBusy) {
            this.repoBeingEdited = true;
        }
        this.enableButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.isBusy) {
            this.repoBeingEdited = true;
        }
        this.enableButtons();
    }

    private void enableButtons() {
        if (!this.isBusy) {
            this.repoEmailLinkButton.setEnabled(this.jTextEmail.getText().toLowerCase().contains("@"));
            this.repoWebLinkButton.setEnabled(this.jTextWeb.getText().toLowerCase().contains("http"));
            this.noteLinkButton.setEnabled(this.noteText.getText().toLowerCase().contains("http"));
            boolean isMainSourcetoBeAttachedAndSelected = this.getSelectedRepository() != this.getMainRepository() && (this.sourceList.getSelectedIndex() == -1 || this.sourceListModel.getElementAt(this.sourceList.getSelectedIndex()) == this.source.getTargetSource());
            this.jButtonSave.setEnabled(this.repoBeingEdited || isMainSourcetoBeAttachedAndSelected);
            this.jButtonSave.setText(NbBundle.getMessage(RepoChooser.class, (String)(isMainSourcetoBeAttachedAndSelected ? "RepoChooser.jButtonSave.text2" : "RepoChooser.jButtonSave.text")));
            this.jButtonCancel.setEnabled(this.repoBeingEdited);
            boolean isMainSourceAttached = false;
            try {
                Property pRepo = ((Source)this.source.getTargetSource()).getProperty("REPO");
                isMainSourceAttached = pRepo != null && pRepo instanceof PropertyRepository;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.attachButton.setEnabled(!this.repoBeingEdited && (!isMainSourceAttached || this.getSelectedRepository() != this.getMainRepository()));
            this.detachButton.setEnabled(!this.repoBeingEdited && isMainSourceAttached);
            this.cancelButton.setEnabled(!this.repoBeingEdited);
        }
    }

    private void displaySelection() {
        if (!this.repoList.isSelectionEmpty()) {
            RepoThumb repotb = this.filteredModel.get(this.repoList.getSelectedIndex());
            this.displayRepoDetails(repotb.entity, this.source);
            this.enableButtons();
            this.jButtonDelete.setEnabled(repotb.entity != null);
        } else {
            this.displayRepoDetails(this.mainSourceRepo, this.source);
            this.enableButtons();
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void commit() {
        Source sourceToSave;
        Repository repoToSave = this.getSelectedRepository();
        if (repoToSave == null) {
            try {
                repoToSave = (Repository)this.gedcom.createEntity("REPO");
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
        }
        this.updateProperty((Property)repoToSave, "NAME", this.jTextName.getText());
        this.updateProperty((Property)repoToSave, "ADDR", this.jTextAddress.getText());
        Property prop = repoToSave.getProperty("ADDR");
        if (!(prop != null || this.jTextZip.getText().isBlank() && this.jTextCity.getText().isBlank() && this.jTextCountry.getText().isBlank())) {
            prop = repoToSave.addProperty("ADDR", this.jTextAddress.getText());
        }
        if (prop != null) {
            this.updateProperty(prop, "POST", this.jTextZip.getText());
            this.updateProperty(prop, "CITY", this.jTextCity.getText());
            this.updateProperty(prop, "CTRY", this.jTextCountry.getText());
        }
        this.updateProperty((Property)repoToSave, this.getEmailTag(), this.jTextEmail.getText());
        this.updateProperty((Property)repoToSave, this.getWebTag(), this.jTextWeb.getText());
        this.updateProperty((Property)repoToSave, "NOTE", this.reponoteText.getText());
        if (this.sourceList.getSelectedIndex() > -1) {
            sourceToSave = (Source)this.sourceListModel.getElementAt(this.sourceList.getSelectedIndex());
        } else {
            Source source = sourceToSave = this.source != null ? (Source)this.source.getTargetSource() : null;
        }
        if (sourceToSave != null) {
            boolean attachOrReattachSource;
            Property pRepo = sourceToSave.getProperty("REPO");
            boolean bl = attachOrReattachSource = repoToSave != this.getMainRepository();
            if (attachOrReattachSource) {
                PropertyRepository sourceRepo;
                if (pRepo == null) {
                    pRepo = sourceToSave.addRepository(repoToSave);
                } else if (pRepo instanceof PropertyRepository && repoToSave != (sourceRepo = (PropertyRepository)pRepo).getTargetEntity().get()) {
                    MediaUtils.replaceRef((PropertyXRef)sourceRepo, (Entity)((Entity)sourceRepo.getTargetEntity().get()), (Entity)repoToSave);
                }
            }
            if (pRepo != null) {
                this.updateProperty(pRepo, "CALN", this.jTextCaln.getText());
                this.updateProperty(pRepo, "NOTE", this.noteText.getText());
                String strMedi = ((JTextComponent)this.jComboBoxMedia.getEditor().getEditorComponent()).getText().trim();
                Property pCaln = pRepo.getProperty("CALN");
                if (pCaln == null && !strMedi.isBlank()) {
                    pCaln = pRepo.addProperty("CALN", "");
                }
                if (pCaln != null) {
                    this.updateProperty(pCaln, "MEDI", strMedi);
                }
            }
        }
        this.refreshAll(repoToSave);
    }

    private void updateProperty(Property parentProp, String tag, String newValue) {
        String oldValue;
        Property prop = parentProp.getProperty(tag);
        String string = oldValue = prop != null ? prop.getValue() : "";
        if (prop == null && !newValue.isBlank()) {
            parentProp.addProperty(tag, newValue);
        } else if (prop != null && !newValue.equals(oldValue)) {
            prop.setValue(newValue);
        } else if (prop != null && newValue.isBlank()) {
            parentProp.delProperty(prop);
        }
    }

    private void delete() {
        Repository repoToDelete;
        if (!this.repoList.isSelectionEmpty()) {
            RepoThumb repotb = this.filteredModel.get(this.repoList.getSelectedIndex());
            repoToDelete = repotb.entity;
        } else {
            repoToDelete = this.mainSourceRepo;
        }
        if (repoToDelete != null) {
            this.gedcom.deleteEntity((Entity)repoToDelete);
            Repository firstEnt = (Repository)this.gedcom.getFirstEntity("REPO");
            this.refreshAll((Repository)(firstEnt != null ? firstEnt : null));
        }
    }

    private void gotoLink(String text) {
        try {
            String link = text.toLowerCase().replaceAll(" ", "%20");
            int i = link.indexOf("http");
            FileAssociation.getDefault().execute(new URL(link.substring(i)));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void openMail(String text) {
        try {
            FileAssociation.getDefault().execute(new URL("mailto:" + text));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateMainRepositoryName() {
        Repository mainRepo = this.getMainRepository();
        this.mainSourceRepositoryName.setText(mainRepo != null ? mainRepo.getDisplayTitle(true) : NbBundle.getMessage(RepoChooser.class, (String)"sourceRepositoryLink.none"));
    }

    private /* synthetic */ void lambda$sourceListMousePressed$3(Entity finalEntity, ActionEvent ae) {
        this.cancelButton.doClick();
        SelectionDispatcher.fireSelection((Context)new Context(finalEntity));
    }

    private class ThumbComparator
    implements Comparator<RepoThumb> {
        private ThumbComparator() {
        }

        @Override
        public int compare(RepoThumb o1, RepoThumb o2) {
            String ent1 = o1.entity == null ? "0" : "1";
            String ent2 = o2.entity == null ? "0" : "1";
            String id1 = o1.entity == null ? "" : o1.entity.getId();
            String id2 = o2.entity == null ? "" : o2.entity.getId();
            String total1 = ent1 + o1.title.toLowerCase() + id1;
            String total2 = ent2 + o2.title.toLowerCase() + id2;
            return total1.compareTo(total2);
        }
    }

    private class RepoListCellRenderer
    extends JLabel
    implements ListCellRenderer<RepoThumb> {
        private RepoListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends RepoThumb> list, RepoThumb value, int index, boolean isSelected, boolean cellHasFocus) {
            String color;
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(1);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredSoftBevelBorder())));
            int labelWidth = THUMB_WIDTH - 8;
            int labelHeight = THUMB_HEIGHT - 8;
            int nbLines = labelHeight / 18;
            int nbTotalLines = this.getFontMetrics(this.getFont()).stringWidth(value.text) / labelWidth;
            int nbMaxCars = value.text.length();
            String add = "";
            if (nbTotalLines > nbLines) {
                nbMaxCars = nbMaxCars * nbLines / nbTotalLines - 3;
                add = "...";
            }
            String text = value.text.substring(0, Math.min(value.text.length(), nbMaxCars)) + add;
            this.setPreferredSize(new Dimension(labelWidth, labelHeight));
            boolean isDarkTheme = UIManager.getBoolean("nb.dark.theme");
            String string = value.isRepo && !value.isUnused ? (isDarkTheme ? "white" : "black") : (color = !value.isRepo && !value.isUnused ? "blue" : "red");
            if (value.entity == null) {
                text = "<center><font size=+0><br><br><i><b>" + text + "</b></i></font></center>";
            }
            this.setText("<html><font color=" + color + ">" + text + "</font></html>");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class SourceListCellRenderer
    extends DefaultListCellRenderer {
        private SourceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            Source entry = (Source)value;
            Object text = "";
            if (value != null) {
                text = entry.getDisplayTitle(true);
                String attr = "";
                if (entry == RepoChooser.this.source.getTargetSource()) {
                    Repository selectedRepo = RepoChooser.this.getSelectedRepository();
                    Repository mainSourceRepo = RepoChooser.this.getMainRepository();
                    if (mainSourceRepo == null) {
                        attr = NbBundle.getMessage(RepoChooser.class, (String)"sourceRepositoryLink.none");
                    } else if (mainSourceRepo == selectedRepo) {
                        attr = NbBundle.getMessage(RepoChooser.class, (String)"sourceRepositoryLink.this");
                    } else if (mainSourceRepo != selectedRepo) {
                        attr = NbBundle.getMessage(RepoChooser.class, (String)"sourceRepositoryLink.other", (Object)mainSourceRepo.getId());
                    }
                    text = entry.getDisplayTitle(true) + " (" + attr + ")";
                }
            }
            return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }

    private class RepoThumb {
        public boolean isRepo = true;
        public Repository entity = null;
        public String title = "";
        public String text = "";
        public boolean isUnused = false;

        public RepoThumb() {
            this.entity = null;
            this.title = NbBundle.getMessage(this.getClass(), (String)"NewRepoTitle");
            this.text = NbBundle.getMessage(this.getClass(), (String)"NewRepoText");
        }

        public RepoThumb(Repository entity) {
            Property prop;
            this.entity = entity;
            this.title = entity.toString(true);
            this.text = "<center>" + entity.toString(true) + "</center>";
            Property pAddr = entity.getProperty("ADDR");
            if (pAddr != null) {
                String str;
                prop = pAddr.getProperty("CITY");
                if (prop != null && !prop.getDisplayValue().trim().isEmpty()) {
                    this.text = this.text + "<br>&bull;&nbsp;" + prop.getDisplayValue();
                }
                if ((prop = pAddr.getProperty("CTRY")) != null && !prop.getDisplayValue().trim().isEmpty()) {
                    this.text = this.text + ", " + prop.getDisplayValue();
                }
                if (!pAddr.getDisplayValue().trim().isEmpty() && (str = pAddr.getDisplayValue()).length() > 0) {
                    this.text = this.text + "<br>&bull;&nbsp;" + str.substring(0, Math.min(16, str.length() - 1)) + ".";
                }
            }
            if ((prop = entity.getProperty("NOTE")) != null) {
                this.text = this.text + "<br>&bull;&nbsp;" + prop.getDisplayValue();
            }
        }

        private void setUnused(boolean b) {
            this.isUnused = b;
        }
    }
}

