/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.IndiCreator;
import ancestris.modules.editors.standard.tools.Utils;
import genj.gedcom.Indi;
import genj.gedcom.PropertyPlace;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class IndiChooser
extends JPanel
implements DocumentListener {
    private List<Indi> indis = null;
    private Indi[] filteredList = null;
    private Indi sourceIndi = null;
    private int relation = 0;
    private JButton okButton = null;
    private String okButtonStdLabel = "";
    private Indi selectedIndi = null;
    private JLabel ListLabel;
    private JLabel controlMessage;
    private JCheckBox femaleCheckBox;
    private JLabel filterLabel;
    private JList<Indi> indisList;
    private JCheckBox likelyCheckBox;
    private JScrollPane listScrollPane;
    private JCheckBox maleCheckBox;
    private JLabel selectedBirth;
    private JLabel selectedDeath;
    private JLabel selectedName;
    private JLabel selectionBirth;
    private JLabel selectionDeath;
    private JLabel selectionLabel;
    private JTextField textFilter;
    private JCheckBox unknownCheckBox;

    public IndiChooser(Indi sourceIndi, String filter, int relation, JButton okButton) {
        this.indis = new ArrayList<Indi>(sourceIndi.getGedcom().getEntities("INDI"));
        this.filteredList = new Indi[0];
        this.sourceIndi = sourceIndi;
        this.relation = relation;
        this.okButton = okButton;
        this.okButtonStdLabel = okButton.getText();
        this.initComponents();
        this.maleCheckBox.setSelected(relation == IndiCreator.REL_FATHER || relation == IndiCreator.REL_BROTHER || relation == IndiCreator.REL_PARTNER && sourceIndi.getSex() == 2 || relation == IndiCreator.REL_CHILD);
        this.femaleCheckBox.setSelected(relation == IndiCreator.REL_MOTHER || relation == IndiCreator.REL_SISTER || relation == IndiCreator.REL_PARTNER && sourceIndi.getSex() == 1 || relation == IndiCreator.REL_CHILD);
        okButton.setEnabled(false);
        this.textFilter.getDocument().addDocumentListener(this);
        this.resetLabels();
        this.updateFilter(filter);
        if (filter.isEmpty()) {
            this.updateList();
        }
    }

    private void initComponents() {
        this.filterLabel = new JLabel();
        this.maleCheckBox = new JCheckBox();
        this.femaleCheckBox = new JCheckBox();
        this.unknownCheckBox = new JCheckBox();
        this.likelyCheckBox = new JCheckBox();
        this.textFilter = new JTextField();
        this.ListLabel = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.indisList = new JList<Indi>(this.filteredList);
        this.selectionLabel = new JLabel();
        this.selectionBirth = new JLabel();
        this.selectionDeath = new JLabel();
        this.selectedName = new JLabel();
        this.selectedBirth = new JLabel();
        this.selectedDeath = new JLabel();
        this.controlMessage = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.filterLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.maleCheckBox, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.maleCheckBox.text"));
        this.maleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndiChooser.this.maleCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.femaleCheckBox, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.femaleCheckBox.text"));
        this.femaleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndiChooser.this.femaleCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.unknownCheckBox, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.unknownCheckBox.text"));
        this.unknownCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndiChooser.this.unknownCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.likelyCheckBox, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.likelyCheckBox.text"));
        this.likelyCheckBox.setToolTipText(NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.likelyCheckBox.toolTipText"));
        this.likelyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndiChooser.this.likelyCheckBoxActionPerformed(evt);
            }
        });
        this.textFilter.setForeground(new Color(102, 102, 102));
        this.textFilter.setText(NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.textFilter.text"));
        this.textFilter.setToolTipText(NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.textFilter.tooltipText"));
        Mnemonics.setLocalizedText((JLabel)this.ListLabel, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.ListLabel.text"));
        this.indisList.setSelectionMode(0);
        this.indisList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IndiChooser.this.indisListMouseClicked(evt);
            }
        });
        this.indisList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                IndiChooser.this.indisListValueChanged(evt);
            }
        });
        this.listScrollPane.setViewportView(this.indisList);
        Mnemonics.setLocalizedText((JLabel)this.selectionLabel, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.selectionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.selectionBirth, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.selectionBirth.text"));
        Mnemonics.setLocalizedText((JLabel)this.selectionDeath, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.selectionDeath.text"));
        this.selectedName.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.selectedName, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.selectedName.text"));
        Mnemonics.setLocalizedText((JLabel)this.selectedBirth, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.selectedBirth.text"));
        Mnemonics.setLocalizedText((JLabel)this.selectedDeath, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.selectedDeath.text"));
        this.controlMessage.setForeground(new Color(255, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.controlMessage, (String)NbBundle.getMessage(IndiChooser.class, (String)"IndiChooser.controlMessage.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.controlMessage, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectionLabel).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectionDeath).addComponent(this.selectionBirth)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.selectedBirth, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.selectedName, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.selectedDeath, -1, -1, Short.MAX_VALUE))).addComponent(this.ListLabel, -1, -1, Short.MAX_VALUE).addComponent(this.textFilter).addComponent(this.listScrollPane).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.maleCheckBox).addGap(18, 18, 18).addComponent(this.femaleCheckBox).addGap(18, 18, 18).addComponent(this.unknownCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.likelyCheckBox)).addComponent(this.filterLabel, -1, 582, Short.MAX_VALUE)).addGap(1, 1, 1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.filterLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maleCheckBox).addComponent(this.femaleCheckBox).addComponent(this.unknownCheckBox).addComponent(this.likelyCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFilter, -2, -1, -2).addGap(18, 18, 18).addComponent(this.ListLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.listScrollPane, -1, 315, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectionLabel).addComponent(this.selectedName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectionBirth).addComponent(this.selectedBirth)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectionDeath).addComponent(this.selectedDeath)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.controlMessage).addGap(8, 8, 8)));
    }

    private void maleCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void femaleCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void unknownCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void indisListValueChanged(ListSelectionEvent evt) {
        this.selectedIndi = this.indisList.getSelectedValue();
        boolean isSelected = this.selectedIndi != null;
        this.okButton.setEnabled(isSelected);
        if (isSelected) {
            this.selectedName.setText(this.selectedIndi.toString());
            Object str = this.selectedIndi.getBirthAsString();
            if (((String)str).isEmpty()) {
                str = "- ";
            }
            str = (String)str + ", ";
            PropertyPlace pp = this.selectedIndi.getBirthPlace();
            str = (String)str + (pp != null ? pp.getCity() : " - ");
            this.selectedBirth.setText((String)str);
            str = this.selectedIndi.getDeathAsString();
            if (((String)str).isEmpty()) {
                str = "- ";
            }
            str = (String)str + ", ";
            pp = this.selectedIndi.getDeathPlace();
            str = (String)str + (pp != null ? pp.getCity() : " - ");
            this.selectedDeath.setText((String)str);
            Utils.TestResult ret = Utils.likelyResult(this.selectedIndi, this.relation, this.sourceIndi, 0);
            String msg = "";
            this.okButton.setText(this.okButtonStdLabel);
            if (ret.getErr() > 0) {
                msg = NbBundle.getMessage(this.getClass(), (String)("ERR_MSG_" + ret.getErr()), (Object)ret.getSetting());
                this.okButton.setText(NbBundle.getMessage(this.getClass(), (String)"ConfirmOK"));
            }
            this.controlMessage.setText(msg);
        } else {
            this.resetLabels();
        }
    }

    private void likelyCheckBoxActionPerformed(ActionEvent evt) {
        this.updateList();
    }

    private void indisListMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && this.okButton.isEnabled()) {
            this.okButton.doClick();
        }
    }

    public Indi getIndi() {
        return this.selectedIndi;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateList();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateList();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateList();
    }

    private void updateList() {
        boolean likely = true;
        ArrayList<Indi> tmpList = new ArrayList<Indi>();
        for (Indi i : this.indis) {
            boolean isSexOK;
            if (i == this.sourceIndi || !i.toString().toLowerCase().contains(this.textFilter.getText().toLowerCase()) || !(isSexOK = i.getSex() == 1 && this.maleCheckBox.isSelected() || i.getSex() == 2 && this.femaleCheckBox.isSelected() || i.getSex() == 0 && this.unknownCheckBox.isSelected())) continue;
            if (this.likelyCheckBox.isSelected()) {
                likely = Utils.isLikely(i, this.relation, this.sourceIndi, 0);
            }
            if (!likely) continue;
            tmpList.add(i);
        }
        Collections.sort(tmpList, (i1, i2) -> i1.toString().toLowerCase().compareTo(i2.toString().toLowerCase()));
        this.filteredList = (Indi[])tmpList.toArray(Indi[]::new);
        this.indisList.setListData((Indi[])this.filteredList);
        if (this.filteredList.length == 0 && !this.textFilter.getText().isEmpty()) {
            this.updateFilter("");
        }
    }

    private void resetLabels() {
        this.selectedName.setText("-");
        this.selectedBirth.setText("-, -");
        this.selectedDeath.setText("-, -");
        this.controlMessage.setText("");
        this.okButton.setText(this.okButtonStdLabel);
    }

    private void updateFilter(String str) {
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            this.textFilter.setText(str);
            this.textFilter.setCaretPosition(str.length());
            this.textFilter.requestFocus();
        });
    }
}

