/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.input.CenterMapListener;
import org.jxmapviewer.input.PanMouseInputListener;
import org.jxmapviewer.input.ZoomMouseWheelListenerCursor;
import org.jxmapviewer.painter.AbstractPainter;
import org.jxmapviewer.painter.CompoundPainter;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.DefaultWaypoint;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.Waypoint;
import org.jxmapviewer.viewer.WaypointPainter;

public class JXMapKit
extends JPanel {
    private static final long serialVersionUID = -8366577998349912380L;
    private static final int DEFAULT_ZOOM = 8;
    private boolean miniMapVisible = true;
    private boolean zoomSliderVisible = true;
    private boolean zoomButtonsVisible = true;
    private final boolean sliderReversed = false;
    private DefaultProviders defaultProvider = DefaultProviders.OpenStreetMaps;
    private boolean addressLocationShown = true;
    private boolean dataProviderCreditShown = true;
    private GeoPosition mapCenterPosition = new GeoPosition(0.0, 0.0);
    private boolean zoomChanging = false;
    private JPanel jPanel1;
    private JXMapViewer mainMap;
    private JXMapViewer miniMap;
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JSlider zoomSlider;
    private AbstractPainter<JXMapViewer> dataProviderCreditPainter = new AbstractPainter<JXMapViewer>(true){

        @Override
        protected void doPaint(Graphics2D g, JXMapViewer map, int width, int height) {
            String attribution;
            try {
                attribution = JXMapKit.this.mainMap.getTileFactory().getInfo().getAttribution();
            }
            catch (NullPointerException ex) {
                attribution = "\u00a9 cartographic contributors";
            }
            g.setPaint(Color.BLACK);
            g.drawString(attribution, 50, map.getHeight() - 10);
        }
    };
    private WaypointPainter<Waypoint> addressLocationPainter = new WaypointPainter<Waypoint>(){

        @Override
        public Set<Waypoint> getWaypoints() {
            HashSet<Waypoint> set = new HashSet<Waypoint>();
            if (JXMapKit.this.getAddressLocation() != null) {
                set.add(new DefaultWaypoint(JXMapKit.this.getAddressLocation()));
            } else {
                set.add(new DefaultWaypoint(0.0, 0.0));
            }
            return set;
        }
    };

    public JXMapKit() {
        this.initComponents();
        this.zoomSlider.setOpaque(false);
        try {
            ImageIcon minusIcon = new ImageIcon(JXMapKit.class.getResource("/org/jxmapviewer/images/minus.png"));
            this.zoomOutButton.setIcon(minusIcon);
            this.zoomOutButton.setText("");
            ImageIcon plusIcon = new ImageIcon(JXMapKit.class.getResource("/org/jxmapviewer/images/plus.png"));
            this.zoomInButton.setIcon(plusIcon);
            this.zoomInButton.setText("");
        }
        catch (Throwable thr) {
            System.out.println("error: " + thr.getMessage());
            thr.printStackTrace();
        }
        OSMTileFactoryInfo info = new OSMTileFactoryInfo();
        DefaultTileFactory tileFactory = new DefaultTileFactory(info);
        this.setTileFactory(tileFactory);
        this.mainMap.setCenterPosition(new GeoPosition(0.0, 0.0));
        this.miniMap.setCenterPosition(new GeoPosition(0.0, 0.0));
        this.mainMap.setRestrictOutsidePanning(true);
        this.miniMap.setRestrictOutsidePanning(true);
        this.rebuildMainMapOverlay();
        this.mainMap.addPropertyChangeListener("center", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Point2D mapCenter = (Point2D)evt.getNewValue();
                TileFactory tf = JXMapKit.this.mainMap.getTileFactory();
                GeoPosition mapPos = tf.pixelToGeo(mapCenter, JXMapKit.this.mainMap.getZoom());
                JXMapKit.this.miniMap.setCenterPosition(mapPos);
            }
        });
        this.mainMap.addPropertyChangeListener("centerPosition", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JXMapKit.this.mapCenterPosition = (GeoPosition)evt.getNewValue();
                JXMapKit.this.miniMap.setCenterPosition(JXMapKit.this.mapCenterPosition);
                Point2D pt = JXMapKit.this.miniMap.getTileFactory().geoToPixel(JXMapKit.this.mapCenterPosition, JXMapKit.this.miniMap.getZoom());
                JXMapKit.this.miniMap.setCenter(pt);
                JXMapKit.this.miniMap.repaint();
            }
        });
        PanMouseInputListener mia = new PanMouseInputListener(this.mainMap);
        this.mainMap.addMouseListener(mia);
        this.mainMap.addMouseMotionListener(mia);
        this.mainMap.addMouseListener(new CenterMapListener(this.mainMap));
        this.mainMap.addMouseWheelListener(new ZoomMouseWheelListenerCursor(this.mainMap));
        this.mainMap.addPropertyChangeListener("zoom", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JXMapKit.this.zoomSlider.setValue(JXMapKit.this.mainMap.getZoom());
                JXMapKit.this.miniMap.setZoom(JXMapKit.this.mainMap.getZoom() + 4);
            }
        });
        this.miniMap.setOverlayPainter((Painter<? super JXMapViewer>)new Painter<JXMapViewer>(){

            @Override
            public void paint(Graphics2D g, JXMapViewer map, int width, int height) {
                Rectangle mainMapBounds = JXMapKit.this.mainMap.getViewportBounds();
                Point2D upperLeft2D = mainMapBounds.getLocation();
                Point2D lowerRight2D = new Point2D.Double(upperLeft2D.getX() + mainMapBounds.getWidth(), upperLeft2D.getY() + mainMapBounds.getHeight());
                GeoPosition upperLeft = JXMapKit.this.mainMap.getTileFactory().pixelToGeo(upperLeft2D, JXMapKit.this.mainMap.getZoom());
                GeoPosition lowerRight = JXMapKit.this.mainMap.getTileFactory().pixelToGeo(lowerRight2D, JXMapKit.this.mainMap.getZoom());
                upperLeft2D = map.getTileFactory().geoToPixel(upperLeft, map.getZoom());
                lowerRight2D = map.getTileFactory().geoToPixel(lowerRight, map.getZoom());
                g = (Graphics2D)g.create();
                Rectangle rect = map.getViewportBounds();
                g.translate(-rect.x, -rect.y);
                g.setPaint(Color.RED);
                g.drawRect((int)upperLeft2D.getX(), (int)upperLeft2D.getY(), (int)(lowerRight2D.getX() - upperLeft2D.getX()), (int)(lowerRight2D.getY() - upperLeft2D.getY()));
                g.setPaint(new Color(255, 0, 0, 50));
                g.fillRect((int)upperLeft2D.getX(), (int)upperLeft2D.getY(), (int)(lowerRight2D.getX() - upperLeft2D.getX()), (int)(lowerRight2D.getY() - upperLeft2D.getY()));
                g.dispose();
            }
        });
        this.setCenterPosition(new GeoPosition(0.0, 0.0));
    }

    public void setZoom(int zoom) {
        this.zoomChanging = true;
        this.mainMap.setZoom(zoom);
        this.miniMap.setZoom(this.mainMap.getZoom() + 4);
        this.zoomSlider.setValue(zoom);
        this.zoomChanging = false;
    }

    public Action getZoomOutAction() {
        AbstractAction act = new AbstractAction(){
            private static final long serialVersionUID = 5525706163434375107L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JXMapKit.this.setZoom(JXMapKit.this.mainMap.getZoom() - 1);
            }
        };
        act.putValue("Name", "-");
        return act;
    }

    public Action getZoomInAction() {
        AbstractAction act = new AbstractAction(){
            private static final long serialVersionUID = 5779971489365451352L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JXMapKit.this.setZoom(JXMapKit.this.mainMap.getZoom() + 1);
            }
        };
        act.putValue("Name", "+");
        return act;
    }

    private void initComponents() {
        this.mainMap = new JXMapViewer();
        this.miniMap = new JXMapViewer();
        this.jPanel1 = new JPanel();
        this.zoomInButton = new JButton();
        this.zoomOutButton = new JButton();
        this.zoomSlider = new JSlider();
        this.setLayout(new GridBagLayout());
        this.mainMap.setLayout(new GridBagLayout());
        this.miniMap.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.miniMap.setMinimumSize(new Dimension(100, 100));
        this.miniMap.setPreferredSize(new Dimension(100, 100));
        this.miniMap.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainMap.add((Component)this.miniMap, gridBagConstraints);
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.zoomInButton.setAction(this.getZoomOutAction());
        this.zoomInButton.setIcon(new ImageIcon(JXMapKit.class.getResource("/org/jxmapviewer/images/plus.png")));
        this.zoomInButton.setMargin(new Insets(2, 2, 2, 2));
        this.zoomInButton.setMaximumSize(new Dimension(20, 20));
        this.zoomInButton.setMinimumSize(new Dimension(20, 20));
        this.zoomInButton.setOpaque(false);
        this.zoomInButton.setPreferredSize(new Dimension(20, 20));
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JXMapKit.this.zoomInButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.zoomInButton, gridBagConstraints);
        this.zoomOutButton.setAction(this.getZoomInAction());
        this.zoomOutButton.setIcon(new ImageIcon(JXMapKit.class.getResource("/org/jxmapviewer/images/minus.png")));
        this.zoomOutButton.setMargin(new Insets(2, 2, 2, 2));
        this.zoomOutButton.setMaximumSize(new Dimension(20, 20));
        this.zoomOutButton.setMinimumSize(new Dimension(20, 20));
        this.zoomOutButton.setOpaque(false);
        this.zoomOutButton.setPreferredSize(new Dimension(20, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.zoomOutButton, gridBagConstraints);
        this.zoomSlider.setMajorTickSpacing(1);
        this.zoomSlider.setMaximum(15);
        this.zoomSlider.setMinimum(10);
        this.zoomSlider.setMinorTickSpacing(1);
        this.zoomSlider.setOrientation(1);
        this.zoomSlider.setPaintTicks(true);
        this.zoomSlider.setSnapToTicks(true);
        this.zoomSlider.setMinimumSize(new Dimension(35, 100));
        this.zoomSlider.setPreferredSize(new Dimension(35, 190));
        this.zoomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JXMapKit.this.zoomSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        this.jPanel1.add((Component)this.zoomSlider, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mainMap.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.mainMap, gridBagConstraints);
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
    }

    private void zoomSliderStateChanged(ChangeEvent evt) {
        if (!this.zoomChanging) {
            this.setZoom(this.zoomSlider.getValue());
        }
    }

    public boolean isMiniMapVisible() {
        return this.miniMapVisible;
    }

    public void setMiniMapVisible(boolean miniMapVisible) {
        boolean old = this.isMiniMapVisible();
        this.miniMapVisible = miniMapVisible;
        this.miniMap.setVisible(miniMapVisible);
        this.firePropertyChange("miniMapVisible", old, this.isMiniMapVisible());
    }

    public boolean isZoomSliderVisible() {
        return this.zoomSliderVisible;
    }

    public void setZoomSliderVisible(boolean zoomSliderVisible) {
        boolean old = this.isZoomSliderVisible();
        this.zoomSliderVisible = zoomSliderVisible;
        this.zoomSlider.setVisible(zoomSliderVisible);
        this.firePropertyChange("zoomSliderVisible", old, this.isZoomSliderVisible());
    }

    public boolean isZoomButtonsVisible() {
        return this.zoomButtonsVisible;
    }

    public void setZoomButtonsVisible(boolean zoomButtonsVisible) {
        boolean old = this.isZoomButtonsVisible();
        this.zoomButtonsVisible = zoomButtonsVisible;
        this.zoomInButton.setVisible(zoomButtonsVisible);
        this.zoomOutButton.setVisible(zoomButtonsVisible);
        this.firePropertyChange("zoomButtonsVisible", old, this.isZoomButtonsVisible());
    }

    public final void setTileFactory(TileFactory fact) {
        this.mainMap.setTileFactory(fact);
        this.mainMap.setZoom(fact.getInfo().getDefaultZoomLevel());
        this.mainMap.setCenterPosition(new GeoPosition(0.0, 0.0));
        this.miniMap.setTileFactory(fact);
        this.miniMap.setZoom(fact.getInfo().getDefaultZoomLevel() + 3);
        this.miniMap.setCenterPosition(new GeoPosition(0.0, 0.0));
        this.zoomSlider.setMinimum(fact.getInfo().getMinimumZoomLevel());
        this.zoomSlider.setMaximum(fact.getInfo().getMaximumZoomLevel());
    }

    public void setCenterPosition(GeoPosition pos) {
        this.mainMap.setCenterPosition(pos);
        this.miniMap.setCenterPosition(pos);
    }

    public GeoPosition getCenterPosition() {
        return this.mainMap.getCenterPosition();
    }

    public GeoPosition getAddressLocation() {
        return this.mainMap.getAddressLocation();
    }

    public void setAddressLocation(GeoPosition pos) {
        this.mainMap.setAddressLocation(pos);
    }

    public JXMapViewer getMainMap() {
        return this.mainMap;
    }

    public JXMapViewer getMiniMap() {
        return this.miniMap;
    }

    public JButton getZoomInButton() {
        return this.zoomInButton;
    }

    public JButton getZoomOutButton() {
        return this.zoomOutButton;
    }

    public JSlider getZoomSlider() {
        return this.zoomSlider;
    }

    public void setAddressLocationShown(boolean b) {
        boolean old = this.isAddressLocationShown();
        this.addressLocationShown = b;
        this.addressLocationPainter.setVisible(b);
        this.firePropertyChange("addressLocationShown", old, b);
        this.repaint();
    }

    public boolean isAddressLocationShown() {
        return this.addressLocationShown;
    }

    public void setDataProviderCreditShown(boolean b) {
        boolean old = this.isDataProviderCreditShown();
        this.dataProviderCreditShown = b;
        this.dataProviderCreditPainter.setVisible(b);
        this.repaint();
        this.firePropertyChange("dataProviderCreditShown", old, b);
    }

    public boolean isDataProviderCreditShown() {
        return this.dataProviderCreditShown;
    }

    private void rebuildMainMapOverlay() {
        CompoundPainter cp = new CompoundPainter();
        cp.setCacheable(false);
        cp.setPainters(this.dataProviderCreditPainter, this.addressLocationPainter);
        this.mainMap.setOverlayPainter(cp);
    }

    public void setDefaultProvider(DefaultProviders prov) {
        DefaultProviders old = this.defaultProvider;
        this.defaultProvider = prov;
        if (prov == DefaultProviders.OpenStreetMaps) {
            OSMTileFactoryInfo info = new OSMTileFactoryInfo();
            DefaultTileFactory tf = new DefaultTileFactory(info);
            this.setTileFactory(tf);
            this.setZoom(8);
            this.setAddressLocation(new GeoPosition(51.5, 0.0));
        }
        this.firePropertyChange("defaultProvider", (Object)old, (Object)prov);
        this.repaint();
    }

    public DefaultProviders getDefaultProvider() {
        return this.defaultProvider;
    }

    public AbstractPainter<JXMapViewer> getDataProviderCreditPainter() {
        return this.dataProviderCreditPainter;
    }

    public void setDataProviderCreditPainter(AbstractPainter<JXMapViewer> dataProviderCreditPainter) {
        this.dataProviderCreditPainter = dataProviderCreditPainter;
        this.rebuildMainMapOverlay();
    }

    public WaypointPainter<Waypoint> getAddressLocationPainter() {
        return this.addressLocationPainter;
    }

    public void setAddressLocationPainter(WaypointPainter<Waypoint> addressLocationPainter) {
        this.addressLocationPainter = addressLocationPainter;
        this.rebuildMainMapOverlay();
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JXMapKit kit = new JXMapKit();
                kit.setDefaultProvider(DefaultProviders.OpenStreetMaps);
                OSMTileFactoryInfo info = new OSMTileFactoryInfo();
                DefaultTileFactory tf = new DefaultTileFactory(info);
                kit.setTileFactory(tf);
                kit.setZoom(14);
                kit.setAddressLocation(new GeoPosition(51.5, 0.0));
                kit.getMainMap().setDrawTileBorders(true);
                kit.getMainMap().setRestrictOutsidePanning(true);
                kit.getMainMap().setHorizontalWrapped(false);
                ((DefaultTileFactory)kit.getMainMap().getTileFactory()).setThreadPoolSize(8);
                JFrame frame = new JFrame("JXMapKit test");
                frame.add(kit);
                frame.pack();
                frame.setSize(500, 300);
                frame.setVisible(true);
            }
        });
    }

    public static enum DefaultProviders {
        OpenStreetMaps,
        Custom;

    }
}

