/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.commonAncestor;

import ancestris.modules.commonAncestor.PreviewTopComponent;
import ancestris.modules.commonAncestor.Renderer;
import ancestris.modules.commonAncestor.SamePanel;
import ancestris.modules.commonAncestor.Step;
import ancestris.modules.commonAncestor.graphics.GraphicsOutputFactory;
import ancestris.modules.commonAncestor.graphics.IGraphicsOutput;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class CommonAncestorTree {
    static final Logger LOG = Logger.getLogger("genj.report");
    private final List<Step> firstIndiDirectLinks = new ArrayList<Step>();
    private final List<Step> secondIndiDirectLinks = new ArrayList<Step>();
    private final GraphicsOutputFactory outputs = new GraphicsOutputFactory();

    public Set<Fam> findCommonAncestors(Indi indi1, Indi indi2) {
        try {
            LinkedHashSet<Fam> ancestorList = new LinkedHashSet<Fam>();
            if (indi1 == null || indi2 == null) {
                return ancestorList;
            }
            if (indi1.isAncestorOf(indi2)) {
                return this.getFamAncestorOf(indi1, indi2);
            }
            if (indi2.isAncestorOf(indi1)) {
                return this.getFamAncestorOf(indi2, indi1);
            }
            return this.getFirstCommonAncestors(indi1, indi2);
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public boolean selectLines(Indi indi1, Indi indi2, Fam ancestorFam) {
        this.firstIndiDirectLinks.clear();
        this.secondIndiDirectLinks.clear();
        Indi ancestor = ancestorFam.getHusband();
        if (ancestor == null) {
            ancestor = ancestorFam.getWife();
        }
        if (indi1 == null || indi2 == null || ancestor == null) {
            return false;
        }
        List lines1 = ancestor.getAncestorLinesWith(indi1);
        List lines2 = ancestor.getAncestorLinesWith(indi2);
        if (lines1.size() + lines2.size() == 0) {
            return false;
        }
        List line1 = !lines1.isEmpty() ? (List)lines1.get(0) : new ArrayList();
        List line2 = !lines2.isEmpty() ? (List)lines2.get(0) : new ArrayList();
        int maxSize1 = Integer.MAX_VALUE;
        int maxSize2 = Integer.MAX_VALUE;
        for (List firstTreeLine : lines1) {
            for (List secondTreeLine : lines2) {
                boolean existCommonIndi = false;
                for (Indi firstIndi : firstTreeLine) {
                    if (firstIndi == indi1 || firstIndi == ancestor) continue;
                    for (Indi secondIndi : secondTreeLine) {
                        if (secondIndi == indi2 || secondIndi == ancestor || !firstIndi.getId().equals(secondIndi.getId())) continue;
                        existCommonIndi = true;
                        break;
                    }
                    if (!existCommonIndi) continue;
                    break;
                }
                if (!existCommonIndi) {
                    if (firstTreeLine.size() >= maxSize1 && secondTreeLine.size() >= maxSize2) continue;
                    line1 = firstTreeLine;
                    line2 = secondTreeLine;
                    maxSize1 = line1.size();
                    maxSize2 = line2.size();
                    continue;
                }
                existCommonIndi = false;
            }
        }
        Indi child = null;
        for (Indi indi : line1) {
            this.firstIndiDirectLinks.add(new Step(this.getLastFamilyWhereSpouse(indi, child), indi, indi.getSex()));
            child = indi;
        }
        child = null;
        for (Indi indi : line2) {
            this.secondIndiDirectLinks.add(new Step(this.getLastFamilyWhereSpouse(indi, child), indi, indi.getSex()));
            child = indi;
        }
        Collections.reverse(this.firstIndiDirectLinks);
        Collections.reverse(this.secondIndiDirectLinks);
        return true;
    }

    public void createPreview(Indi indi1, Indi indi2, Fam ancestor, boolean displayedId, boolean displayRecentYears, int husband_or_wife_first, int degreelaw, PreviewTopComponent previewTopComponent) {
        this.selectLines(indi1, indi2, ancestor);
        String relationshipDegree = this.calcRelationshipDegree(this.firstIndiDirectLinks.size() - 1, this.secondIndiDirectLinks.size() - 1, degreelaw, true);
        previewTopComponent.updatePreView(indi1, indi2, this.firstIndiDirectLinks, this.secondIndiDirectLinks, displayedId, displayRecentYears, husband_or_wife_first, relationshipDegree);
    }

    public void createCommonTree(Indi indi1, Indi indi2, Fam ancestor, File outputFile, boolean displayedId, boolean displayRecentYears, int husband_or_wife_first, int degreelaw, String fileTypeName) {
        if (!this.selectLines(indi1, indi2, ancestor)) {
            return;
        }
        IGraphicsOutput output = this.outputs.createOutput(outputFile, fileTypeName);
        if (output == null) {
            return;
        }
        try {
            String relationshipDegree = this.calcRelationshipDegree(this.firstIndiDirectLinks.size() - 1, this.secondIndiDirectLinks.size() - 1, degreelaw, true);
            output.output(new Renderer(indi1, indi2, this.firstIndiDirectLinks, this.secondIndiDirectLinks, displayedId, displayRecentYears, husband_or_wife_first, relationshipDegree));
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Error in tree calculation", e);
        }
    }

    public String getRelationshipDegree(Indi indi1, Indi indi2, Fam ancestor, int degreelaw) {
        if (!this.selectLines(indi1, indi2, ancestor)) {
            return "";
        }
        return this.calcRelationshipDegree(this.firstIndiDirectLinks.size() - 1, this.secondIndiDirectLinks.size() - 1, degreelaw, false);
    }

    public int getTotalDegree() {
        return this.firstIndiDirectLinks.size() + this.secondIndiDirectLinks.size();
    }

    protected String calcRelationshipDegree(int s1, int s2, int degreelaw, boolean displayLaw) {
        Object ret = "";
        if (degreelaw == 0) {
            ret = s1 == s2 ? "" + s1 : (this.firstIndiDirectLinks.isEmpty() || this.secondIndiDirectLinks.isEmpty() ? "" + Math.max(s1, s2) : s1 + "/" + s2);
        }
        if (degreelaw == 1) {
            ret = this.firstIndiDirectLinks.isEmpty() || this.secondIndiDirectLinks.isEmpty() ? "" + Math.max(s1, s2) : "" + (s1 + s2);
        }
        Object law = "";
        if (displayLaw) {
            law = (String)law + " (" + NbBundle.getMessage(SamePanel.class, (String)(degreelaw == 0 ? "SamePanel.canonlaw" : "SamePanel.civillaw")) + ")";
        }
        return (String)ret + (String)law;
    }

    private Fam getLastFamilyWhereSpouse(Indi indi, Indi child) {
        Fam[] fams = indi.getFamiliesWhereSpouse();
        if (fams == null || fams.length == 0) {
            return null;
        }
        Fam ret = fams[fams.length - 1];
        if (child != null) {
            for (Fam fam : fams) {
                if (!child.isChildIn(fam)) continue;
                ret = fam;
                break;
            }
        }
        return ret;
    }

    private Set<Fam> getFirstCommonAncestors(Indi firstIndi, Indi secondIndi) {
        Set<Fam> ancestorListFirst = this.getCommonAncestors(firstIndi, null);
        Set<Fam> ancestorListCommon = this.getCommonAncestors(secondIndi, ancestorListFirst);
        return ancestorListCommon;
    }

    private Set<Fam> getFamAncestorOf(Indi firstIndi, Indi secondIndi) {
        Fam[] fams;
        HashSet<Fam> commonSet = new HashSet<Fam>();
        for (Fam fam : fams = firstIndi.getFamiliesWhereSpouse()) {
            for (Indi indi : fam.getChildren()) {
                if (indi == null || indi != secondIndi && !indi.isAncestorOf(secondIndi)) continue;
                commonSet.add(fam);
                return commonSet;
            }
        }
        return commonSet;
    }

    private Set<Fam> getCommonAncestors(Indi indi, Set<Fam> includeSet) {
        Fam fam;
        HashSet<Fam> commonSet = new HashSet<Fam>();
        HashSet<Fam> seen = new HashSet<Fam>();
        LinkedList<Fam> todos = new LinkedList<Fam>();
        Fam fam2 = fam = indi != null ? indi.getFamilyWhereBiologicalChild() : null;
        if (fam != null) {
            todos.add(fam);
        }
        while (!todos.isEmpty()) {
            Indi mother;
            Indi father;
            Fam todo = (Fam)todos.remove();
            if (seen.contains(todo)) continue;
            seen.add(todo);
            if (includeSet != null && includeSet.contains(todo)) {
                boolean isAncestor = false;
                for (Fam f : commonSet) {
                    Indi parent = todo.getHusband() != null ? todo.getHusband() : todo.getWife();
                    if (!parent.isAncestorOf(f)) continue;
                    isAncestor = true;
                    break;
                }
                if (isAncestor) continue;
                commonSet.add(todo);
                continue;
            }
            if (includeSet == null) {
                commonSet.add(todo);
            }
            Fam fam3 = fam = (father = todo.getHusband()) != null ? father.getFamilyWhereBiologicalChild() : null;
            if (fam != null && !seen.contains(fam)) {
                todos.add(fam);
            }
            if ((fam = (mother = todo.getWife()) != null ? mother.getFamilyWhereBiologicalChild() : null) == null || seen.contains(fam)) continue;
            todos.add(fam);
        }
        return commonSet;
    }

    public Map<String, IGraphicsOutput> getOutputList() {
        return this.outputs.getOutputList();
    }

    public List<String> getFileTypeNames() {
        return this.outputs.getFileTypeNames();
    }
}

