/*
 * Decompiled with CFR 0.152.
 */
package gj.util;

import gj.model.Arc;
import gj.model.Node;
import gj.util.ArcIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModelHelper {
    public static void move(Node node, Point2D delta) {
        Point2D pos = node.getPosition();
        pos.setLocation(pos.getX() + delta.getX(), pos.getY() + delta.getY());
    }

    public static boolean isNeighbour(Node node, List<Node> nodes) {
        for (Arc arc : node.getArcs()) {
            if (!nodes.contains(ModelHelper.getOther(arc, node))) continue;
            return true;
        }
        return false;
    }

    public static List<Node> getNeighbours(Node node) {
        ArrayList<Node> result = new ArrayList<Node>(1 + node.getArcs().size());
        result.add(node);
        ArcIterator it = new ArcIterator(node);
        while (it.next()) {
            if (!it.isFirst || it.isLoop) continue;
            result.add(ModelHelper.getOther(it.arc, node));
        }
        return result;
    }

    public static Node getOther(Arc arc, Node node) {
        Node other = arc.getStart();
        if (other == node) {
            other = arc.getEnd();
        }
        return other;
    }

    public static Rectangle2D getBounds(Collection<Node> nodes) {
        if (nodes.isEmpty()) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        double x1 = Double.MAX_VALUE;
        double y1 = Double.MAX_VALUE;
        double x2 = -1.7976931348623157E308;
        double y2 = -1.7976931348623157E308;
        for (Node node : nodes) {
            Point2D p = node.getPosition();
            Rectangle2D box = node.getShape().getBounds2D();
            x1 = Math.min(x1, p.getX() + box.getMinX());
            y1 = Math.min(y1, p.getY() + box.getMinY());
            x2 = Math.max(x2, p.getX() + box.getMaxX());
            y2 = Math.max(y2, p.getY() + box.getMaxY());
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }
}

