/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.placehistory;

import genj.chart.Chart;
import genj.chart.IndexedSeries;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.util.DirectAccessTokenizer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class ReportPlaceHistory
extends Report {
    private List<String> placeValues;
    private static int EVENT_DURATION = 5;
    public int topn = 10;
    private int jurisdiction = 0;
    public boolean makeGroupOther = false;

    public Chart start(Indi[] indis) {
        return this.start(indis[0].getGedcom());
    }

    public Chart start(Gedcom gedcom) {
        Object[] jurisdictions;
        this.topn = Math.max(1, this.topn);
        String format = gedcom.getPlaceFormat();
        if (!format.isBlank() && (jurisdictions = new DirectAccessTokenizer(format, ",").getTokens(true)).length > 0) {
            this.jurisdiction = Math.max(Math.min(jurisdictions.length - 1, this.jurisdiction), 0);
            Object choice = this.getValueFromUser(this.translate("jurisdiction"), jurisdictions, jurisdictions[this.jurisdiction]);
            if (choice == null) {
                return null;
            }
            for (int i = 0; i < jurisdictions.length; ++i) {
                if (jurisdictions[i] != choice) continue;
                this.jurisdiction = i;
            }
        }
        this.placeValues = this.getPlaceValues(gedcom, this.jurisdiction);
        Collection indis = gedcom.getIndis();
        int start = this.findStart(indis);
        int length = PointInTime.getNow().getYear() - start + 1;
        IndexedSeries others = new IndexedSeries("", start, length);
        TreeMap<String, IndexedSeries> name2series = new TreeMap<String, IndexedSeries>(new RankSort());
        for (PropertyPlace place : gedcom.getPropertiesByClass(PropertyPlace.class)) {
            this.analyze(place, name2series, others, this.jurisdiction);
        }
        if (name2series.isEmpty()) {
            return null;
        }
        if (this.makeGroupOther) {
            others.setName(this.translate("others"));
            name2series.put(String.valueOf('\uffff'), others);
        }
        return new Chart(this.translate("title", new Object[]{gedcom.getDisplayName()}), null, this.translate("yaxis"), IndexedSeries.toArray(name2series.values()), (NumberFormat)new DecimalFormat("#"), (NumberFormat)new DecimalFormat("#,###"), true);
    }

    private int findStart(Collection<Indi> indis) {
        int result = PointInTime.getNow().getYear() - 100;
        for (Indi indi : indis) {
            PointInTime start;
            PropertyDate birth = indi.getBirthDateOption();
            if (birth == null || !(start = birth.getStart()).isValid()) continue;
            try {
                result = Math.min(result, start.getPointInTime((Calendar)PointInTime.GREGORIAN).getYear());
            }
            catch (GedcomException gedcomException) {}
        }
        return result;
    }

    private void analyze(PropertyPlace place, Map<String, IndexedSeries> name2series, IndexedSeries others, int jurisdiction) {
        IndexedSeries series;
        int rank = this.getRank(place.getJurisdiction(jurisdiction));
        if (rank > this.topn) {
            return;
        }
        String name = place.getJurisdiction(jurisdiction);
        int start = Integer.MIN_VALUE;
        boolean found = false;
        Property parent = place.getParent();
        Property date = parent.getProperty("DATE");
        if (date instanceof PropertyDate) {
            try {
                start = ((PropertyDate)date).getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                if (start != Integer.MAX_VALUE) {
                    found = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!found) {
            Entity entity = place.getEntity();
            if (entity instanceof Indi) {
                Indi indi = (Indi)entity;
                try {
                    start = indi.getBirthDateOption().getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                    if (start != Integer.MAX_VALUE) {
                        found = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!found && entity instanceof Fam) {
                Fam fam = (Fam)entity;
                try {
                    start = fam.getMarriageDate().getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                    if (start != Integer.MAX_VALUE) {
                        found = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (!found) {
            return;
        }
        int end = start + EVENT_DURATION;
        if (rank > this.topn) {
            if (!this.makeGroupOther) {
                return;
            }
            series = others;
        } else {
            series = name2series.get(name);
            if (series == null) {
                series = new IndexedSeries(name, others);
                name2series.put(name, series);
            }
        }
        while (start <= end) {
            series.inc(start);
            ++start;
        }
    }

    private List<String> getPlaceValues(Gedcom gedcom, int jurisdiction) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (PropertyPlace place : gedcom.getPropertiesByClass(PropertyPlace.class)) {
            String name = place.getJurisdiction(jurisdiction);
            if (name == null || name.isBlank()) continue;
            Integer count = (Integer)countMap.get(name);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            count = count + 1;
            countMap.put(name, count);
        }
        Map topNSortedMap = countMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(this.topn).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return topNSortedMap.keySet().stream().toList();
    }

    private int getRank(String name) {
        int rank = this.placeValues.indexOf(name);
        return rank > -1 ? rank : this.placeValues.size() + 1;
    }

    private String getProperty(Indi indi, String tag) {
        Property prop;
        Property[] props = indi.getProperties(tag);
        Property property = prop = props.length > 0 ? props[props.length - 1] : null;
        if (prop == null) {
            return "";
        }
        return prop.getDisplayValue();
    }

    private class RankSort
    implements Comparator<String> {
        private RankSort() {
        }

        @Override
        public int compare(String o1, String o2) {
            return ReportPlaceHistory.this.getRank(o1) - ReportPlaceHistory.this.getRank(o2);
        }
    }
}

