/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.phonetics;

import ancestris.reports.phonetics.Phonetics;

public class Phonex
implements Phonetics {
    public static final char[] CHAR_MAPPING = "01230120022455012623010202".toCharArray();
    private int maxCodeLen = 4;

    @Override
    public String encode(String txt) {
        char mapped;
        if (txt == null || txt.length() == 0) {
            return null;
        }
        txt = txt.toUpperCase();
        int current = 0;
        StringBuilder word = new StringBuilder(txt);
        while (current < word.length()) {
            if (!Character.isLetter(word.charAt(current))) {
                word = word.deleteCharAt(current);
                continue;
            }
            ++current;
        }
        while (word.toString().endsWith("S")) {
            word.deleteCharAt(word.length() - 1);
        }
        while (word.toString().startsWith("H")) {
            word.deleteCharAt(0);
        }
        if (word.length() == 0) {
            return null;
        }
        char[] input = word.toString().toCharArray();
        StringBuilder processed = new StringBuilder();
        switch (input[0]) {
            case 'K': {
                if (input.length > 1 && input[1] == 'N') {
                    processed.append(input, 1, input.length - 1);
                    break;
                }
                input[0] = 67;
                processed.append(input);
                break;
            }
            case 'P': {
                if (input.length > 1 && input[1] == 'H') {
                    input[1] = 70;
                    processed.append(input, 1, input.length - 1);
                    break;
                }
                input[0] = 66;
                processed.append(input);
                break;
            }
            case 'W': {
                if (input.length > 1 && input[1] == 'R') {
                    processed.append(input, 1, input.length - 1);
                    break;
                }
                processed.append(input);
                break;
            }
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'Y': {
                input[0] = 65;
                processed.append(input);
                break;
            }
            case 'V': {
                input[0] = 70;
                processed.append(input);
                break;
            }
            case 'Q': {
                input[0] = 67;
                processed.append(input);
                break;
            }
            case 'J': {
                input[0] = 71;
                processed.append(input);
                break;
            }
            case 'Z': {
                input[0] = 83;
                processed.append(input);
                break;
            }
            default: {
                processed.append(input);
            }
        }
        String processedString = processed.toString();
        StringBuilder code = new StringBuilder(this.maxCodeLen);
        int incount = 1;
        int count = 1;
        code.append(processedString.charAt(0));
        char last = this.getCode(processedString, 0);
        while (incount < processedString.length() && (mapped = this.getCode(processedString, incount++)) != '\u0000' && count < this.maxCodeLen) {
            if (mapped != '0' && mapped != last) {
                code.append(mapped);
            }
            last = mapped;
        }
        while (code.length() < this.maxCodeLen) {
            code.append('0');
        }
        return code.toString().substring(0, this.maxCodeLen);
    }

    private char getCode(String s, int location) {
        Character a = null;
        Character b = null;
        Character c = null;
        if (location - 1 >= 0 && location - 1 < s.length()) {
            a = Character.valueOf(s.charAt(location - 1));
        }
        if (location >= 0 && location < s.length()) {
            b = Character.valueOf(s.charAt(location));
        }
        if (location + 1 >= 0 && location + 1 < s.length()) {
            c = Character.valueOf(s.charAt(location + 1));
        }
        return this.getCode(a, b, c);
    }

    private char getCode(Character prev, Character c, Character next) {
        if (c == null || !Character.isLetter(c.charValue())) {
            return '0';
        }
        if ((c.charValue() == 'D' || c.charValue() == 'T') && next != null && next.charValue() == 'C') {
            return '0';
        }
        if (!(c.charValue() != 'L' && c.charValue() != 'R' || next != null && next.charValue() != 'A' && next.charValue() != 'E' && next.charValue() != 'I' && next.charValue() != 'O' && next.charValue() != 'U')) {
            return '0';
        }
        if (!(c.charValue() != 'D' && c.charValue() != 'G' || prev == null || prev.charValue() != 'M' && prev.charValue() != 'N')) {
            return '0';
        }
        int loc = Character.toUpperCase(c.charValue()) - 65;
        if (loc < 0 || loc > CHAR_MAPPING.length - 1) {
            return '0';
        }
        return CHAR_MAPPING[loc];
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int maxCodeLen) {
        this.maxCodeLen = maxCodeLen;
    }

    public String toString() {
        return "Phonex";
    }
}

