/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.almanac;

import ancestris.reports.FormattingOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.ColorUtils;
import ancestris.reports.utils.PropUtils;
import genj.almanac.Almanac;
import genj.almanac.Event;
import genj.fo.Document;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.option.Multiline;
import genj.option.Sorter;
import genj.report.Report;
import genj.timeline.TimelineView;
import genj.util.PackageUtils;
import genj.util.Registry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.openide.util.Exceptions;

public class ReportAlmanac
extends Report {
    public FormattingOptions formattingOptions = new FormattingOptions();
    @Multiline
    public int[] almanacSelector = IntStream.range(0, ALMANACS.length).toArray();
    public String[] almanacSelectors = ALMANACS;
    public int yearFrom = 0;
    public int yearTo = 0;
    public String filter = "";
    public Layout layout = new Layout();
    private final SimpleColorsOptions defaultColors = new SimpleColorsOptions();
    public Colors colors = new Colors();
    private static final String[] ALMANACS = (String[])ReportAlmanac.getAlmanacNamesFromResources().toArray(String[]::new);
    private Gedcom gedcom;
    private PointInTime from;
    private PointInTime to;
    private Document doc;
    private Map<String, Color> almanacColors = null;
    private static final String PREFIX = "Almanac-";
    private static final String[] SORT_FIELD_NAMES = new String[]{Gedcom.getName((String)"CTRY"), Gedcom.getName((String)"DATE")};
    private Map<Integer, Integer> map;

    public Document start(Gedcom gedcom) {
        return this.report(gedcom, gedcom.getEntities("INDI"));
    }

    public Document start(Indi indi) {
        return this.report(indi.getGedcom(), Collections.singletonList(indi));
    }

    public Document start(Indi[] indis) {
        if (indis.length == 0) {
            return null;
        }
        return this.report(indis[0].getGedcom(), Arrays.asList(indis));
    }

    public Document start(PropertyDate[] dates) {
        PointInTime localFrom = new PointInTime();
        PointInTime localTo = new PointInTime();
        for (PropertyDate date : dates) {
            this.getTimespan(date, localFrom, localTo);
        }
        if (!localFrom.isValid() || !localTo.isValid()) {
            this.println(this.translate("nothing", new Object[]{0}));
            return null;
        }
        return this.report(this.getAlmanac().getEvents(localFrom, localTo, this.getAlmanacList(), this.getAlmanacCategories(), this.getSigLevel()));
    }

    private Document report(Gedcom ged, Collection<Indi> indis) {
        this.gedcom = ged;
        Iterator<Event> events = this.getEvents(indis);
        if (events == null) {
            this.println(this.translate("nothing", new Object[]{indis.size()}));
            return null;
        }
        return this.report(events);
    }

    private Document report(Iterator<Event> events) {
        this.map = this.layout.sorter.getMap((Object[])SORT_FIELD_NAMES);
        boolean sortEventOnCountry = this.map.get(0) == 0;
        String selectedAlmanacs = PropUtils.getEventTags(this.almanacSelector, ALMANACS);
        this.almanacColors = this.getAlmanacColors();
        Pattern pattern = Pattern.compile(this.filter, 2);
        ArrayList<Event> records = new ArrayList<Event>();
        while (events.hasNext()) {
            Event event = events.next();
            if (!event.getAlmanac().matches(selectedAlmanacs) || !this.filter.isBlank() && !pattern.matcher(event.toReportString()).find()) continue;
            records.add(event);
        }
        Collections.sort(records, (e1, e2) -> {
            String ctr1 = e1.getAlmanac();
            String ctr2 = e2.getAlmanac();
            int year1 = e1.getDate().getStart().getYear();
            int year2 = e2.getDate().getStart().getYear();
            if (sortEventOnCountry) {
                return ctr1.equals(ctr2) ? Integer.compare(year1, year2) : ctr1.compareTo(ctr2);
            }
            return year1 == year2 ? ctr1.compareTo(ctr2) : Integer.compare(year1, year2);
        });
        String textColor = ColorUtils.color2string(this.colors.fgText);
        String bgColor = ColorUtils.color2string(this.colors.bgColor);
        String title = this.translate("header", new Object[]{records.size(), this.from.toReportString(), this.to.toReportString()});
        this.doc = this.formattingOptions.createDocument(this.translate("name"), textColor, bgColor);
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.includeTOC) {
            this.doc.addTOC(2, false, !sortEventOnCountry);
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.yearFrom != 0 || this.yearTo != 0) {
            this.doc.addText(this.translate("yearSpan"), "font-weight=bold");
            if (this.yearFrom != 0) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + this.translate("yearFrom") + ": ");
                this.doc.addText(String.valueOf(this.yearFrom), "font-weight=bold");
            }
            if (this.yearTo != 0) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + this.translate("yearTo") + ": ");
                this.doc.addText(String.valueOf(this.yearTo), "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.almanacSelector.length != ALMANACS.length) {
            this.doc.addText(this.translate("almanacSelector"), "font-weight=bold");
            this.doc.nextParagraph();
            this.doc.addText("\u2219  ");
            for (int alm = 0; alm < this.almanacSelector.length; ++alm) {
                if (alm != 0) {
                    this.doc.addText(",\u00a0");
                }
                this.doc.addText(this.almanacSelectors[this.almanacSelector[alm]]);
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        if (!this.filter.isBlank()) {
            this.doc.addText(this.translate("filter") + ": ");
            this.doc.addText(this.filter, "font-weight=bold");
            this.doc.nextParagraph("space-before=1cm");
        }
        String primaryKey = "";
        String secondaryKey = "";
        for (Event event : records) {
            String[] segments;
            String newPrimaryKey;
            String string = newPrimaryKey = sortEventOnCountry ? event.getAlmanac() : String.valueOf(event.getTime().getYear());
            if (!newPrimaryKey.equals(primaryKey)) {
                primaryKey = newPrimaryKey;
                if (!secondaryKey.isBlank()) {
                    this.doc.endList();
                    this.doc.nextParagraph("space-before=1cm");
                    this.doc.addText("\u00a0");
                }
                if (this.formattingOptions.includeTOC) {
                    this.doc.addTOCEntry(primaryKey);
                    this.doc.nextParagraph();
                    this.doc.addLink("^^^", "title");
                }
                this.doc.startSection(primaryKey, "", 2, false, false, "");
                secondaryKey = "";
            }
            if (this.layout.groupBy && (sortEventOnCountry || this.almanacSelector.length > 1)) {
                String newSecondaryKey;
                String string2 = newSecondaryKey = sortEventOnCountry ? String.valueOf(event.getTime().getYear()) : event.getAlmanac();
                if (!newSecondaryKey.equals(secondaryKey)) {
                    secondaryKey = newSecondaryKey;
                    this.doc.startSection(secondaryKey, "", 3, false, false, "");
                    this.doc.startList();
                }
            } else if (secondaryKey.isBlank()) {
                this.doc.startList();
                secondaryKey = "not blank";
            }
            this.doc.nextListItem();
            this.doc.addText(event.getDate().getDisplayValue(), "font-weight=bold");
            this.doc.nextParagraph();
            String color = this.colors.useTimelineColors ? ColorUtils.color2string(this.almanacColors.get(PREFIX + event.getAlmanac())) : textColor;
            String htmlClean = "<[^>]*>";
            for (String segment : segments = event.getDescription().split("(<br>|<br\\>)")) {
                int i = segment.indexOf("<u>");
                if (i > -1) {
                    int j = segment.indexOf("</u>");
                    String underline = segment.substring(i, j);
                    this.doc.addText(segment.substring(0, i).replaceAll(htmlClean, ""), "color=" + color);
                    this.doc.addText(underline.replaceAll(htmlClean, ""), "font-weight=bold, text-decoration=underline, color=" + color);
                    segment = segment.substring(j);
                }
                this.doc.addText(segment.replaceAll(htmlClean, ""), "color=" + color);
                this.doc.nextParagraph();
            }
            this.doc.nextParagraph();
            this.doc.addText("\u00a0");
        }
        if (!records.isEmpty()) {
            this.doc.endList();
        }
        return this.doc;
    }

    private Iterator<Event> getEvents(Collection<Indi> indis) {
        this.from = new PointInTime();
        this.to = new PointInTime();
        for (Indi indi : indis) {
            this.getLifespan(indi, this.from, this.to);
        }
        if (this.yearFrom != 0) {
            this.from = new PointInTime(0, 0, this.yearFrom);
        }
        if (this.yearTo != 0) {
            this.to = new PointInTime(0, 0, this.yearTo + 1);
            this.to.add(-1, 0, 0);
        }
        if (!this.from.isValid() || !this.to.isValid()) {
            this.from.set(0, 0, 1);
            this.to.set(0, 0, 3000);
        }
        return this.getAlmanac().getEvents(this.from, this.to, this.getAlmanacList(), this.getAlmanacCategories(), this.getSigLevel());
    }

    private void getLifespan(Indi indi, PointInTime from, PointInTime to) {
        List events = indi.getProperties(PropertyEvent.class);
        for (int e = 0; e < events.size(); ++e) {
            Property event = (Property)events.get(e);
            PropertyDate date = (PropertyDate)event.getProperty("DATE");
            this.getTimespan(date, from, to);
        }
    }

    private void getTimespan(PropertyDate date, PointInTime from, PointInTime to) {
        if (date == null || !date.isValid()) {
            return;
        }
        try {
            PointInTime end;
            PointInTime start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
            PointInTime pointInTime = end = date.isRange() ? date.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN) : start;
            if (!from.isValid() || from.compareTo(start) > 0) {
                from.set(start);
            }
            if (!to.isValid() || to.compareTo(end) < 0) {
                to.set(end);
            }
        }
        catch (GedcomException gedcomException) {
            // empty catch block
        }
    }

    private Almanac getAlmanac() {
        Almanac almanac = Almanac.getInstance();
        almanac.waitLoaded();
        return almanac;
    }

    private static List<String> getAlmanacNamesFromResources() {
        ArrayList<String> result = new ArrayList<String>();
        Almanac almanac = Almanac.getInstance();
        String PCKNAME = "genj.almanac.resources";
        try {
            for (String res : PackageUtils.findInPackage((String)"genj.almanac.resources", (Pattern)Pattern.compile(".*/[^/]*\\" + Almanac.ALMANAC_EXTENSION))) {
                String name = res.substring("genj.almanac.resources".length() + 1);
                String almName = almanac.getAlmanacNameFromFilename(name);
                if (almName.isBlank()) continue;
                result.add(almName);
            }
        }
        catch (ClassNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private List<String> getAlmanacList() {
        ArrayList<String> result = new ArrayList<String>(Almanac.getInstance().getAlmanacs());
        String[] ignoredNames = Registry.get(TimelineView.class).get("almanac.ignorenames", new String[0]);
        ArrayList<String> ignoredAlmanacsList = new ArrayList<String>();
        ignoredAlmanacsList.addAll(Arrays.asList(ignoredNames));
        result.removeAll(ignoredAlmanacsList);
        return result;
    }

    private List<String> getAlmanacCategories() {
        ArrayList<String> result = new ArrayList<String>(Almanac.getInstance().getCategories());
        String[] ignored = Registry.get(TimelineView.class).get("almanac.ignore", new String[0]);
        ArrayList<String> ignoredAlmanacCategories = new ArrayList<String>();
        ignoredAlmanacCategories.addAll(Arrays.asList(ignored));
        result.removeAll(ignoredAlmanacCategories);
        return result;
    }

    private int getSigLevel() {
        return Registry.get(TimelineView.class).get("almanac.siglevel", 0);
    }

    private Map<String, Color> getAlmanacColors() {
        ArrayList alms = new ArrayList(Almanac.getInstance().getAlmanacs());
        HashMap ret = new HashMap();
        alms.forEach(alm -> ret.put(PREFIX + alm, Color.BLUE));
        return Registry.get(TimelineView.class).get("color", ret);
    }

    public class Layout {
        public Sorter sorter = new Sorter((Object[])SORT_FIELD_NAMES);
        public boolean groupBy = false;
    }

    public class Colors {
        public boolean useTimelineColors = true;
        public Color fgText;
        public Color bgColor;

        public Colors() {
            this.fgText = ReportAlmanac.this.defaultColors.fgText;
            this.bgColor = ReportAlmanac.this.defaultColors.bgColor;
        }
    }
}

