/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.mergefile;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.GedcomMgr;
import ancestris.modules.gedcom.mergefile.GedcomMergeResultPanel;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.Submitter;
import genj.util.Origin;
import java.awt.Dialog;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class GedcomMerge
extends AncestrisPlugin
implements Runnable {
    private static final Logger LOG = Logger.getLogger(GedcomMerge.class.getName(), null);
    private static String[] ENTITIES = new String[]{"SUBM", "INDI", "FAM", "OBJE", "NOTE", "SOUR", "REPO"};
    private final File leftGedcomFile;
    private final File rightGedcomFile;
    private final File gedcomMergeFile;
    private ProgressHandle progressHandle;
    private int progressCounter = 0;
    private Context leftGedcomContext;
    private Context rightGedcomContext;
    private static RequestProcessor RP = null;

    public GedcomMerge() {
        this.leftGedcomFile = null;
        this.rightGedcomFile = null;
        this.gedcomMergeFile = null;
    }

    public GedcomMerge(File leftGedcom, File rightGedcom, File gedcomMergeFile) {
        this.leftGedcomFile = leftGedcom;
        this.rightGedcomFile = rightGedcom;
        this.gedcomMergeFile = gedcomMergeFile;
    }

    @Override
    public void run() {
        if (this.leftGedcomFile == null || this.rightGedcomFile == null) {
            return;
        }
        this.leftGedcomContext = GedcomMgr.getDefault().openGedcom(FileUtil.toFileObject((File)this.leftGedcomFile));
        if (this.leftGedcomContext == null) {
            return;
        }
        Gedcom leftGedcom = this.leftGedcomContext.getGedcom();
        this.rightGedcomContext = GedcomMgr.getDefault().openGedcom(FileUtil.toFileObject((File)this.rightGedcomFile));
        if (this.rightGedcomContext == null) {
            return;
        }
        Gedcom rightGedcom = this.rightGedcomContext.getGedcom();
        this.progressHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"merge.progress"), () -> false);
        if (RP == null) {
            RP = new RequestProcessor("GedcomMerge");
        }
        Runnable runnable = () -> this.mergeGedcom(leftGedcom, rightGedcom);
        RequestProcessor.Task task = RP.create(runnable);
        task.schedule(0);
    }

    private void mergeGedcom(Gedcom leftGedcom, Gedcom rightGedcom) {
        ArrayList rightGedcomEntities;
        ArrayList leftGedcomEntities;
        Gedcom mergedGedcom;
        this.progressHandle.setInitialDelay(0);
        this.progressHandle.start(30);
        this.progressCounter = 0;
        this.progressHandle.progress(this.progressCounter++);
        try {
            mergedGedcom = new Gedcom(Origin.create((URL)this.gedcomMergeFile.toURI().toURL()));
            Entity srcEntity = leftGedcom.getFirstEntity("HEAD");
            String[] destEntity = mergedGedcom.createEntity("HEAD", "");
            this.copyPropertiesCluster((Property)srcEntity, (Property)destEntity);
            Submitter submitter = (Submitter)leftGedcom.getFirstEntity("SUBM");
            if (submitter == null) {
                submitter = (Submitter)rightGedcom.getFirstEntity("SUBM");
            }
            if (submitter == null) {
                submitter = (Submitter)mergedGedcom.createEntity("SUBM");
                submitter.addDefaultProperties();
            }
            mergedGedcom.setGrammar(leftGedcom.getGrammar());
            mergedGedcom.setEncoding(leftGedcom.getEncoding());
            mergedGedcom.setLanguage(leftGedcom.getLanguage());
        }
        catch (GedcomException | MalformedURLException ex) {
            LOG.log(Level.WARNING, "unexpected exception creating new gedcom", ex);
            return;
        }
        int[] placeMap = this.mapPlaceFormat(leftGedcom, rightGedcom);
        if (placeMap != null) {
            this.remapPlaces(rightGedcom.getEntities(), placeMap);
        }
        this.progressHandle.progress(this.progressCounter++);
        for (String entityType : ENTITIES) {
            leftGedcomEntities = new ArrayList(leftGedcom.getEntities(entityType));
            Collections.sort(leftGedcomEntities);
            rightGedcomEntities = new ArrayList(rightGedcom.getEntities(entityType));
            Collections.sort(rightGedcomEntities);
            String entityIDPrefix = Gedcom.getEntityPrefix((String)entityType);
            String format = String.format("%s%%0%dd", entityIDPrefix, String.valueOf(leftGedcomEntities.size() + rightGedcomEntities.size()).length());
            int lastID = this.settingIDs(leftGedcom, leftGedcomEntities, format, 1);
            this.progressHandle.progress(this.progressCounter++);
            this.settingIDs(rightGedcom, rightGedcomEntities, format, lastID);
            this.progressHandle.progress(this.progressCounter++);
        }
        for (String entityType : ENTITIES) {
            leftGedcomEntities = new ArrayList(leftGedcom.getEntities(entityType));
            Collections.sort(leftGedcomEntities);
            for (Entity srcEntity : leftGedcomEntities) {
                try {
                    Entity destEntity = mergedGedcom.createEntity(srcEntity.getTag(), srcEntity.getId());
                    this.copyPropertiesCluster((Property)srcEntity, (Property)destEntity);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            this.progressHandle.progress(this.progressCounter++);
            rightGedcomEntities = new ArrayList(rightGedcom.getEntities(entityType));
            Collections.sort(rightGedcomEntities);
            for (Entity srcEntity : rightGedcomEntities) {
                try {
                    Entity destEntity = mergedGedcom.createEntity(srcEntity.getTag(), srcEntity.getId());
                    this.copyPropertiesCluster((Property)srcEntity, (Property)destEntity);
                }
                catch (GedcomException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
            }
            this.progressHandle.progress(this.progressCounter++);
        }
        Submitter submitter = (Submitter)mergedGedcom.getFirstEntity("SUBM");
        mergedGedcom.setSubmitter(submitter);
        this.progressHandle.progress(this.progressCounter++);
        this.progressHandle.finish();
        GedcomMergeResultPanel gedcomMergeResultPanel = new GedcomMergeResultPanel(leftGedcom, rightGedcom, mergedGedcom);
        JButton openMergeGedcomButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"open.mergeGedcom"));
        DialogDescriptor gedcomMergeResultDescriptor = new DialogDescriptor((Object)gedcomMergeResultPanel, NbBundle.getMessage(this.getClass(), (String)"merge.result.dialog"), true, new Object[]{openMergeGedcomButton, NotifyDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, (HelpCtx)null, null);
        Dialog gedcomMergeResultDialog = DialogDisplayer.getDefault().createDialog(gedcomMergeResultDescriptor);
        gedcomMergeResultDialog.setVisible(true);
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            GedcomMgr.getDefault().gedcomClose(this.rightGedcomContext);
            GedcomMgr.getDefault().gedcomClose(this.leftGedcomContext);
        });
        if (gedcomMergeResultDescriptor.getValue() == openMergeGedcomButton) {
            WindowManager.getDefault().invokeWhenUIReady(() -> {
                Indi firstIndi = (Indi)mergedGedcom.getFirstEntity("INDI");
                GedcomMgr.getDefault().saveGedcom(new Context((Entity)firstIndi));
                GedcomDirectory.getDefault().openGedcom(FileUtil.toFileObject((File)mergedGedcom.getOrigin().getFile()));
            });
        }
    }

    public int settingIDs(Gedcom gedcom, Collection<? extends Entity> entities, String format, int startFrom) {
        if (entities == null || entities.isEmpty()) {
            return startFrom;
        }
        LOG.log(Level.FINE, "SettingIDs for {0} starting from {1}", new Object[]{entities.iterator().next().getTag(), startFrom});
        ArrayList<? extends Entity> sortedEntities = new ArrayList<Entity>(entities);
        PropertyComparator2 comp = entities.iterator().next().getComparator();
        Collections.sort(sortedEntities, comp);
        try {
            String newID;
            int iCounter = 1;
            for (Entity entity : sortedEntities) {
                newID = String.format(format, iCounter);
                if (!entity.getId().equals(newID)) {
                    LOG.log(Level.FINE, "SettingIDs for {0} old id {1} new id {2}", new Object[]{entity.getValue(), entity.getId(), newID});
                    entity.setId(newID);
                }
                ++iCounter;
            }
            if (startFrom != 1) {
                iCounter = Math.max(startFrom, sortedEntities.size() + 1);
                for (Entity entity : sortedEntities) {
                    newID = String.format(format, iCounter);
                    if (!entity.getId().equals(newID)) {
                        LOG.log(Level.FINE, "SettingIDs for {0} old id {1} new id {2}", new Object[]{entity.getValue(), entity.getId(), newID});
                        entity.setId(newID);
                    }
                    ++iCounter;
                }
            }
        }
        catch (GedcomException e) {
            LOG.log(Level.SEVERE, e.getMessage());
        }
        LOG.log(Level.FINE, "First Free Id {0}", startFrom + entities.size());
        return startFrom + entities.size();
    }

    private void copyPropertiesCluster(Property srcProperty, Property destProperty) throws GedcomException {
        if (srcProperty == null || destProperty == null) {
            return;
        }
        for (int i = 0; i < srcProperty.getNoOfProperties(); ++i) {
            Property addedProperty;
            Property child = srcProperty.getProperty(i);
            if (child.getTag().equals("CHAN")) {
                addedProperty = destProperty.addProperty(child.getTag(), child.getValue());
                ((PropertyChange)addedProperty).setTime(((PropertyChange)child).getTime());
                continue;
            }
            if (child instanceof PropertyName) {
                addedProperty = destProperty.addProperty(child.getTag(), "", i);
                this.copyPropertiesCluster(child, addedProperty);
                continue;
            }
            if (child.getTag().equals("XREF")) continue;
            addedProperty = destProperty.addProperty(child.getTag(), child.getValue(), i);
            this.copyPropertiesCluster(child, addedProperty);
        }
    }

    private int[] mapPlaceFormat(Gedcom gedcomX, Gedcom gedcomY) {
        String pf1 = gedcomX.getPlaceFormat();
        String pf2 = gedcomY.getPlaceFormat();
        if (pf1.length() == 0 || pf2.length() == 0) {
            return null;
        }
        if (pf1.compareTo(pf2) == 0) {
            return null;
        }
        String[] tags1 = pf1.split("\\,");
        int[] placeMap = new int[tags1.length];
        ArrayList<String> tags2 = new ArrayList<String>(Arrays.asList(pf2.split("\\,")));
        ArrayList<String> tagsTemp = new ArrayList<String>(Arrays.asList(pf2.split("\\,")));
        for (int i = 0; i < tags1.length; ++i) {
            String tag = tags1[i];
            String selection = tags2.get(0);
            int iSel = tags2.indexOf(selection);
            placeMap[i] = tagsTemp.indexOf(selection);
            if (tags2.size() <= 1) continue;
            tags2.remove(iSel);
        }
        return placeMap;
    }

    private void remapPlaces(List<Entity> entities, int[] placeMap) {
        if (placeMap == null) {
            return;
        }
        for (Entity entity : entities) {
            List places = entity.getProperties(PropertyPlace.class);
            for (Property propPlace : places) {
                String place = propPlace.toString();
                String[] placeTab = place.split("\\,", -1);
                Object newPlace = "";
                for (int i = 0; i < placeMap.length; ++i) {
                    if (placeMap[i] >= placeTab.length) {
                        newPlace = place + ",,,,,,,,,,,,,,,,".substring(0, placeMap.length - placeTab.length + 1);
                        break;
                    }
                    newPlace = (String)newPlace + placeTab[placeMap[i]] + ",";
                }
                newPlace = ((String)newPlace).substring(0, ((String)newPlace).length() - 1);
                propPlace.setValue((String)newPlace);
            }
        }
    }
}

