/*
 * Decompiled with CFR 0.152.
 */
package swingx.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class Slice
extends JPanel {
    protected int spacing = 4;
    protected float weight = 0.5f;
    protected int orientation;
    private SliceLayout layout = new SliceLayout();
    protected JComponent main;
    protected JComponent remainder;
    protected JComponent divider = new JPanel();

    public Slice() {
        this.setLayout(this.layout);
        this.divider.setOpaque(false);
        this.divider.addMouseListener(this.layout);
        this.divider.addMouseMotionListener(this.layout);
        this.add(this.divider);
        this.setOrientation(1);
    }

    public void setMain(JComponent main) {
        if (this.main != null) {
            this.remove(this.main);
        }
        this.main = main;
        if (main != null) {
            this.add(main);
        }
        this.repaint();
        this.revalidate();
    }

    public void setRemainder(JComponent remainder) {
        if (this.remainder != null) {
            this.remove(this.remainder);
        }
        this.remainder = remainder;
        if (remainder != null) {
            this.add(remainder);
        }
        this.repaint();
        this.revalidate();
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
        this.revalidate();
        this.repaint();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 1: {
                this.divider.setCursor(Cursor.getPredefinedCursor(8));
                break;
            }
            case 3: {
                this.divider.setCursor(Cursor.getPredefinedCursor(9));
                break;
            }
            case 2: {
                this.divider.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case 4: {
                this.divider.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            default: {
                throw new IllegalArgumentException("unkown orientation '" + orientation + "'");
            }
        }
        this.orientation = orientation;
        this.revalidate();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public JComponent getMain() {
        return this.main;
    }

    public JComponent getRemainder() {
        return this.remainder;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        if (weight > 1.0f) {
            weight = 1.0f;
        }
        if (weight < 0.0f) {
            weight = 0.0f;
        }
        this.weight = weight;
        this.revalidate();
    }

    public JComponent getOther(JComponent child) {
        if (this.main == child) {
            return this.remainder;
        }
        if (this.remainder == child) {
            return this.main;
        }
        throw new IllegalArgumentException("unkown child");
    }

    public void replace(JComponent child, JComponent newChild) {
        if (this.main == child) {
            this.setMain(newChild);
        } else if (this.remainder == child) {
            this.setRemainder(newChild);
        } else {
            throw new IllegalArgumentException("unkown child");
        }
    }

    private class SliceLayout
    extends MouseInputAdapter
    implements LayoutManager {
        private Point dragStart;

        private SliceLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            Insets insets = Slice.this.getInsets();
            int x = insets.left;
            int y = insets.top;
            int width = parent.getWidth() - insets.left - insets.right;
            int height = parent.getHeight() - insets.top - insets.bottom;
            if (Slice.this.main != null && Slice.this.main.isVisible() && Slice.this.remainder != null && Slice.this.remainder.isVisible()) {
                Slice.this.divider.setVisible(true);
                if (Slice.this.orientation == 1 || Slice.this.orientation == 3) {
                    int bottomHeight;
                    int topHeight;
                    JComponent bottom;
                    JComponent top;
                    height -= Slice.this.spacing;
                    if (Slice.this.orientation == 1) {
                        top = Slice.this.main;
                        bottom = Slice.this.remainder;
                        topHeight = (int)((float)height * Slice.this.weight);
                        bottomHeight = height - topHeight;
                    } else {
                        bottom = Slice.this.main;
                        top = Slice.this.remainder;
                        bottomHeight = (int)((float)height * Slice.this.weight);
                        topHeight = height - bottomHeight;
                    }
                    Dimension bottomSize = bottom.getMinimumSize();
                    if (bottomSize.height > bottomHeight) {
                        bottomHeight = Math.min(bottomSize.height, height);
                        topHeight = height - bottomHeight;
                    }
                    Dimension topSize = top.getMinimumSize();
                    if (topSize.height > topHeight) {
                        topHeight = Math.min(topSize.height, height - Slice.this.spacing);
                        bottomHeight = height - topHeight;
                    }
                    top.setBounds(x, y, width, topHeight);
                    Slice.this.divider.setBounds(x, y += topHeight, width, Slice.this.spacing);
                    bottom.setBounds(x, y += Slice.this.spacing, width, bottomHeight);
                } else if (Slice.this.orientation == 2 || Slice.this.orientation == 4) {
                    int rightWidth;
                    int leftWidth;
                    JComponent right;
                    JComponent left;
                    width -= Slice.this.spacing;
                    if (Slice.this.orientation == 2) {
                        left = Slice.this.main;
                        right = Slice.this.remainder;
                        leftWidth = (int)((float)width * Slice.this.weight);
                        rightWidth = width - leftWidth;
                    } else {
                        right = Slice.this.main;
                        left = Slice.this.remainder;
                        rightWidth = (int)((float)width * Slice.this.weight);
                        leftWidth = width - rightWidth;
                    }
                    Dimension rightSize = right.getMinimumSize();
                    if (rightSize.width > rightWidth) {
                        rightWidth = Math.min(rightSize.width, width);
                        leftWidth = width - rightWidth;
                    }
                    Dimension leftSize = left.getMinimumSize();
                    if (leftSize.width > leftWidth) {
                        leftWidth = Math.min(leftSize.width, width - Slice.this.spacing);
                        rightWidth = width - leftWidth;
                    }
                    left.setBounds(x, y, leftWidth, height);
                    Slice.this.divider.setBounds(x += leftWidth, y, Slice.this.spacing, height);
                    right.setBounds(x += Slice.this.spacing, y, rightWidth, height);
                }
            } else {
                Slice.this.divider.setVisible(false);
                if (Slice.this.main != null) {
                    Slice.this.main.setBounds(x, y, width, height);
                }
                if (Slice.this.remainder != null) {
                    Slice.this.remainder.setBounds(x, y, width, height);
                }
            }
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension size = new Dimension();
            if (Slice.this.main != null && Slice.this.main.isVisible()) {
                Dimension mainSize = Slice.this.main.getMinimumSize();
                if (Slice.this.orientation == 2 || Slice.this.orientation == 4) {
                    size.width += mainSize.width;
                    size.height = Math.max(mainSize.height, size.height);
                } else {
                    size.width = Math.max(mainSize.width, size.width);
                    size.height += mainSize.height;
                }
            }
            if (Slice.this.remainder != null && Slice.this.remainder.isVisible()) {
                Dimension remainderSize = Slice.this.remainder.getMinimumSize();
                if (Slice.this.orientation == 2 || Slice.this.orientation == 4) {
                    size.width += remainderSize.width;
                    size.height = Math.max(remainderSize.height, size.height);
                } else {
                    size.width = Math.max(remainderSize.width, size.width);
                    size.height += remainderSize.height;
                }
            }
            if (Slice.this.main != null && Slice.this.main.isVisible() && Slice.this.remainder != null && Slice.this.remainder.isVisible()) {
                if (Slice.this.orientation == 2 || Slice.this.orientation == 4) {
                    size.width += Slice.this.spacing;
                } else {
                    size.height += Slice.this.spacing;
                }
            }
            Insets insets = Slice.this.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        public void mousePressed(MouseEvent e) {
            this.dragStart = e.getPoint();
        }

        public void mouseDragged(MouseEvent e) {
            int x = Slice.this.divider.getX() + e.getX() - this.dragStart.x;
            int y = Slice.this.divider.getY() + e.getY() - this.dragStart.y;
            int height = Slice.this.getHeight() - Slice.this.spacing;
            int width = Slice.this.getWidth() - Slice.this.spacing;
            switch (Slice.this.orientation) {
                case 1: {
                    Slice.this.weight = (float)y / (float)height;
                    break;
                }
                case 3: {
                    Slice.this.weight = 1.0f - (float)y / (float)height;
                    break;
                }
                case 2: {
                    Slice.this.weight = (float)x / (float)width;
                    break;
                }
                case 4: {
                    Slice.this.weight = 1.0f - (float)x / (float)width;
                }
            }
            Slice.this.weight = Math.max(0.0f, Math.min(Slice.this.weight, 1.0f));
            this.layoutContainer(Slice.this);
            Slice.this.weight = Slice.this.orientation == 1 || Slice.this.orientation == 3 ? (float)Slice.this.main.getHeight() / (float)height : (float)Slice.this.main.getWidth() / (float)width;
            Slice.this.main.validate();
            Slice.this.remainder.validate();
        }
    }
}

