/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.table;

import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanField;
import ancestris.modules.releve.model.BeanGroup;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldSimpleValue;
import ancestris.modules.releve.model.RecordModel;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;

public class TableModelRecordCheck
extends AbstractTableModel {
    private final ArrayList<AbstractRecord.FieldType> fieldTypeList = new ArrayList();
    private final ArrayList<String> columnNameList = new ArrayList();
    private final RecordModel modelParent;
    private static final Field birthField = new FieldSimpleValue();
    private static final Field marriageField = new FieldSimpleValue();
    private static final Field deathField = new FieldSimpleValue();

    public TableModelRecordCheck(RecordModel modelAll) {
        this.modelParent = modelAll;
        for (BeanGroup group : BeanGroup.getGroups(AbstractRecord.RecordType.MISC)) {
            for (BeanField editorBeanField : group.getFields()) {
                this.fieldTypeList.add(editorBeanField.getFieldType());
                this.columnNameList.add(editorBeanField.getLabel());
            }
        }
    }

    public AbstractRecord getRecord(int index) {
        return this.modelParent.getRecord(index);
    }

    @Override
    public int getColumnCount() {
        return this.columnNameList.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNameList.get(col);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return Field.class;
    }

    @Override
    public int getRowCount() {
        return this.modelParent.getRowCount();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Field field;
        AbstractRecord record = this.modelParent.getRecord(row);
        if (col == 0) {
            switch (record.getType()) {
                case BIRTH: {
                    field = birthField;
                    break;
                }
                case MARRIAGE: {
                    field = marriageField;
                    break;
                }
                case DEATH: {
                    field = deathField;
                    break;
                }
                default: {
                    field = record.getField(this.fieldTypeList.get(col));
                    break;
                }
            }
        } else {
            field = record.getField(this.fieldTypeList.get(col));
        }
        if (field != null) {
            return field;
        }
        return "";
    }

    static {
        birthField.setValue(ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.row.Birth"));
        marriageField.setValue(ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.row.Marriage"));
        deathField.setValue(ResourceBundle.getBundle("ancestris/modules/releve/model/Bundle").getString("model.row.Death"));
    }
}

