/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.GedcomDirectory;
import ancestris.gedcom.GedcomFileListener;
import ancestris.modules.releve.RelevePlaceEditor;
import ancestris.modules.releve.file.FileBuffer;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.CompletionProvider;
import ancestris.modules.releve.model.GedcomLink;
import ancestris.modules.releve.model.GedcomLinkProvider;
import ancestris.modules.releve.model.RecordBirth;
import ancestris.modules.releve.model.RecordDeath;
import ancestris.modules.releve.model.RecordInfoPlace;
import ancestris.modules.releve.model.RecordMarriage;
import ancestris.modules.releve.model.RecordMisc;
import ancestris.modules.releve.model.RecordModel;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import java.io.File;
import java.util.List;
import org.openide.util.NbPreferences;

public class DataManager
extends AncestrisPlugin
implements GedcomFileListener {
    private final RecordModel dataModel = new RecordModel();
    private final CompletionProvider completionProvider = new CompletionProvider();
    private final GedcomLinkProvider gedcomLinkProvider = new GedcomLinkProvider();
    Gedcom completionGedcom = null;
    File currentFile;
    private final int[] previousRecordIndex = new int[2];
    static boolean duplicateControlEnabled = true;
    static boolean valueControlEnabled = true;
    static boolean copyPlaceEnabled = true;
    static boolean copyParishEnabled = true;
    static boolean copyCoteEnabled = true;
    static boolean copyEventDateEnabled = true;
    static boolean copySecondDateEnabled = true;
    static boolean copyFreeCommentEnabled = true;
    static boolean copyNotaryEnabled = true;
    static boolean gedcomCompletion = true;
    private boolean gedcomLinkState = false;
    static boolean copySourceTextToComment = false;
    static boolean autoselection = false;

    public DataManager() {
        this.setGedcomCompletion(gedcomCompletion);
    }

    public boolean isDirty() {
        boolean result = false;
        return result |= this.dataModel.isDirty();
    }

    public void resetDirty() {
        this.dataModel.resetDirty();
    }

    public AbstractRecord createRecord(AbstractRecord.RecordType recordType) {
        return switch (recordType) {
            case AbstractRecord.RecordType.BIRTH -> new RecordBirth();
            case AbstractRecord.RecordType.DEATH -> new RecordDeath();
            case AbstractRecord.RecordType.MARRIAGE -> new RecordMarriage();
            default -> new RecordMisc();
        };
    }

    public int addRecord(AbstractRecord newRecord) {
        String defaultPlace;
        if (newRecord.getPlace().toString().equals(RecordInfoPlace.EMPTY) && !(defaultPlace = RelevePlaceEditor.getDefaultPlace(this)).isBlank()) {
            newRecord.setPlace(defaultPlace);
        }
        int recordIndex = this.dataModel.addRecord(newRecord);
        this.completionProvider.addRecord(newRecord);
        this.gedcomLinkProvider.addRecord(newRecord);
        this.previousRecordIndex[1] = this.previousRecordIndex[0];
        this.previousRecordIndex[0] = recordIndex;
        return recordIndex;
    }

    public void addRecords(FileBuffer fileBuffer, boolean append) {
        if (!append && this.dataModel.getRowCount() != 0) {
            this.removeAll();
        }
        this.dataModel.addRecords(fileBuffer.getRecords());
        for (AbstractRecord record : fileBuffer.getRecords()) {
            this.completionProvider.addRecord(record);
            this.gedcomLinkProvider.addRecord(record);
        }
        if (!append) {
            this.resetDirty();
        }
        this.previousRecordIndex[1] = this.dataModel.getRowCount() - 1;
        this.previousRecordIndex[0] = this.dataModel.getRowCount() - 1;
    }

    public void insertRecord(AbstractRecord.RecordType recordType, int index) {
        AbstractRecord newRecord = this.createRecord(recordType);
        this.dataModel.insertRecord(newRecord, index);
        this.completionProvider.addRecord(newRecord);
        this.gedcomLinkProvider.addRecord(newRecord);
        this.previousRecordIndex[1] = this.previousRecordIndex[0];
        this.previousRecordIndex[0] = index;
    }

    public void removeRecord(AbstractRecord record) {
        int recordIndex = this.dataModel.getIndex(record);
        this.gedcomLinkProvider.removeRecord(record);
        this.completionProvider.removeRecord(record);
        this.dataModel.removeRecord(record);
        if (recordIndex == this.previousRecordIndex[1]) {
            this.previousRecordIndex[1] = this.dataModel.getRowCount() - 1;
        }
        if (recordIndex == this.previousRecordIndex[0]) {
            this.previousRecordIndex[0] = this.dataModel.getRowCount() - 1;
        }
    }

    public void swapRecordNext(AbstractRecord record) {
        this.dataModel.swapRecordNext(record);
    }

    public void swapRecordPrevious(AbstractRecord record) {
        this.dataModel.swapRecordPrevious(record);
    }

    public void renumberRecords(AbstractRecord record, int[] tableIndexList) {
        this.dataModel.renumberRecords(record, tableIndexList);
    }

    public void removeAll() {
        this.getCompletionProvider().removeAll();
        this.dataModel.removeAll();
        this.gedcomLinkProvider.removeAll();
        this.completionProvider.addGedcomCompletion(this.completionGedcom);
        this.resetDirty();
    }

    public AbstractRecord getRecord(int recordIndex) {
        return this.dataModel.getRecord(recordIndex);
    }

    public int getPreviousRecordIndex() {
        return this.previousRecordIndex[1];
    }

    public String verifyRecord(AbstractRecord record) {
        return this.dataModel.verifyRecord(record);
    }

    static void loadOptions() {
        copyPlaceEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("CopyPlaceEnabled", "true"));
        copyCoteEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("CopyCoteEnabled", "true"));
        copyEventDateEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("CopyEventDateEnabled", "true"));
        copySecondDateEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("CopySecondDateEnabled", "true"));
        copyFreeCommentEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("CopyFreeCommentEnabled", "true"));
        copyNotaryEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("CopyNotaryEnabled", "true"));
        copyParishEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("CopyParishEnabled", "true"));
        duplicateControlEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("DuplicateRecordControlEnabled", "true"));
        valueControlEnabled = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("ValueControlEnabled", "true"));
        gedcomCompletion = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("GedcomCompletionEnabled", "true"));
        copySourceTextToComment = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("CopySourceTextToComment", "false"));
        autoselection = Boolean.parseBoolean(NbPreferences.forModule(DataManager.class).get("Autoselection", "false"));
    }

    public static boolean getDuplicateControlEnabled() {
        return duplicateControlEnabled;
    }

    public static boolean getCopyPlaceEnabled() {
        return copyPlaceEnabled;
    }

    public static boolean getCopyCoteEnabled() {
        return copyCoteEnabled;
    }

    public static boolean getCopyEventDateEnabled() {
        return copyEventDateEnabled;
    }

    public static boolean getCopySecondDateEnabled() {
        return copySecondDateEnabled;
    }

    public static boolean getCopyFreeCommentEnabled() {
        return copyFreeCommentEnabled;
    }

    public static boolean getCopyNotaryEnabled() {
        return copyNotaryEnabled;
    }

    public static boolean getCopyParishEnabled() {
        return copyParishEnabled;
    }

    public static boolean getNewValueControlEnabled() {
        return valueControlEnabled;
    }

    public static boolean getGecomCompletionEnabled() {
        return gedcomCompletion;
    }

    public static boolean getCopySourceTextToComment() {
        return copySourceTextToComment;
    }

    public static boolean getAutoselection() {
        return autoselection;
    }

    public static void setDuplicateControlEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("DuplicateRecordControlEnabled", String.valueOf(enabled));
        duplicateControlEnabled = enabled;
    }

    public static void setNewValueControlEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("ValueControlEnabled", String.valueOf(enabled));
        valueControlEnabled = enabled;
    }

    public static void setGedcomCompletionEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("GedcomCompletionEnabled", String.valueOf(enabled));
        gedcomCompletion = enabled;
    }

    public static void setCopyPlaceEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("CopyPlaceEnabled", String.valueOf(enabled));
        copyPlaceEnabled = enabled;
    }

    public static void setCopyCoteEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("CopyCoteEnabled", String.valueOf(enabled));
        copyCoteEnabled = enabled;
    }

    public static void setCopyEventDateEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("CopyEventDateEnabled", String.valueOf(enabled));
        copyEventDateEnabled = enabled;
    }

    public static void setCopySecondDateEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("CopySecondDateEnabled", String.valueOf(enabled));
        copySecondDateEnabled = enabled;
    }

    public static void setCopyFreeCommentEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("CopyFreeCommentEnabled", String.valueOf(enabled));
        copyFreeCommentEnabled = enabled;
    }

    public static void setCopyNotaryEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("CopyNotaryEnabled", String.valueOf(enabled));
        copyNotaryEnabled = enabled;
    }

    public static void setCopyParishEnabled(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("CopyParishEnabled", String.valueOf(enabled));
        copyParishEnabled = enabled;
    }

    public static void setCopySourceTextToComment(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("CopySourceTextToComment", String.valueOf(enabled));
        copySourceTextToComment = enabled;
    }

    public static void setAutoselection(boolean enabled) {
        NbPreferences.forModule(DataManager.class).put("Autoselection", String.valueOf(enabled));
        autoselection = enabled;
    }

    public RecordModel getDataModel() {
        return this.dataModel;
    }

    public CompletionProvider getCompletionProvider() {
        return this.completionProvider;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(File currentFile) {
        this.currentFile = currentFile;
    }

    public void gedcomClosed(Gedcom gedcom) {
        if (this.completionGedcom != null && this.completionGedcom.equals(gedcom)) {
            this.removeGedcomCompletion();
        }
    }

    public void commitRequested(Context context) {
    }

    public void gedcomOpened(Gedcom gedcom) {
        if (gedcomCompletion) {
            this.addGedcomCompletion(gedcom);
        }
    }

    public final void setGedcomCompletion(boolean completion) {
        if (this.completionGedcom == null && completion) {
            Context context = this.getSelectedContext();
            if (context != null && context.getGedcom() != null) {
                this.addGedcomCompletion(context.getGedcom());
            }
        } else if (this.completionGedcom != null && !completion) {
            this.removeGedcomCompletion();
        }
    }

    private Context getSelectedContext() {
        Context context = null;
        if (context != null) {
            return context;
        }
        List contextList = GedcomDirectory.getDefault().getContexts();
        if (contextList != null && contextList.size() > 0) {
            return (Context)contextList.get(0);
        }
        return null;
    }

    void addGedcomCompletion(Gedcom gedcom) {
        this.completionGedcom = gedcom;
        this.completionProvider.addGedcomCompletion(gedcom);
        this.showGedcomLink(this.gedcomLinkState, true);
    }

    void removeGedcomCompletion() {
        this.completionProvider.removeAll();
        for (AbstractRecord record : this.dataModel.releveList) {
            this.completionProvider.addRecord(record);
        }
        this.completionGedcom = null;
        this.showGedcomLink(this.gedcomLinkState, true);
    }

    public void showGedcomLink(boolean state, boolean quiet) {
        this.gedcomLinkProvider.init(this.dataModel, this.completionGedcom, state, quiet);
        this.gedcomLinkState = state;
    }

    public GedcomLink getGedcomLink(AbstractRecord record) {
        return this.gedcomLinkProvider.getGedcomLink(record);
    }

    static {
        DataManager.loadOptions();
    }

    public static enum ModelType {
        MODEL_BIRTH,
        MODEL_MARRIAGE,
        DEATH,
        MISC,
        ALL;

    }
}

