/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeTableAction;
import ancestris.modules.releve.merge.ProposalRule;
import ancestris.modules.releve.merge.ProposalRuleTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

class ProposalRuleList
extends AbstractTableModel
implements ProposalRuleTableModel {
    private final List<ProposalRule> dataList = new ArrayList<ProposalRule>();
    private int nbEqual = 0;
    private int nbCompatibleChecked = 0;
    private int nbCompatibleNotChecked = 0;
    private int nbConflict = 0;
    private int nbMandatory = 0;
    private int nbNotApplicable = 0;
    private int nbTotal = 0;
    private final String[] columnNames = new String[]{"", NbBundle.getMessage(ProposalRuleList.class, (String)"MergePanel.title.recordColumn"), "=>", NbBundle.getMessage(ProposalRuleList.class, (String)"MergePanel.title.gedcomColumn"), NbBundle.getMessage(ProposalRuleList.class, (String)"MergePanel.title.identifierColumn")};
    private final Class<?>[] columnClass = new Class[]{String.class, Object.class, Boolean.class, Object.class, MergeTableAction.class};

    ProposalRuleList() {
    }

    void add(ProposalRule proposalRule, boolean display) {
        this.add(proposalRule, display, 0);
    }

    private void add(ProposalRule rule, boolean display, int level) {
        if (rule.getSuperRule() != null && rule.getSuperRule().getCompareResult() == ProposalRule.CompareResult.NOT_APPLICABLE) {
            rule.m_merge = false;
            rule.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
        }
        rule.m_merge_initial = rule.m_merge;
        if (display && !this.dataList.contains(rule)) {
            this.dataList.add(rule);
            rule.m_label = ProposalRule.getRuleLabel(rule.getLabelResourceName());
            for (int i = 0; i < level; ++i) {
                rule.m_label = "  " + rule.m_label;
            }
            ++level;
            if (rule.getCompareResult() != null) {
                switch (rule.getCompareResult()) {
                    case EQUAL: {
                        ++this.nbEqual;
                        break;
                    }
                    case COMPATIBLE: {
                        if (rule.getMerge()) {
                            ++this.nbCompatibleChecked;
                            break;
                        }
                        ++this.nbCompatibleNotChecked;
                        break;
                    }
                    case CONFLICT: {
                        ++this.nbConflict;
                        break;
                    }
                    case MANDATORY: {
                        ++this.nbMandatory;
                        break;
                    }
                    default: {
                        ++this.nbNotApplicable;
                    }
                }
                ++this.nbTotal;
            }
        }
        for (ProposalRule subRule : rule.getSubRules()) {
            this.add(subRule, subRule.m_display, level);
        }
    }

    public int getNbEqual() {
        return this.nbEqual;
    }

    public int getNbCompatibleChecked() {
        return this.nbCompatibleChecked;
    }

    public int getNbCompatibleNotChecked() {
        return this.nbCompatibleNotChecked;
    }

    public int getNbConflict() {
        return this.nbConflict;
    }

    public int getNbTotal() {
        return this.nbTotal;
    }

    @Override
    public ProposalRule.CompareResult getCompareResult(int index) {
        if (this.dataList.get(index).getCompareResult() != null) {
            return this.dataList.get(index).getCompareResult();
        }
        return ProposalRule.CompareResult.NOT_APPLICABLE;
    }

    @Override
    public boolean getMerge(int index) {
        return this.dataList.get(index).getMerge();
    }

    @Override
    public boolean isMergeChanged(int index) {
        return this.dataList.get(index).isMergeChanged();
    }

    private void check(int ruleNum, boolean state) {
        ProposalRule rule = this.dataList.get(ruleNum);
        rule.setMerge(state);
        this.fireTableCellUpdated(ruleNum, 2);
        this.fireTableCellUpdated(ruleNum, 3);
        this.checkSubRule(rule, state);
        this.checkSuperRule(rule, state);
    }

    private void checkSubRule(ProposalRule rule, boolean state) {
        for (ProposalRule subRule : rule.getSubRules()) {
            int index = this.dataList.indexOf(subRule);
            if (index == -1) {
                // empty if block
            }
            if (state) {
                subRule.restoreInitialMerge();
            } else {
                subRule.setMerge(false);
            }
            this.fireTableCellUpdated(this.dataList.indexOf(subRule), 2);
            this.fireTableCellUpdated(this.dataList.indexOf(subRule), 3);
            this.checkSubRule(subRule, state);
        }
    }

    private void checkSuperRule(ProposalRule rule, boolean state) {
        ProposalRule superRule = rule.getSuperRule();
        if (superRule != null) {
            this.checkSuperRule(superRule, state);
            if (state) {
                superRule.setMerge(true);
                int parentIndex = this.dataList.indexOf(superRule);
                if (parentIndex != -1) {
                    this.fireTableCellUpdated(parentIndex, 2);
                    this.fireTableCellUpdated(parentIndex, 3);
                }
            }
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataList.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.columnClass[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.dataList.get(row).getLabel();
            }
            case 1: {
                return this.dataList.get(row).getDisplayRecord();
            }
            case 2: {
                return this.dataList.get(row).getMerge();
            }
            case 3: {
                return this.dataList.get(row).getDisplayEntity();
            }
            case 4: {
                return this.dataList.get(row).getDisplayAction();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rule, int col) {
        switch (col) {
            case 1: {
                return this.dataList.get(rule).getDisplayRecord() instanceof MergeTableAction;
            }
            case 2: {
                ProposalRule.CompareResult cr = this.dataList.get(rule).getCompareResult();
                return cr == ProposalRule.CompareResult.COMPATIBLE || cr == ProposalRule.CompareResult.CONFLICT;
            }
            case 3: {
                return this.dataList.get(rule).getDisplayEntity() instanceof MergeTableAction;
            }
            case 4: {
                return this.dataList.get(rule).getDisplayAction() instanceof MergeTableAction;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, int rule, int col) {
        switch (col) {
            case 1: {
                this.dataList.get(rule).onRecordChanged(value);
                this.fireTableDataChanged();
                break;
            }
            case 2: {
                this.check(rule, (Boolean)value);
                break;
            }
            case 3: {
                this.dataList.get(rule).onSelectedEntityChanged(value);
                this.fireTableDataChanged();
                break;
            }
        }
    }
}

