/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeInfo;
import ancestris.modules.releve.merge.MergeOption;
import ancestris.modules.releve.merge.MergeQuery;
import ancestris.modules.releve.merge.MergeRecord;
import ancestris.modules.releve.merge.MergeTableAction;
import ancestris.modules.releve.merge.ProposalHelper;
import ancestris.modules.releve.merge.ProposalRule;
import ancestris.modules.releve.merge.ProposalRuleList;
import ancestris.modules.releve.merge.SpouseTag;
import ancestris.util.Utilities;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceRole;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyNote;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyQuality;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.gedcom.values.RoleEnum;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.NbBundle;

public class Proposal
implements Comparable<Proposal> {
    private final ProposalRuleList m_displayRuleList;
    private ARuleEntity<?, ?, ?> m_ruleRoot;
    private final ProposalHelper m_helper;
    private RuleSource m_ruleSource;
    private List<RuleWitness> m_ruleWitnesses;

    public Proposal(ProposalHelper proposalHelper, Indi indi, Fam parentFamily, Indi father, Indi mother) throws Exception {
        this(proposalHelper, indi, null, null, parentFamily, father, mother);
    }

    public Proposal(ProposalHelper proposalHelper, Indi indi, Fam marriedFamily, SpouseTag marriedTag, Fam parentFamily, Indi father, Indi mother) throws Exception {
        this(proposalHelper, proposalHelper.getRecord().getIndi(), indi, marriedFamily, marriedTag, parentFamily, father, mother);
    }

    public Proposal(ProposalHelper proposalHelper, MergeRecord.RecordParticipant participant, Indi indi, Fam marriedFamily, SpouseTag marriedTag, Fam parentFamily, Indi father, Indi mother) throws Exception {
        this(proposalHelper, (Entity)indi);
        if (indi != null && parentFamily == null) {
            parentFamily = indi.getFamilyWhereBiologicalChild();
        }
        if (parentFamily != null) {
            if (father == null) {
                father = parentFamily.getHusband();
            }
            if (mother == null) {
                mother = parentFamily.getWife();
            }
        }
        this.m_ruleRoot = new RuleIndi(null, participant, indi, marriedFamily, marriedTag, parentFamily, father, mother);
        if (participant.getParticipantType() == MergeRecord.MergeParticipantType.participant1) {
            this.initDisplayMainEvent();
        }
        this.initDisplay(this.m_ruleRoot, true);
        this.initDisplayWitnesses();
    }

    public Proposal(ProposalHelper proposalHelper, Fam family, Indi husband, Fam husbandParentFamily, Indi husbandFather, Indi husbandMother, Indi wife, Fam wifeParentFamily, Indi wifeFather, Indi wifeMother) throws Exception {
        this(proposalHelper, (Entity)family);
        if (family != null) {
            if (husband == null) {
                husband = family.getHusband();
            }
            if (wife == null) {
                wife = family.getWife();
            }
        }
        if (husband != null && husbandParentFamily == null) {
            husbandParentFamily = husband.getFamilyWhereBiologicalChild();
        }
        if (husbandParentFamily != null) {
            if (husbandFather == null) {
                husbandFather = husbandParentFamily.getHusband();
            }
            if (husbandMother == null) {
                husbandMother = husbandParentFamily.getWife();
            }
        }
        if (wife != null && wifeParentFamily == null) {
            wifeParentFamily = wife.getFamilyWhereBiologicalChild();
        }
        if (wifeParentFamily != null) {
            if (wifeFather == null) {
                wifeFather = wifeParentFamily.getHusband();
            }
            if (wifeMother == null) {
                wifeMother = wifeParentFamily.getWife();
            }
        }
        this.m_ruleRoot = new RuleFamily(proposalHelper.getRecord().getFamily(), family, husband, null, husbandParentFamily, husbandFather, husbandMother, wife, null, wifeParentFamily, wifeFather, wifeMother);
        this.initDisplayMainEvent();
        this.initDisplay(this.m_ruleRoot, true);
        this.initDisplayWitnesses();
    }

    private void initDisplayMainEvent() {
        if (this.m_helper.getRecord().isInsinuation()) {
            RuleEvent ruleInsinuation = new RuleEvent(this.m_ruleRoot, "EVEN", this.m_helper.getRecord().getInsinuationType(), this.m_helper.getRecord().getEventType(), this.m_helper.getRecord().getInsinuationDate(), this.m_helper.getRecord().getEventResidence(), this.m_helper.getRecordWitnesses(), true);
            this.initDisplay(ruleInsinuation.findSubRule(RuleSource.class), true);
            this.initDisplay(new RuleSeparator(this.m_ruleRoot), true);
            this.initDisplay(ruleInsinuation, true);
            this.initDisplay(new RuleSeparator(this.m_ruleRoot), true);
            this.initDisplay(new RuleEvent(this.m_ruleRoot, this.m_helper.getRecord().getEventTypeTag(), this.m_helper.getRecord().getEventTagName(), this.m_helper.getRecord().getEventType(), this.m_helper.getRecord().getEventDate(), null, this.m_helper.getRecordWitnesses(), false), true);
            this.initDisplay(new RuleSeparator(this.m_ruleRoot), true);
        } else if (!(this.m_helper.getRecord().getEventTypeTag().equals("BIRT") || this.m_helper.getRecord().getEventTypeTag().equals("DEAT") || this.m_helper.getRecord().getEventTypeTag().equals("MARR"))) {
            RuleEvent ruleEvent = new RuleEvent(this.m_ruleRoot, this.m_helper.getRecord().getEventTypeTag(), this.m_helper.getRecord().getEventTagName(), this.m_helper.getRecord().getEventType(), this.m_helper.getRecord().getEventDate(), this.m_helper.getRecord().getEventResidence(), this.m_helper.getRecordWitnesses(), true);
            this.initDisplay(this.m_ruleRoot.findSubRule(RuleSource.class), true);
            this.initDisplay(new RuleSeparator(this.m_ruleRoot), true);
            this.initDisplay(ruleEvent, true);
        } else {
            this.initDisplay(this.m_ruleRoot.findSubRule(RuleSource.class), true);
        }
        this.initDisplay(new RuleSeparator(this.m_ruleRoot), true);
    }

    private void initDisplayWitnesses() {
        if (this.m_ruleWitnesses.size() > 0) {
            this.initDisplay(new RuleSeparator(this.m_ruleRoot), true);
        }
        for (RuleWitness ruleWitness : this.m_ruleWitnesses) {
            this.initDisplay(ruleWitness, true);
        }
    }

    protected Proposal(ProposalHelper helper, Entity proposedEntity) {
        this.m_helper = helper;
        this.m_displayRuleList = new ProposalRuleList();
    }

    private void initDisplay(ProposalRule rule, boolean display) {
        rule.m_display = display;
        this.m_displayRuleList.add(rule, display);
    }

    ProposalRuleList getDisplayRuleList() {
        return this.m_displayRuleList;
    }

    boolean isSelectedEntityProposed() {
        return this.m_ruleRoot.getEntity() == this.m_helper.getSelectedEntity();
    }

    Entity getMainEntity() {
        return this.m_ruleRoot.getEntity();
    }

    Property getMainEvent() {
        PropertyEventDetails eventProperty = null;
        ProposalRule commentRule = this.m_ruleRoot.findSubRule(RuleComment.class);
        if (commentRule != null) {
            eventProperty = ((RuleEvent)((RuleComment)commentRule).getSuperRule()).getEventProperty();
        }
        return eventProperty;
    }

    protected String getEventComment() {
        return this.m_helper.getEventComment();
    }

    public MergeInfo getMergeInfo() {
        MergeInfo info = new MergeInfo();
        this.m_ruleRoot.getInfo(info);
        return info;
    }

    public RuleSource getRuleSource() {
        return this.m_ruleSource;
    }

    public RuleWitness getRuleWitness(MergeRecord.RecordWitness recordWitness) {
        for (RuleWitness ruleWitness : this.m_ruleWitnesses) {
            if (ruleWitness.m_recordWitness != recordWitness) continue;
            return ruleWitness;
        }
        return null;
    }

    public String getSummary(final boolean html) {
        MergeInfo.InfoFormatter formatter = new MergeInfo.InfoFormatter(){

            @Override
            public String getSeparator() {
                if (html) {
                    return "</li><li>";
                }
                return ", ";
            }

            @Override
            public Object format(Object arg) {
                StringBuilder stringArgs = new StringBuilder();
                if (arg == null) {
                    stringArgs.append("");
                } else if (arg instanceof ProposalRule) {
                    ProposalRule rule = (ProposalRule)arg;
                    MergeInfo info = new MergeInfo();
                    rule.getInfo(info);
                    stringArgs.append(info.toString(this));
                } else if (arg instanceof Indi) {
                    Indi indi = (Indi)arg;
                    stringArgs.append(indi.getFirstName()).append(" ").append(indi.getLastName());
                    if (indi.getBirthDate() != null && indi.getBirthDate().isValid()) {
                        stringArgs.append(" \u00b0");
                        if (indi.getBirthDate().getFormat().getPrefix1Name() != null) {
                            stringArgs.append(indi.getBirthDate().getFormat().getPrefix1Name()).append(" ");
                        }
                        stringArgs.append(indi.getBirthDate().getStart().getYear());
                    }
                    stringArgs.append(" (").append(indi.getId()).append(")");
                } else if (arg instanceof Fam) {
                    stringArgs.append(((Fam)arg).getDisplayValue());
                    stringArgs.append("(").append(((Fam)arg).getId()).append(")");
                } else if (arg instanceof Entity) {
                    stringArgs.append(((Entity)arg).getId());
                } else {
                    stringArgs.append(arg.toString());
                }
                return stringArgs.toString().trim();
            }
        };
        if (html) {
            Entity proposedEntity;
            StringBuilder summary = new StringBuilder();
            summary.append("<html>");
            if (this.m_displayRuleList.getNbConflict() > 0 && this.m_helper.getSelectedEntity() != null) {
                summary.append("<font color=\"red\">").append(NbBundle.getMessage(Proposal.class, (String)"Summary.conflict1", (Object)this.m_helper.getSelectedEntity().toString())).append("<br>").append(NbBundle.getMessage(Proposal.class, (String)"Summary.conflict2")).append("</font>").append("<br><br>");
            }
            if ((proposedEntity = this.getMainEntity()) != null) {
                summary.append(NbBundle.getMessage(Proposal.class, (String)"Summary.fit1", (Object)proposedEntity.toString()));
            } else {
                summary.append(NbBundle.getMessage(Proposal.class, (String)"Summary.fit2"));
            }
            summary.append("<ul>");
            if (this.m_displayRuleList.getNbEqual() > 0) {
                summary.append("<li>").append(NbBundle.getMessage(Proposal.class, (String)"Summary.nbEqual", (Object)this.m_displayRuleList.getNbEqual())).append("</li>");
            }
            if (this.m_displayRuleList.getNbCompatibleChecked() > 0) {
                summary.append("<li>").append(NbBundle.getMessage(Proposal.class, (String)"Summary.nbCompatible1", (Object)this.m_displayRuleList.getNbCompatibleChecked())).append("</li>");
            }
            if (this.m_displayRuleList.getNbCompatibleNotChecked() > 0) {
                summary.append("<li>").append(NbBundle.getMessage(Proposal.class, (String)"Summary.nbCompatible2", (Object)this.m_displayRuleList.getNbCompatibleNotChecked())).append("</li>");
            }
            if (this.m_displayRuleList.getNbConflict() > 0) {
                summary.append("<li><font color=\"red\">").append(NbBundle.getMessage(Proposal.class, (String)"Summary.nbConflict", (Object)this.m_displayRuleList.getNbConflict())).append("</li></font>");
            }
            summary.append("</ul>");
            summary.append(NbBundle.getMessage(ProposalRule.class, (String)"Summary.copy"));
            summary.append("<ul><li>");
            summary.append(this.getMergeInfo().toString(formatter));
            summary.append("</li></ul>");
            summary.append("</html>");
            return summary.toString();
        }
        return this.getMergeInfo().toString(formatter);
    }

    public boolean equalAs(Proposal that) {
        return this.m_ruleRoot.equalAs(that.m_ruleRoot);
    }

    void copyRecordToEntity() throws Exception {
        this.m_ruleRoot.copyRecordToEntity();
        for (RuleWitness rule : this.m_ruleWitnesses) {
            rule.copyRecordToEntity();
        }
    }

    @Override
    public int compareTo(Proposal that) {
        int nombre2;
        int nombre1 = that.getDisplayRuleList().getNbEqual();
        if (nombre1 > (nombre2 = this.getDisplayRuleList().getNbEqual())) {
            return 1;
        }
        if (nombre1 == nombre2) {
            nombre1 = that.getDisplayRuleList().getNbCompatibleNotChecked();
            if (nombre1 > (nombre2 = this.getDisplayRuleList().getNbCompatibleNotChecked())) {
                return 1;
            }
            if (nombre1 == nombre2) {
                nombre1 = that.getDisplayRuleList().getNbCompatibleChecked();
                if (nombre1 > (nombre2 = this.getDisplayRuleList().getNbCompatibleChecked())) {
                    return 1;
                }
                if (nombre1 == nombre2) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
        return -1;
    }

    public static String appendValue(String value, String ... otherValues) {
        int fieldSize = value.length();
        StringBuilder sb = new StringBuilder();
        sb.append(value.trim());
        for (String otherValue : otherValues) {
            if (otherValue.trim().isEmpty()) continue;
            if (fieldSize > 0) {
                sb.append(", ");
            }
            sb.append(otherValue);
            fieldSize += otherValue.length();
        }
        return sb.toString();
    }

    class RuleIndi
    extends ARuleEntity<ProposalRule, MergeRecord.RecordIndi, Indi> {
        RuleIndi(ProposalRule superRule, MergeRecord.RecordParticipant participant, Indi indi, Fam marriedFamily, SpouseTag marriedTag, Fam parentFamily, Indi father, Indi mother) throws Exception {
            super(Proposal.this, superRule, (MergeRecord.RecordEntity)participant, (Entity)indi);
            this.m_merge = true;
            this.m_compareResult = superRule == null && participant.getParticipantType() == MergeRecord.MergeParticipantType.participant1 ? ProposalRule.CompareResult.MANDATORY : ProposalRule.CompareResult.COMPATIBLE;
            this.createDisplayAction(this.m_compareResult);
            this.addSubRule(new RuleLastName(this), true);
            this.addSubRule(new RuleFirstName(this), true);
            this.addSubRule(new RuleSex(this), true);
            boolean birthMainEvent = superRule == null && Proposal.this.m_helper.getRecord().getEventTypeTag().equals("BIRT");
            this.addSubRule(new RuleEvent(this, "BIRT", null, null, participant.getBirthDate(), participant.getBirthResidence(), Proposal.this.m_helper.getRecordWitnesses(), birthMainEvent), false);
            if (!birthMainEvent) {
                this.addSubRule(new RuleOccupation(this), true);
                boolean deathMainEvent = superRule == null && Proposal.this.m_helper.getRecord().getEventTypeTag().equals("DEAT");
                this.addSubRule(new RuleEvent(this, "DEAT", null, null, participant.getDeathDate(), participant.getDeathResidence(), Proposal.this.m_helper.getRecordWitnesses(), deathMainEvent), false);
                if (marriedFamily != null || !participant.getMarriedFamily().getMarried().getFirstName().isEmpty() || !participant.getMarriedFamily().getMarried().getLastName().isEmpty()) {
                    this.addSubRule(new RuleSeparator(this), true);
                    this.addSubRule(new RuleFamilyMarried(this, participant.getMarriedFamily(), null, marriedFamily, marriedTag), true);
                }
            }
            this.addSubRule(new RuleSeparator(this), true);
            this.addSubRule(new RuleFamily(this, participant.getParentFamily(), parentFamily, father, mother), true);
        }

        RuleIndi(RuleFamilyMarried superRule, MergeRecord.RecordMarried participant, Indi indiMarried) throws Exception {
            super(Proposal.this, (ProposalRule)superRule, (MergeRecord.RecordEntity)participant, (Entity)indiMarried);
            this.m_merge = true;
            this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            this.createDisplayAction(this.m_compareResult);
            this.addSubRule(new RuleLastName(this), true);
            this.addSubRule(new RuleFirstName(this), true);
            this.addSubRule(new RuleSex(this), true);
            this.addSubRule(new RuleEvent(this, "BIRT", null, null, participant.getBirthDate(), null, Proposal.this.m_helper.getRecordWitnesses(), false), false);
            this.addSubRule(new RuleEvent(this, "DEAT", null, null, participant.getDeathDate(), null, Proposal.this.m_helper.getRecordWitnesses(), false), false);
            this.addSubRule(new RuleOccupation(this), true);
        }

        RuleIndi(RuleFamily superRule, MergeRecord.RecordParent recordParent, Indi indiParent) throws Exception {
            super(Proposal.this, (ProposalRule)superRule, (MergeRecord.RecordEntity)recordParent, (Entity)indiParent);
            if (recordParent.getFirstName().isEmpty() && recordParent.getLastName().isEmpty() && indiParent == null) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            }
            this.createDisplayAction(this.m_compareResult);
            this.addSubRule(new RuleLastName(this), true);
            this.addSubRule(new RuleFirstName(this), true);
            this.addSubRule(new RuleEvent(this, "BIRT", null, null, ((MergeRecord.RecordIndi)this.getRecordEntity()).getBirthDate(), null, Proposal.this.m_helper.getRecordWitnesses(), false), false);
            this.addSubRule(new RuleEvent(this, "DEAT", null, null, ((MergeRecord.RecordIndi)this.getRecordEntity()).getDeathDate(), null, Proposal.this.m_helper.getRecordWitnesses(), false), false);
            this.addSubRule(new RuleOccupation(this), true);
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                Indi indi = (Indi)this.getEntity();
                if (indi == null) {
                    indi = Proposal.this.m_helper.createIndi();
                    indi.setName(((MergeRecord.RecordIndi)this.getRecordEntity()).getFirstName(), ((MergeRecord.RecordIndi)this.getRecordEntity()).getLastName());
                    indi.setSex(((MergeRecord.RecordIndi)this.getRecordEntity()).getSex());
                    this.setEntity(indi);
                }
                this.copyRecordToEntitySubRules();
            }
        }

        @Override
        public void getInfo(MergeInfo info) {
            if (this.isChecked()) {
                if (this.getSuperRule() == null) {
                    info.add("%s%s%s", this.getEntity() != null ? this.getEntity() : RuleIndi.getRuleLabel(this.getLabelResourceName() + ".New"), this.findSubRule(RuleFamilyMarried.class), this.findSubRule(RuleFamily.class));
                } else if (this.getEntity() != null) {
                    info.add("%s", this.getEntity());
                } else {
                    info.add(RuleIndi.getRuleLabel(this.getLabelResourceName() + ".New"), new Object[0]);
                }
            }
        }

        @Override
        public final String getLabelResourceName() {
            String eventTag;
            if (this.getRecordEntity() instanceof MergeRecord.RecordParent) {
                if (((MergeRecord.RecordIndi)this.getRecordEntity()).getSex() == 1) {
                    return "Proposal.Father";
                }
                return "Proposal.Mother";
            }
            if (this.getRecordEntity() instanceof MergeRecord.RecordMarried) {
                String eventTag2 = Proposal.this.m_helper.getRecord().getEventTypeTag();
                if (eventTag2.equals("MARR") || eventTag2.equals("MARB") || eventTag2.equals("MARC") || eventTag2.equals("MARL")) {
                    return "Proposal.ExSpouse";
                }
                return "Proposal.Spouse";
            }
            switch (eventTag = Proposal.this.m_helper.getRecord().getEventTypeTag()) {
                case "MARR": 
                case "MARB": 
                case "MARC": 
                case "MARL": {
                    if (((MergeRecord.RecordIndi)this.getRecordEntity()).getSex() == 1) {
                        return "Proposal.Husband";
                    }
                    return "Proposal.Wife";
                }
                case "DEAT": {
                    return "Proposal.Deceased";
                }
                case "BIRT": {
                    return "Proposal.Child";
                }
            }
            return "Proposal.Individual";
        }
    }

    static abstract class ARuleEntity<P extends ProposalRule, R extends MergeRecord.RecordEntity, E extends Entity>
    extends ARule<P> {
        private final R m_recordEntity;
        private E m_entity;
        private MergeTableAction m_action;
        final /* synthetic */ Proposal this$0;

        ARuleEntity(P superRule, R recordEntity, E entity) {
            this.this$0 = this$0;
            super((Proposal)this$0, superRule);
            this.m_recordEntity = recordEntity;
            this.m_entity = entity;
            this.m_action = null;
        }

        public final R getRecordEntity() {
            return this.m_recordEntity;
        }

        public final E getEntity() {
            return this.m_entity;
        }

        public void setEntity(E entity) {
            this.m_entity = entity;
        }

        @Override
        public boolean equalAs(ProposalRule that) {
            boolean result;
            if (that instanceof ARuleEntity) {
                E entity1 = this.getEntity();
                E entity2 = ((ARuleEntity)that).getEntity();
                result = entity1 == null ? entity1 == entity2 : (entity2 == null ? false : entity1.getId().equals(entity2.getId()));
                if (result) {
                    result = super.equalAs(that);
                }
            } else {
                result = false;
            }
            return result;
        }

        public void createDisplayAction(ProposalRule.CompareResult compareResult) {
            if (compareResult != ProposalRule.CompareResult.NOT_APPLICABLE) {
                this.m_action = new MergeTableAction.ShowEntityAction((Entity)this.getEntity(), ARuleEntity.getRuleLabel(this.getLabelResourceName() + ".New"));
            }
        }

        @Override
        public MergeTableAction getDisplayAction() {
            return this.m_action;
        }
    }

    class RuleFamily
    extends ARuleEntity<RuleIndi, MergeRecord.RecordFamily, Fam> {
        private final RuleIndi m_ruleHusband;
        private final RuleIndi m_ruleWife;

        RuleFamily(MergeRecord.RecordMarriageFamily recordFamily, Fam family, Indi husband, Fam husbandMarriedFamily, Fam husbandParentFamily, Indi husbandFather, Indi husbandMother, Indi wife, Fam wifeMarriedFamily, Fam wifeParentFamily, Indi wifeFather, Indi wifeMother) throws Exception {
            super(Proposal.this, null, (MergeRecord.RecordEntity)recordFamily, (Entity)family);
            this.m_merge = true;
            this.m_compareResult = ProposalRule.CompareResult.MANDATORY;
            this.createDisplayAction(this.m_compareResult);
            if (Proposal.this.m_helper.getRecord().getEventTypeTag().equals("MARR")) {
                this.addSubRule(new RuleEvent(this, "MARR", null, Proposal.this.m_helper.getRecord().getEventType(), Proposal.this.m_helper.getRecord().getEventDate(), Proposal.this.m_helper.getRecord().getEventResidence(), Proposal.this.m_helper.getRecordWitnesses(), true), false);
            } else {
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
                this.addSubRule(new RuleEvent(this, "MARR", null, Proposal.this.m_helper.getRecord().getEventType(), Proposal.this.m_helper.getRecord().calculateMariageDateFromMarc(Proposal.this.m_helper.getRecord().getEventDate()), null, Proposal.this.m_helper.getRecordWitnesses(), false), false);
            }
            this.m_ruleHusband = new RuleIndi(this, Proposal.this.m_helper.getRecord().getIndi(), husband, husbandMarriedFamily, SpouseTag.HUSB, husbandParentFamily, husbandFather, husbandMother);
            this.addSubRule(this.m_ruleHusband, true);
            this.addSubRule(new RuleSeparator(this), true);
            this.m_ruleWife = new RuleIndi(this, Proposal.this.m_helper.getRecord().getWife(), wife, wifeMarriedFamily, SpouseTag.WIFE, wifeParentFamily, wifeFather, wifeMother);
            this.addSubRule(this.m_ruleWife, true);
        }

        RuleFamily(RuleIndi superRule, MergeRecord.RecordParentFamily recordParentFamily, Fam parentFamily, Indi indiFather, Indi indiMother) throws Exception {
            super(Proposal.this, (ProposalRule)superRule, (MergeRecord.RecordEntity)recordParentFamily, (Entity)parentFamily);
            if (parentFamily != null) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else if (recordParentFamily.getHusband().getLastName().isEmpty() && recordParentFamily.getWife().getLastName().isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            }
            this.createDisplayAction(this.m_compareResult);
            this.addSubRule(new RuleEvent(this, "MARR", null, null, recordParentFamily.getMarriageDate(), null, Proposal.this.m_helper.getRecordWitnesses(), false), false);
            this.m_ruleHusband = new RuleIndi(this, recordParentFamily.getHusband(), indiFather);
            this.addSubRule(this.m_ruleHusband, true);
            this.m_ruleWife = new RuleIndi(this, recordParentFamily.getWife(), indiMother);
            this.addSubRule(this.m_ruleWife, true);
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                Indi wife;
                Indi husband;
                Indi indi;
                Fam family = (Fam)this.getEntity();
                if (family == null) {
                    family = Proposal.this.m_helper.createFam();
                    this.setEntity(family);
                }
                this.copyRecordToEntitySubRules();
                if (this.getSuperRule() != null && !(indi = (Indi)((RuleIndi)this.getSuperRule()).getEntity()).isDescendantOf(family)) {
                    family.addChild(indi);
                }
                if ((husband = (Indi)this.m_ruleHusband.getEntity()) != null && family.getHusband() != husband) {
                    family.setHusband(husband);
                }
                if ((wife = (Indi)this.m_ruleWife.getEntity()) != null && family.getWife() != wife) {
                    family.setWife(wife);
                }
            }
        }

        @Override
        public void getInfo(MergeInfo info) {
            if (this.isChecked()) {
                Fam family = (Fam)this.getEntity();
                this.m_ruleHusband.getEntity();
                this.m_ruleWife.getEntity();
                if (this.getSuperRule() == null) {
                    info.add("%s x %s %s %s %s %s %s", this.m_ruleHusband, this.m_ruleWife, family, this.m_ruleHusband.findSubRule(RuleFamily.class), this.m_ruleHusband.findSubRule(RuleFamilyMarried.class), this.m_ruleWife.findSubRule(RuleFamily.class), this.m_ruleWife.findSubRule(RuleFamilyMarried.class));
                } else {
                    info.addSeparator();
                    if (this.m_ruleHusband.isChecked() && this.m_ruleWife.isChecked()) {
                        info.add("%s: %s x %s %s", RuleFamily.getRuleLabel(this.getLabelResourceName()), this.m_ruleHusband, this.m_ruleWife, family);
                    } else {
                        info.add("%s: %s %s %s", RuleFamily.getRuleLabel(this.getLabelResourceName()), this.m_ruleHusband, this.m_ruleWife, family);
                    }
                }
            }
        }

        @Override
        public String getLabelResourceName() {
            if (this.getSuperRule() == null) {
                return "Proposal.Family";
            }
            if (((RuleIndi)this.getSuperRule()).getSuperRule() == null) {
                return "Proposal.Parents";
            }
            if (((MergeRecord.RecordIndi)((RuleIndi)this.getSuperRule()).getRecordEntity()).getSex() == 1) {
                return "Proposal.HusbandParents";
            }
            return "Proposal.WifeParents";
        }
    }

    class RuleEvent
    extends ARuleValue<ARuleEntity<?, ?, ?>, String> {
        private final String m_eventTag;
        private PropertyEventDetails m_eventProperty;

        RuleEvent(ARuleEntity<?, ?, ?> superRule, String eventTag, String evenTagLabel, String evenType, PropertyDate recordEventDate, MergeRecord.RecordResidence recordEventResidence, List<MergeRecord.RecordWitness> recordWitnesses, boolean mainEvent) {
            boolean mergeFalse;
            super(Proposal.this, superRule);
            this.m_eventTag = eventTag;
            Object proposedEntity = superRule.getEntity();
            if (proposedEntity != null) {
                if (this.m_eventTag.equals("BIRT") || this.m_eventTag.equals("DEAT")) {
                    this.m_eventProperty = (PropertyEvent)proposedEntity.getProperty(Proposal.this.m_helper.getEventTag(this.m_eventTag));
                } else {
                    String tag = Proposal.this.m_helper.getEventTag(eventTag);
                    if (recordEventDate.isComparable()) {
                        boolean sameType = false;
                        block0: for (Property iterationEvent : proposedEntity.getProperties(tag)) {
                            String entityEventType;
                            if (evenType != null && !evenType.isEmpty() && evenType.equalsIgnoreCase(entityEventType = iterationEvent.getPropertyValue("TYPE").trim())) {
                                sameType = true;
                            }
                            for (Property iterationProperty : iterationEvent.getProperties("DATE", false)) {
                                PropertyDate iterationDate = (PropertyDate)iterationProperty;
                                if (!MergeQuery.isCompatible(recordEventDate, iterationDate) || this.m_eventProperty != null && !sameType) continue;
                                this.m_eventProperty = (PropertyEventDetails)iterationEvent;
                                continue block0;
                            }
                        }
                    }
                }
            } else {
                this.m_eventProperty = null;
            }
            this.m_recordValue = evenTagLabel;
            this.m_entityValue = this.m_eventProperty != null ? (eventTag.equals("EVEN") ? this.m_eventProperty.getPropertyValue("TYPE") : Proposal.this.m_helper.getTagName(this.m_eventProperty)) : "";
            if (mainEvent) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.MANDATORY;
            } else if (this.m_recordValue != null) {
                if (((String)this.m_recordValue).isEmpty()) {
                    this.m_merge = false;
                    this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
                } else {
                    this.m_merge = !((String)this.m_recordValue).equals(this.m_entityValue);
                    this.m_compareResult = this.m_merge ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
                }
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            }
            if (!(this.m_eventTag.equals("BIRT") || this.m_eventTag.equals("MARR") || this.m_eventTag.equals("DEAT"))) {
                RuleType ruleType = new RuleType(this, evenType);
                this.addSubRule(ruleType, true);
            }
            RuleDate ruleDate = new RuleDate(this, recordEventDate);
            this.addSubRule(ruleDate, true);
            boolean bl = mergeFalse = !ruleDate.getMerge() && ruleDate.getCompareResult() != ProposalRule.CompareResult.EQUAL;
            if (recordEventResidence != null) {
                RulePlace rulePlace = new RulePlace(this, recordEventResidence);
                this.addSubRule(rulePlace, true);
                mergeFalse &= rulePlace.getDisplayEntity() != null && !rulePlace.getDisplayEntity().toString().isEmpty();
            }
            if (mainEvent) {
                this.addSubRule(new RuleComment(this), true);
                Proposal.this.m_ruleSource = new RuleSource(this);
                this.addSubRule(Proposal.this.m_ruleSource, true);
                Proposal.this.m_ruleWitnesses = new ArrayList<RuleWitness>();
                for (MergeRecord.RecordWitness recordWitness : recordWitnesses) {
                    ProposalHelper cfr_ignored_0 = Proposal.this.m_helper;
                    RuleWitness ruleWitness = new RuleWitness(null, recordWitness, ProposalHelper.findWitnessInGedcom(recordWitness, Proposal.this.m_helper.getGedcom()), this);
                    Proposal.this.m_ruleWitnesses.add(ruleWitness);
                }
            }
            if (mergeFalse) {
                for (int index = 0; index < this.getSubRules().size(); ++index) {
                    this.getSubRules().get(index).setMerge(false);
                }
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                if (this.getEventProperty() == null) {
                    RuleDate ruleDate = (RuleDate)this.findSubRule(RuleDate.class);
                    int position = Proposal.this.m_helper.getPropertyBestPosition((Entity)((ARuleEntity)this.getSuperRule()).getEntity(), (PropertyDate)ruleDate.m_recordValue);
                    this.m_eventProperty = (PropertyEventDetails)((ARuleEntity)this.getSuperRule()).getEntity().addProperty(Proposal.this.m_helper.getEventTag(this.m_eventTag), "", position);
                }
                if (this.m_eventTag.equals("EVEN")) {
                    Property propertyType = this.m_eventProperty.getProperty("TYPE");
                    if (propertyType == null) {
                        propertyType = this.m_eventProperty.addProperty("TYPE", "");
                    }
                    propertyType.setValue((String)this.m_recordValue);
                }
                this.copyRecordToEntitySubRules();
                if (this.findSubRule(RuleComment.class) == null) {
                    for (ProposalRule rule : this.getSubRules()) {
                        if (!rule.isChecked()) continue;
                        if (rule instanceof RuleDate) {
                            Proposal.this.m_helper.copyReferenceNote((Property)this.m_eventProperty, "DATE");
                            break;
                        }
                        if (!(rule instanceof RulePlace)) continue;
                        Proposal.this.m_helper.copyReferenceNote((Property)this.m_eventProperty, "PLAC");
                        break;
                    }
                }
            }
        }

        @Override
        public String getLabelResourceName() {
            if (Proposal.this.m_helper.getRecord().isInsinuation() && this.findSubRule(RuleComment.class) == null) {
                return "Proposal.EventInsinuated";
            }
            return "Proposal.Event";
        }

        public PropertyEventDetails getEventProperty() {
            return this.m_eventProperty;
        }

        public final String getEventTag() {
            return this.m_eventTag;
        }

        @Override
        public String toString() {
            return this.m_eventTag + " " + (String)this.m_recordValue;
        }
    }

    class RuleSource
    extends ARuleValue<RuleEvent, String>
    implements MergeTableAction.SourceUpdateListener {
        private Source m_selectedSource;
        private PropertySource m_selectedSourceCitation;
        private final RuleSourcePage m_rulePage;
        private final RuleSourceReliability m_ruleReliability;
        private final RuleSourceText m_ruleSourceText;
        private final RuleSourceMedia m_ruleSourceMedia;
        private MergeTableAction.SourceCitationSelection m_sourceCitationAction;

        RuleSource(RuleEvent superRule) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_selectedSource = Proposal.this.m_helper.findSourceInGedcom(((RuleEvent)this.getSuperRule()).getEventProperty());
            this.m_recordValue = this.m_selectedSource != null ? this.m_selectedSource.getDisplayTitle(false) : Proposal.this.m_helper.getEventSourceTitle();
            List<PropertySource> existingSourceCitations = Proposal.this.m_helper.searchSourceCitationInEvent(((RuleEvent)this.getSuperRule()).getEventProperty());
            this.m_selectedSourceCitation = Proposal.this.m_helper.searchSourceCitationMostCompatible(null, existingSourceCitations);
            this.m_entityValue = this.m_selectedSourceCitation != null ? ((Entity)this.m_selectedSourceCitation.getTargetEntity().get()).getDisplayTitle(false) : "";
            if (!existingSourceCitations.isEmpty()) {
                this.m_sourceCitationAction = new MergeTableAction.SourceCitationSelection(this.m_selectedSourceCitation, existingSourceCitations);
            }
            this.compareRecordAndEntity();
            this.m_rulePage = new RuleSourcePage(this, Proposal.this.m_helper.getRecord().makeEventPage());
            this.addSubRule(this.m_rulePage, true);
            this.m_ruleReliability = new RuleSourceReliability(this);
            this.addSubRule(this.m_ruleReliability, true);
            this.m_ruleSourceText = new RuleSourceText(this, Proposal.this.m_helper.getRecord().getEventDeedText());
            this.addSubRule(this.m_ruleSourceText, true);
            this.m_ruleSourceMedia = new RuleSourceMedia(this, Proposal.this.m_helper.getRecord().getEventMedia());
            this.addSubRule(this.m_ruleSourceMedia, true);
        }

        @Override
        public void sourceUpdated(String newSourceTile, Source existingSource) {
            this.m_selectedSource = existingSource;
            this.m_recordValue = this.m_selectedSource != null ? this.m_selectedSource.getDisplayTitle(false) : Proposal.this.m_helper.getEventSourceTitle();
            List<PropertySource> existingSourceCitations = Proposal.this.m_helper.searchSourceCitationInEvent(((RuleEvent)this.getSuperRule()).getEventProperty());
            this.m_selectedSourceCitation = Proposal.this.m_helper.searchSourceCitationMostCompatible((String)this.m_recordValue, existingSourceCitations);
            this.m_entityValue = this.m_selectedSourceCitation != null ? ((Entity)this.m_selectedSourceCitation.getTargetEntity().get()).getDisplayTitle(false) : "";
            if (!existingSourceCitations.isEmpty()) {
                this.m_sourceCitationAction = new MergeTableAction.SourceCitationSelection(this.m_selectedSourceCitation, existingSourceCitations);
            }
            this.compareRecordAndEntity();
            this.m_rulePage.sourceUpdated();
            this.m_ruleReliability.sourceUpdated();
            this.m_ruleSourceText.sourceUpdated();
            this.m_ruleSourceMedia.sourceUpdated();
        }

        void compareRecordAndEntity() {
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (((String)this.m_recordValue).equals(this.m_entityValue)) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else if (((String)this.m_entityValue).isEmpty()) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                PropertyEventDetails eventProperty = ((RuleEvent)this.getSuperRule()).getEventProperty();
                if (this.m_selectedSourceCitation != null && this.m_compareResult == ProposalRule.CompareResult.CONFLICT) {
                    eventProperty.delProperty((Property)this.m_selectedSourceCitation);
                    this.m_selectedSourceCitation = null;
                    this.m_rulePage.sourceUpdated();
                    this.m_ruleReliability.sourceUpdated();
                    this.m_ruleSourceText.sourceUpdated();
                    this.m_ruleSourceMedia.sourceUpdated();
                }
                if (this.m_selectedSource == null) {
                    this.m_selectedSource = Proposal.this.m_helper.createSource();
                    this.m_selectedSource.addProperty("TITL", (String)this.m_recordValue);
                }
                if (this.m_selectedSourceCitation == null) {
                    this.m_selectedSourceCitation = (PropertySource)eventProperty.addProperty("SOUR", "@" + this.m_selectedSource.getId() + "@");
                    try {
                        this.m_selectedSourceCitation.link();
                    }
                    catch (GedcomException ex) {
                        throw new Exception(String.format("Link source=%s error=%s ", this.m_selectedSource == null ? this.m_selectedSource : this.m_selectedSource.getTitle(), ex.getMessage()));
                    }
                }
            }
            this.copyRecordToEntitySubRules();
        }

        @Override
        public Object getDisplayRecord() {
            if (this.m_selectedSource != null) {
                Proposal.this.m_helper.getSourceAction().setSource(this.m_selectedSource);
            }
            return Proposal.this.m_helper.getSourceAction();
        }

        @Override
        public Object getDisplayEntity() {
            if (this.m_sourceCitationAction != null) {
                return this.m_sourceCitationAction;
            }
            return this.m_entityValue;
        }

        @Override
        public void onSelectedEntityChanged(Object object) {
            if (object instanceof MergeTableAction.SourceCitationSelection) {
                MergeTableAction.SourceCitationSelection sourceCitationAction = (MergeTableAction.SourceCitationSelection)object;
                this.m_selectedSourceCitation = sourceCitationAction.getProperty();
                this.m_entityValue = this.m_selectedSourceCitation != null ? ((Entity)this.m_selectedSourceCitation.getTargetEntity().get()).getDisplayTitle(false) : "";
                this.compareRecordAndEntity();
                this.m_rulePage.sourceUpdated();
                this.m_ruleReliability.sourceUpdated();
                this.m_ruleSourceText.sourceUpdated();
                this.m_ruleSourceMedia.sourceUpdated();
            }
        }

        @Override
        public MergeTableAction getDisplayAction() {
            return new MergeTableAction.ShowEntityAction((Entity)this.m_selectedSource, RuleSource.getRuleLabel(this.getLabelResourceName() + ".New"));
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventSource";
        }

        PropertySource getSourceCitation() {
            return this.m_selectedSourceCitation;
        }
    }

    class RuleSeparator
    extends ARule<ProposalRule> {
        RuleSeparator(ProposalRule superRule) {
            super(Proposal.this, superRule);
            this.m_merge = false;
            this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
        }

        @Override
        public void copyRecordToEntity() throws Exception {
        }
    }

    class RuleWitness
    extends ARuleEntity<ProposalRule, MergeRecord.RecordWitness, Indi>
    implements MergeTableAction.WitnessUpdateListener {
        private final MergeRecord.RecordWitness m_recordWitness;
        private Indi m_selectedWitness;
        private final RuleEvent m_ruleEvent;
        private PropertyAssociation m_selectedWitnessAssociation;
        private final RuleWitnessRole m_ruleWitnessRole;
        private String m_recordValue;
        private String m_entityValue;
        private MergeTableAction.WitnessAssociationSelection m_witnessAssociationAction;

        RuleWitness(ProposalRule superRule, MergeRecord.RecordWitness recordWitness, Indi witness, RuleEvent ruleEvent) {
            super(Proposal.this, superRule, (MergeRecord.RecordEntity)recordWitness, (Entity)witness);
            this.m_ruleEvent = ruleEvent;
            this.m_recordWitness = recordWitness;
            this.m_recordValue = this.m_recordWitness != null ? recordWitness.getDisplayValue() : "";
            this.m_selectedWitness = witness;
            this.m_entityValue = this.m_selectedWitness != null ? this.m_selectedWitness.toString(false) : "";
            List<PropertyAssociation> existingWitnessAssociations = Proposal.this.m_helper.searchWitnessAssociationInEvent(this.m_ruleEvent.getEventProperty());
            this.m_selectedWitnessAssociation = Proposal.this.m_helper.searchWitnessAssociationMostCompatible(this.m_recordWitness, existingWitnessAssociations);
            if (this.m_selectedWitnessAssociation != null) {
                this.m_selectedWitness = (Indi)this.m_selectedWitnessAssociation.getTargetEntity().get();
                this.m_entityValue = this.m_selectedWitness.toString(false);
            } else {
                this.m_entityValue = "";
            }
            if (!existingWitnessAssociations.isEmpty()) {
                this.m_witnessAssociationAction = new MergeTableAction.WitnessAssociationSelection(this.m_selectedWitnessAssociation, existingWitnessAssociations);
            }
            this.compareRecordAndEntity();
            this.m_ruleWitnessRole = new RuleWitnessRole(this, ruleEvent.m_eventTag);
            this.addSubRule(this.m_ruleWitnessRole, true);
            this.addSubRule(new RuleWitnessOccupation(this), true);
        }

        @Override
        public void witnessUpdated(String newWitnessTile, Indi existingWitness) {
            this.m_selectedWitness = existingWitness;
            this.m_recordValue = this.m_selectedWitness != null ? this.m_selectedWitness.getDisplayTitle(true) : "";
            List<PropertyAssociation> existingWitnessAssociations = Proposal.this.m_helper.searchWitnessAssociationInEvent(this.m_ruleEvent.getEventProperty());
            this.m_selectedWitnessAssociation = Proposal.this.m_helper.searchWitnessAssociationMostCompatible(this.m_recordWitness, existingWitnessAssociations);
            if (this.m_selectedWitnessAssociation != null) {
                this.m_selectedWitness = (Indi)this.m_selectedWitnessAssociation.getTargetEntity().get();
                this.m_entityValue = this.m_selectedWitness.toString(false);
            } else {
                this.m_entityValue = "";
            }
            if (!existingWitnessAssociations.isEmpty()) {
                this.m_witnessAssociationAction = new MergeTableAction.WitnessAssociationSelection(this.m_selectedWitnessAssociation, existingWitnessAssociations);
            }
            this.compareRecordAndEntity();
            this.m_ruleWitnessRole.witnessUpdated();
        }

        void compareRecordAndEntity() {
            if (this.m_recordValue.isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (Utilities.removeDiacriticsLower((String)this.m_entityValue).contains(Utilities.removeDiacriticsLower((String)this.m_recordValue))) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else if (this.m_entityValue.isEmpty()) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                PropertyEventDetails eventProperty = this.m_ruleEvent.getEventProperty();
                if (!eventProperty.isGrammar7()) {
                    return;
                }
                if (this.m_selectedWitnessAssociation != null && this.m_compareResult == ProposalRule.CompareResult.CONFLICT) {
                    eventProperty.delProperty((Property)this.m_selectedWitnessAssociation);
                    this.m_selectedWitnessAssociation = null;
                    this.m_ruleWitnessRole.witnessUpdated();
                }
                if (this.m_selectedWitness == null) {
                    this.m_selectedWitness = Proposal.this.m_helper.createIndi();
                    PropertyName name = (PropertyName)this.m_selectedWitness.addProperty("NAME", "");
                    name.setName(this.m_recordWitness.getFirstName(), this.m_recordWitness.getLastName());
                }
                if (this.m_selectedWitnessAssociation == null) {
                    this.m_selectedWitnessAssociation = (PropertyAssociation)eventProperty.addProperty("ASSO", "@" + this.m_selectedWitness.getId() + "@");
                    try {
                        this.m_selectedWitnessAssociation.link();
                    }
                    catch (GedcomException ex) {
                        eventProperty.delProperty((Property)this.m_selectedWitnessAssociation);
                        throw new Exception(String.format("Link witness=%s error=%s ", this.m_selectedWitness == null ? this.m_selectedWitness : this.m_selectedWitness.getDisplayTitle(false), ex.getMessage()));
                    }
                }
            }
            this.copyRecordToEntitySubRules();
        }

        @Override
        public Object getDisplayRecord() {
            for (MergeTableAction.WitnessRecordSelection selection : Proposal.this.m_helper.getWitnessActions()) {
                if (selection.m_recordWitness != this.m_recordWitness) continue;
                return selection;
            }
            return null;
        }

        @Override
        public Object getDisplayEntity() {
            if (this.m_witnessAssociationAction != null) {
                return this.m_witnessAssociationAction;
            }
            return this.m_entityValue;
        }

        @Override
        public void onSelectedEntityChanged(Object object) {
            if (object instanceof MergeTableAction.WitnessAssociationSelection) {
                MergeTableAction.WitnessAssociationSelection witnessAssociationAction = (MergeTableAction.WitnessAssociationSelection)object;
                this.m_selectedWitnessAssociation = witnessAssociationAction.getProperty();
                this.m_entityValue = this.m_selectedWitnessAssociation != null ? ((Entity)this.m_selectedWitnessAssociation.getTargetEntity().get()).toString(false) : "";
                this.compareRecordAndEntity();
                this.m_ruleWitnessRole.witnessUpdated();
            }
        }

        @Override
        public MergeTableAction getDisplayAction() {
            return new MergeTableAction.ShowEntityAction((Entity)this.m_selectedWitness, RuleWitness.getRuleLabel(this.getLabelResourceName() + ".New"));
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventWitness";
        }

        PropertyAssociation getWitnessAssociation() {
            return this.m_selectedWitnessAssociation;
        }

        Indi getWitness() {
            return this.m_selectedWitness;
        }
    }

    class RuleComment
    extends ARuleValue<RuleEvent, String> {
        private Property m_propertyNote;

        RuleComment(RuleEvent superRule) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = Proposal.this.m_helper.getEventComment();
            PropertyEventDetails eventProperty = ((RuleEvent)this.getSuperRule()).getEventProperty();
            Object object = this.m_entityValue = eventProperty == null ? "" : eventProperty.getPropertyValue("NOTE");
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (((String)this.m_entityValue).isEmpty()) {
                this.m_merge = !((String)this.m_recordValue).equals(this.m_entityValue);
                this.m_compareResult = this.m_merge ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = !((String)this.m_entityValue).contains((CharSequence)this.m_recordValue);
                this.m_compareResult = !((String)this.m_recordValue).equals(this.m_entityValue) ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            String comment;
            if (this.isChecked() && !(comment = Proposal.this.m_helper.getEventComment()).isEmpty()) {
                Object value;
                PropertyEventDetails birthProperty = ((RuleEvent)this.getSuperRule()).getEventProperty();
                this.m_propertyNote = birthProperty.getProperty("NOTE");
                if (this.m_propertyNote == null) {
                    this.m_propertyNote = birthProperty.addProperty("NOTE", "");
                }
                if (this.m_propertyNote instanceof PropertyNote) {
                    this.m_propertyNote = (Property)((PropertyNote)this.m_propertyNote).getTargetEntity().get();
                }
                if (!((String)(value = this.m_propertyNote.getValue())).isEmpty()) {
                    value = (String)value + "\n";
                }
                value = (String)value + comment;
                this.m_propertyNote.setValue((String)value);
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventComment";
        }
    }

    class RuleWitnessOccupation
    extends ARuleValue<RuleWitness, String> {
        RuleWitnessOccupation(RuleWitness superRule) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = superRule.m_recordWitness.getOccupation();
            this.m_entityValue = null;
            Indi witness = superRule.getWitness();
            Object object = this.m_entityValue = witness == null ? null : MergeQuery.findOccupation(witness, Proposal.this.m_helper.getRecord().getEventDate());
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else {
                this.m_merge = !((String)this.m_recordValue).equals(this.m_entityValue);
                this.m_compareResult = this.m_merge ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                String occupation = ((RuleWitness)this.getSuperRule()).m_recordWitness.getOccupation();
                Indi indi = ((RuleWitness)this.getSuperRule()).getWitness();
                PropertyDate occupationDate = Proposal.this.m_helper.getRecord().getEventDate();
                Property occupationProperty = null;
                if (!occupation.isEmpty()) {
                    occupationProperty = indi.addProperty("OCCU", "", Proposal.this.m_helper.getPropertyBestPosition((Entity)indi, occupationDate));
                    occupationProperty.setValue(occupation);
                }
                if (occupationProperty != null) {
                    PropertyDate date = (PropertyDate)occupationProperty.addProperty("DATE", "");
                    date.setValue(occupationDate.getValue());
                    Proposal.this.m_helper.copyReferenceNote(occupationProperty, "DATE");
                }
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.Occupation";
        }
    }

    class RuleWitnessRole
    extends ARuleValue<RuleWitness, PropertyChoiceRole> {
        private MergeTableAction.WitnessRoleRecordSelection witnessRoleRecordSelection;

        RuleWitnessRole(RuleWitness superRule, String eventTag) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = new PropertyChoiceRole("ROLE");
            RoleEnum role = switch (eventTag) {
                case "BIRT" -> RoleEnum.WITN;
                case "CHR" -> RoleEnum.GODP;
                default -> RoleEnum.WITN;
            };
            ((PropertyChoiceRole)this.m_recordValue).setValue(role.getDisplayValue());
            this.witnessRoleRecordSelection = new MergeTableAction.WitnessRoleRecordSelection((PropertyChoiceRole)this.m_recordValue);
            this.m_entityValue = Proposal.this.m_helper.searchRoleInWitnessAssociation(((RuleWitness)this.getSuperRule()).getWitnessAssociation());
            this.compareRecordAndEntity();
        }

        private void compareRecordAndEntity() {
            if (this.m_recordValue == null) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (this.m_entityValue == null) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else if (((PropertyChoiceRole)this.m_entityValue).getValue().equals(((PropertyChoiceRole)this.m_recordValue).getValue())) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            PropertyAssociation association;
            if (this.isChecked() && (association = ((RuleWitness)this.getSuperRule()).getWitnessAssociation()) != null) {
                Property roleProperty = association.getProperty("ROLE");
                if (roleProperty == null) {
                    association.addProperty("ROLE", ((PropertyChoiceRole)this.m_recordValue).getValue());
                } else {
                    roleProperty.setValue(((PropertyChoiceRole)this.m_recordValue).getValue());
                }
            }
        }

        @Override
        public Object getDisplayRecord() {
            this.witnessRoleRecordSelection.setValue((PropertyChoiceRole)this.m_recordValue);
            return this.witnessRoleRecordSelection;
        }

        @Override
        public Object getDisplayEntity() {
            return this.m_entityValue;
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventWitnessRole";
        }

        @Override
        public void onRecordChanged(Object object) {
            if (object instanceof MergeTableAction.WitnessRoleRecordSelection) {
                MergeTableAction.WitnessRoleRecordSelection witnessAction = (MergeTableAction.WitnessRoleRecordSelection)object;
                ((PropertyChoiceRole)this.m_recordValue).setValue(witnessAction.getProperty().getValue());
                this.compareRecordAndEntity();
                if (this.m_recordValue != null && (this.m_entityValue == null || this.m_entityValue != null && !((PropertyChoiceRole)this.m_recordValue).getValue().equals(((PropertyChoiceRole)this.m_entityValue).getValue()))) {
                    this.m_merge = true;
                }
            }
        }

        void witnessUpdated() {
            this.m_entityValue = Proposal.this.m_helper.searchRoleInWitnessAssociation(((RuleWitness)this.getSuperRule()).getWitnessAssociation());
            this.compareRecordAndEntity();
        }
    }

    class RuleSourceMedia
    extends ARuleValue<RuleSource, String> {
        private List<PropertyMedia> m_existingMediaProperties;
        private PropertyMedia m_selectedMediaProperty;
        private MergeTableAction.SourceMediaSelection m_sourceMediaAction;

        RuleSourceMedia(RuleSource superRule, String recordValue) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = recordValue;
            this.m_existingMediaProperties = Proposal.this.m_helper.searchMediaInSourceCitation(((RuleSource)this.getSuperRule()).getSourceCitation());
            this.setEntity(Proposal.this.m_helper.searchMediaWithSameValue(this.m_existingMediaProperties, (String)this.m_recordValue));
        }

        void setEntity(PropertyMedia selectedMediaProperty) {
            this.m_selectedMediaProperty = selectedMediaProperty;
            this.m_entityValue = ProposalHelper.getFileValue(selectedMediaProperty);
            this.compareRecordAndEntity();
            if (!this.m_existingMediaProperties.isEmpty()) {
                this.m_sourceMediaAction = new MergeTableAction.SourceMediaSelection(this.m_selectedMediaProperty, this.m_existingMediaProperties);
            }
        }

        final void compareRecordAndEntity() {
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (((String)this.m_entityValue).isEmpty()) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else if (((String)this.m_entityValue).contains((CharSequence)this.m_recordValue)) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        void sourceUpdated() {
            this.m_existingMediaProperties = Proposal.this.m_helper.searchMediaInSourceCitation(((RuleSource)this.getSuperRule()).getSourceCitation());
            this.setEntity(Proposal.this.m_helper.searchMediaWithSameValue(this.m_existingMediaProperties, (String)this.m_recordValue));
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked() && ((RuleSource)this.getSuperRule()).getSourceCitation() != null) {
                PropertySource source;
                PropertySource parentOfObje = null;
                parentOfObje = MergeOption.getSourceScopeCity() ? (source = ((RuleSource)this.getSuperRule()).getSourceCitation()) : (source = (Property)((RuleSource)this.getSuperRule()).getSourceCitation().getTargetEntity().get());
                Media media = null;
                PropertyMedia pMedia = null;
                if (this.m_selectedMediaProperty != null) {
                    pMedia = this.m_selectedMediaProperty;
                }
                if (pMedia == null) {
                    media = (Media)parentOfObje.getGedcom().createEntity("OBJE");
                    pMedia = (PropertyMedia)parentOfObje.addMedia(media);
                }
                if (media == null) {
                    media = (Media)pMedia.getTargetEntity().get();
                }
                PropertyFile pFile = null;
                Property tmp = media.getProperty("FILE");
                if (tmp instanceof PropertyFile) {
                    pFile = (PropertyFile)tmp;
                }
                if (pFile == null) {
                    pFile = (PropertyFile)media.addProperty("FILE", "");
                }
                pFile.setValue((String)this.m_recordValue);
                Property pForm = pFile.getProperty("FORM");
                if (pForm == null) {
                    pForm = pFile.addProperty("FORM", "");
                }
                pForm.setValue(pFile.getSuffix());
                Property pTitl = pFile.getProperty("TITL");
                if (pTitl == null) {
                    pTitl = pFile.addProperty("TITL", "");
                }
                String title = Proposal.this.m_helper.getRecord().getTitle();
                pTitl.setValue(title);
            }
        }

        @Override
        public Object getDisplayEntity() {
            if (!this.m_existingMediaProperties.isEmpty()) {
                return this.m_sourceMediaAction;
            }
            return this.m_entityValue;
        }

        @Override
        public void onSelectedEntityChanged(Object object) {
            if (object instanceof MergeTableAction.SourceMediaSelection) {
                MergeTableAction.SourceMediaSelection sourceMediaAction = (MergeTableAction.SourceMediaSelection)object;
                this.setEntity(sourceMediaAction.getProperty());
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventMedia";
        }
    }

    class RuleSourceText
    extends ARuleValue<RuleSource, String> {
        private List<PropertyMultilineValue> m_existingTextProperties;
        private PropertyMultilineValue m_selectedTextProperty;
        private MergeTableAction.SourceTextSelection m_sourceTextAction;

        RuleSourceText(RuleSource superRule, String recordValue) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = recordValue;
            this.m_existingTextProperties = Proposal.this.m_helper.searchTextInSourceCitation(((RuleSource)this.getSuperRule()).getSourceCitation());
            this.setEntity(Proposal.this.m_helper.searchTextWithSameValue(this.m_existingTextProperties, (String)this.m_recordValue));
        }

        void setEntity(PropertyMultilineValue selectedTextProperty) {
            this.m_selectedTextProperty = selectedTextProperty;
            this.m_entityValue = this.m_selectedTextProperty != null ? this.m_selectedTextProperty.getValue() : "";
            this.compareRecordAndEntity();
            if (!this.m_existingTextProperties.isEmpty()) {
                this.m_sourceTextAction = new MergeTableAction.SourceTextSelection(this.m_selectedTextProperty, this.m_existingTextProperties);
            }
        }

        final void compareRecordAndEntity() {
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (((String)this.m_entityValue).isEmpty()) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else if (((String)this.m_entityValue).contains((CharSequence)this.m_recordValue)) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        void sourceUpdated() {
            this.m_existingTextProperties = Proposal.this.m_helper.searchTextInSourceCitation(((RuleSource)this.getSuperRule()).getSourceCitation());
            this.setEntity(Proposal.this.m_helper.searchTextWithSameValue(this.m_existingTextProperties, (String)this.m_recordValue));
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked() && ((RuleSource)this.getSuperRule()).getSourceCitation() != null) {
                if (MergeOption.getSourceScopeCity()) {
                    PropertySource source = ((RuleSource)this.getSuperRule()).getSourceCitation();
                    Property sourceData = source.getProperty("DATA");
                    if (sourceData == null) {
                        sourceData = source.addProperty("DATA", "");
                    }
                    sourceData.addProperty("TEXT", (String)this.m_recordValue);
                } else {
                    Property sourceTarget = (Property)((RuleSource)this.getSuperRule()).getSourceCitation().getTargetEntity().get();
                    if (sourceTarget.getProperty("TEXT") == null) {
                        sourceTarget.addProperty("TEXT", (String)this.m_recordValue);
                    } else {
                        sourceTarget.setValue(new TagPath("SOUR:TEXT"), (String)this.m_recordValue);
                    }
                }
            }
        }

        @Override
        public Object getDisplayEntity() {
            if (!this.m_existingTextProperties.isEmpty()) {
                return this.m_sourceTextAction;
            }
            return this.m_entityValue;
        }

        @Override
        public void onSelectedEntityChanged(Object object) {
            if (object instanceof MergeTableAction.SourceTextSelection) {
                MergeTableAction.SourceTextSelection sourceTextAction = (MergeTableAction.SourceTextSelection)object;
                this.setEntity(sourceTextAction.getProperty());
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventDeedText";
        }
    }

    class RuleSourceReliability
    extends ARuleValue<RuleSource, PropertyQuality> {
        RuleSourceReliability(RuleSource superRule) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = new PropertyQuality();
            ((PropertyQuality)this.m_recordValue).setQuality(3);
            this.m_entityValue = Proposal.this.m_helper.searchReliabilityInSourceCitation(((RuleSource)this.getSuperRule()).getSourceCitation());
            this.compareRecordAndEntity();
        }

        private void compareRecordAndEntity() {
            if (this.m_recordValue == null) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (this.m_entityValue == null) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else if (((PropertyQuality)this.m_entityValue).getQuality() == ((PropertyQuality)this.m_recordValue).getQuality()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            PropertySource sourceCitation;
            if (this.isChecked() && (sourceCitation = ((RuleSource)this.getSuperRule()).getSourceCitation()) != null) {
                Property quayProperty = sourceCitation.getProperty("QUAY");
                if (quayProperty == null) {
                    sourceCitation.addProperty("QUAY", ((PropertyQuality)this.m_recordValue).getValue());
                } else {
                    quayProperty.setValue(((PropertyQuality)this.m_recordValue).getValue());
                }
            }
        }

        @Override
        public Object getDisplayRecord() {
            return new MergeTableAction.SourceReliabilitySelection((PropertyQuality)this.m_recordValue);
        }

        @Override
        public Object getDisplayEntity() {
            return this.m_entityValue;
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventSourceReliability";
        }

        @Override
        public void onRecordChanged(Object object) {
            if (object instanceof MergeTableAction.SourceReliabilitySelection) {
                MergeTableAction.SourceReliabilitySelection reliabilityAction = (MergeTableAction.SourceReliabilitySelection)object;
                ((PropertyQuality)this.m_recordValue).setQuality(reliabilityAction.getProperty().getQuality());
                this.compareRecordAndEntity();
                if (this.m_recordValue != null && (this.m_entityValue == null || this.m_entityValue != null && ((PropertyQuality)this.m_recordValue).getQuality() != ((PropertyQuality)this.m_entityValue).getQuality())) {
                    this.m_merge = true;
                }
            }
        }

        void sourceUpdated() {
            this.m_entityValue = Proposal.this.m_helper.searchReliabilityInSourceCitation(((RuleSource)this.getSuperRule()).getSourceCitation());
            this.compareRecordAndEntity();
        }
    }

    class RuleSourcePage
    extends ARuleValue<RuleSource, String> {
        private Property m_pageProperty;

        RuleSourcePage(RuleSource superRule, String recordValue) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = recordValue;
            PropertySource sourceProperty = ((RuleSource)this.getSuperRule()).getSourceCitation();
            if (sourceProperty != null) {
                this.m_pageProperty = sourceProperty.getProperty(new TagPath("SOUR:PAGE"));
                this.m_entityValue = this.m_pageProperty != null ? this.m_pageProperty.getValue() : "";
            } else {
                this.m_pageProperty = null;
                this.m_entityValue = "";
            }
            this.compareRecordAndEntity();
        }

        void compareRecordAndEntity() {
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (this.m_pageProperty != null) {
                if (((String)this.m_recordValue).equals(this.m_entityValue)) {
                    this.m_merge = false;
                    this.m_compareResult = ProposalRule.CompareResult.EQUAL;
                } else {
                    String eventCote = Proposal.this.m_helper.getRecord().getEventCote();
                    String eventPage = Proposal.this.m_helper.getRecord().getEventPage();
                    this.m_entityValue = this.m_pageProperty.getValue();
                    if (!eventCote.isEmpty() && this.m_pageProperty.getValue().contains(eventCote) && !eventPage.isEmpty() && this.m_pageProperty.getValue().contains(eventPage)) {
                        this.m_merge = false;
                        this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
                    } else {
                        this.m_merge = false;
                        this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
                    }
                }
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            }
        }

        void sourceUpdated() {
            PropertySource sourceProperty = ((RuleSource)this.getSuperRule()).getSourceCitation();
            if (sourceProperty != null) {
                this.m_pageProperty = sourceProperty.getProperty("PAGE");
                this.m_entityValue = this.m_pageProperty != null ? this.m_pageProperty.getValue() : "";
            } else {
                this.m_pageProperty = null;
                this.m_entityValue = "";
            }
            this.compareRecordAndEntity();
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                if (this.m_pageProperty == null) {
                    ((RuleSource)this.getSuperRule()).getSourceCitation().addProperty("PAGE", Proposal.this.m_helper.getRecord().makeEventPage());
                } else {
                    this.m_pageProperty.setValue(Proposal.this.m_helper.getRecord().makeEventPage());
                }
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventSourcePage";
        }
    }

    class RuleSex
    extends ARuleValue<ARuleEntity<?, MergeRecord.RecordIndi, Indi>, String> {
        RuleSex(ARuleEntity<?, MergeRecord.RecordIndi, Indi> superRule) {
            int entityValue;
            super(Proposal.this, superRule);
            this.m_recordValue = PropertySex.getLabelForSex((int)superRule.getRecordEntity().getSex());
            this.m_entityValue = superRule.getEntity() == null ? "" : PropertySex.getLabelForSex((int)(superRule.getEntity() == null ? 0 : superRule.getEntity().getSex()));
            Indi indi = (Indi)((ARuleEntity)this.getSuperRule()).getEntity();
            int recordValue = ((MergeRecord.RecordIndi)((ARuleEntity)this.getSuperRule()).getRecordEntity()).getSex();
            int n = entityValue = indi == null ? 0 : indi.getSex();
            if (recordValue == 0) {
                if (entityValue == 0) {
                    if (indi == null) {
                        this.m_merge = false;
                        this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
                    } else {
                        this.m_merge = false;
                        this.m_compareResult = ProposalRule.CompareResult.EQUAL;
                    }
                } else {
                    this.m_merge = false;
                    this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
                }
            } else if (entityValue == 0) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else {
                this.m_merge = false;
                this.m_compareResult = recordValue != entityValue ? ProposalRule.CompareResult.CONFLICT : ProposalRule.CompareResult.EQUAL;
            }
        }

        @Override
        public void copyRecordToEntity() {
            if (this.isChecked()) {
                ((Indi)((ARuleEntity)this.getSuperRule()).getEntity()).setSex(((MergeRecord.RecordIndi)((ARuleEntity)this.getSuperRule()).getRecordEntity()).getSex());
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.Sex";
        }
    }

    class RulePlace
    extends ARuleValue<RuleEvent, String> {
        private final MergeRecord.RecordResidence m_recordResidence;

        RulePlace(RuleEvent superRule, MergeRecord.RecordResidence recordResidence) {
            String entityPlace;
            String entityAddress;
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordResidence = recordResidence;
            this.m_recordValue = Proposal.appendValue(this.m_recordResidence.getAddress(), this.m_recordResidence.getPlace());
            if (((RuleEvent)this.getSuperRule()).getEventProperty() == null) {
                entityAddress = "";
                entityPlace = "";
            } else {
                entityAddress = ((RuleEvent)this.getSuperRule()).getEventProperty().getPropertyValue("ADDR");
                entityPlace = ((RuleEvent)this.getSuperRule()).getEventProperty().getPropertyValue("PLAC");
            }
            this.m_entityValue = Proposal.appendValue(entityAddress, entityPlace);
            if (this.m_recordResidence.isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (((String)this.m_entityValue).isBlank()) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else if (((String)this.m_recordValue).equals(this.m_entityValue)) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                String place = this.m_recordResidence.getPlace();
                String address = this.m_recordResidence.getAddress();
                PropertyEventDetails eventProperty = ((RuleEvent)this.getSuperRule()).getEventProperty();
                PropertyPlace propertyPlace = (PropertyPlace)eventProperty.getProperty("PLAC");
                if (propertyPlace == null) {
                    propertyPlace = (PropertyPlace)eventProperty.addProperty("PLAC", "");
                }
                propertyPlace.setValue(place);
                Proposal.this.m_helper.copyPlaceCoordinates(propertyPlace);
                if (!address.isEmpty()) {
                    Property propertyAddress = eventProperty.getProperty("ADDR");
                    if (propertyAddress == null) {
                        propertyAddress = eventProperty.addProperty("ADDR", "");
                    }
                    propertyAddress.setValue(address);
                }
            }
        }

        @Override
        public String getLabelResourceName() {
            switch (((RuleEvent)this.getSuperRule()).getEventTag()) {
                case "BIRT": {
                    return "Proposal.BirthPlace";
                }
                case "DEAT": {
                    return "Proposal.DeathPlace";
                }
            }
            return "Proposal.EventInsinuationPlace";
        }
    }

    class RuleType
    extends ARuleValue<RuleEvent, String> {
        RuleType(RuleEvent superRule, String type) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = type;
            this.m_entityValue = ((RuleEvent)this.getSuperRule()).getEventProperty() == null ? "" : ((RuleEvent)this.getSuperRule()).getEventProperty().getPropertyValue("TYPE");
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (((String)this.m_entityValue).isBlank()) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            } else if (((String)this.m_recordValue).equals(this.m_entityValue)) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                PropertyEventDetails eventProperty = ((RuleEvent)this.getSuperRule()).getEventProperty();
                Property property = eventProperty.getProperty("TYPE", false);
                if (property == null) {
                    property = eventProperty.addProperty("TYPE", "");
                }
                property.setValue((String)this.m_recordValue);
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.EventType";
        }
    }

    class RuleOccupation
    extends ARuleValue<ARuleEntity<?, MergeRecord.RecordIndi, Indi>, String> {
        RuleOccupation(ARuleEntity<?, MergeRecord.RecordIndi, Indi> superRule) {
            super(Proposal.this, superRule);
            this.m_recordValue = superRule.getRecordEntity().getOccupationWithDate();
            Object object = this.m_entityValue = superRule.getEntity() == null ? null : MergeQuery.findOccupation(superRule.getEntity(), Proposal.this.m_helper.getRecord().getEventDate());
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else {
                this.m_merge = !((String)this.m_recordValue).equals(this.m_entityValue);
                this.m_compareResult = this.m_merge ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                String occupation = ((MergeRecord.RecordIndi)((ARuleEntity)this.getSuperRule()).getRecordEntity()).getOccupation();
                Indi indi = (Indi)((ARuleEntity)this.getSuperRule()).getEntity();
                PropertyDate occupationDate = Proposal.this.m_helper.getRecord().getEventDate();
                MergeRecord.RecordResidence residence = ((MergeRecord.RecordIndi)((ARuleEntity)this.getSuperRule()).getRecordEntity()).getResidence();
                Property occupationProperty = null;
                if (!occupation.isEmpty()) {
                    occupationProperty = indi.addProperty("OCCU", "", Proposal.this.m_helper.getPropertyBestPosition((Entity)indi, occupationDate));
                    occupationProperty.setValue(occupation);
                } else if (!residence.isEmpty()) {
                    occupationProperty = indi.addProperty("RESI", "", Proposal.this.m_helper.getPropertyBestPosition((Entity)indi, occupationDate));
                }
                if (occupationProperty != null) {
                    PropertyDate date = (PropertyDate)occupationProperty.addProperty("DATE", "");
                    date.setValue(occupationDate.getValue());
                    if (!residence.isEmpty()) {
                        Proposal.this.m_helper.copyPlace(residence, occupationProperty);
                    }
                    Proposal.this.m_helper.copyReferenceNote(occupationProperty, "DATE");
                }
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.Occupation";
        }
    }

    class RuleLastName
    extends ARuleValue<ARuleEntity<?, MergeRecord.RecordIndi, Indi>, String> {
        RuleLastName(ARuleEntity<?, MergeRecord.RecordIndi, Indi> superRule) {
            super(Proposal.this, superRule);
            this.m_recordValue = superRule.getRecordEntity().getLastName();
            Object object = this.m_entityValue = superRule.getEntity() == null ? "" : superRule.getEntity().getLastName();
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (((String)this.m_entityValue).isEmpty()) {
                this.m_merge = !((String)this.m_recordValue).equals(this.m_entityValue);
                this.m_compareResult = this.m_merge ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            } else if (MergeQuery.isSameLastName(((String)this.m_recordValue).trim(), ((String)this.m_entityValue).trim())) {
                this.m_merge = false;
                this.m_compareResult = !((String)this.m_recordValue).equals(this.m_entityValue) ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                ((Indi)((ARuleEntity)this.getSuperRule()).getEntity()).setName(((Indi)((ARuleEntity)this.getSuperRule()).getEntity()).getFirstName(), ((MergeRecord.RecordIndi)((ARuleEntity)this.getSuperRule()).getRecordEntity()).getLastName());
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.LastName";
        }
    }

    class RuleFirstName
    extends ARuleValue<ARuleEntity<?, MergeRecord.RecordIndi, Indi>, String> {
        RuleFirstName(ARuleEntity<?, MergeRecord.RecordIndi, Indi> superRule) {
            super(Proposal.this, superRule);
            this.m_recordValue = superRule.getRecordEntity().getFirstName();
            Object object = this.m_entityValue = superRule.getEntity() == null ? "" : superRule.getEntity().getFirstName();
            if (((String)this.m_recordValue).isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (((String)this.m_entityValue).isEmpty()) {
                this.m_merge = !((String)this.m_recordValue).equals(this.m_entityValue);
                this.m_compareResult = this.m_merge ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            } else if (MergeQuery.isSameFirstName(((String)this.m_recordValue).trim(), ((String)this.m_entityValue).trim())) {
                this.m_merge = false;
                this.m_compareResult = !((String)this.m_recordValue).equals(this.m_entityValue) ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            } else {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                ((Indi)((ARuleEntity)this.getSuperRule()).getEntity()).setName(((MergeRecord.RecordIndi)((ARuleEntity)this.getSuperRule()).getRecordEntity()).getFirstName(), ((Indi)((ARuleEntity)this.getSuperRule()).getEntity()).getLastName());
            }
        }

        @Override
        public String getLabelResourceName() {
            return "Proposal.FirstName";
        }
    }

    class RuleFamilyMarried
    extends ARuleEntity<ARuleEntity<?, MergeRecord.RecordIndi, Indi>, MergeRecord.RecordMarriedFamily, Fam> {
        private final RuleIndi m_indiMarriedRule;
        private final SpouseTag m_marriedTag;

        RuleFamilyMarried(ARuleEntity<?, MergeRecord.RecordIndi, Indi> superRule, MergeRecord.RecordMarriedFamily recordFamily, Indi indiMarried, Fam marriedFamily, SpouseTag marriedTag) throws Exception {
            super(Proposal.this, superRule, (MergeRecord.RecordEntity)recordFamily, (Entity)marriedFamily);
            this.m_marriedTag = marriedTag;
            if (indiMarried == null && this.getEntity() != null) {
                indiMarried = marriedTag == SpouseTag.HUSB ? ((Fam)this.getEntity()).getWife() : ((Fam)this.getEntity()).getHusband();
            }
            if (this.getEntity() != null) {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else if (recordFamily.getMarried().getLastName().isEmpty() && recordFamily.getMarried().getFirstName().isEmpty()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else {
                this.m_merge = true;
                this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
            }
            this.createDisplayAction(this.m_compareResult);
            this.addSubRule(new RuleEvent(this, "MARR", null, null, recordFamily.getMarriageDate(), null, Proposal.this.m_helper.getRecordWitnesses(), false), false);
            this.m_indiMarriedRule = new RuleIndi(this, recordFamily.getMarried(), indiMarried);
            this.addSubRule(this.m_indiMarriedRule, true);
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                Indi indiMarried;
                if (this.getEntity() == null) {
                    this.setEntity(Proposal.this.m_helper.createFam());
                }
                this.copyRecordToEntitySubRules();
                Indi indi = (Indi)((ARuleEntity)this.getSuperRule()).getEntity();
                if (indi != null) {
                    if (this.m_marriedTag == SpouseTag.HUSB) {
                        ((Fam)this.getEntity()).setHusband(indi);
                    } else {
                        ((Fam)this.getEntity()).setWife(indi);
                    }
                }
                if ((indiMarried = (Indi)this.m_indiMarriedRule.getEntity()) != null) {
                    if (this.m_marriedTag != SpouseTag.HUSB) {
                        ((Fam)this.getEntity()).setHusband(indiMarried);
                    } else {
                        ((Fam)this.getEntity()).setWife(indiMarried);
                    }
                }
            }
        }

        @Override
        public void getInfo(MergeInfo info) {
            if (this.isChecked()) {
                info.addSeparator();
                info.add("%s: %s %s", RuleFamilyMarried.getRuleLabel(this.getLabelResourceName()), this.findSubRule(RuleIndi.class), this.getEntity());
            }
        }

        @Override
        public final String getLabelResourceName() {
            String eventTag = Proposal.this.m_helper.getRecord().getEventTypeTag();
            if (eventTag.equals("MARR") || eventTag.equals("MARB") || eventTag.equals("MARC") || eventTag.equals("MARL")) {
                return "Proposal.ExFamily";
            }
            return "Proposal.Family";
        }
    }

    class RuleDate
    extends ARuleValue<RuleEvent, PropertyDate> {
        RuleDate(RuleEvent superRule, PropertyDate recordDate) {
            super(Proposal.this, (ProposalRule)superRule);
            this.m_recordValue = new PropertyDate();
            PropertyDate tempDate = recordDate;
            ((PropertyDate)this.m_recordValue).setValue(tempDate.getFormat(), tempDate.getStart(), tempDate.getEnd(), tempDate.getPhrase());
            Object object = this.m_entityValue = ((RuleEvent)this.getSuperRule()).getEventProperty() == null ? null : (PropertyDate)((RuleEvent)this.getSuperRule()).getEventProperty().getProperty("DATE", false);
            if (!((PropertyDate)this.m_recordValue).isComparable()) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.NOT_APPLICABLE;
            } else if (this.m_entityValue == null || !((PropertyDate)this.m_entityValue).isComparable()) {
                this.m_merge = ((PropertyDate)this.m_recordValue).isComparable();
                this.m_compareResult = this.m_merge ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.EQUAL;
            } else if (((PropertyDate)this.m_recordValue).getValue().equals(((PropertyDate)this.m_entityValue).getValue())) {
                this.m_merge = false;
                this.m_compareResult = ProposalRule.CompareResult.EQUAL;
            } else {
                PropertyDate bestDate = MergeQuery.getMostAccurateDate((PropertyDate)this.m_recordValue, (PropertyDate)this.m_entityValue);
                if (bestDate == null) {
                    this.m_merge = false;
                    this.m_compareResult = ProposalRule.CompareResult.CONFLICT;
                } else if (bestDate == this.m_entityValue) {
                    this.m_merge = false;
                    this.m_compareResult = MergeQuery.isCompatible((PropertyDate)this.m_recordValue, (PropertyDate)this.m_entityValue) ? ProposalRule.CompareResult.COMPATIBLE : ProposalRule.CompareResult.CONFLICT;
                } else {
                    ((PropertyDate)this.m_recordValue).setValue(bestDate.getFormat(), bestDate.getStart(), bestDate.getEnd(), bestDate.getPhrase());
                    this.m_merge = true;
                    this.m_compareResult = ProposalRule.CompareResult.COMPATIBLE;
                }
            }
        }

        @Override
        public void copyRecordToEntity() throws Exception {
            if (this.isChecked()) {
                PropertyEventDetails eventProperty = ((RuleEvent)this.getSuperRule()).getEventProperty();
                PropertyDate propertyDate = (PropertyDate)eventProperty.getProperty("DATE", false);
                if (propertyDate == null) {
                    propertyDate = (PropertyDate)eventProperty.addProperty("DATE", "");
                }
                propertyDate.setValue(((PropertyDate)this.m_recordValue).getValue());
            }
        }

        @Override
        public String getLabelResourceName() {
            switch (((RuleEvent)this.getSuperRule()).getEventTag()) {
                case "BIRT": {
                    return "Proposal.BirthDate";
                }
                case "DEAT": {
                    return "Proposal.DeathDate";
                }
                case "MARR": {
                    return "Proposal.MarriageDate";
                }
            }
            return "Proposal.EventInsinuationDate";
        }
    }

    static abstract class ARuleValue<P extends ProposalRule, V>
    extends ARule<P> {
        protected V m_recordValue;
        protected V m_entityValue;
        final /* synthetic */ Proposal this$0;

        ARuleValue(P superRule) {
            this.this$0 = this$0;
            super((Proposal)this$0, superRule);
        }

        @Override
        public Object getDisplayRecord() {
            return this.m_recordValue;
        }

        @Override
        public Object getDisplayEntity() {
            return this.m_entityValue;
        }
    }

    static abstract class ARule<P extends ProposalRule>
    extends ProposalRule {
        private P m_SuperRule;
        final /* synthetic */ Proposal this$0;

        ARule(P superRule) {
            this.this$0 = this$0;
            this.m_SuperRule = superRule;
            this.initSuper();
        }

        private void initSuper() {
            if (this.m_SuperRule != null) {
                ((ProposalRule)this.m_SuperRule).getSubRules().add(this);
            }
        }

        public final P getSuperRule() {
            return this.m_SuperRule;
        }
    }
}

