/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.io.FileAssociation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.util.Exceptions;

public class EditorHyperlinkSupport
implements HyperlinkListener {
    private static final Logger LOG = Logger.getLogger("ancestris.log");
    private JEditorPane editor;

    public EditorHyperlinkSupport(JEditorPane editor) {
        this.editor = editor;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        if (e.getDescription().startsWith("#")) {
            this.editor.scrollToReference(e.getDescription().substring(1));
        } else {
            try {
                this.handleHyperlink(e.getDescription());
            }
            catch (Throwable t) {
                LOG.log(Level.INFO, "can't open browser for " + e.getDescription());
            }
        }
    }

    protected void handleHyperlink(String link) throws IOException, URISyntaxException {
        try {
            FileAssociation.getDefault().execute(new URL(link.replaceAll(" ", "%20")));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

