/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteArray {
    private static final int CLUSTER = 4096;
    private static final byte[] EMPTY = new byte[0];
    private byte[] bits = EMPTY;
    private boolean isAllowInterrupts;

    public ByteArray(InputStream in) throws InterruptedException, IOException {
        this(in, Math.max(in.available(), 4096), false);
    }

    public ByteArray(InputStream in, boolean allowInterrupts) throws InterruptedException, IOException {
        this(in, Math.max(in.available(), 4096), allowInterrupts);
    }

    public ByteArray(InputStream in, int cluster, boolean allowInterrupts) throws InterruptedException, IOException {
        this.isAllowInterrupts = allowInterrupts;
        byte[] buffer = new byte[cluster + 1];
        int len = 0;
        int total = 0;
        while (true) {
            len = in.read(buffer, total, buffer.length - total);
            if (this.isAllowInterrupts && Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (len < 0) break;
            if ((total += len) < buffer.length) continue;
            byte[] tmp = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, tmp, 0, buffer.length);
            buffer = tmp;
        }
        this.bits = new byte[total];
        System.arraycopy(buffer, 0, this.bits, 0, total);
        buffer = null;
    }

    public byte[] getBytes() {
        return this.bits;
    }
}

