/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer.views;

import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyFile;
import genj.gedcom.TagPath;
import genj.renderer.BlueprintRenderer;
import genj.renderer.BlueprintRendererSample;
import genj.util.Dimension2d;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class MyView
extends View {
    private static final Logger LOG = Logger.getLogger("ancestris.renderer");
    private Element element;
    private Font font = null;
    private Color foreground = null;
    private Dimension2D preferredSpan = null;
    private int maxAtt = 0;
    private BlueprintRenderer renderer;

    public MyView(Element elem, BlueprintRenderer rdr) {
        super(elem);
        this.element = elem;
        this.renderer = rdr;
        try {
            String att = (String)elem.getAttributes().getAttribute("max");
            if (att != null) {
                this.maxAtt = Integer.parseInt(att);
            }
        }
        catch (NumberFormatException t) {
            LOG.log(Level.FINER, "Error with maxAtt conversion", t);
        }
    }

    @Override
    public int viewToModel(float arg0, float arg1, Shape arg2, Position.Bias[] arg3) {
        throw new RuntimeException("viewToModel() is not supported");
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        throw new RuntimeException("modelToView() is not supported");
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        if (axis == 1) {
            return 0;
        }
        if (len > this.getPreferredSpan(0)) {
            return 1000;
        }
        return 0;
    }

    @Override
    public View breakView(int axis, int offset, float pos, float len) {
        return this;
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (this.preferredSpan == null) {
            this.preferredSpan = this.getPreferredSpan();
            if (this.maxAtt > 0) {
                double maxWidth = this.renderer.getRoot().getWidth() * (float)this.maxAtt / 100.0f;
                if (this.preferredSpan.getWidth() > maxWidth) {
                    Property prop = this.getProperty("path", "default");
                    if (prop == null && this.renderer instanceof BlueprintRendererSample) {
                        Object p = this.element.getAttributes().getAttribute("path");
                        if (p != null) {
                            prop = this.renderer.getProperty(this.renderer.getEntity(), new TagPath((String)p));
                        } else {
                            p = this.element.getAttributes().getAttribute("default");
                            if (p != null) {
                                prop = this.renderer.getProperty(this.renderer.getEntity(), new TagPath((String)p));
                            }
                        }
                    }
                    this.preferredSpan = "media".equals(this.element.getName()) || prop instanceof PropertyFile || prop instanceof PropertyBlob ? new Dimension2d(maxWidth, this.preferredSpan.getHeight() * maxWidth / this.preferredSpan.getWidth()) : new Dimension2d(maxWidth, this.preferredSpan.getHeight());
                }
            }
        }
        return (float)(axis == 0 ? this.preferredSpan.getWidth() : this.preferredSpan.getHeight());
    }

    private Property getProperty(String path, String defaultPath) {
        Property prop = null;
        Object p = this.element.getAttributes().getAttribute(path);
        if (p != null) {
            prop = this.renderer.getEntity().getProperty(new TagPath((String)p));
        }
        if (prop != null) {
            return prop;
        }
        if (prop == null || p == null) {
            p = this.element.getAttributes().getAttribute(defaultPath);
        }
        if (p != null) {
            prop = this.renderer.getEntity().getProperty(new TagPath((String)p));
        }
        return prop;
    }

    public abstract String getHTMLValue(int var1, int var2, File var3);

    @Override
    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public float getMaximumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public float getAlignment(int axis) {
        if (0 == axis) {
            return super.getAlignment(axis);
        }
        float height = (float)this.getPreferredSpan().getHeight();
        FontMetrics fm = this.getGraphics().getFontMetrics();
        float h = fm.getHeight();
        float d = fm.getDescent();
        return (h - d) / height;
    }

    @Override
    public Graphics getGraphics() {
        this.renderer.getGraphics().setFont(this.getFont());
        return this.renderer.getGraphics();
    }

    protected Color getForeground() {
        if (this.foreground == null) {
            this.foreground = this.renderer.getDoc().getForeground(this.renderer.getDoc().getStyleSheet().getViewAttributes(this));
        }
        return this.foreground;
    }

    protected Font getFont() {
        if (this.font == null) {
            this.font = this.renderer.getDoc().getFont(this.renderer.getDoc().getStyleSheet().getViewAttributes(this));
        }
        return this.font;
    }

    protected abstract Dimension2D getPreferredSpan();

    public void invalidate() {
        this.preferredSpan = null;
        this.font = null;
        super.preferenceChanged(this, true, true);
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.renderer.getFactory();
    }

    protected void render(String txt, Graphics2D g, Rectangle r) {
        if (txt.length() == 0) {
            return;
        }
        TextLayout layout = new TextLayout(txt, g.getFont(), g.getFontRenderContext());
        layout.draw(g, (float)r.getX(), (float)r.getY() + layout.getAscent());
    }

    protected int getMaxAtt() {
        return this.maxAtt;
    }

    protected BlueprintRenderer getRenderer() {
        return this.renderer;
    }
}

