/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.Option;
import genj.option.OptionUI;
import genj.util.swing.ImageIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import swingx.tree.AbstractTreeModel;

public class OptionsWidget
extends JPanel {
    public static final ImageIcon IMAGE = new ImageIcon(OptionsWidget.class, "images/Options");
    private JTree tree;
    private Model model = new Model();
    private int widthOf1stColumn = 32;
    private String title;
    private DefaultTreeCellRenderer defaultRenderer;

    public OptionsWidget(String title) {
        this(title, null);
    }

    public OptionsWidget(String title, List<? extends Option> options) {
        this.title = title;
        this.tree = new JTree(this.model){

            @Override
            public boolean isPathEditable(TreePath path) {
                return path.getLastPathComponent() instanceof Option;
            }
        };
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new Cell());
        this.tree.setCellEditor(new Cell());
        this.tree.setEditable(true);
        this.tree.setInvokesStopCellEditing(true);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.tree));
        if (options != null) {
            this.setOptions(options);
        }
    }

    @Override
    public void removeNotify() {
        this.stopEditing();
        super.removeNotify();
    }

    public void stopEditing() {
        this.tree.stopEditing();
    }

    public void setOptions(List<? extends Option> set) {
        this.stopEditing();
        this.tree.clearSelection();
        ArrayList<Option> options = new ArrayList<Option>();
        for (Option option : set) {
            if (option.getUI(this) == null) continue;
            options.add(option);
        }
        Font font = this.tree.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        FontMetrics fm = null;
        Graphics graphicsContext = this.getGraphics();
        if (graphicsContext != null) {
            fm = graphicsContext.getFontMetrics(font);
        }
        this.widthOf1stColumn = 0;
        for (Option option : options) {
            if (fm == null) {
                this.widthOf1stColumn = Math.max(this.widthOf1stColumn, 4 + (int)Math.ceil(font.getStringBounds(option.getName(), fontRenderContext).getWidth()));
                continue;
            }
            this.widthOf1stColumn = Math.max(this.widthOf1stColumn, 4 + (int)Math.ceil(fm.getStringBounds(option.getName(), graphicsContext).getWidth()));
        }
        this.model.setOptions(options);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.doLayout();
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
        this.defaultRenderer = new DefaultTreeCellRenderer();
    }

    private class Model
    extends AbstractTreeModel {
        private final List<String> categories = new ArrayList<String>();
        private final Map<String, List<Option>> cat2options = new HashMap<String, List<Option>>();

        private Model() {
        }

        @Override
        protected Object getParent(Object node) {
            throw new IllegalArgumentException();
        }

        private List<Option> getCategory(String cat) {
            List<Option> result;
            if (cat == null) {
                cat = OptionsWidget.this.title;
            }
            if ((result = this.cat2options.get(cat)) == null) {
                result = new ArrayList<Option>();
                this.cat2options.put(cat, result);
                this.categories.add(cat);
            }
            return result;
        }

        private void setOptions(List<Option> set) {
            this.cat2options.clear();
            this.categories.clear();
            for (Option option : set) {
                List<Option> cat = this.getCategory(option.getCategory());
                cat.add(option);
            }
            this.fireTreeStructureChanged(this, new Object[]{this}, null, null);
        }

        @Override
        public Object getRoot() {
            return this;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this) {
                return this.categories.size();
            }
            return this.getCategory((String)parent).size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof Option;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this) {
                return this.categories.get(index);
            }
            return this.getCategory((String)parent).get(index);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            throw new IllegalArgumentException();
        }
    }

    private class Cell
    extends AbstractCellEditor
    implements TreeCellRenderer,
    TreeCellEditor {
        private OptionUI optionUi;
        private final JPanel panel = new JPanel(){

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (ks.getKeyCode() == 10) {
                    Cell.this.stopCellEditing();
                }
                if (ks.getKeyCode() == 27) {
                    Cell.this.cancelCellEditing();
                }
                return true;
            }
        };
        private final JLabel labelForName = new JLabel();
        private final JLabel labelForValue = new JLabel();

        private Cell() {
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.labelForName, "West");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (OptionsWidget.this.defaultRenderer != null) {
                if (selected) {
                    this.labelForName.setForeground(OptionsWidget.this.defaultRenderer.getTextSelectionColor());
                    this.labelForName.setBackground(OptionsWidget.this.defaultRenderer.getBackgroundSelectionColor());
                    this.labelForValue.setForeground(OptionsWidget.this.defaultRenderer.getTextSelectionColor());
                    this.labelForValue.setBackground(OptionsWidget.this.defaultRenderer.getBackgroundSelectionColor());
                } else {
                    this.labelForName.setForeground(OptionsWidget.this.defaultRenderer.getTextNonSelectionColor());
                    this.labelForName.setBackground(OptionsWidget.this.defaultRenderer.getBackgroundNonSelectionColor());
                    this.labelForValue.setForeground(OptionsWidget.this.defaultRenderer.getTextNonSelectionColor());
                    this.labelForValue.setBackground(OptionsWidget.this.defaultRenderer.getBackgroundNonSelectionColor());
                }
            }
            if (value instanceof Option) {
                Option option = (Option)value;
                return this.assemblePanel(option, false);
            }
            Font font = this.labelForValue.getFont();
            this.labelForName.setFont(new Font(font.getFamily(), 1, font.getSize() + 2));
            this.labelForName.setBorder(new EmptyBorder(14, 6, 2, 0));
            if (this.panel.getComponentCount() > 1) {
                this.panel.remove(1);
            }
            this.labelForName.setText(value.toString());
            Graphics g = OptionsWidget.this.getGraphics();
            if (g != null) {
                FontMetrics metrics = OptionsWidget.this.getGraphics().getFontMetrics(font);
                int hgt = metrics.getHeight();
                int adv = metrics.stringWidth(this.labelForName.getText()) * 2;
                Dimension size = new Dimension(adv + 6, hgt + 16);
                this.labelForName.setPreferredSize(size);
            } else {
                this.labelForName.setPreferredSize(null);
            }
            return this.panel;
        }

        private JPanel assemblePanel(Option option, boolean forceUI) {
            JComponent compForValue;
            if (this.panel.getComponentCount() > 1) {
                this.panel.remove(1);
            }
            this.optionUi = option.getUI(OptionsWidget.this);
            this.labelForName.setText(option.getName());
            this.labelForName.setPreferredSize(new Dimension(OptionsWidget.this.widthOf1stColumn, 16));
            String text = this.optionUi.getTextRepresentation();
            if (text != null && !forceUI) {
                this.labelForValue.setText(text);
                compForValue = this.labelForValue;
            } else {
                compForValue = this.optionUi.getComponentRepresentation();
            }
            this.panel.add((Component)compForValue, "Center");
            this.panel.setToolTipText(option.getToolTip());
            this.labelForName.setFont(this.labelForValue.getFont());
            this.labelForName.setBorder(new EmptyBorder(0, 0, 0, 0));
            return this.panel;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            return this.assemblePanel((Option)value, true);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public void cancelCellEditing() {
            this.optionUi = null;
            super.cancelCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            if (this.optionUi != null) {
                this.optionUi.endRepresentation();
            }
            return super.stopCellEditing();
        }
    }
}

