/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util;

public class TimingUtility {
    private long start;
    private static TimingUtility instance;

    public static TimingUtility getInstance() {
        if (instance == null) {
            instance = new TimingUtility();
        }
        return instance;
    }

    public TimingUtility() {
        this.reset();
    }

    public void reset() {
        this.start = System.currentTimeMillis();
    }

    public String getTime() {
        return String.format("%05d", System.currentTimeMillis() - this.start);
    }

    public String getTimeHMS() {
        int duration = (int)(System.currentTimeMillis() - this.start);
        int hours = duration / 1000 / 3600;
        int min = (duration -= hours * 1000 * 3600) / 1000 / 60;
        int sec = (duration -= min * 1000 * 60) / 1000;
        return String.format("%02d:%02d:%02d", hours, min, sec);
    }

    public long getDelay() {
        return System.currentTimeMillis() - this.start;
    }
}

