/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.AncestrisCorePlugin;
import ancestris.core.pluginservice.PluginInterface;
import ancestris.view.AncestrisViewInterface;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public interface AncestrisAPIEntry {
    public static final String DELIMITER_IN_ANCHOR = "*";
    public static final String DELIMITER_IN_ANCHOR_REGEX = "\\*";

    public boolean processAction(String var1, Entity var2);

    public boolean isEntryID(String var1);

    public Gedcom getAPIGedcom();

    public static class Factory {
        public static AncestrisAPIEntry lookupAll(String id, Gedcom gedcom, boolean create) {
            AncestrisAPIEntry api = Factory.findOpenedAPI(id, gedcom);
            if (api == null && create) {
                for (PluginInterface plugin : Lookup.getDefault().lookupAll(PluginInterface.class)) {
                    if (!plugin.getPluginName().equals(id)) continue;
                    plugin.launchModule((Object)gedcom);
                    api = Factory.findOpenedAPI(id, gedcom);
                }
            }
            return api;
        }

        private static AncestrisAPIEntry findOpenedAPI(String id, Gedcom gedcom) {
            for (AncestrisViewInterface view : AncestrisCorePlugin.lookupAll(AncestrisViewInterface.class)) {
                AncestrisAPIEntry api;
                if (!(view instanceof AncestrisAPIEntry) || !(api = (AncestrisAPIEntry)((Object)view)).isEntryID(id) || !gedcom.equals(api.getAPIGedcom()) || !(view instanceof TopComponent)) continue;
                TopComponent tc = (TopComponent)view;
                if (!tc.isOpened()) {
                    tc.open();
                }
                tc.requestActive();
                return api;
            }
            return null;
        }

        public static String getAnchor(String view, String command, Entity entity) {
            StringBuilder sb = new StringBuilder();
            sb.append(entity.getTag());
            sb.append(AncestrisAPIEntry.DELIMITER_IN_ANCHOR);
            sb.append(entity.getId());
            sb.append(AncestrisAPIEntry.DELIMITER_IN_ANCHOR);
            sb.append(view);
            sb.append(AncestrisAPIEntry.DELIMITER_IN_ANCHOR);
            sb.append(command);
            return sb.toString();
        }
    }
}

