/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import ancestris.modules.editors.aries.utilities.PropertyTag2Name;
import genj.gedcom.Property;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;

public class SourceCitationsTableModel
extends AbstractTableModel {
    ArrayList<Property> mSourcesList = new ArrayList();
    private final String[] columnsName = new String[]{NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.events.title"), NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.description.title"), NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.page.title"), NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.text.title"), NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.multimedia.title"), NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.note.title")};

    @Override
    public int getRowCount() {
        return this.mSourcesList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnsName.length;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Property source = this.mSourcesList.get(row);
        if (source != null && source.isValid()) {
            switch (column) {
                case 0: {
                    if (source instanceof PropertySource) {
                        Property event = source.getProperty("EVEN");
                        if (event != null) {
                            return PropertyTag2Name.getTagName(event.getValue());
                        }
                        return "";
                    }
                    return "";
                }
                case 1: {
                    if (source instanceof PropertySource) {
                        PropertySource propertySource = (PropertySource)source;
                        Source targetEntity = propertySource.getTargetEntity().orElse(null);
                        if (targetEntity != null) {
                            return targetEntity.getTitle();
                        }
                        return "";
                    }
                    return source.getValue();
                }
                case 2: {
                    if (source instanceof PropertySource) {
                        Property page = source.getProperty("PAGE");
                        if (page != null) {
                            return page.getValue();
                        }
                        return "";
                    }
                    return "";
                }
                case 3: {
                    if (source instanceof PropertySource) {
                        PropertySource pSource = (PropertySource)source;
                        Property texte = source.getProperty(new TagPath(".:DATA:TEXT"));
                        if (texte != null) {
                            return NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.text.value.yes");
                        }
                        Source targetEntity = pSource.getTargetEntity().orElse(null);
                        if (targetEntity != null && targetEntity.getText() != null && !targetEntity.getText().isEmpty()) {
                            return NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.text.value.yes");
                        }
                        return NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.text.value.no");
                    }
                    return NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.text.value.no");
                }
                case 4: {
                    PropertySource propertySource;
                    Source targetEntity;
                    ArrayList<Property> multimediaObjects = new ArrayList<Property>(Arrays.asList(source.getProperties("OBJE")));
                    if (source instanceof PropertySource && (targetEntity = (Source)(propertySource = (PropertySource)source).getTargetEntity().orElse(null)) != null) {
                        multimediaObjects.addAll(Arrays.asList(targetEntity.getProperties("OBJE")));
                    }
                    if (!multimediaObjects.isEmpty()) {
                        return NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.multimedia.value.yes");
                    }
                    return NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.multimedia.value.no");
                }
                case 5: {
                    PropertySource propertySource;
                    Source targetEntity;
                    ArrayList<Property> notes = new ArrayList<Property>();
                    notes.addAll(Arrays.asList(source.getProperties("NOTE")));
                    if (source.isGrammar7()) {
                        notes.addAll(Arrays.asList(source.getProperties("SNOTE")));
                    }
                    if (source instanceof PropertySource && (targetEntity = (Source)(propertySource = (PropertySource)source).getTargetEntity().orElse(null)) != null) {
                        notes.addAll(Arrays.asList(targetEntity.getProperties("NOTE")));
                        if (targetEntity.isGrammar7()) {
                            notes.addAll(Arrays.asList(targetEntity.getProperties("SNOTE")));
                        }
                    }
                    if (!notes.isEmpty()) {
                        return NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.note.value.yes");
                    }
                    return NbBundle.getMessage(SourceCitationsTableModel.class, (String)"SourceCitationsTableModel.column.note.value.no");
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        return this.columnsName[col];
    }

    public String[] getColumnsName() {
        return this.columnsName;
    }

    public void add(Property source) {
        this.mSourcesList.add(source);
        this.fireTableDataChanged();
    }

    public void addAll(List<Property> sourcesList) {
        this.mSourcesList.addAll(sourcesList);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.mSourcesList.clear();
        this.fireTableDataChanged();
    }

    public Property getValueAt(int row) {
        return this.mSourcesList.get(row);
    }

    public Property remove(int row) {
        Property source = this.mSourcesList.remove(row);
        this.fireTableDataChanged();
        return source;
    }

    public int indexOf(Object o) {
        return this.mSourcesList.indexOf(o);
    }
}

