/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.file.FileSinkBase;

public class FileSinkDOT
extends FileSinkBase {
    protected PrintWriter out;
    protected String graphName = "";
    protected boolean digraph;

    public FileSinkDOT() {
        this(false);
    }

    public FileSinkDOT(boolean digraph) {
        this.digraph = digraph;
    }

    public void setDirected(boolean digraph) {
        this.digraph = digraph;
    }

    public boolean isDirected() {
        return this.digraph;
    }

    @Override
    protected void exportGraph(Graph graph) {
        String graphId = graph.getId();
        AtomicLong timeId = new AtomicLong(0L);
        graph.attributeKeys().forEach(key -> this.graphAttributeAdded(graphId, timeId.getAndIncrement(), (String)key, graph.getAttribute((String)key)));
        for (Node node : graph) {
            String nodeId = node.getId();
            this.out.printf("\t\"%s\" %s;%n", nodeId, this.outputAttributes(node));
        }
        graph.edges().forEach(edge -> {
            String fromNodeId = edge.getNode0().getId();
            String toNodeId = edge.getNode1().getId();
            String attr = this.outputAttributes((Element)edge);
            if (this.digraph) {
                this.out.printf("\t\"%s\" -> \"%s\"", fromNodeId, toNodeId);
                if (!edge.isDirected()) {
                    this.out.printf(" -> \"%s\"", fromNodeId);
                }
            } else {
                this.out.printf("\t\"%s\" -- \"%s\"", fromNodeId, toNodeId);
            }
            this.out.printf(" %s;%n", attr);
        });
    }

    @Override
    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.out.printf("%s {%n", this.digraph ? "digraph" : "graph");
        if (this.graphName.length() > 0) {
            this.out.printf("\tgraph [label=%s];%n", this.graphName);
        }
    }

    @Override
    protected void outputEndOfFile() throws IOException {
        this.out.printf("}%n", new Object[0]);
    }

    @Override
    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
    }

    @Override
    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    @Override
    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
    }

    @Override
    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
        this.out.printf("\tgraph [ %s ];%n", this.outputAttribute(attribute, value, true));
    }

    @Override
    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("\tgraph [ %s ];%n", this.outputAttribute(attribute, newValue, true));
    }

    @Override
    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
    }

    @Override
    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        this.out.printf("\t\"%s\" [ %s ];%n", nodeId, this.outputAttribute(attribute, value, true));
    }

    @Override
    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("\t\"%s\" [ %s ];%n", nodeId, this.outputAttribute(attribute, newValue, true));
    }

    @Override
    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
    }

    @Override
    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (this.digraph) {
            this.out.printf("\t\"%s\" -> \"%s\"", fromNodeId, toNodeId);
            if (!directed) {
                this.out.printf(" -> \"%s\"", fromNodeId);
            }
            this.out.printf(";%n", new Object[0]);
        } else {
            this.out.printf("\t\"%s\" -- \"%s\";%n", fromNodeId, toNodeId);
        }
    }

    @Override
    public void edgeRemoved(String graphId, long timeId, String edgeId) {
    }

    @Override
    public void graphCleared(String graphId, long timeId) {
    }

    @Override
    public void nodeAdded(String graphId, long timeId, String nodeId) {
        this.out.printf("\t\"%s\";%n", nodeId);
    }

    @Override
    public void nodeRemoved(String graphId, long timeId, String nodeId) {
    }

    @Override
    public void stepBegins(String graphId, long timeId, double step) {
    }

    protected String outputAttribute(String key, Object value, boolean first) {
        boolean quote = true;
        if (value instanceof Number) {
            quote = false;
        }
        return String.format("%s\"%s\"=%s%s%s", first ? "" : ",", key, quote ? "\"" : "", value, quote ? "\"" : "");
    }

    protected String outputAttributes(Element e) {
        if (e.getAttributeCount() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder("[");
        AtomicBoolean first = new AtomicBoolean(true);
        e.attributeKeys().forEach(key -> {
            boolean quote = true;
            Object value = e.getAttribute((String)key);
            if (value instanceof Number) {
                quote = false;
            }
            buffer.append(String.format("%s\"%s\"=%s%s%s", first.get() ? "" : ",", key, quote ? "\"" : "", value, quote ? "\"" : ""));
            first.set(false);
        });
        return buffer.append(']').toString();
    }

    protected static enum What {
        NODE,
        EDGE,
        OTHER;

    }
}

