/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph;

import java.io.IOException;
import org.graphstream.graph.Edge;
import org.graphstream.graph.EdgeFactory;
import org.graphstream.graph.EdgeRejectedException;
import org.graphstream.graph.Element;
import org.graphstream.graph.ElementNotFoundException;
import org.graphstream.graph.IdAlreadyInUseException;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.Structure;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.GraphParseException;
import org.graphstream.stream.Pipe;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSinkFactory;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceFactory;
import org.graphstream.ui.view.Viewer;

public interface Graph
extends Element,
Pipe,
Iterable<Node>,
Structure {
    public Node getNode(String var1);

    public Edge getEdge(String var1);

    public NodeFactory<? extends Node> nodeFactory();

    public EdgeFactory<? extends Edge> edgeFactory();

    public boolean isStrict();

    public boolean isAutoCreationEnabled();

    public double getStep();

    public void setNodeFactory(NodeFactory<? extends Node> var1);

    public void setEdgeFactory(EdgeFactory<? extends Edge> var1);

    public void setStrict(boolean var1);

    public void setAutoCreate(boolean var1);

    public void clear();

    public Node addNode(String var1) throws IdAlreadyInUseException;

    default public Edge addEdge(String id, String node1, String node2) throws IdAlreadyInUseException, ElementNotFoundException, EdgeRejectedException {
        return this.addEdge(id, node1, node2, false);
    }

    default public Edge addEdge(String id, String from, String to, boolean directed) throws IdAlreadyInUseException, ElementNotFoundException, EdgeRejectedException {
        Node src = this.getNode(from);
        Node dst = this.getNode(to);
        if (src == null || dst == null) {
            if (this.isStrict()) {
                throw new ElementNotFoundException("Node '%s'", src == null ? from : to);
            }
            if (!this.isAutoCreationEnabled()) {
                return null;
            }
            if (src == null) {
                src = this.addNode(from);
            }
            if (dst == null) {
                dst = this.addNode(to);
            }
        }
        return this.addEdge(id, src, dst, directed);
    }

    public void stepBegins(double var1);

    public Iterable<AttributeSink> attributeSinks();

    public Iterable<ElementSink> elementSinks();

    default public void read(String filename) throws IOException, GraphParseException, ElementNotFoundException {
        FileSource input = FileSourceFactory.sourceFor(filename);
        if (input == null) {
            throw new IOException("No source reader for " + filename);
        }
        input.addSink(this);
        this.read(input, filename);
        input.removeSink(this);
    }

    default public void read(FileSource input, String filename) throws IOException, GraphParseException {
        input.readAll(filename);
    }

    default public void write(String filename) throws IOException {
        FileSink output = FileSinkFactory.sinkFor(filename);
        if (output == null) {
            throw new IOException("No sink writer for " + filename);
        }
        this.write(output, filename);
    }

    default public void write(FileSink output, String filename) throws IOException {
        output.writeAll(this, filename);
    }

    public Viewer display();

    public Viewer display(boolean var1);

    public Node getNode(int var1) throws IndexOutOfBoundsException;

    public Edge getEdge(int var1) throws IndexOutOfBoundsException;

    default public Edge addEdge(String id, int index1, int index2) throws IndexOutOfBoundsException, IdAlreadyInUseException, EdgeRejectedException {
        return this.addEdge(id, this.getNode(index1), this.getNode(index2), false);
    }

    default public Edge addEdge(String id, int fromIndex, int toIndex, boolean directed) throws IndexOutOfBoundsException, IdAlreadyInUseException, EdgeRejectedException {
        return this.addEdge(id, this.getNode(fromIndex), this.getNode(toIndex), directed);
    }

    default public Edge addEdge(String id, Node node1, Node node2) throws IdAlreadyInUseException, EdgeRejectedException {
        return this.addEdge(id, node1, node2, false);
    }

    public Edge addEdge(String var1, Node var2, Node var3, boolean var4) throws IdAlreadyInUseException, EdgeRejectedException;

    default public Edge removeEdge(int index) throws IndexOutOfBoundsException {
        Edge edge = this.getEdge(index);
        if (edge == null) {
            if (this.isStrict()) {
                throw new ElementNotFoundException("Edge #" + index, new Object[0]);
            }
            return null;
        }
        return this.removeEdge(edge);
    }

    default public Edge removeEdge(int fromIndex, int toIndex) throws IndexOutOfBoundsException, ElementNotFoundException {
        Node fromNode = this.getNode(fromIndex);
        Node toNode = this.getNode(toIndex);
        if (fromNode == null || toNode == null) {
            if (this.isStrict()) {
                throw new ElementNotFoundException("Node #%d", fromNode == null ? fromIndex : toIndex);
            }
            return null;
        }
        return this.removeEdge(fromNode, toNode);
    }

    public Edge removeEdge(Node var1, Node var2) throws ElementNotFoundException;

    default public Edge removeEdge(String from, String to) throws ElementNotFoundException {
        Node fromNode = this.getNode(from);
        Node toNode = this.getNode(to);
        if (fromNode == null || toNode == null) {
            if (this.isStrict()) {
                throw new ElementNotFoundException("Node \"%s\"", fromNode == null ? from : to);
            }
            return null;
        }
        return this.removeEdge(fromNode, toNode);
    }

    default public Edge removeEdge(String id) throws ElementNotFoundException {
        Edge edge = this.getEdge(id);
        if (edge == null) {
            if (this.isStrict()) {
                throw new ElementNotFoundException("Edge \"" + id + "\"", new Object[0]);
            }
            return null;
        }
        return this.removeEdge(edge);
    }

    public Edge removeEdge(Edge var1);

    default public Node removeNode(int index) throws IndexOutOfBoundsException {
        Node node = this.getNode(index);
        if (node == null) {
            if (this.isStrict()) {
                throw new ElementNotFoundException("Node #" + index, new Object[0]);
            }
            return null;
        }
        return this.removeNode(node);
    }

    default public Node removeNode(String id) throws ElementNotFoundException {
        Node node = this.getNode(id);
        if (node == null) {
            if (this.isStrict()) {
                throw new ElementNotFoundException("Node \"" + id + "\"", new Object[0]);
            }
            return null;
        }
        return this.removeNode(node);
    }

    public Node removeNode(Node var1);
}

