/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public interface Element {
    public String getId();

    public int getIndex();

    public Object getAttribute(String var1);

    public Object getFirstAttributeOf(String ... var1);

    public <T> T getAttribute(String var1, Class<T> var2);

    public <T> T getFirstAttributeOf(Class<T> var1, String ... var2);

    default public CharSequence getLabel(String key) {
        return this.getAttribute(key, CharSequence.class);
    }

    default public double getNumber(String key) {
        Object o = this.getAttribute(key);
        if (o != null) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            if (o instanceof CharSequence) {
                try {
                    return Double.parseDouble(o.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return Double.NaN;
    }

    default public List<? extends Number> getVector(String key) {
        List l;
        Object o = this.getAttribute(key);
        if (o != null && o instanceof List && (l = (List)o).size() > 0 && l.get(0) instanceof Number) {
            return l;
        }
        return null;
    }

    default public Object[] getArray(String key) {
        return this.getAttribute(key, Object[].class);
    }

    default public Map<?, ?> getMap(String key) {
        Object o = this.getAttribute(key);
        if (o != null && o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    public boolean hasAttribute(String var1);

    public boolean hasAttribute(String var1, Class<?> var2);

    default public boolean hasLabel(String key) {
        return this.getAttribute(key, CharSequence.class) != null;
    }

    default public boolean hasNumber(String key) {
        if (this.getAttribute(key, Number.class) != null) {
            return true;
        }
        CharSequence o = this.getAttribute(key, CharSequence.class);
        if (o != null) {
            try {
                Double.parseDouble(o.toString());
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    default public boolean hasVector(String key) {
        List o = this.getAttribute(key, List.class);
        if (o != null && o.size() > 0) {
            return o.get(0) instanceof Number;
        }
        return false;
    }

    default public boolean hasArray(String key) {
        return this.getAttribute(key, Object[].class) != null;
    }

    default public boolean hasMap(String key) {
        Object o = this.getAttribute(key);
        return o != null && o instanceof Map;
    }

    public Stream<String> attributeKeys();

    public void clearAttributes();

    public void setAttribute(String var1, Object ... var2);

    default public void setAttributes(Map<String, Object> attributes) {
        attributes.forEach((string, object) -> this.setAttribute((String)string, object));
    }

    public void removeAttribute(String var1);

    public int getAttributeCount();
}

