/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.list;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.KeyStroke;
import org.oxbow.swingbits.list.CheckListEditor;
import org.oxbow.swingbits.list.CheckListFilterType;
import org.oxbow.swingbits.list.CheckListRenderer;
import org.oxbow.swingbits.list.DefaultCheckListModel;
import org.oxbow.swingbits.list.ICheckListModel;
import org.oxbow.swingbits.util.IObjectToStringTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckList<T> {
    private final JList list;
    private static final MouseAdapter checkBoxEditor = new CheckListEditor();

    private CheckList(JList jList) {
        if (jList == null) {
            throw new NullPointerException();
        }
        this.list = jList;
        this.list.getSelectionModel().setSelectionMode(0);
        if (!this.isEditorAttached()) {
            jList.addMouseListener(checkBoxEditor);
        }
        this.list.setCellRenderer(new CheckListRenderer());
        this.setupKeyboardActions(jList);
    }

    private void setupKeyboardActions(final JList jList) {
        String string = "toggle-check";
        jList.getInputMap().put(KeyStroke.getKeyStroke(32, 0), string);
        jList.getActionMap().put(string, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                CheckList.this.toggleIndex(jList.getSelectedIndex());
            }
        });
    }

    private boolean isEditorAttached() {
        for (MouseListener mouseListener : this.list.getMouseListeners()) {
            if (!(mouseListener instanceof CheckListEditor)) continue;
            return true;
        }
        return false;
    }

    public JList getList() {
        return this.list;
    }

    public void setData(Collection<T> collection) {
        this.setModel(new DefaultCheckListModel<T>(collection));
    }

    public void setModel(ICheckListModel<T> iCheckListModel) {
        this.list.setModel(iCheckListModel);
    }

    public ICheckListModel<T> getModel() {
        return (ICheckListModel)this.list.getModel();
    }

    public Collection<T> getCheckedItems() {
        return this.getModel().getCheckedItems();
    }

    public void setCheckedItems(Collection<T> collection) {
        this.getModel().setCheckedItems(collection);
    }

    public void filter(String string, IObjectToStringTranslator iObjectToStringTranslator, CheckListFilterType checkListFilterType) {
        this.getModel().filter(string, iObjectToStringTranslator, checkListFilterType);
    }

    public void toggleIndex(int n) {
        if (n >= 0 && n < this.list.getModel().getSize()) {
            ICheckListModel<T> iCheckListModel;
            iCheckListModel.setCheckedIndex(n, !(iCheckListModel = this.getModel()).isCheckedIndex(n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private JList list;

        public Builder(JList jList) {
            this.list = jList == null ? new JList() : jList;
        }

        public Builder() {
            this(null);
        }

        public <T> CheckList<T> build() {
            return new CheckList(this.list);
        }
    }
}

