/*
 * Decompiled with CFR 0.152.
 */
package org.geonames.wikipedia;

public class TextSummaryExtractor {
    public static String extractSummary(String string, int n) {
        return TextSummaryExtractor.extractSummary(string, n, true);
    }

    public static String extractSummary(String string, int n, boolean bl) {
        int n2;
        int n3;
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        while (n4 > -1 && (stringBuilder.length() < 50 + 2 * n || n == 0) && n4 < string.length()) {
            char c = string.charAt(n4);
            if (c == '{') {
                n3 = TextSummaryExtractor.skipTemplate(string, n4);
                if (string.toLowerCase().indexOf("{{audio") == n4 && (n2 = string.lastIndexOf("|", n3)) > -1) {
                    String string2 = string.substring(n2 + 1, n3 - 2).trim();
                    stringBuilder.append(string2);
                }
                if (string.toLowerCase().indexOf("{{formatnum") == n4 && (n2 = string.indexOf(":", n4)) > -1) {
                    int n5 = n3 - 2;
                    if (string.indexOf("|", n2) > -1) {
                        n5 = string.indexOf("|", n2);
                    }
                    String string3 = string.substring(n2 + 1, n5).trim();
                    stringBuilder.append(string3);
                }
                n4 = n3;
                continue;
            }
            if (c == '<') {
                if (string.length() > n4 + 1 && string.charAt(n4 + 1) == '!') {
                    n4 = TextSummaryExtractor.skipHTMLComment(string, n4);
                    continue;
                }
                n4 = TextSummaryExtractor.skipHTMLElement(string, n4);
                continue;
            }
            if (c == '[') {
                if (string.charAt(n4 + 1) == '[') {
                    n3 = string.indexOf("]]", n4);
                    n2 = string.indexOf(":", n4);
                    if (n2 > -1 && n2 < n3) {
                        n4 = TextSummaryExtractor.findEndOfLink(string, n4);
                        continue;
                    }
                    int n6 = string.indexOf("|", n4);
                    if (n6 > -1 && n6 < n3) {
                        n4 = n6 + 1;
                        continue;
                    }
                    n4 += 2;
                    continue;
                }
                n3 = string.indexOf("]", n4);
                if (n3 > -1) {
                    n4 = n3 + 1;
                    continue;
                }
            } else if (c == ']') {
                if (n4 + 1 < string.length() && string.charAt(n4 + 1) == ']') {
                    n4 += 2;
                    continue;
                }
            } else if (c == '=' && n4 + 1 < string.length() && string.charAt(n4 + 1) == '=') {
                n3 = string.indexOf("==", n4 + 2);
                if (n3 <= -1) continue;
                n4 = n3 + 2;
                continue;
            }
            stringBuilder.append(c);
            ++n4;
        }
        String string4 = TextSummaryExtractor.removeIndentAtBeginning(stringBuilder.toString());
        string4 = string4.replaceAll("\\([^\\w]*\\)", "");
        string4 = string4.replaceAll("\\([, ]*", "(");
        string4 = string4.replaceAll("[, ]*\\)", ")");
        string4 = TextSummaryExtractor.removeWhiteSpace(string4.replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ")).trim();
        string4 = TextSummaryExtractor.removeBold(string4);
        string4 = TextSummaryExtractor.removeItalic(string4);
        string4 = string4.replaceAll("&nbsp;", " ");
        string4 = string4.replaceAll("\\( ", "(");
        string4 = string4.replaceAll(" \\)", ")");
        n3 = string4.length();
        if (bl && (n2 = string4.indexOf("==")) > 10) {
            n3 = n2;
        }
        if ((n3 < 20 || n3 > n) && (double)(n3 = string4.lastIndexOf(".", n)) < 0.7 * (double)n) {
            n3 = string4.lastIndexOf(" ", n);
        }
        if (n3 > -1 && n3 < string4.length()) {
            string4 = string4.substring(0, n3) + " (...)";
        }
        return string4.trim();
    }

    static int skipTemplate(String string, int n) {
        int n2;
        if (string.charAt(n) != '{') {
            return n;
        }
        int n3 = 1;
        for (n2 = n + 1; n3 > 0 && string.length() > n2; ++n2) {
            if (string.charAt(n2) == '{') {
                ++n3;
                continue;
            }
            if (string.charAt(n2) != '}') continue;
            --n3;
        }
        return n2;
    }

    static int skipHTMLElement(String string, int n) {
        int n2;
        if (string.charAt(n) != '<') {
            return n;
        }
        int n3 = 1;
        for (n2 = n + 1; n3 > 0 && string.length() > n2; ++n2) {
            if (string.charAt(n2) == '<') {
                ++n3;
                continue;
            }
            if (string.charAt(n2) != '>') continue;
            --n3;
        }
        return n2;
    }

    static int skipHTMLComment(String string, int n) {
        if (string.charAt(n) != '<' && string.charAt(n + 1) != '!') {
            return n;
        }
        int n2 = n;
        while ((n2 = string.indexOf(45, n2)) > -1) {
            if (string.length() < n2 + 2) {
                return string.length();
            }
            if (string.charAt(n2) == '-' && string.charAt(n2 + 1) == '-' && string.charAt(n2 + 2) == '>') {
                return n2 + 3;
            }
            ++n2;
        }
        return n2;
    }

    private static String removeIndentAtBeginning(String string) {
        if ((string = string.trim()).startsWith(":")) {
            int n;
            int n2 = string.indexOf("\n");
            if (n2 > -1) {
                string = string.substring(n2 + 1);
            } else if (string.startsWith(":''") && (n = string.indexOf("''", 3)) > -1) {
                string = string.substring(n + 2);
            }
        }
        return string;
    }

    private static int findEndOfLink(String string, int n) {
        int n2 = string.indexOf("]]", n);
        if (n2 == -1) {
            return n;
        }
        int n3 = n;
        int n4 = string.indexOf("[[", n3 + 2);
        while (n4 > -1 && n4 < n2) {
            n3 = n2;
            n2 = string.indexOf("]]", n2 + 2);
            n4 = string.indexOf("[[", n3);
        }
        if (n2 != -1) {
            n3 = n2;
        }
        return n3;
    }

    public static String removeWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ') {
                if (n == 0) {
                    stringBuffer.append(cArray[i]);
                }
                ++n;
                continue;
            }
            stringBuffer.append(cArray[i]);
            n = 0;
        }
        return stringBuffer.toString();
    }

    public static String removeBold(String string) {
        return string.replaceAll("'''", "");
    }

    public static String removeItalic(String string) {
        return string.replaceAll("''", "");
    }
}

