/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree.output;

import ancestris.report.svgtree.IndiBox;
import ancestris.report.svgtree.filter.TreeFilter;
import ancestris.report.svgtree.filter.TreeFilterBase;
import java.util.HashMap;
import java.util.Map;

public class AlignChildren
implements TreeFilter {
    private final Map<IndiBox, Integer> parentLevels = new HashMap<IndiBox, Integer>();
    private final Map<Integer, Integer> genLevels = new HashMap<Integer, Integer>();

    public AlignChildren() {
        this.parentLevels.clear();
    }

    @Override
    public void filter(IndiBox indibox) {
        int maxGen = this.resetValues(indibox);
        for (int gen = 0; gen <= maxGen; ++gen) {
            if (!this.fixGen(gen)) continue;
            this.resetValues(indibox);
        }
        if (!this.genLevels.isEmpty() && maxGen > 0) {
            indibox.hMinus = -this.genLevels.get(maxGen).intValue();
        }
    }

    private int resetValues(IndiBox indibox) {
        int ret = 0;
        this.parentLevels.clear();
        this.genLevels.clear();
        new DetermineParentLevels().filter(indibox);
        for (IndiBox indib : this.parentLevels.keySet()) {
            if (indib.gen > ret) {
                ret = indib.gen;
            }
            Integer level = this.parentLevels.get(indib);
            Integer minLevel = this.genLevels.get(indib.gen);
            if (minLevel == null) {
                minLevel = Integer.MAX_VALUE;
            }
            if (level >= minLevel) continue;
            this.genLevels.put(indib.gen, level);
        }
        return ret;
    }

    private boolean fixGen(int gen) {
        boolean ret = false;
        for (IndiBox indib : this.parentLevels.keySet()) {
            Integer minLevel;
            int level;
            if (indib.gen != gen || (level = this.parentLevels.get(indib).intValue()) <= (minLevel = this.genLevels.get(indib.gen))) continue;
            ret = true;
            int diff = minLevel - level;
            indib.y += diff;
            indib.hPlus -= diff;
        }
        return ret;
    }

    private class DetermineParentLevels
    extends TreeFilterBase {
        private int level = 0;

        private DetermineParentLevels() {
        }

        @Override
        protected void preFilter(IndiBox indibox) {
            if (indibox.prev != null) {
                this.level += indibox.y;
            }
            if (indibox.getDir().equals((Object)IndiBox.Direction.PARENT)) {
                AlignChildren.this.parentLevels.put(indibox, this.level);
            }
        }

        @Override
        protected void postFilter(IndiBox indibox) {
            if (indibox.prev != null) {
                this.level -= indibox.y;
            }
        }
    }
}

