/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.RepositoryMatcherOptions;
import ancestris.util.GedcomUtilities;
import genj.gedcom.Property;
import genj.gedcom.Repository;
import genj.gedcom.TagPath;
import java.util.ArrayList;
import java.util.HashSet;

public class RepositoryMatcher
extends EntityMatcher<Repository, RepositoryMatcherOptions> {
    private static final int[] points = new int[]{-100, -50, 0, 50, 100};

    public RepositoryMatcher() {
        this.options = new RepositoryMatcherOptions();
    }

    @Override
    public int compare(Repository left, Repository right) {
        int itemScore = 0;
        int score = 0;
        int sumOfWeights = 0;
        itemScore = COMPARE_UNKNOWN;
        String leftName = GedcomUtilities.normalizeString((String)left.getRepositoryName());
        String rightName = GedcomUtilities.normalizeString((String)right.getRepositoryName());
        if (!leftName.isBlank() && !rightName.isBlank()) {
            ++sumOfWeights;
            itemScore = leftName.equals(rightName) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftName, (String)rightName, (int)3));
        }
        score += points[itemScore];
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("REPO:ADDR");
        fields.add("REPO:ADDR:CITY");
        fields.add("REPO:ADDR:POST");
        fields.add("REPO:ADDR:CTRY");
        fields.add("REPO:PHON");
        fields.add("REPO:EMAIL");
        fields.add("REPO:WWW");
        for (String tag : fields) {
            String leftValue = this.getProp(left, tag);
            String rightValue = this.getProp(right, tag);
            itemScore = COMPARE_UNKNOWN;
            if (!leftValue.isBlank() && !rightValue.isBlank()) {
                ++sumOfWeights;
                itemScore = leftValue.equals(rightValue) ? COMPARE_SURE_SAME : this.getLevel(GedcomUtilities.similarity((String)leftValue, (String)rightValue, (int)3));
            }
            score += points[itemScore];
        }
        return score / sumOfWeights;
    }

    @Override
    public String[] getKeys(Repository entity) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(RepositoryMatcher.getKeyWords(entity.getRepositoryName(), 3));
        String city = this.getProp(entity, "REPO:ADDR:CITY");
        if (!city.isBlank()) {
            keys.add(city);
        }
        return (String[])keys.toArray(String[]::new);
    }

    private String getProp(Repository repo, String tag) {
        String value;
        Property p = repo.getProperty(new TagPath(tag));
        if (p != null && !(value = GedcomUtilities.normalizeString((String)p.getValue())).isBlank()) {
            return value;
        }
        return "";
    }

    @Override
    public String getHexaKey(Repository entity) {
        return "00";
    }

    @Override
    public void reset() {
    }
}

