# Copyright 1999-2022 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7
GNOME_ORG_MODULE="gnome-2048"

inherit gnome.org gnome2-utils meson vala xdg

DESCRIPTION="Move the tiles until you obtain the 2048 tile"
HOMEPAGE="https://wiki.gnome.org/Apps/2048"

LICENSE="GPL-3+"
SLOT="0"
KEYWORDS="amd64"
IUSE=""

RDEPEND="
	>=dev-libs/glib-2.42.0:2
	>=x11-libs/gtk+-3.24.0:3
	>=media-libs/clutter-1.12.0:1.0
	>=media-libs/clutter-gtk-1.6.0:1.0
	>=dev-libs/libgee-0.14.0:0.8
	>=dev-libs/libgnome-games-support-1.7.1:1=
"
DEPEND="${RDEPEND}"
BDEPEND="
	dev-libs/libxml2:2
	dev-util/itstool
	>=sys-devel/gettext-0.19.8
	virtual/pkgconfig
	$(vala_depend)
"

PATCHES=(
	"${FILESDIR}"/${PN}-3.38.2-meson-0.61.patch
)

src_prepare() {
	xdg_src_prepare
	vala_src_prepare
}

pkg_postinst() {
	xdg_pkg_postinst
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_pkg_postrm
	gnome2_schemas_update
}
