# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999

CABAL_FEATURES="lib profile haddock hoogle hscolour"
inherit haskell-cabal

DESCRIPTION="A simple and intuitive library for automated testing"
HOMEPAGE="https://github.com/typeclasses/chell"

LICENSE="MIT"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="+color-output"

CABAL_CHDEPS=(
	'base ^>= 4.16 || ^>= 4.17 || ^>= 4.18' 'base >= 4.14 && < 5'
	'bytestring ^>= 0.11.4 || ^>= 0.12' 'bytestring >= 0.10'
	'template-haskell ^>=2.18 || ^>= 2.19 || ^>= 2.20' 'template-haskell >= 2.16'
	'text ^>= 1.2.5 || ^>= 2.0' 'text >= 1.2'
	'transformers ^>= 0.5.6 || ^>= 0.6' 'transformers >= 0.5.6'
)

RDEPEND="
	>=dev-haskell/options-1.2.1:=[profile?] <dev-haskell/options-1.3:=[profile?]
	>=dev-haskell/patience-0.3:=[profile?] <dev-haskell/patience-0.4:=[profile?]
	>=dev-haskell/random-1.2.1:=[profile?] <dev-haskell/random-1.3:=[profile?]
	>=dev-haskell/text-1.2:=[profile?]
	>=dev-lang/ghc-8.10.6:=
	color-output? (
		>=dev-haskell/ansi-terminal-1.0:=[profile?] <dev-haskell/ansi-terminal-1.1:=[profile?]
	)
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.2.1.0
"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag color-output color-output)
}
