# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.2.0.9999
#hackport: flags: +small_base

CABAL_FEATURES="test-suite"
inherit haskell-cabal

DESCRIPTION="Alex is a tool for generating lexical analysers in Haskell"
HOMEPAGE="https://www.haskell.org/alex/"

GIT_REPO="https://github.com/haskell/${PN}"
GIT_COMMIT="13732056ff8d287f2ee0c4ecb968efe04516c890"
GIT_P="${PN}-${GIT_COMMIT}"
GIT_S="${WORKDIR}/${GIT_P}"
SRC_URI+=" doc? (
	${GIT_REPO}/archive/${GIT_COMMIT}.tar.gz -> ${GIT_P}.tar.gz
)"

LICENSE="BSD"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="doc"

RDEPEND=">=dev-lang/ghc-8.8.1:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.0.0.0
	doc? (
		dev-python/sphinx
		dev-python/sphinx-rtd-theme
	)
"
src_prepare() {
	if use doc; then
		cp -a "${GIT_S}/doc/" "${S}" || die
		eapply "${FILESDIR}/${PN}-3.2.7.2-fix-docs.patch"
	fi

	haskell-cabal_src_prepare
}

src_configure() {
	# make sure we don't accidentally use those
	# installed in system
	haskell-cabal_src_configure \
		--with-alex=false \
		--with-happy=false \
		--flag=small_base
}

src_compile() {
	haskell-cabal_src_compile

	if use doc; then
		emake -C "${S}/doc/" -j1
	fi
}

src_test() {
	# 1. workaround Setup.hs deadlock: https://github.com/haskell/cabal/issues/2398
	# 2. use freshly built ALEX= binary and datadir path
	alex_datadir="${S}"/data \
	emake -k -C tests all ALEX="${S}"/dist/build/alex/alex
}

src_install() {
	haskell-cabal_src_install

	if use doc; then
		dodoc -r "${S}/doc/_build/html"
	fi
}
