/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class QNameFn
extends SystemFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        try {
            XPathContext early = visitor.getStaticContext().makeEarlyEvaluationContext();
            Item item1 = this.argument[1].evaluateItem(early);
            String lex = item1.getStringValue();
            Item item0 = this.argument[0].evaluateItem(early);
            String uri = item0 == null ? "" : item0.getStringValue();
            NameChecker checker = visitor.getConfiguration().getNameChecker();
            String[] parts = checker.getQNameParts(lex);
            if (parts[0].length() != 0 && !checker.isValidNCName(parts[0])) {
                XPathException err = new XPathException("Malformed prefix in QName: '" + parts[0] + '\'');
                err.setErrorCode("FOCA0002");
                throw err;
            }
            return Literal.makeLiteral(new QNameValue(parts[0], uri, parts[1], BuiltInAtomicType.QNAME, checker));
        }
        catch (QNameException e) {
            XPathException err = new XPathException(e.getMessage(), this);
            err.setErrorCode("FOCA0002");
            err.setLocator(this);
            throw err;
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(context);
        String uri = arg0 == null ? null : arg0.getStringValue();
        try {
            String lex = this.argument[1].evaluateItem(context).getStringValue();
            NameChecker checker = context.getConfiguration().getNameChecker();
            String[] parts = checker.getQNameParts(lex);
            if (parts[0].length() != 0 && !checker.isValidNCName(parts[0])) {
                XPathException err = new XPathException("Malformed prefix in QName: '" + parts[0] + '\'');
                err.setErrorCode("FORG0001");
                throw err;
            }
            return new QNameValue(parts[0], uri, parts[1], BuiltInAtomicType.QNAME, checker);
        }
        catch (QNameException e) {
            this.dynamicError(e.getMessage(), "FOCA0002", context);
            return null;
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }
}

