/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lv extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Griničas laiks",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apijas ziemas laiks",
               "",
               "Apijas vasaras laiks",
               "",
               "Apijas laiks",
               "",
            };
        final String[] Cook = new String[] {
               "Kuka salu ziemas laiks",
               "",
               "Kuka salu vasaras laiks",
               "",
               "Kuka salu laiks",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubas ziemas laiks",
               "CST",
               "Kubas vasaras laiks",
               "CDT",
               "Kubas laiks",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fidži ziemas laiks",
               "",
               "Fidži vasaras laiks",
               "",
               "Fidži laiks",
               "",
            };
        final String[] Gulf = new String[] {
               "Persijas līča laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovdas ziemas laiks",
               "",
               "Hovdas vasaras laiks",
               "",
               "Hovdas laiks",
               "",
            };
        final String[] Iran = new String[] {
               "Irānas ziemas laiks",
               "",
               "Irānas vasaras laiks",
               "",
               "Irānas laiks",
               "",
            };
        final String[] Niue = new String[] {
               "Niues laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omskas ziemas laiks",
               "",
               "Omskas vasaras laiks",
               "",
               "Omskas laiks",
               "",
            };
        final String[] Peru = new String[] {
               "Peru ziemas laiks",
               "",
               "Peru vasaras laiks",
               "",
               "Peru laiks",
               "",
            };
        final String[] Truk = new String[] {
               "Čūkas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Veika salas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Čīles ziemas laiks",
               "",
               "Čīles vasaras laiks",
               "",
               "Čīles laiks",
               "",
            };
        final String[] China = new String[] {
               "Ķīnas ziemas laiks",
               "CST",
               "Ķīnas vasaras laiks",
               "CDT",
               "Ķīnas laiks",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosu (Kīlinga) salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Deivisas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indijas ziemas laiks",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japānas ziemas laiks",
               "JST",
               "Japānas vasaras laiks",
               "JDT",
               "Japānas laiks",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korejas ziemas laiks",
               "KST",
               "Korejas vasaras laiks",
               "KST",
               "Korejas laiks",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepālas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa ziemas laiks",
               "SST",
               "Samoa vasaras laiks",
               "SST",
               "Samoa laiks",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Šovas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongas ziemas laiks",
               "",
               "Tongas vasaras laiks",
               "",
               "Tongas laiks",
               "",
            };
        final String[] Yukon = new String[] {
               "Jukonas laiks",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Aļaskas ziemas laiks",
               "AKST",
               "Aļaskas vasaras laiks",
               "AKDT",
               "Aļaskas laiks",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazones ziemas laiks",
               "",
               "Amazones vasaras laiks",
               "",
               "Amazones laiks",
               "",
            };
        final String[] Azores = new String[] {
               "Azoru salu ziemas laiks",
               "",
               "Azoru salu vasaras laiks",
               "",
               "Azoru salu laiks",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butānas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunejas Darusalamas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Lieldienu salas ziemas laiks",
               "",
               "Lieldienu salas vasaras laiks",
               "",
               "Lieldienu salas laiks",
               "",
            };
        final String[] Guyana = new String[] {
               "Gajānas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Havaju–Aleutu ziemas laiks",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Izraēlas ziemas laiks",
               "IST",
               "Izraēlas vasaras laiks",
               "IDT",
               "Izraēlas laiks",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mosonas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Maskavas ziemas laiks",
               "MSK",
               "Maskavas vasaras laiks",
               "MSK",
               "Maskavas laiks",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponapē laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samaras ziemas laiks",
               "",
               "Samaras vasaras laiks",
               "",
               "Samaras laiks",
               "",
            };
        final String[] Tahiti = new String[] {
               "Taiti laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taibei ziemas laiks",
               "CST",
               "Taibei vasaras laiks",
               "CDT",
               "Taibei laiks",
               "CT",
            };
        final String[] Turkey = new String[] {
               "Turcijas ziemas laiks",
               "",
               "Turcijas vasaras laiks",
               "",
               "Turcijas laiks",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostokas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Volisas un Futunas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arābijas pussalas ziemas laiks",
               "",
               "Arābijas pussalas vasaras laiks",
               "",
               "Arābijas pussalas laiks",
               "",
            };
        final String[] Armenia = new String[] {
               "Armēnijas ziemas laiks",
               "",
               "Armēnijas vasaras laiks",
               "",
               "Armēnijas laiks",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolīvijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Četemas ziemas laiks",
               "",
               "Četemas vasaras laiks",
               "",
               "Četemas laiks",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Universālais koordinētais laiks",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvadoras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambjē salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruzijas ziemas laiks",
               "",
               "Gruzijas vasaras laiks",
               "",
               "Gruzijas laiks",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskas ziemas laiks",
               "",
               "Irkutskas vasaras laiks",
               "",
               "Irkutskas laiks",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadanas ziemas laiks",
               "",
               "Magadanas vasaras laiks",
               "",
               "Magadanas laiks",
               "",
            };
        final String[] Myanmar = new String[] {
               "Mjanmas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkas salas ziemas laiks",
               "",
               "Norfolkas salas vasaras laiks",
               "",
               "Norfolkas salas laiks",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernandu di Noroņas ziemas laiks",
               "",
               "Fernandu di Noroņas vasaras laiks",
               "",
               "Fernandu di Noroņas laiks",
               "",
            };
        final String[] Reunion = new String[] {
               "Reinjonas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Roteras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Zālamana salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvajas ziemas laiks",
               "",
               "Urugvajas vasaras laiks",
               "",
               "Urugvajas laiks",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu ziemas laiks",
               "",
               "Vanuatu vasaras laiks",
               "",
               "Vanuatu laiks",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutskas ziemas laiks",
               "",
               "Jakutskas vasaras laiks",
               "",
               "Jakutskas laiks",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantijas ziemas laiks",
               "AST",
               "Atlantijas vasaras laiks",
               "AST",
               "Atlantijas laiks",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brazīlijas ziemas laiks",
               "",
               "Brazīlijas vasaras laiks",
               "",
               "Brazīlijas laiks",
               "",
            };
        final String[] Chamorro = new String[] {
               "Čamorra ziemas laiks",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbijas ziemas laiks",
               "",
               "Kolumbijas vasaras laiks",
               "",
               "Kolumbijas laiks",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklenda (Malvinu) salu ziemas laiks",
               "",
               "Folklenda (Malvinu) salu vasaras laiks",
               "",
               "Folklenda (Malvinu) salu laiks",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaizijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldīvijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulanbatoras ziemas laiks",
               "",
               "Ulanbatoras vasaras laiks",
               "",
               "Ulanbatoras laiks",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistānas ziemas laiks",
               "PKT",
               "Pakistānas vasaras laiks",
               "PKST",
               "Pakistānas laiks",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paragvajas ziemas laiks",
               "",
               "Paragvajas vasaras laiks",
               "",
               "Paragvajas laiks",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkērnas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentīnas ziemas laiks",
               "",
               "Argentīnas vasaras laiks",
               "",
               "Argentīnas laiks",
               "",
            };
        final String[] Christmas = new String[] {
               "Ziemsvētku salas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Honkongas ziemas laiks",
               "HKT",
               "Honkongas vasaras laiks",
               "HKST",
               "Honkongas laiks",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indoķīnas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovskas-Kamčatskas ziemas laiks",
               "",
               "Petropavlovskas-Kamčatskas vasaras laiks",
               "",
               "Petropavlovskas-Kamčatskas laiks",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgizstānas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lorda Hava salas ziemas laiks",
               "",
               "Lorda Hava salas vasaras laiks",
               "",
               "Lorda Hava salas laiks",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marķīza salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Maurīcijas ziemas laiks",
               "",
               "Maurīcijas vasaras laiks",
               "",
               "Maurīcijas laiks",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapūras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venecuēlas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbaidžānas ziemas laiks",
               "",
               "Azerbaidžānas vasaras laiks",
               "",
               "Azerbaidžānas laiks",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladešas ziemas laiks",
               "",
               "Bangladešas vasaras laiks",
               "",
               "Bangladešas laiks",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kaboverdes ziemas laiks",
               "",
               "Kaboverdes vasaras laiks",
               "",
               "Kaboverdes laiks",
               "",
            };
        final String[] East_Timor = new String[] {
               "Austrumtimoras laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Kazahstānas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seišeļu salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadžikistānas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekistānas ziemas laiks",
               "",
               "Uzbekistānas vasaras laiks",
               "",
               "Uzbekistānas laiks",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganistānas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarskas ziemas laiks",
               "",
               "Krasnojarskas vasaras laiks",
               "",
               "Krasnojarskas laiks",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Jaunzēlandes ziemas laiks",
               "NZST",
               "Jaunzēlandes vasaras laiks",
               "NZDT",
               "Jaunzēlandes laiks",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Filipīnu ziemas laiks",
               "PST",
               "Filipīnu vasaras laiks",
               "PDT",
               "Filipīnu laiks",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokas ziemas laiks",
               "",
               "Vladivostokas vasaras laiks",
               "",
               "Vladivostokas laiks",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indijas okeāna laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Lainas salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ņūfaundlendas ziemas laiks",
               "NST",
               "Ņūfaundlendas vasaras laiks",
               "NDT",
               "Ņūfaundlendas laiks",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistānas ziemas laiks",
               "",
               "Turkmenistānas vasaras laiks",
               "",
               "Turkmenistānas laiks",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francijas Gviānas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Jaunkaledonijas ziemas laiks",
               "",
               "Jaunkaledonijas vasaras laiks",
               "",
               "Jaunkaledonijas laiks",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Dienviddžordžijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgas ziemas laiks",
               "",
               "Jekaterinburgas vasaras laiks",
               "",
               "Jekaterinburgas laiks",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Centrālāfrikas laiks",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Austrumāfrikas laiks",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Rietumāfrikas laiks",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dimondirvilas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Centrāleiropas ziemas laiks",
               "CET",
               "Centrāleiropas vasaras laiks",
               "CEST",
               "Centrāleiropas laiks",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Austrumeiropas ziemas laiks",
               "EET",
               "Austrumeiropas vasaras laiks",
               "EEST",
               "Austrumeiropas laiks",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Rietumeiropas ziemas laiks",
               "WET",
               "Rietumeiropas vasaras laiks",
               "WEST",
               "Rietumeiropas laiks",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksikas Klusā okeāna piekrastes ziemas laiks",
               "MST",
               "Meksikas Klusā okeāna piekrastes vasaras laiks",
               "MDT",
               "Meksikas Klusā okeāna piekrastes laiks",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Dienvidāfrikas ziemas laiks",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Centrālais ziemas laiks",
               "CST",
               "Centrālais vasaras laiks",
               "CDT",
               "Centrālais laiks",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Austrumu ziemas laiks",
               "EST",
               "Austrumu vasaras laiks",
               "EST",
               "Austrumu laiks",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Klusā okeāna ziemas laiks",
               "PST",
               "Klusā okeāna vasaras laiks",
               "PDT",
               "Klusā okeāna laiks",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Francijas Dienvidjūru un Antarktikas teritorijas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilberta salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havaju–Aleutu ziemas laiks",
               "HST",
               "Havaju–Aleutu vasaras laiks",
               "HDT",
               "Havaju–Aleutu laiks",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Fēniksa salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Senpjēras un Mikelonas ziemas laiks",
               "",
               "Senpjēras un Mikelonas vasaras laiks",
               "",
               "Senpjēras un Mikelonas laiks",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Kalnu ziemas laiks",
               "MST",
               "Kalnu vasaras laiks",
               "MST",
               "Kalnu laiks",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Māršala salu laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Jaungvinejas laiks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Austrālijas centrālais ziemas laiks",
               "ACST",
               "Austrālijas centrālais vasaras laiks",
               "ACDT",
               "Austrālijas centrālais laiks",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Austrālijas austrumu ziemas laiks",
               "AEST",
               "Austrālijas austrumu vasaras laiks",
               "AEDT",
               "Austrālijas austrumu laiks",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Austrālijas rietumu ziemas laiks",
               "AWST",
               "Austrālijas rietumu vasaras laiks",
               "AWDT",
               "Austrālijas rietumu laiks",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Centrālindonēzijas laiks",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Austrumindonēzijas laiks",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Rietumindonēzijas laiks",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Austrālijas centrālais rietumu ziemas laiks",
               "",
               "Austrālijas centrālais rietumu vasaras laiks",
               "",
               "Austrālijas centrālais rietumu laiks",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Lielbritānijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Universālais koordinētais laiks",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Īrijas ziemas laiks",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Universālais koordinētais laiks",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Universālais koordinētais laiks",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Lielbritānijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Universālais koordinētais laiks",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Universālais koordinētais laiks",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Universālais koordinētais laiks",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Īrijas ziemas laiks",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Lielbritānijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Lielbritānijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Lielbritānijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Lielbritānijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Griničas laiks",
                    "GMT",
                    "Lielbritānijas vasaras laiks",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Adena" },
            { "timezone.excity.Asia/Hovd", "Hovda" },
            { "timezone.excity.Asia/Omsk", "Omska" },
            { "timezone.excity.Asia/Oral", "Orala" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ammāna" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Čita" },
            { "timezone.excity.Asia/Dhaka", "Daka" },
            { "timezone.excity.Asia/Dubai", "Dubaija" },
            { "timezone.excity.Asia/Kabul", "Kabula" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Katara" },
            { "timezone.excity.Asia/Seoul", "Seula" },
            { "timezone.excity.Asia/Tokyo", "Tokija" },
            { "timezone.excity.Asia/Tomsk", "Tomska" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Džūba" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Anadyr", "Anadira" },
            { "timezone.excity.Asia/Aqtobe", "Aktebe" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "timezone.excity.Asia/Beirut", "Beirūta" },
            { "timezone.excity.Asia/Brunei", "Bruneja" },
            { "timezone.excity.Asia/Hebron", "Hebrona" },
            { "timezone.excity.Asia/Kuwait", "Kuveita" },
            { "timezone.excity.Asia/Muscat", "Maskata" },
            { "timezone.excity.Asia/Riyadh", "Rijāda" },
            { "timezone.excity.Asia/Saigon", "Hošimina" },
            { "timezone.excity.Asia/Taipei", "Taibei" },
            { "timezone.excity.Asia/Tehran", "Teherāna" },
            { "timezone.excity.Asia/Urumqi", "Urumči" },
            { "timezone.excity.Etc/Unknown", "nezināma pilsēta" },
            { "timezone.excity.Europe/Kiev", "Kijeva" },
            { "timezone.excity.Europe/Riga", "Rīga" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mae" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akra" },
            { "timezone.excity.Africa/Cairo", "Kaira" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "timezone.excity.Africa/Dakar", "Dakara" },
            { "timezone.excity.Africa/Lagos", "Lagosa" },
            { "timezone.excity.Africa/Tunis", "Tunisa" },
            { "timezone.excity.America/Adak", "Adaka" },
            { "timezone.excity.America/Nome", "Noma" },
            { "timezone.excity.Asia/Baghdad", "Bagdāde" },
            { "timezone.excity.Asia/Bahrain", "Bahreina" },
            { "timezone.excity.Asia/Bangkok", "Bangkoka" },
            { "timezone.excity.Asia/Barnaul", "Barnaula" },
            { "timezone.excity.Asia/Bishkek", "Biškeka" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Irkutsk", "Irkutska" },
            { "timezone.excity.Asia/Jakarta", "Džakarta" },
            { "timezone.excity.Asia/Karachi", "Karāči" },
            { "timezone.excity.Asia/Kuching", "Kučina" },
            { "timezone.excity.Asia/Magadan", "Magadana" },
            { "timezone.excity.Asia/Nicosia", "Nikosija" },
            { "timezone.excity.Asia/Rangoon", "Ranguna" },
            { "timezone.excity.Asia/Yakutsk", "Jakutska" },
            { "timezone.excity.Asia/Yerevan", "Erevāna" },
            { "timezone.excity.Europe/Kirov", "Kirova" },
            { "timezone.excity.Europe/Minsk", "Minska" },
            { "timezone.excity.Europe/Paris", "Parīze" },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "timezone.excity.Europe/Vaduz", "Vaduca" },
            { "timezone.excity.Indian/Cocos", "Kokosu (Kīlinga) sala" },
            { "timezone.excity.Pacific/Apia", "Apija" },
            { "timezone.excity.Pacific/Fiji", "Fidži" },
            { "timezone.excity.Pacific/Guam", "Guama" },
            { "timezone.excity.Pacific/Truk", "Čūka" },
            { "timezone.excity.Pacific/Wake", "Veika sala" },
            { "timezone.excity.Africa/Bangui", "Bangi" },
            { "timezone.excity.Africa/Banjul", "Bandžula" },
            { "timezone.excity.Africa/Bissau", "Bisava" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.Africa/Maputo", "Maputu" },
            { "timezone.excity.Africa/Niamey", "Niameja" },
            { "timezone.excity.America/Bahia", "Baija" },
            { "timezone.excity.America/Belem", "Belena" },
            { "timezone.excity.America/Boise", "Boisisitija" },
            { "timezone.excity.America/Jujuy", "Huhuja" },
            { "timezone.excity.America/Thule", "Tule" },
            { "timezone.excity.Asia/Ashgabat", "Ašgabata" },
            { "timezone.excity.Asia/Calcutta", "Kalkāta" },
            { "timezone.excity.Asia/Damascus", "Damaska" },
            { "timezone.excity.Asia/Dushanbe", "Dušanbe" },
            { "timezone.excity.Asia/Jayapura", "Džajapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Makassar", "Makasara" },
            { "timezone.excity.Asia/Qostanay", "Kostanaja" },
            { "timezone.excity.Asia/Sakhalin", "Sahalīna" },
            { "timezone.excity.Asia/Shanghai", "Šanhaja" },
            { "timezone.excity.Asia/Tashkent", "Taškenta" },
            { "timezone.excity.Asia/Ust-Nera", "Ustjņera" },
            { "timezone.excity.Europe/Athens", "Atēnas" },
            { "timezone.excity.Europe/Berlin", "Berlīne" },
            { "timezone.excity.Europe/Dublin", "Dublina" },
            { "timezone.excity.Europe/Jersey", "Džērsija" },
            { "timezone.excity.Europe/Lisbon", "Lisabona" },
            { "timezone.excity.Europe/London", "Londona" },
            { "timezone.excity.Europe/Madrid", "Madride" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Maskava" },
            { "timezone.excity.Europe/Prague", "Prāga" },
            { "timezone.excity.Europe/Tirane", "Tirāna" },
            { "timezone.excity.Europe/Vienna", "Vīne" },
            { "timezone.excity.Europe/Warsaw", "Varšava" },
            { "timezone.excity.Europe/Zagreb", "Zagreba" },
            { "timezone.excity.Europe/Zurich", "Cīrihe" },
            { "timezone.excity.Indian/Chagos", "Čagosa" },
            { "timezone.excity.Indian/Comoro", "Komoras" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abidžana" },
            { "timezone.excity.Africa/Algiers", "Alžīra" },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Africa/Tripoli", "Tripole" },
            { "timezone.excity.America/Belize", "Beliza" },
            { "timezone.excity.America/Cancun", "Kankuna" },
            { "timezone.excity.America/Cayman", "Kaimanu salas" },
            { "timezone.excity.America/Cuiaba", "Kujaba" },
            { "timezone.excity.America/Dawson", "Dousona" },
            { "timezone.excity.America/Denver", "Denvera" },
            { "timezone.excity.America/Guyana", "Gajāna" },
            { "timezone.excity.America/Inuvik", "Inuvika" },
            { "timezone.excity.America/Juneau", "Džuno" },
            { "timezone.excity.America/La_Paz", "Lapasa" },
            { "timezone.excity.America/Maceio", "Masejo" },
            { "timezone.excity.America/Manaus", "Manausa" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.America/Nassau", "Naso" },
            { "timezone.excity.America/Recife", "Resifi" },
            { "timezone.excity.America/Regina", "Ridžaina" },
            { "timezone.excity.Asia/Hong_Kong", "Honkonga" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzaleme" },
            { "timezone.excity.Asia/Kamchatka", "Kamčatka" },
            { "timezone.excity.Asia/Pontianak", "Pontianaka" },
            { "timezone.excity.Asia/Pyongyang", "Phenjana" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Samarkand", "Samarkanda" },
            { "timezone.excity.Asia/Singapore", "Singapūra" },
            { "timezone.excity.Asia/Vientiane", "Vjenčana" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Saratov", "Saratova" },
            { "timezone.excity.Europe/Tallinn", "Tallina" },
            { "timezone.excity.Europe/Vatican", "Vatikāns" },
            { "timezone.excity.Europe/Vilnius", "Viļņa" },
            { "timezone.excity.Indian/Mayotte", "Majota" },
            { "timezone.excity.Indian/Reunion", "Reinjona" },
            { "timezone.excity.Pacific/Easter", "Lieldienu sala" },
            { "timezone.excity.Pacific/Kosrae", "Kosraja" },
            { "timezone.excity.Pacific/Majuro", "Madžuro" },
            { "timezone.excity.Pacific/Midway", "Midvejs" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Pacific/Ponape", "Ponpeja" },
            { "timezone.excity.Pacific/Saipan", "Saipana" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.Pacific/Tarawa", "Tarava" },
            { "timezone.excity.Pacific/Wallis", "Volisa" },
            { "timezone.excity.Africa/Blantyre", "Blantaira" },
            { "timezone.excity.Africa/Djibouti", "Džibutija" },
            { "timezone.excity.Africa/El_Aaiun", "Ajūna" },
            { "timezone.excity.Africa/Freetown", "Frītauna" },
            { "timezone.excity.Africa/Khartoum", "Hartūma" },
            { "timezone.excity.Africa/Kinshasa", "Kinšasa" },
            { "timezone.excity.Africa/Monrovia", "Monrovija" },
            { "timezone.excity.Africa/Ndjamena", "Ndžamena" },
            { "timezone.excity.Africa/Sao_Tome", "Santome" },
            { "timezone.excity.Africa/Windhoek", "Vindhuka" },
            { "timezone.excity.America/Antigua", "Antigva" },
            { "timezone.excity.America/Caracas", "Karakasa" },
            { "timezone.excity.America/Cayenne", "Kajenna" },
            { "timezone.excity.America/Chicago", "Čikāga" },
            { "timezone.excity.America/Cordoba", "Kordova" },
            { "timezone.excity.America/Creston", "Krestona" },
            { "timezone.excity.America/Curacao", "Kirasao" },
            { "timezone.excity.America/Detroit", "Detroita" },
            { "timezone.excity.America/Godthab", "Nūka" },
            { "timezone.excity.America/Grenada", "Grenāda" },
            { "timezone.excity.America/Halifax", "Helifeksa" },
            { "timezone.excity.America/Iqaluit", "Ikaluita" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.America/Managua", "Managva" },
            { "timezone.excity.America/Marigot", "Merigota" },
            { "timezone.excity.America/Mendoza", "Mendosa" },
            { "timezone.excity.America/Moncton", "Monktona" },
            { "timezone.excity.America/Noronha", "Noroņa" },
            { "timezone.excity.America/Ojinaga", "Ohinaga" },
            { "timezone.excity.America/Phoenix", "Fīniksa" },
            { "timezone.excity.America/Tijuana", "Tihuana" },
            { "timezone.excity.America/Yakutat", "Jakutata" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnompeņa" },
            { "timezone.excity.Atlantic/Azores", "Azoru salas" },
            { "timezone.excity.Atlantic/Canary", "Kanāriju salas" },
            { "timezone.excity.Atlantic/Faeroe", "Fēru salas" },
            { "timezone.excity.Australia/Eucla", "Jukla" },
            { "timezone.excity.Australia/Perth", "Pērta" },
            { "timezone.excity.Europe/Belgrade", "Belgrada" },
            { "timezone.excity.Europe/Brussels", "Brisele" },
            { "timezone.excity.Europe/Budapest", "Budapešta" },
            { "timezone.excity.Europe/Busingen", "Bīzingene" },
            { "timezone.excity.Europe/Chisinau", "Kišiņeva" },
            { "timezone.excity.Europe/Guernsey", "Gērnsija" },
            { "timezone.excity.Europe/Istanbul", "Stambula" },
            { "timezone.excity.Europe/Sarajevo", "Sarajeva" },
            { "timezone.excity.Indian/Maldives", "Maldīvija" },
            { "timezone.excity.Pacific/Chatham", "Četema" },
            { "timezone.excity.Pacific/Gambier", "Gambjē salas" },
            { "timezone.excity.Pacific/Norfolk", "Norfolka" },
            { "timezone.excity.Africa/Bujumbura", "Bužumbura" },
            { "timezone.excity.Africa/Mogadishu", "Mogadīšo" },
            { "timezone.excity.America/Anguilla", "Angilja" },
            { "timezone.excity.America/Asuncion", "Asunsjona" },
            { "timezone.excity.America/Barbados", "Barbadosa" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.America/Edmonton", "Edmontona" },
            { "timezone.excity.America/Mazatlan", "Masatlana" },
            { "timezone.excity.America/Miquelon", "Mikelona" },
            { "timezone.excity.America/New_York", "Ņujorka" },
            { "timezone.excity.America/Resolute", "Rezolūta" },
            { "timezone.excity.America/Santarem", "Santarena" },
            { "timezone.excity.America/Santiago", "Santjago" },
            { "timezone.excity.America/St_Johns", "Sentdžonsa" },
            { "timezone.excity.America/St_Kitts", "Sentkitsa" },
            { "timezone.excity.America/St_Lucia", "Sentlūsija" },
            { "timezone.excity.America/Winnipeg", "Vinipega" },
            { "timezone.excity.Antarctica/Casey", "Keisi" },
            { "timezone.excity.Antarctica/Davis", "Deivisa" },
            { "timezone.excity.Antarctica/Syowa", "Šova" },
            { "timezone.excity.Antarctica/Troll", "Trolla" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarska" },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirska" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulanbatora" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostoka" },
            { "timezone.excity.Atlantic/Stanley", "Stenli" },
            { "timezone.excity.Australia/Darwin", "Dārvina" },
            { "timezone.excity.Australia/Hobart", "Hobārta" },
            { "timezone.excity.Australia/Sydney", "Sidneja" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdama" },
            { "timezone.excity.Europe/Astrakhan", "Astrahaņa" },
            { "timezone.excity.Europe/Bucharest", "Bukareste" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltārs" },
            { "timezone.excity.Europe/Ljubljana", "Ļubļana" },
            { "timezone.excity.Europe/Mariehamn", "Mariehamna" },
            { "timezone.excity.Europe/Stockholm", "Stokholma" },
            { "timezone.excity.Europe/Ulyanovsk", "Uļjanovska" },
            { "timezone.excity.Europe/Volgograd", "Volgograda" },
            { "timezone.excity.Indian/Christmas", "Ziemsvētku sala" },
            { "timezone.excity.Indian/Kerguelen", "Kergelēna sala" },
            { "timezone.excity.Indian/Mauritius", "Maurīcija" },
            { "timezone.excity.Pacific/Auckland", "Oklenda" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Pacific/Pitcairn", "Pitkērna" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "timezone.excity.Africa/Libreville", "Librevila" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbaši" },
            { "timezone.excity.Africa/Nouakchott", "Nuakšota" },
            { "timezone.excity.Africa/Porto-Novo", "Portonovo" },
            { "timezone.excity.America/Anchorage", "Ankurāža" },
            { "timezone.excity.America/Araguaina", "Aragvaina" },
            { "timezone.excity.America/Boa_Vista", "Boavista" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Chihuahua", "Čivava" },
            { "timezone.excity.America/Coyhaique", "Kojhaika" },
            { "timezone.excity.America/Glace_Bay", "Gleisbeja" },
            { "timezone.excity.America/Goose_Bay", "Gūsbeja" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.America/Guayaquil", "Gvajakila" },
            { "timezone.excity.America/Matamoros", "Matamorosa" },
            { "timezone.excity.America/Menominee", "Menominī" },
            { "timezone.excity.America/Monterrey", "Monterreja" },
            { "timezone.excity.America/Sao_Paulo", "Sanpaulu" },
            { "timezone.excity.America/St_Thomas", "Sentomasa" },
            { "timezone.excity.America/Vancouver", "Vankūvera" },
            { "timezone.excity.Antarctica/Mawson", "Mosona" },
            { "timezone.excity.Antarctica/Palmer", "Pālmera" },
            { "timezone.excity.Antarctica/Vostok", "Vostoka" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kualalumpura" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzņecka" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhāgena" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburga" },
            { "timezone.excity.Europe/San_Marino", "Sanmarīno" },
            { "timezone.excity.Europe/Simferopol", "Simferopole" },
            { "timezone.excity.Pacific/Enderbury", "Kantona" },
            { "timezone.excity.Pacific/Galapagos", "Galapagu salas" },
            { "timezone.excity.Pacific/Kwajalein", "Kvadžaleina" },
            { "timezone.excity.Pacific/Marquesas", "Marķīza salas" },
            { "timezone.excity.Pacific/Pago_Pago", "Pagopago" },
            { "timezone.excity.Africa/Addis_Ababa", "Adisabeba" },
            { "timezone.excity.Africa/Brazzaville", "Brazavila" },
            { "timezone.excity.Africa/Ouagadougou", "Vagadugu" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Grand_Turk", "Grandtkērka" },
            { "timezone.excity.America/Guadeloupe", "Gvadelupa" },
            { "timezone.excity.America/Hermosillo", "Ermosiljo" },
            { "timezone.excity.America/Kralendijk", "Krālendeika" },
            { "timezone.excity.America/Louisville", "Lūivila" },
            { "timezone.excity.America/Martinique", "Martinika" },
            { "timezone.excity.America/Montserrat", "Montserrata" },
            { "timezone.excity.America/Rio_Branco", "Riobranko" },
            { "timezone.excity.America/St_Vincent", "Sentvinsenta" },
            { "timezone.excity.America/Whitehorse", "Vaithorsa" },
            { "timezone.excity.Antarctica/McMurdo", "Makmerdo" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Srednekolymsk", "Sredņekolimska" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburga" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikjavika" },
            { "timezone.excity.Atlantic/St_Helena", "Sv.Helēnas sala" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Australia/Brisbane", "Brisbena" },
            { "timezone.excity.Australia/Lindeman", "Lindemana" },
            { "timezone.excity.Europe/Isle_of_Man", "Menas sala" },
            { "timezone.excity.Europe/Kaliningrad", "Kaļiņingrada" },
            { "timezone.excity.Pacific/Kiritimati", "Kirisimasi" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburga" },
            { "timezone.excity.America/El_Salvador", "Salvadora" },
            { "timezone.excity.America/Fort_Nelson", "Fortnelsona" },
            { "timezone.excity.America/Los_Angeles", "Losandželosa" },
            { "timezone.excity.America/Mexico_City", "Mehiko" },
            { "timezone.excity.America/Porto_Velho", "Portuveļu" },
            { "timezone.excity.America/Puerto_Rico", "Puertoriko" },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Arctic/Longyearbyen", "Longjērbīene" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kaboverde" },
            { "timezone.excity.Australia/Lord_Howe", "Lordhava" },
            { "timezone.excity.Australia/Melbourne", "Melburna" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivu" },
            { "timezone.excity.Pacific/Guadalcanal", "Gvadalkanala" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dāresalāma" },
            { "timezone.excity.America/Blanc-Sablon", "Blansablona" },
            { "timezone.excity.America/Buenos_Aires", "Buenosairesa" },
            { "timezone.excity.America/Campo_Grande", "Kampugrandi" },
            { "timezone.excity.America/Danmarkshavn", "Denmārkšavna" },
            { "timezone.excity.America/Dawson_Creek", "Dousonkrīka" },
            { "timezone.excity.America/Indiana/Knox", "Noksa, Indiāna" },
            { "timezone.excity.America/Indianapolis", "Indianapolisa" },
            { "timezone.excity.America/Punta_Arenas", "Puntaarenasa" },
            { "timezone.excity.America/Rankin_Inlet", "Rankininleta" },
            { "timezone.excity.America/Scoresbysund", "Itokortormita" },
            { "timezone.excity.Antarctica/Macquarie", "Makvori" },
            { "timezone.excity.Pacific/Bougainville", "Bugenvila sala" },
            { "timezone.excity.Pacific/Port_Moresby", "Portmorsbi" },
            { "timezone.excity.America/Cambridge_Bay", "Kembridžbeja" },
            { "timezone.excity.America/Ciudad_Juarez", "Huaresa" },
            { "timezone.excity.America/Coral_Harbour", "Atikokana" },
            { "timezone.excity.America/Indiana/Vevay", "Vīveja, Indiāna" },
            { "timezone.excity.America/Lower_Princes", "Louerprinseskvotera" },
            { "timezone.excity.America/Port_of_Spain", "Portofspeina" },
            { "timezone.excity.America/Santo_Domingo", "Santodomingo" },
            { "timezone.excity.America/St_Barthelemy", "Senbartelmī" },
            { "timezone.excity.America/Swift_Current", "Sviftkarenta" },
            { "timezone.excity.Australia/Broken_Hill", "Brokenhila" },
            { "timezone.excity.America/Bahia_Banderas", "Bajabanderasa" },
            { "timezone.excity.America/Port-au-Prince", "Portoprensa" },
            { "timezone.excity.Atlantic/South_Georgia", "Dienviddžordžija" },
            { "timezone.excity.America/Indiana/Marengo", "Marengo, Indiāna" },
            { "timezone.excity.America/Indiana/Winamac", "Vinamaka, Indiāna" },
            { "timezone.excity.America/Argentina/Tucuman", "Tukumana" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ušuaja" },
            { "timezone.excity.America/Indiana/Tell_City", "Telsitija, Indiāna" },
            { "timezone.excity.America/Indiana/Vincennes", "Vinsensa, Indiāna" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dimondirvila" },
            { "timezone.excity.America/Argentina/La_Rioja", "Larjoha" },
            { "timezone.excity.America/Argentina/San_Juan", "Sanhuana" },
            { "timezone.excity.America/Argentina/San_Luis", "Sanluisa" },
            { "timezone.excity.America/Indiana/Petersburg", "Pītersbērga, Indiāna" },
            { "timezone.excity.America/Kentucky/Monticello", "Montičelo, Kentuki" },
            { "timezone.excity.America/North_Dakota/Beulah", "Bjula, Ziemeļdakota" },
            { "timezone.excity.America/North_Dakota/Center", "Sentera, Ziemeļdakota" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Riogaljegosa" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Ņūseilema, Ziemeļdakota" },
        };
        return data;
    }
}
