Upgrading instructions
======================

Follow these instructions if upgrading from a previous version
of Roundcube Webmail. We recommend to carefully backup the existing
installation as well as the database before going through the following steps.

Using the update script
-----------------------
There is a shell script (for unix based systems) that does the job for you.
To use it, unpack the archive of the new Roundcube version to a temporary location
(don't replace the Roundcube installation you want to update)
and cd into that directory. From there, run the following command in a shell:
```
./bin/installto.sh <TARGET-FOLDER>
```
For `<TARGET-FOLDER>` you specify the path to the Roundcube installation
which should be updated. The update script will then copy all new files to the
target location and check and update the configuration and database schema.
After all is done, the temporary folder with the new Roundcube files can be
removed again.

_***WARNING:*** Make sure files have proper owner/group for your setup. If you use
         tar to extract the package, `--no-same-owner` option might be helpful._

_***WARNING:*** See [Post-Upgrade Activities](#postupgrade) section below._

_***WARNING:*** If you use MySQL < 5.7.7 or MariaDB < 10.2.2 make sure to configure it with:_
```
innodb_large_prefix=1
innodb_file_per_table=1
innodb_file_format=Barracuda
```

Updating manually
-----------------
If you don't have shell access to the Roundcube installation or if do not run
it on a unix system, you need to do the following operations by hand:

1. Replace all files in
   - `bin/`
   - `SQL/`
   - `public_html/`
   - `program/`
   - `installer/`
2. Replace the configuration defaults files:
   - `config/defaults.inc.php`
   - `config/mimetypes.php`
3. rsync the contents of the following folders from your installation
   directory into the target folder:
   - `skins/`
   - `plugins/`
   - `vendor/`
4. Update dependencies:
   - If you previously installed plugins through composer, update dependencies
   by running `php composer.phar update --no-dev`.
   - Install/update dependencies using composer:
      - get composer from [getcomposer.org][getcomposer]
      - if you want to use LDAP address books, enable the LDAP libraries in your
     `composer.json` file by moving the items from "suggest" to the "require"
     section (remove the explanation texts after the version!).
      - run `php composer.phar update --no-dev`.
   - If you use git sources or the release package without dependencies
   update javascript dependencies by executing `./bin/install-jsdeps.sh` script.
   - If you use git sources, install developer tools using `npm install`.
   - If you use git sources, compile css files for the Elastic skin as described
   in the [skins/elastic/README.md](../skins/elastic/README.md) file.
5. Run `./bin/update.sh` from the commandline OR
   open `http://url-to-roundcube/installer.php` in a browser and choose "3 Test config".
   To enable the latter one, you have to temporary set `enable_installer`
   to true in your local `config/config.inc.php` file.\
   _***WARNING:*** See SQLite database upgrade below._
6. Let the update script/installer check your configuration and
   update your config files and database schema as suggested by the updater.
7. Make sure `enable_installer` is set to false again.
8. See [Post-Upgrade Activities](#postupgrade) section.

<a name="postupgrade"></a>
Post-Upgrade Activities
-----------------------
1. Check system requirements in [INSTALL.md](INSTALL.md) file.
2. If you're using build-in addressbook, run indexing script `./bin/indexcontacts.sh`.
3. When upgrading from version older than *0.6-beta* you should make sure
   your folder settings contain namespace prefix. For example Courier users
   should add INBOX. prefix to folder names in main configuration file.
4. When upgrading from version older than *1.4.0* make sure old files
   in configured `temp_dir` are removed. Since this version we use constant filename
   prefix and do not remove files not starting with "RCMTEMP".


SQLite database upgrade
-----------------------

Versions older than *0.9* were supporting SQLite v2 only. Newer versions require
database in v3 format. The best what you can do is to convert database file
to the new format using command line tools:
```
sqlite OLD.DB .dump | sqlite3 NEW.DB
```

Other tools
-----------
In case you need to only update the database schema you can use `./bin/updatedb.sh` script.
For example, to update the Roundcube core database run:
```
./bin/updatedb.sh --package=roundcube --dir=SQL
```

[getcomposer]: https://getcomposer.org/
