/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bas = "баса";
        final String metaValue_zbl = "блиссимболи";
        final String metaValue_gu = "гуџарати";
        final String metaValue_kn = "каннада";
        final String metaValue_nqo = "нко";
        final String metaValue_te = "телугу";
        final String metaValue_vai = "вај";
        final Object[][] data = new Object[][] {
            { "001", "Свет" },
            { "002", "Африка" },
            { "003", "Северна Америка" },
            { "005", "Јужна Америка" },
            { "009", "Океанија" },
            { "011", "Западна Африка" },
            { "013", "Централна Америка" },
            { "014", "Источна Африка" },
            { "015", "Северна Африка" },
            { "017", "Средна Африка" },
            { "018", "Јужна Африка" },
            { "019", "Америки" },
            { "021", "Северна континентална Америка" },
            { "029", "Кариби" },
            { "030", "Источна Азија" },
            { "034", "Јужна Азија" },
            { "035", "Југоисточна Азија" },
            { "039", "Јужна Европа" },
            { "053", "Австралазија" },
            { "054", "Меланезија" },
            { "057", "Микронезиски регион" },
            { "061", "Полинезија" },
            { "142", "Азија" },
            { "143", "Централна Азија" },
            { "145", "Западна Азија" },
            { "150", "Европа" },
            { "151", "Источна Европа" },
            { "154", "Северна Европа" },
            { "155", "Западна Европа" },
            { "202", "Супсахарска Африка" },
            { "419", "Латинска Америка" },
            { "AC", "Остров Асенсион" },
            { "AD", "Андора" },
            { "AE", "Обединети Арапски Емирати" },
            { "AF", "Авганистан" },
            { "AG", "Антига и Барбуда" },
            { "AI", "Ангвила" },
            { "AL", "Албанија" },
            { "AM", "Ерменија" },
            { "AO", "Ангола" },
            { "AQ", "Антарктик" },
            { "AR", "Аргентина" },
            { "AS", "Американска Самоа" },
            { "AT", "Австрија" },
            { "AU", "Австралија" },
            { "AW", "Аруба" },
            { "AX", "Оландски Острови" },
            { "AZ", "Азербејџан" },
            { "BA", "Босна и Херцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Белгија" },
            { "BF", "Буркина Фасо" },
            { "BG", "Бугарија" },
            { "BH", "Бахреин" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Свети Вартоломеј" },
            { "BM", "Бермуди" },
            { "BN", "Брунеј" },
            { "BO", "Боливија" },
            { "BQ", "Карипска Холандија" },
            { "BR", "Бразил" },
            { "BS", "Бахами" },
            { "BT", "Бутан" },
            { "BV", "Остров Буве" },
            { "BW", "Боцвана" },
            { "BY", "Белорусија" },
            { "BZ", "Белизе" },
            { "CA", "Канада" },
            { "CC", "Кокосови (Килиншки) Острови" },
            { "CD", "Конго - Киншаса" },
            { "CF", "Централноафриканска Република" },
            { "CG", "Конго - Бразавил" },
            { "CH", "Швајцарија" },
            { "CI", "Брегот на Слоновата Коска" },
            { "CK", "Кукови Острови" },
            { "CL", "Чиле" },
            { "CM", "Камерун" },
            { "CN", "Кина" },
            { "CO", "Колумбија" },
            { "CP", "Остров Клипертон" },
            { "CQ", "Сарк" },
            { "CR", "Костарика" },
            { "CU", "Куба" },
            { "CV", "Кабо Верде" },
            { "CW", "Курасао" },
            { "CX", "Божиќен Остров" },
            { "CY", "Кипар" },
            { "CZ", "Чешка" },
            { "DE", "Германија" },
            { "DG", "Диего Гарсија" },
            { "DJ", "Џибути" },
            { "DK", "Данска" },
            { "DM", "Доминика" },
            { "DO", "Доминиканска Република" },
            { "DZ", "Алжир" },
            { "EA", "Сеута и Мелиља" },
            { "EC", "Еквадор" },
            { "EE", "Естонија" },
            { "EG", "Египет" },
            { "EH", "Западна Сахара" },
            { "ER", "Еритреја" },
            { "ES", "Шпанија" },
            { "ET", "Етиопија" },
            { "EU", "Европска унија" },
            { "EZ", "Еврозона" },
            { "FI", "Финска" },
            { "FJ", "Фиџи" },
            { "FK", "Фолкландски Острови" },
            { "FM", "Микронезија" },
            { "FO", "Фарски Острови" },
            { "FR", "Франција" },
            { "GA", "Габон" },
            { "GB", "Обединето Кралство" },
            { "GD", "Гренада" },
            { "GE", "Грузија" },
            { "GF", "Француска Гвајана" },
            { "GG", "Гернзи" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренланд" },
            { "GM", "Гамбија" },
            { "GN", "Гвинеја" },
            { "GP", "Гвадалупе" },
            { "GQ", "Екваторска Гвинеја" },
            { "GR", "Грција" },
            { "GS", "Јужна Џорџија и Јужни Сендвички Острови" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвинеја Бисао" },
            { "GY", "Гвајана" },
            { "HK", "Хонгконг САР Кина" },
            { "HM", "Остров Херд и Острови Мекдоналд" },
            { "HN", "Хондурас" },
            { "HR", "Хрватска" },
            { "HT", "Хаити" },
            { "HU", "Унгарија" },
            { "IC", "Канарски Острови" },
            { "ID", "Индонезија" },
            { "IE", "Ирска" },
            { "IL", "Израел" },
            { "IM", "Остров Ман" },
            { "IN", "Индија" },
            { "IO", "Британска Индоокеанска Територија" },
            { "IQ", "Ирак" },
            { "IR", "Иран" },
            { "IS", "Исланд" },
            { "IT", "Италија" },
            { "JE", "Џерси" },
            { "JM", "Јамајка" },
            { "JO", "Јордан" },
            { "JP", "Јапонија" },
            { "KE", "Кенија" },
            { "KG", "Киргистан" },
            { "KH", "Камбоџа" },
            { "KI", "Кирибати" },
            { "KM", "Коморски Острови" },
            { "KN", "Свети Китс и Невис" },
            { "KP", "Северна Кореја" },
            { "KR", "Јужна Кореја" },
            { "KW", "Кувајт" },
            { "KY", "Кајмански Острови" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Либан" },
            { "LC", "Сент Лусија" },
            { "LI", "Лихтенштајн" },
            { "LK", "Шри Ланка" },
            { "LR", "Либерија" },
            { "LS", "Лесото" },
            { "LT", "Литванија" },
            { "LU", "Луксембург" },
            { "LV", "Латвија" },
            { "LY", "Либија" },
            { "MA", "Мароко" },
            { "MC", "Монако" },
            { "MD", "Молдавија" },
            { "ME", "Црна Гора" },
            { "MF", "Сент Мартин" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалски Острови" },
            { "MK", "Северна Македонија" },
            { "ML", "Мали" },
            { "MM", "Мјанмар (Бурма)" },
            { "MN", "Монголија" },
            { "MO", "Макао САР" },
            { "MP", "Северни Маријански Острови" },
            { "MQ", "Мартиник" },
            { "MR", "Мавританија" },
            { "MS", "Монсерат" },
            { "MT", "Малта" },
            { "MU", "Маврициус" },
            { "MV", "Малдиви" },
            { "MW", "Малави" },
            { "MX", "Мексико" },
            { "MY", "Малезија" },
            { "MZ", "Мозамбик" },
            { "NA", "Намибија" },
            { "NC", "Нова Каледонија" },
            { "NE", "Нигер" },
            { "NF", "Норфолшки Остров" },
            { "NG", "Нигерија" },
            { "NI", "Никарагва" },
            { "NL", "Холандија" },
            { "NO", "Норвешка" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниује" },
            { "NZ", "Нов Зеланд" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Француска Полинезија" },
            { "PG", "Папуа Нова Гвинеја" },
            { "PH", "Филипини" },
            { "PK", "Пакистан" },
            { "PL", "Полска" },
            { "PM", "Сент Пјер и Микелан" },
            { "PN", "Питкернски Острови" },
            { "PR", "Порторико" },
            { "PS", "Палестински Територии" },
            { "PT", "Португалија" },
            { "PW", "Палау" },
            { "PY", "Парагвај" },
            { "QA", "Катар" },
            { "QO", "Зависни земји во Океанија" },
            { "RE", "Рејунион" },
            { "RO", "Романија" },
            { "RS", "Србија" },
            { "RU", "Русија" },
            { "RW", "Руанда" },
            { "SA", "Саудиска Арабија" },
            { "SB", "Соломонски Острови" },
            { "SC", "Сејшели" },
            { "SD", "Судан" },
            { "SE", "Шведска" },
            { "SG", "Сингапур" },
            { "SH", "Света Елена" },
            { "SI", "Словенија" },
            { "SJ", "Свалбард и Јан Мајен" },
            { "SK", "Словачка" },
            { "SL", "Сиера Леоне" },
            { "SM", "Сан Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомалија" },
            { "SR", "Суринам" },
            { "SS", "Јужен Судан" },
            { "ST", "Саун Томе и Принсип" },
            { "SV", "Ел Салвадор" },
            { "SX", "Свети Мартин" },
            { "SY", "Сирија" },
            { "SZ", "Есватини" },
            { "TA", "Тристан да Куња" },
            { "TC", "Острови Туркс и Каикос" },
            { "TD", "Чад" },
            { "TF", "Француски Јужни Територии" },
            { "TG", "Того" },
            { "TH", "Тајланд" },
            { "TJ", "Таџикистан" },
            { "TK", "Токелау" },
            { "TL", "Тимор Лесте" },
            { "TM", "Туркменистан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Турција" },
            { "TT", "Тринидад и Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тајван" },
            { "TZ", "Танзанија" },
            { "UA", "Украина" },
            { "UG", "Уганда" },
            { "UM", "Американски територии во Пацификот" },
            { "UN", "Обединети нации" },
            { "US", "Соединети Американски Држави" },
            { "UY", "Уругвај" },
            { "UZ", "Узбекистан" },
            { "VA", "Ватикан" },
            { "VC", "Сент Винсент и Гренадини" },
            { "VE", "Венецуела" },
            { "VG", "Британски Девствени Острови" },
            { "VI", "Американски Девствени Острови" },
            { "VN", "Виетнам" },
            { "VU", "Вануату" },
            { "WF", "Валис и Футуна" },
            { "WS", "Самоа" },
            { "XA", "псевдо-акценти" },
            { "XB", "псевдо-биди" },
            { "XK", "Косово" },
            { "YE", "Јемен" },
            { "YT", "Мајот" },
            { "ZA", "Јужноафриканска Република" },
            { "ZM", "Замбија" },
            { "ZW", "Зимбабве" },
            { "ZZ", "Непознат регион" },
            { "aa", "афарски" },
            { "ab", "апхаски" },
            { "ae", "авестански" },
            { "af", "африканс" },
            { "ak", "акански" },
            { "am", "амхарски" },
            { "an", "арагонски" },
            { "ar", "арапски" },
            { "as", "асамски" },
            { "av", "аварски" },
            { "ay", "ајмарски" },
            { "az", "азербејџански" },
            { "ba", "башкирски" },
            { "be", "белоруски" },
            { "bg", "бугарски" },
            { "bi", "бислама" },
            { "bm", "бамбара" },
            { "bn", "бенгалски" },
            { "bo", "тибетски" },
            { "br", "бретонски" },
            { "bs", "босански" },
            { "ca", "каталонски" },
            { "ce", "чеченски" },
            { "ch", "чаморски" },
            { "co", "корзикански" },
            { "cr", "кри" },
            { "cs", "чешки" },
            { "cu", "црковнословенски" },
            { "cv", "чувашки" },
            { "cy", "велшки" },
            { "da", "дански" },
            { "de", "германски" },
            { "dv", "дивехи" },
            { "dz", "ѕонгка" },
            { "ee", "еве" },
            { "el", "грчки" },
            { "en", "англиски" },
            { "eo", "есперанто" },
            { "es", "шпански" },
            { "et", "естонски" },
            { "eu", "баскиски" },
            { "fa", "персиски" },
            { "ff", "фула" },
            { "fi", "фински" },
            { "fj", "фиџиски" },
            { "fo", "фарски" },
            { "fr", "француски" },
            { "fy", "западнофризиски" },
            { "ga", "ирски" },
            { "gd", "шкотски гелски" },
            { "gl", "галисиски" },
            { "gn", "гварански" },
            { "gu", metaValue_gu },
            { "gv", "манкс" },
            { "ha", "хауса" },
            { "he", "хебрејски" },
            { "hi", "хинди" },
            { "ho", "хири моту" },
            { "hr", "хрватски" },
            { "ht", "хаитски" },
            { "hu", "унгарски" },
            { "hy", "ерменски" },
            { "hz", "хереро" },
            { "ia", "интерлингва" },
            { "id", "индонезиски" },
            { "ie", "интерлингве" },
            { "ig", "игбо" },
            { "ii", "сичуан ји" },
            { "ik", "инупијачки" },
            { "io", "идо" },
            { "is", "исландски" },
            { "it", "италијански" },
            { "iu", "инуктитут" },
            { "ja", "јапонски" },
            { "jv", "јавански" },
            { "ka", "грузиски" },
            { "kg", "конго" },
            { "ki", "кикују" },
            { "kj", "квањама" },
            { "kk", "казашки" },
            { "kl", "калалисут" },
            { "km", "кмерски" },
            { "kn", metaValue_kn },
            { "ko", "корејски" },
            { "kr", "канури" },
            { "ks", "кашмирски" },
            { "ku", "курманџи" },
            { "kv", "коми" },
            { "kw", "корнски" },
            { "ky", "киргиски" },
            { "la", "латински" },
            { "lb", "луксембуршки" },
            { "lg", "ганда" },
            { "li", "лимбуршки" },
            { "ln", "лингала" },
            { "lo", "лаошки" },
            { "lt", "литвански" },
            { "lu", "луба-катанга" },
            { "lv", "латвиски" },
            { "mg", "малгашки" },
            { "mh", "маршалски" },
            { "mi", "маорски" },
            { "mk", "македонски" },
            { "ml", "малајалски" },
            { "mn", "монголски" },
            { "mr", "марати" },
            { "ms", "малајски" },
            { "mt", "малтешки" },
            { "my", "бурмански" },
            { "na", "науруански" },
            { "nb", "норвешки букмол" },
            { "nd", "северен ндебеле" },
            { "ne", "непалски" },
            { "ng", "ндонга" },
            { "nl", "холандски" },
            { "nn", "норвешки нинорск" },
            { "no", "норвешки" },
            { "nr", "јужен ндебеле" },
            { "nv", "навахо" },
            { "ny", "њанџа" },
            { "oc", "окситански" },
            { "oj", "оџибва" },
            { "om", "оромо" },
            { "or", "одија" },
            { "os", "осетски" },
            { "pa", "пенџапски" },
            { "pi", "пали" },
            { "pl", "полски" },
            { "ps", "паштунски" },
            { "pt", "португалски" },
            { "qu", "кечуански" },
            { "rm", "реторомански" },
            { "rn", "рунди" },
            { "ro", "романски" },
            { "ru", "руски" },
            { "rw", "руандски" },
            { "sa", "санскрит" },
            { "sc", "сардински" },
            { "sd", "синди" },
            { "se", "северен сами" },
            { "sg", "санго" },
            { "sh", "српскохрватски" },
            { "si", "синхалски" },
            { "sk", "словачки" },
            { "sl", "словенечки" },
            { "sm", "самоански" },
            { "sn", "шона" },
            { "so", "сомалиски" },
            { "sq", "албански" },
            { "sr", "српски" },
            { "ss", "свати" },
            { "st", "сесото" },
            { "su", "сундски" },
            { "sv", "шведски" },
            { "sw", "свахили" },
            { "ta", "тамилски" },
            { "te", metaValue_te },
            { "tg", "таџикистански" },
            { "th", "тајландски" },
            { "ti", "тигриња" },
            { "tk", "туркменски" },
            { "tl", "тагалог" },
            { "tn", "цвана" },
            { "to", "тонгајски" },
            { "tr", "турски" },
            { "ts", "цонга" },
            { "tt", "татарски" },
            { "tw", "тви" },
            { "ty", "тахитски" },
            { "ug", "ујгурски" },
            { "uk", "украински" },
            { "ur", "урду" },
            { "uz", "узбечки" },
            { "ve", "венда" },
            { "vi", "виетнамски" },
            { "vo", "волапик" },
            { "wa", "валонски" },
            { "wo", "волофски" },
            { "xh", "коса" },
            { "yi", "јидиш" },
            { "yo", "јорупски" },
            { "za", "џуаншки" },
            { "zh", "кинески" },
            { "zu", "зулу" },
            { "ace", "ачешки" },
            { "ach", "аколи" },
            { "ada", "адангме" },
            { "ady", "адигејски" },
            { "aeb", "туниски арапски" },
            { "afh", "африхили" },
            { "agq", "агемски" },
            { "ain", "ајну" },
            { "akk", "акадски" },
            { "akz", "алабамски" },
            { "ale", "алеутски" },
            { "aln", "гешки албански" },
            { "alt", "јужноалтајски" },
            { "ang", "староанглиски" },
            { "ann", "оболо" },
            { "anp", "ангика" },
            { "arc", "арамејски" },
            { "arn", "мапучки" },
            { "aro", "араона" },
            { "arp", "арапахо" },
            { "arq", "алжирски арапски" },
            { "ars", "неџдиски арапски" },
            { "arw", "аравачки" },
            { "ary", "марокански арапски" },
            { "arz", "египетски арапски" },
            { "asa", "асу" },
            { "ase", "американски знаковен јазик" },
            { "ast", "астурски" },
            { "atj", "атикамек" },
            { "avk", "котава" },
            { "awa", "авади" },
            { "bal", "белуџиски" },
            { "ban", "балиски" },
            { "bar", "баварски" },
            { "bas", metaValue_bas },
            { "bax", "бамунски" },
            { "bbc", "тоба" },
            { "bbj", "гомала" },
            { "bej", "беџа" },
            { "bem", "бемба" },
            { "bew", "бетавски" },
            { "bez", "бена" },
            { "bfd", "бафут" },
            { "bfq", "бадага" },
            { "bgc", "харијанви" },
            { "bgn", "западен балочи" },
            { "bho", "боџпури" },
            { "bik", "биколски" },
            { "bin", "бини" },
            { "bjn", "банџарски" },
            { "bkm", "ком" },
            { "bla", "сиксика" },
            { "blo", "ании" },
            { "bpy", "бишнуприја" },
            { "bqi", "бахтијарски" },
            { "bra", "брај" },
            { "brh", "брахујски" },
            { "brx", "бодо" },
            { "bss", "акосе" },
            { "bua", "бурјатски" },
            { "bug", "бугиски" },
            { "bum", "булу" },
            { "byn", "биленски" },
            { "byv", "медумба" },
            { "cad", "кадо" },
            { "car", "карипски" },
            { "cay", "кајуга" },
            { "cch", "ацам" },
            { "ccp", "чакмански" },
            { "ceb", "себуански" },
            { "cgg", "чига" },
            { "chb", "чибча" },
            { "chg", "чагатајски" },
            { "chk", "чучки" },
            { "chm", "мариски" },
            { "chn", "чинучки жаргон" },
            { "cho", "чоктавски" },
            { "chp", "чипевјански" },
            { "chr", "чероки" },
            { "chy", "чејенски" },
            { "ckb", "централнокурдски" },
            { "clc", "чилкотински" },
            { "cop", "коптски" },
            { "cps", "капизнон" },
            { "crg", "мичиф" },
            { "crh", "кримскотурски" },
            { "crj", "југоисточен кријски" },
            { "crk", "прериски кријски" },
            { "crl", "североисточен кријски" },
            { "crm", "лосовски кријски" },
            { "crr", "каролински алгонкински" },
            { "crs", "француски (Сеселва креоли)" },
            { "csb", "кашупски" },
            { "csw", "мочуришен кријски" },
            { "dak", "дакота" },
            { "dar", "даргва" },
            { "dav", "таита" },
            { "del", "делавер" },
            { "den", "слејви" },
            { "dgr", "догрипски" },
            { "din", "динка" },
            { "dje", "зарма" },
            { "doi", "догри" },
            { "dsb", "долнолужички" },
            { "dtp", "дусунски" },
            { "dua", "дуала" },
            { "dum", "среднохоландски" },
            { "dyo", "јола-фоњи" },
            { "dyu", "џула" },
            { "dzg", "дазага" },
            { "ebu", "ембу" },
            { "efi", "ефик" },
            { "egl", "емилијански" },
            { "egy", "староегипетски" },
            { "eka", "екаџук" },
            { "elx", "еламски" },
            { "enm", "средноанглиски" },
            { "esu", "централнојупички" },
            { "ewo", "евондо" },
            { "ext", "екстремадурски" },
            { "fan", "фанг" },
            { "fat", "фанти" },
            { "fil", "филипински" },
            { "fit", "турнедаленски фински" },
            { "fon", "фон" },
            { "frc", "каџунски француски" },
            { "frm", "среднофранцуски" },
            { "fro", "старофранцуски" },
            { "frp", "франкопровансалски" },
            { "frr", "севернофризиски" },
            { "frs", "источнофризиски" },
            { "fur", "фурлански" },
            { "gaa", "га" },
            { "gag", "гагауски" },
            { "gan", "ган" },
            { "gay", "гајо" },
            { "gba", "гбаја" },
            { "gbz", "зороастриски дари" },
            { "gez", "гиз" },
            { "gil", "гилбертански" },
            { "glk", "гилански" },
            { "gmh", "средногорногермански" },
            { "goh", "старогорногермански" },
            { "gon", "гонди" },
            { "gor", "горонтало" },
            { "got", "готски" },
            { "grb", "гребо" },
            { "grc", "старогрчки" },
            { "gsw", "швајцарски германски" },
            { "guc", "гвахиро" },
            { "gur", "фарефаре" },
            { "guz", "гуси" },
            { "gwi", "гвичински" },
            { "hai", "хајда" },
            { "hak", "хака" },
            { "haw", "хавајски" },
            { "hax", "јужен хајда" },
            { "hif", "фиџиски хинди" },
            { "hil", "хилигајнонски" },
            { "hit", "хетитски" },
            { "hmn", "хмонг" },
            { "hsb", "горнолужички" },
            { "hsn", "сјанг" },
            { "hup", "хупа" },
            { "hur", "халкомелем" },
            { "iba", "ибан" },
            { "ibb", "ибибио" },
            { "ikt", "западноканадски инуктитут" },
            { "ilo", "илокански" },
            { "inh", "ингушки" },
            { "izh", "ижорски" },
            { "jam", "јамајски креолски" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачаме" },
            { "jpr", "еврејскоперсиски" },
            { "jrb", "еврејскоарапски" },
            { "jut", "јитски" },
            { "kaa", "каракалпачки" },
            { "kab", "кабилски" },
            { "kac", "качински" },
            { "kaj", "каџе" },
            { "kam", "камба" },
            { "kaw", "кави" },
            { "kbd", "кабардински" },
            { "kbl", "канембу" },
            { "kcg", "тјап" },
            { "kde", "маконде" },
            { "kea", "кабувердиану" },
            { "ken", "кењанг" },
            { "kfo", "коро" },
            { "kgp", "каинганшки" },
            { "kha", "каси" },
            { "kho", "хотански" },
            { "khq", "којра чиини" },
            { "khw", "коварски" },
            { "kiu", "зазаки" },
            { "kkj", "како" },
            { "kln", "каленџин" },
            { "kmb", "кимбунду" },
            { "koi", "коми-пермјачки" },
            { "kok", "конкани" },
            { "kos", "козрејски" },
            { "kpe", "кпеле" },
            { "krc", "карачаевско-балкарски" },
            { "kri", "крио" },
            { "krj", "кинарајски" },
            { "krl", "карелски" },
            { "kru", "курух" },
            { "ksb", "шамбала" },
            { "ksf", "бафија" },
            { "ksh", "колоњски" },
            { "kum", "кумички" },
            { "kut", "кутенајски" },
            { "kwk", "кваквала" },
            { "kxv", "куви" },
            { "lad", "ладино" },
            { "lag", "ланги" },
            { "lah", "ланда" },
            { "lam", "ламба" },
            { "lez", "лезгински" },
            { "lfn", "лингва франка нова" },
            { "lij", "лигурски" },
            { "lil", "лилуетски" },
            { "liv", "ливонски" },
            { "lkt", "лакотски" },
            { "lmo", "ломбардиски" },
            { "lol", "монго" },
            { "lou", "луизијански креолски" },
            { "loz", "лози" },
            { "lrc", "севернолуриски" },
            { "lsm", "самиски" },
            { "ltg", "латгалски" },
            { "lua", "луба-лулуа" },
            { "lui", "лујсењски" },
            { "lun", "лунда" },
            { "luo", "луо" },
            { "lus", "мизо" },
            { "luy", "луја" },
            { "lzh", "книжевен кинески" },
            { "lzz", "ласки" },
            { "mad", "мадурски" },
            { "maf", "мафа" },
            { "mag", "магахи" },
            { "mai", "маитили" },
            { "mak", "макасарски" },
            { "man", "мандинго" },
            { "mas", "масајски" },
            { "mde", "маба" },
            { "mdf", "мокшански" },
            { "mdr", "мандарски" },
            { "men", "менде" },
            { "mer", "меру" },
            { "mfe", "морисјен" },
            { "mga", "средноирски" },
            { "mgh", "макува-мито" },
            { "mgo", "мета" },
            { "mic", "микмак" },
            { "min", "минангкабау" },
            { "mnc", "манџурски" },
            { "mni", "манипурски" },
            { "moe", "ину-аимунски" },
            { "moh", "мохавски" },
            { "mos", "моси" },
            { "mrj", "западномариски" },
            { "mua", "мунданг" },
            { "mul", "повеќе јазици" },
            { "mus", "крик" },
            { "mwl", "мирандски" },
            { "mwr", "марвари" },
            { "mye", "мјене" },
            { "myv", "ерзјански" },
            { "mzn", "мазендерански" },
            { "nan", "јужномински" },
            { "nap", "неаполски" },
            { "naq", "нама" },
            { "nds", "долногермански" },
            { "new", "неварски" },
            { "nia", "нијас" },
            { "niu", "ниујески" },
            { "njo", "ао нага" },
            { "nmg", "квазио" },
            { "nnh", "нгиембун" },
            { "nog", "ногајски" },
            { "non", "старонордиски" },
            { "nov", "новијал" },
            { "nqo", metaValue_nqo },
            { "nso", "северносотски" },
            { "nus", "нуер" },
            { "nwc", "класичен неварски" },
            { "nym", "њамвези" },
            { "nyn", "њанколе" },
            { "nyo", "њоро" },
            { "nzi", "нзима" },
            { "ojb", "северозападен оџибва" },
            { "ojc", "централен оџибва" },
            { "ojs", "очиски кријски" },
            { "ojw", "западен оџибва" },
            { "oka", "оканагански" },
            { "osa", "осашки" },
            { "ota", "отомански турски" },
            { "pag", "пангасинански" },
            { "pal", "средноперсиски" },
            { "pam", "пампанга" },
            { "pap", "папијаменто" },
            { "pau", "палауански" },
            { "pcd", "пикардски" },
            { "pcm", "нигериски пиџин" },
            { "pdc", "пенсилваниски германски" },
            { "pdt", "менонитски долногермански" },
            { "peo", "староперсиски" },
            { "pfl", "фалечкогермански" },
            { "phn", "феникиски" },
            { "pis", "пиџин" },
            { "pms", "пиемонтски" },
            { "pnt", "понтски" },
            { "pon", "понпејски" },
            { "pqm", "малиситски пасамакводски" },
            { "prg", "пруски" },
            { "pro", "старопровансалски" },
            { "quc", "киче" },
            { "qug", "кичвански" },
            { "raj", "раџастански" },
            { "rap", "рапанујски" },
            { "rar", "раротонгански" },
            { "rgn", "ромањолски" },
            { "rhg", "рохиншки" },
            { "rif", "рифски" },
            { "rof", "ромбо" },
            { "rom", "ромски" },
            { "rtm", "ротумански" },
            { "rue", "русински" },
            { "rug", "ровијански" },
            { "rup", "влашки" },
            { "rwk", "руа" },
            { "sad", "сандаве" },
            { "sah", "јакутски" },
            { "sam", "самарјански арамејски" },
            { "saq", "самбуру" },
            { "sas", "сасачки" },
            { "sat", "сантали" },
            { "saz", "саураштра" },
            { "sba", "нгембеј" },
            { "sbp", "сангу" },
            { "scn", "сицилијански" },
            { "sco", "шкотски германски" },
            { "sdc", "сасарски сардински" },
            { "sdh", "јужнокурдски" },
            { "see", "сенека" },
            { "seh", "сена" },
            { "sei", "сери" },
            { "sel", "селкупски" },
            { "ses", "којраборо сени" },
            { "sga", "староирски" },
            { "sgs", "самогитски" },
            { "shi", "тачелхит" },
            { "shn", "шан" },
            { "shu", "чадски арапски" },
            { "sid", "сидамо" },
            { "slh", "јужен лушуцид" },
            { "sli", "долношлезиски" },
            { "sly", "селајарски" },
            { "sma", "јужен сами" },
            { "smj", "луле сами" },
            { "smn", "инариски сами" },
            { "sms", "сколт сами" },
            { "snk", "сонинке" },
            { "sog", "зогдијански" },
            { "srn", "срански тонго" },
            { "srr", "серер" },
            { "ssy", "сахо" },
            { "stq", "затерландски фризиски" },
            { "str", "салишки (Северен Теснец)" },
            { "suk", "сукума" },
            { "sus", "сусу" },
            { "sux", "сумерски" },
            { "swb", "коморијански" },
            { "syc", "класичен сириски" },
            { "syr", "сириски" },
            { "szl", "шлезиски" },
            { "tce", "јужнотучонски" },
            { "tcy", "тулу" },
            { "tem", "тимне" },
            { "teo", "тесо" },
            { "ter", "терено" },
            { "tet", "тетум" },
            { "tgx", "тагишки" },
            { "tht", "талтански" },
            { "tig", "тигре" },
            { "tiv", "тив" },
            { "tkl", "токелауански" },
            { "tkr", "цахурски" },
            { "tlh", "клингонски" },
            { "tli", "тлингит" },
            { "tly", "талишки" },
            { "tmh", "тамашек" },
            { "tog", "њаса тонга" },
            { "tok", "токи пона" },
            { "tpi", "ток писин" },
            { "tru", "туројо" },
            { "trv", "тароко" },
            { "tsd", "цаконски" },
            { "tsi", "цимшијански" },
            { "ttm", "севернотучонски" },
            { "ttt", "татски" },
            { "tum", "тумбука" },
            { "tvl", "тувалуански" },
            { "twq", "тазавак" },
            { "tyv", "тувански" },
            { "tzm", "централноатлански тамазитски" },
            { "udm", "удмуртски" },
            { "uga", "угаритски" },
            { "umb", "умбунду" },
            { "und", "непознат јазик" },
            { "vai", metaValue_vai },
            { "vec", "венецијански" },
            { "vep", "вепшки" },
            { "vls", "западнофламански" },
            { "vmf", "мајнскофранконски" },
            { "vmw", "макуа" },
            { "vot", "вотски" },
            { "vro", "виру" },
            { "vun", "вунџо" },
            { "wae", "валсер" },
            { "wal", "воламо" },
            { "war", "варајски" },
            { "was", "вашо" },
            { "wbp", "варлпири" },
            { "wuu", "ву" },
            { "xal", "калмички" },
            { "xmf", "мегрелски" },
            { "xnr", "кангри" },
            { "xog", "сога" },
            { "yao", "јао" },
            { "yap", "јапски" },
            { "yav", "јенгбен" },
            { "ybb", "јемба" },
            { "yrl", "њенгату" },
            { "yue", "кантонски" },
            { "zap", "запотечки" },
            { "zbl", metaValue_zbl },
            { "zea", "зеландски" },
            { "zen", "зенага" },
            { "zgh", "стандарден марокански тамазитски" },
            { "zun", "зуни" },
            { "zxx", "без лингвистичка содржина" },
            { "zza", "заза" },
            { "Adlm", "адламско" },
            { "Afak", "афака" },
            { "Aghb", "кавкаскоалбански" },
            { "Arab", "арапско писмо" },
            { "Aran", "насталик" },
            { "Armi", "царскоарамејски" },
            { "Armn", "ерменско писмо" },
            { "Avst", "авестанско" },
            { "Bali", "балиско" },
            { "Bamu", "бамумско" },
            { "Bass", metaValue_bas },
            { "Batk", "батачко" },
            { "Beng", "бенгалско писмо" },
            { "Blis", metaValue_zbl },
            { "Bopo", "бопомофо" },
            { "Brah", "брами" },
            { "Brai", "брајово писмо" },
            { "Bugi", "бугиско" },
            { "Buhd", "бухидско" },
            { "Cakm", "чакманско" },
            { "Cans", "канадско слоговно" },
            { "Cari", "кариско" },
            { "Cham", "чамско" },
            { "Cher", "черокиско" },
            { "Cirt", "кирт" },
            { "Copt", "коптско" },
            { "Cprt", "кипарско" },
            { "Cyrl", "кирилско писмо" },
            { "Cyrs", "старословенска кирилица" },
            { "Deva", "деванагари" },
            { "Dsrt", "дезеретско" },
            { "Dupl", "Диплојеево стенографско" },
            { "Egyd", "египетско демотско" },
            { "Egyh", "египетско хиератско" },
            { "Egyp", "египетски хиероглифи" },
            { "Elba", "елбасанско" },
            { "Ethi", "етиопско писмо" },
            { "Geok", "грузиски хуцури" },
            { "Geor", "грузиско писмо" },
            { "Glag", "глаголица" },
            { "Goth", "готско" },
            { "Gran", "гранта" },
            { "Grek", "грчко писмо" },
            { "Gujr", metaValue_gu },
            { "Guru", "гурмуки" },
            { "Hanb", "ханб" },
            { "Hang", "хангул" },
            { "Hani", "ханско писмо" },
            { "Hano", "хануноовско" },
            { "Hans", "поедноставено" },
            { "Hant", "традиционално" },
            { "Hebr", "хебрејско писмо" },
            { "Hira", "хирагана" },
            { "Hluw", "анадолски хиероглифи" },
            { "Hmng", "пахауанско хмоншко" },
            { "Hrkt", "јапонско слоговно" },
            { "Hung", "староунгарско" },
            { "Inds", "харапско" },
            { "Ital", "староиталско" },
            { "Jamo", "џамо" },
            { "Java", "јаванско" },
            { "Jpan", "јапонско писмо" },
            { "Jurc", "џурченско" },
            { "Kali", "каја ли" },
            { "Kana", "катакана" },
            { "Khar", "карошти" },
            { "Khmr", "кмерско писмо" },
            { "Khoj", "хоџки" },
            { "Knda", metaValue_kn },
            { "Kore", "корејско писмо" },
            { "Kpel", "кпелско" },
            { "Kthi", "кајти" },
            { "Lana", "ланско" },
            { "Laoo", "лаошко писмо" },
            { "Latf", "фрактурна латиница" },
            { "Latg", "гелска латиница" },
            { "Latn", "латинично писмо" },
            { "Lepc", "лепчанско" },
            { "Limb", "лимбу" },
            { "Lina", "линеарно А" },
            { "Linb", "линеарно Б" },
            { "Lisu", "Фрејзерово" },
            { "Loma", "ломско" },
            { "Lyci", "ликиско" },
            { "Lydi", "лидиско" },
            { "Mahj", "махаџани" },
            { "Mand", "мандејско" },
            { "Mani", "манихејско" },
            { "Maya", "мајански хиероглифи" },
            { "Mend", "мендско" },
            { "Merc", "мероитско ракописно" },
            { "Mero", "мероитско" },
            { "Mlym", "малајалско писмо" },
            { "Modi", "моди" },
            { "Mong", "монголско писмо" },
            { "Moon", "Муново" },
            { "Mroo", "мро" },
            { "Mtei", "мејтејско" },
            { "Mymr", "мјанмарско писмо" },
            { "Narb", "старосеверноарапско" },
            { "Nbat", "набатејско" },
            { "Nkgb", "насиска геба" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "нишу" },
            { "Ogam", "огам" },
            { "Olck", "ол чики" },
            { "Orkh", "старотурско" },
            { "Orya", "оријанско писмо" },
            { "Osma", "сомалиско" },
            { "Palm", "палмирско" },
            { "Pauc", "Паучинхауово" },
            { "Perm", "старопермско" },
            { "Phag", "пагспа" },
            { "Phli", "натписно средноперсиско" },
            { "Phlp", "псалтирско средноперсиско" },
            { "Phlv", "книжевно староперсиско" },
            { "Phnx", "феникиско" },
            { "Plrd", "Полардово" },
            { "Prti", "натписно партиско" },
            { "Rjng", "реџаншко" },
            { "Rohg", "ханифи" },
            { "Roro", "ронгоронго" },
            { "Runr", "рунско" },
            { "Samr", "самарјанско" },
            { "Sara", "сарати" },
            { "Sarb", "старојужноарапско" },
            { "Saur", "саураштранско" },
            { "Sgnw", "знаковно пишување" },
            { "Shaw", "Шоово" },
            { "Shrd", "шарада" },
            { "Sidd", "сидам" },
            { "Sind", "кудабади" },
            { "Sinh", "синхалско писмо" },
            { "Sora", "соранг сомпенг" },
            { "Sund", "сунданско" },
            { "Sylo", "силхетско нагари" },
            { "Syrc", "сириско" },
            { "Syre", "естрангелско сириско" },
            { "Syrj", "западносириско" },
            { "Syrn", "источносириско" },
            { "Tagb", "тагбанванско" },
            { "Takr", "такри" },
            { "Tale", "тај ле" },
            { "Talu", "ново тај луе" },
            { "Taml", "тамилско писмо" },
            { "Tang", "тангутско" },
            { "Tavt", "тај вјет" },
            { "Telu", metaValue_te },
            { "Teng", "тенгвар" },
            { "Tfng", "тифинаг" },
            { "Tglg", "тагалошко" },
            { "Thaa", "тана" },
            { "Thai", "тајландско писмо" },
            { "Tibt", "тибетско писмо" },
            { "Tirh", "тирхута" },
            { "Ugar", "угаритско" },
            { "Vaii", metaValue_vai },
            { "Visp", "видлив говор" },
            { "Wara", "варанг кшити" },
            { "Wole", "волеајско" },
            { "Xpeo", "староперсиско" },
            { "Xsux", "сумероакадско клинесто" },
            { "Yiii", "ји" },
            { "Zinh", "наследено" },
            { "Zmth", "математичка нотација" },
            { "Zsye", "емоџи" },
            { "Zsym", "симболи" },
            { "Zxxx", "без писмо" },
            { "Zyyy", "општо" },
            { "Zzzz", "непознато писмо" },
            { "de_AT", "австриски германски" },
            { "de_CH", "швајцарски горногермански" },
            { "en_AU", "австралиски англиски" },
            { "en_CA", "канадски англиски" },
            { "en_GB", "британски англиски" },
            { "en_US", "американски англиски" },
            { "es_ES", "шпански (Европа)" },
            { "es_MX", "мексикански шпански" },
            { "fa_AF", "дари" },
            { "fr_CA", "канадски француски" },
            { "fr_CH", "швајцарски француски" },
            { "nl_BE", "фламански" },
            { "pt_BR", "бразилски португалски" },
            { "pt_PT", "португалски (Европа)" },
            { "ro_MD", "молдавски" },
            { "sw_CD", "конгоански свахили" },
            { "ar_001", "современ стандардизиран арапски" },
            { "es_419", "латиноамерикански шпански" },
            { "key.ca", "Календар" },
            { "key.cf", "Формат на валута" },
            { "key.co", "Подредување" },
            { "key.cu", "Валута" },
            { "key.em", "Приказ на емоџи" },
            { "key.hc", "Часовен циклус (12 или 24)" },
            { "key.lb", "Стил за разделување редови" },
            { "key.lw", "Разделување редови во рамки на зборови" },
            { "key.ms", "Мерен систем" },
            { "key.nu", "Броеви" },
            { "key.ss", "Разделување реченица по кратенка" },
            { "nds_NL", "долносаксонски" },
            { "zh_Hans", "поедноставен кинески" },
            { "zh_Hant", "традиционален кинески" },
            { "%%PINYIN", "Пинјин романизација" },
            { "%%WADEGILE", "Вејд-Џајлс романизација" },
            { "type.ca.roc", "Мингуо-календар" },
            { "type.co.eor", "Европски правила за подредување" },
            { "type.hc.h11", "12-часовен систем (0 – 11)" },
            { "type.hc.h12", "12-часовен систем (1 – 12)" },
            { "type.hc.h23", "24-часовен систем (0 – 23)" },
            { "type.hc.h24", "24-часовен систем (1 – 24)" },
            { "type.nu.ahom", "Ахомски цифри" },
            { "type.nu.arab", "Арапско-индиски цифри" },
            { "type.nu.armn", "Ерменски броеви" },
            { "type.nu.beng", "Бенгалски цифри" },
            { "type.nu.cakm", "Чакмански цифри" },
            { "type.nu.deva", "Деванагарски цифри" },
            { "type.nu.ethi", "Етиопски броеви" },
            { "type.nu.geor", "Грузиски броеви" },
            { "type.nu.grek", "Грчки броеви" },
            { "type.nu.gujr", "Гуџарати цифри" },
            { "type.nu.guru", "Гурмуки цифри" },
            { "type.nu.hans", "Поедноставени кинески броеви" },
            { "type.nu.hant", "Традиционални кинески броеви" },
            { "type.nu.hebr", "Хебрејски броеви" },
            { "type.nu.java", "Јавански цифри" },
            { "type.nu.jpan", "Јапонски броеви" },
            { "type.nu.khmr", "Кмерски цифри" },
            { "type.nu.knda", "Каннада цифри" },
            { "type.nu.laoo", "Лаошки цифри" },
            { "type.nu.latn", "Арапски броеви" },
            { "type.nu.mlym", "Малајалски цифри" },
            { "type.nu.mtei", "Мејтејски цифри" },
            { "type.nu.mymr", "Мјанмарски цифри" },
            { "type.nu.olck", "Цифри ол чики" },
            { "type.nu.orya", "Одиски цифри" },
            { "type.nu.taml", "Традиционални тамилски броеви" },
            { "type.nu.telu", "Телугу цифри" },
            { "type.nu.thai", "Тајландски цифри" },
            { "type.nu.tibt", "Тибетски цифри" },
            { "type.nu.vaii", "Цифри ваи" },
            { "type.ca.dangi", "Дангиски календар" },
            { "type.co.ducet", "Стандардно подредување во уникод" },
            { "type.co.emoji", "Подредување емотикони" },
            { "type.lb.loose", "Допустлив стил за разделување редови" },
            { "type.nu.roman", "Римски броеви" },
            { "type.ca.coptic", "Коптски календар" },
            { "type.ca.hebrew", "Еврејски календар" },
            { "type.ca.indian", "Индиски национален календар" },
            { "type.co.compat", "Претходно подредување" },
            { "type.co.pinyin", "Сортирање Pinyin" },
            { "type.co.search", "Општо пребарување" },
            { "type.co.stroke", "Ритмички редослед" },
            { "type.co.unihan", "Подредување унихан" },
            { "type.co.zhuyin", "Подредување жујин" },
            { "type.lb.normal", "Нормален стил за разделување редови" },
            { "type.lb.strict", "Строг стил за разделување редови" },
            { "type.ms.metric", "Метрички систем" },
            { "type.ca.chinese", "Кинески календар" },
            { "type.ca.islamic", "Исламски календар" },
            { "type.ca.iso8601", "Календар ISO-8601" },
            { "type.ca.persian", "Персиски календар" },
            { "type.cf.account", "Сметководствен формат на валута" },
            { "type.nu.arabext", "Проширени арапско-индиски цифри" },
            { "type.nu.armnlow", "Ерменски мали броеви" },
            { "type.nu.greklow", "Грчки мали броеви" },
            { "type.nu.hanidec", "Кинески децимални броеви" },
            { "type.nu.hansfin", "Поедноставени кинески финансиски броеви" },
            { "type.nu.hantfin", "Традиционални кинески финансиски броеви" },
            { "type.nu.jpanfin", "Јапонски финансиски броеви" },
            { "type.nu.tamldec", "Тамилски цифри" },
            { "type.ca.buddhist", "Будистички календар" },
            { "type.ca.ethiopic", "Етиопски календар" },
            { "type.ca.japanese", "Јапонски календар" },
            { "type.cf.standard", "Стандарден формат на валута" },
            { "type.co.reformed", "Реформирано подредување" },
            { "type.co.searchjl", "Пребарување според почетна согласка хангул" },
            { "type.co.standard", "Стандардно подредување" },
            { "type.ms.uksystem", "Империјален мерен систем" },
            { "type.ms.ussystem", "Американски мерен систем" },
            { "type.nu.fullwide", "Цифри со целосна ширина" },
            { "type.nu.romanlow", "Римски мали броеви" },
            { "type.ca.gregorian", "Грегоријански календар" },
            { "type.co.phonebook", "Азбучен редослед" },
            { "type.co.dictionary", "Подредување по азбучен редослед" },
            { "type.co.traditional", "Традиционално сортирање" },
            { "type.ca.islamic-rgsa", "Исламски календар (Саудиска Арабија)" },
            { "type.ca.islamic-tbla", "Исламски календар (астрономска епоха)" },
            { "type.ca.islamic-civil", "Исламски граѓански календар" },
            { "type.ca.islamic-umalqura", "Исламски календар (Ум ал-Кура)" },
            { "type.ca.ethiopic-amete-alem", "Етиопски Амет Алем календар" },
        };
        return data;
    }
}
