/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter;

import com.intellij.jupyter.core.core.impl.file.JupyterNotebookLanguageUtils;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.lang.Language;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.NotebookLanguageProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/NotebookMetadataLanguageProvider;", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/NotebookLanguageProvider;", "<init>", "()V", "getTemplateLanguage", "Lcom/intellij/lang/Language;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onlyCache", "", "intellij.jupyter.core"})
public final class NotebookMetadataLanguageProvider
implements NotebookLanguageProvider {
    @Nullable
    public Language getTemplateLanguage(@NotNull VirtualFile file, boolean onlyCache) {
        Language language;
        Language calculatedLanguage;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile original = JupyterFileUtils.INSTANCE.getOriginalFile(file);
        Language cachedLanguage = JupyterNotebookLanguageUtils.INSTANCE.getNotebookLanguage(original);
        if (cachedLanguage != null) {
            return cachedLanguage;
        }
        if (onlyCache) {
            return null;
        }
        JupyterNotebookBase jupyterNotebookBase = JupyterFileUtils.INSTANCE.readNotebookOrNull(original);
        Object object = calculatedLanguage = jupyterNotebookBase != null ? jupyterNotebookBase.getLanguage() : null;
        if (calculatedLanguage != null) {
            JupyterNotebookLanguageUtils.INSTANCE.setNotebookLanguage(original, calculatedLanguage);
        }
        if ((language = calculatedLanguage) == null) {
            language = Language.ANY;
        }
        return language;
    }
}

