/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoNumber;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.ProtobufDecoder;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingKt;
import kotlinx.serialization.protobuf.internal.ProtobufReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/serialization/protobuf/internal/OneOfElementReader;", "Lkotlinx/serialization/protobuf/internal/ProtobufDecoder;", "proto", "Lkotlinx/serialization/protobuf/ProtoBuf;", "decoder", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "classId", "", "contentDecoded", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "decodeElementIndex", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufDecoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/OneOfElementReader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,551:1\n808#2,11:552\n*S KotlinDebug\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/OneOfElementReader\n*L\n505#1:552,11\n*E\n"})
final class OneOfElementReader
extends ProtobufDecoder {
    private final int classId;
    private boolean contentDecoded;

    /*
     * WARNING - void declaration
     */
    public OneOfElementReader(@NotNull ProtoBuf proto, @NotNull ProtobufReader decoder, @NotNull SerialDescriptor descriptor2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(decoder, "decoder");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        super(proto, decoder, descriptor2);
        if (!(descriptor2.getElementsCount() == 1)) {
            boolean $i$a$-require-OneOfElementReader$32 = false;
            String $i$a$-require-OneOfElementReader$32 = "Implementation of oneOf type " + descriptor2.getSerialName() + " should contain only 1 element, but get " + descriptor2.getElementsCount();
            throw new IllegalArgumentException($i$a$-require-OneOfElementReader$32.toString());
        }
        Iterable $this$filterIsInstance$iv = descriptor2.getElementAnnotations(0);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProtoNumber)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        ProtoNumber protoNumber = (ProtoNumber)CollectionsKt.singleOrNull((List)destination$iv$iv);
        if (!(protoNumber != null)) {
            boolean bl = false;
            String string = "Implementation of oneOf type " + descriptor2.getSerialName() + " should have @ProtoNumber annotation";
            throw new IllegalArgumentException(string.toString());
        }
        this.classId = protoNumber.number();
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        long tag;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual(serialKind, StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual(serialKind, StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
            tag = this.getCurrentTagOrDefault();
            if (tag == 19500L && Intrinsics.areEqual(this.descriptor, descriptor2)) {
                return this;
            }
            if (HelpersKt.isOneOf(tag)) {
                throw new SerializationException("An oneof element cannot be directly child of another oneof element");
            }
        } else {
            throw new SerializationException("Type " + descriptor2.getKind() + " cannot be directly child of oneof element");
        }
        return new ProtobufDecoder(this.proto, ProtobufDecodingKt.access$makeDelimited(this.reader, tag), descriptor2);
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int n;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.contentDecoded) {
            n = -1;
        } else {
            this.contentDecoded = true;
            n = 0;
        }
        return n;
    }
}

