/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.jba;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.SettingsDialogListener;
import com.intellij.openapi.options.newEditor.SettingsEditor;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.settingsSync.core.SettingsSyncBundle;
import com.intellij.settingsSync.core.SettingsSyncEventListener;
import com.intellij.settingsSync.core.SettingsSyncEvents;
import com.intellij.settingsSync.core.SettingsSyncLocalSettings;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import com.intellij.settingsSync.core.communicator.RemoteCommunicatorHolder;
import com.intellij.settingsSync.core.statistics.SettingsSyncEventsStatistics;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncPromotion;", "Lcom/intellij/openapi/options/newEditor/SettingsDialogListener;", "<init>", "()V", "afterApply", "", "settingsEditor", "Lcom/intellij/openapi/options/newEditor/SettingsEditor;", "modifiedConfigurableIds", "", "", "getConfigurable", "Lcom/intellij/openapi/options/Configurable;", "path", "Ljavax/swing/tree/TreePath;", "Companion", "intellij.settingsSync"})
public final class SettingsSyncPromotion
implements SettingsDialogListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean promotionShownThisSession;

    public void afterApply(@NotNull SettingsEditor settingsEditor, @NotNull Set<String> modifiedConfigurableIds) {
        Object v3;
        SimpleTree settingsTree;
        GotItTooltip gotItTooltip;
        block4: {
            Intrinsics.checkNotNullParameter((Object)settingsEditor, (String)"settingsEditor");
            Intrinsics.checkNotNullParameter(modifiedConfigurableIds, (String)"modifiedConfigurableIds");
            if (SettingsSyncSettings.Companion.getInstance().getSyncEnabled() || SettingsSyncLocalSettings.Companion.getInstance().getKnownAndAppliedServerId() != null || !Registry.Companion.is("settingsSync.promotion.in.settings", false)) {
                return;
            }
            gotItTooltip = new GotItTooltip("settings.sync.in.settings", SettingsSyncBundle.INSTANCE.message("promotion.in.settings.text", new Object[0]), (Disposable)settingsEditor);
            if (!gotItTooltip.canShow()) {
                Disposer.dispose((Disposable)((Disposable)gotItTooltip));
                return;
            }
            Disposer.register((Disposable)((Disposable)gotItTooltip), () -> SettingsSyncPromotion.afterApply$lambda$0(gotItTooltip));
            promotionShownThisSession = true;
            SimpleTree simpleTree = settingsEditor.getTreeView().getTree();
            Intrinsics.checkNotNullExpressionValue((Object)simpleTree, (String)"getTree(...)");
            settingsTree = simpleTree;
            JBTreeTraverser jBTreeTraverser = TreeUtil.treePathTraverser((JTree)((JTree)settingsTree));
            Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"treePathTraverser(...)");
            Iterable iterable = (Iterable)jBTreeTraverser;
            for (Object t : iterable) {
                Configurable configurable;
                TreePath path = (TreePath)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)path);
                Configurable configurable2 = configurable = this.getConfigurable(path);
                if (!Intrinsics.areEqual((Object)(configurable2 != null ? configurable2.getDisplayName() : null), (Object)SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]))) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        TreePath treePath = v3;
        if (treePath == null) {
            return;
        }
        TreePath settingsSyncPath = treePath;
        Configurable configurable = this.getConfigurable(settingsSyncPath);
        Intrinsics.checkNotNull((Object)configurable);
        Configurable settingsSyncConfigurable = configurable;
        settingsTree.scrollPathToVisible(settingsSyncPath);
        gotItTooltip.withHeader(SettingsSyncBundle.INSTANCE.message("promotion.in.settings.header", new Object[0])).withButtonLabel(SettingsSyncBundle.INSTANCE.message("promotion.in.settings.open", new Object[0])).withSecondaryButton(SettingsSyncBundle.INSTANCE.message("promotion.in.settings.skip", new Object[0]), SettingsSyncPromotion::afterApply$lambda$2).withGotItButtonAction(() -> SettingsSyncPromotion.afterApply$lambda$4(settingsEditor, settingsSyncConfigurable)).withPosition(Balloon.Position.atRight).show((JComponent)settingsTree, (arg_0, arg_1) -> SettingsSyncPromotion.afterApply$lambda$5(settingsTree, settingsSyncPath, arg_0, arg_1));
        SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.SHOWN);
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            public void loginStateChanged() {
                if (RemoteCommunicatorHolder.INSTANCE.getCurrentUserData() != null) {
                    SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.LOGGED_IN));
                }
            }

            public void enabledStateChanged(boolean syncEnabled) {
                if (syncEnabled) {
                    SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.ENABLED));
                    SettingsSyncEvents.Companion.getInstance().removeListener(this);
                }
            }
        }, (Disposable)settingsEditor);
    }

    private final Configurable getConfigurable(TreePath path) {
        Object object = path.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        if (defaultMutableTreeNode == null) {
            return null;
        }
        DefaultMutableTreeNode lastNode = defaultMutableTreeNode;
        Object object2 = lastNode.getUserObject();
        FilteringTreeStructure.FilteringNode filteringNode = object2 instanceof FilteringTreeStructure.FilteringNode ? (FilteringTreeStructure.FilteringNode)object2 : null;
        if (filteringNode == null) {
            return null;
        }
        FilteringTreeStructure.FilteringNode filteringNode2 = filteringNode;
        Object object3 = filteringNode2.getDelegate();
        SimpleNode simpleNode = object3 instanceof SimpleNode ? (SimpleNode)object3 : null;
        if (simpleNode == null) {
            return null;
        }
        SimpleNode delegate = simpleNode;
        return SettingsTreeView.getConfigurable((SimpleNode)delegate);
    }

    private static final void afterApply$lambda$0(GotItTooltip $gotItTooltip) {
        $gotItTooltip.gotIt();
    }

    private static final Unit afterApply$lambda$2() {
        SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.SKIP);
        return Unit.INSTANCE;
    }

    private static final Unit afterApply$lambda$4$lambda$3(SettingsEditor $settingsEditor, Configurable $settingsSyncConfigurable) {
        $settingsEditor.select($settingsSyncConfigurable);
        return Unit.INSTANCE;
    }

    private static final Unit afterApply$lambda$4(SettingsEditor $settingsEditor, Configurable $settingsSyncConfigurable) {
        ActionsKt.invokeLater((ModalityState)ModalityState.stateForComponent((Component)((Component)$settingsEditor)), () -> SettingsSyncPromotion.afterApply$lambda$4$lambda$3($settingsEditor, $settingsSyncConfigurable));
        SettingsSyncEventsStatistics.INSTANCE.getPROMOTION_IN_SETTINGS().log((Object)SettingsSyncEventsStatistics.PromotionInSettingsEvent.GO_TO_SETTINGS_SYNC);
        return Unit.INSTANCE;
    }

    private static final Point afterApply$lambda$5(SimpleTree $settingsTree, TreePath $settingsSyncPath, Component component, Balloon balloon) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"<unused var>");
        Rectangle rectangle = $settingsTree.getPathBounds($settingsSyncPath);
        if (rectangle == null) {
            throw new IllegalStateException(("Failed to get bounds for path: " + $settingsSyncPath).toString());
        }
        Rectangle pathBounds = rectangle;
        int x = pathBounds.x + Math.min(pathBounds.width, JBUI.scale((int)150));
        return new Point(x, pathBounds.y + pathBounds.height / 2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncPromotion$Companion;", "", "<init>", "()V", "promotionShownThisSession", "", "getPromotionShownThisSession", "()Z", "setPromotionShownThisSession", "(Z)V", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getPromotionShownThisSession() {
            return promotionShownThisSession;
        }

        public final void setPromotionShownThisSession(boolean bl) {
            promotionShownThisSession = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

